/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.spi;

import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.security.RoleManager;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.spi.AbstractEntityManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.UnknownEntityException;

public abstract class AbstractRoleManager
extends AbstractEntityManager
implements RoleManager {
    private static final long serialVersionUID = 1L;

    protected abstract <T extends Role> T persistNewRole(T var1) throws DataBackendException;

    @Override
    public <T extends Role> T getRoleInstance() throws DataBackendException {
        try {
            Role role = (Role)Class.forName(this.getClassName()).newInstance();
            return (T)role;
        }
        catch (Exception e) {
            throw new DataBackendException("Problem creating instance of class " + this.getClassName(), e);
        }
    }

    @Override
    public <T extends Role> T getRoleInstance(String roleName) throws DataBackendException {
        T role = this.getRoleInstance();
        role.setName(roleName);
        return role;
    }

    @Override
    public <T extends Role> T getRoleByName(String name) throws DataBackendException, UnknownEntityException {
        Role role = (Role)this.getAllRoles().getByName(name);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        return (T)role;
    }

    @Override
    public <T extends Role> T getRoleById(Object id) throws DataBackendException, UnknownEntityException {
        Role role = (Role)this.getAllRoles().getById(id);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        return (T)role;
    }

    @Override
    public synchronized <T extends Role> T addRole(T role) throws DataBackendException, EntityExistsException {
        boolean roleExists = false;
        if (StringUtils.isEmpty((CharSequence)role.getName())) {
            throw new DataBackendException("Could not create a role with empty name!");
        }
        try {
            roleExists = this.checkExists(role);
            if (!roleExists) {
                return this.persistNewRole(role);
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addRole(Role) failed", e);
        }
        throw new EntityExistsException("Role '" + String.valueOf(role) + "' already exists");
    }

    @Override
    public boolean checkExists(Role role) throws DataBackendException {
        return this.checkExists(role.getName());
    }
}

