/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TurbinePermission;
import org.apache.fulcrum.security.torque.om.TurbinePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.turbine.DefaultAbstractTurbinePermission;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbinePermission
extends DefaultAbstractTurbinePermission
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1735909169129L;
    private Integer entityId = null;
    private String entityName = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    protected List<TurbineRolePermission> collTurbineRolePermissions = null;
    private transient Criteria lastTurbineRolePermissionCriteria = null;
    private static final TurbinePermissionPeer peer = new TurbinePermissionPeer();

    @Override
    public Integer getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(Integer v) {
        if (!Objects.equals(this.entityId, v)) {
            this.setModified(true);
        }
        this.entityId = v;
        if (this.collTurbineRolePermissions != null) {
            for (TurbineRolePermission element : this.collTurbineRolePermissions) {
                element.setPermissionId(v);
            }
        }
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String v) {
        if (!Objects.equals(this.entityName, v)) {
            this.setModified(true);
        }
        this.entityName = v;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<TurbineRolePermission> initTurbineRolePermissions() {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = new ArrayList<TurbineRolePermission>();
        }
        return this.collTurbineRolePermissions;
    }

    public boolean isTurbineRolePermissionsInitialized() {
        return this.collTurbineRolePermissions != null;
    }

    public void addTurbineRolePermission(TurbineRolePermission toAdd) throws TorqueException {
        toAdd.setTurbinePermission((TurbinePermission)this);
        this.getTurbineRolePermissions().add(toAdd);
    }

    public void addTurbineRolePermission(TurbineRolePermission l, Connection con) throws TorqueException {
        this.getTurbineRolePermissions(con).add(l);
        l.setTurbinePermission((TurbinePermission)this);
    }

    public void resetTurbineRolePermission() {
        this.collTurbineRolePermissions = null;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions() throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria());
            for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                turbineRolePermission.setTurbinePermission((TurbinePermission)this);
            }
        }
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Criteria criteria) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            this.collTurbineRolePermissions = this.getTurbineRolePermissions(new Criteria(), con);
            for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                turbineRolePermission.setTurbinePermission((TurbinePermission)this);
            }
        }
        return this.collTurbineRolePermissions;
    }

    public List<TurbineRolePermission> getTurbineRolePermissions(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelect(criteria, con);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    protected List<TurbineRolePermission> getTurbineRolePermissionsJoinTurbineRole(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineRolePermission> result = this.getTurbineRolePermissionsJoinTurbineRole(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineRolePermission> list = result;
            return list;
        }
    }

    protected List<TurbineRolePermission> getTurbineRolePermissionsJoinTurbineRole(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineRolePermissions == null) {
            if (this.isNew()) {
                this.initTurbineRolePermissions();
            } else {
                criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbineRole(criteria, connection);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        } else {
            criteria.and((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)this.getEntityId());
            if (this.lastTurbineRolePermissionCriteria == null || !this.lastTurbineRolePermissionCriteria.equals((Object)criteria)) {
                this.collTurbineRolePermissions = TurbineRolePermissionPeer.doSelectJoinTurbineRole(criteria, connection);
                for (TurbineRolePermission turbineRolePermission : this.collTurbineRolePermissions) {
                    turbineRolePermission.setTurbinePermission((TurbinePermission)this);
                }
            }
        }
        this.lastTurbineRolePermissionCriteria = criteria;
        return this.collTurbineRolePermissions;
    }

    public void save() throws TorqueException {
        this.save(TurbinePermissionPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbinePermissionPeer.doInsert((TurbinePermission)this, con);
                    this.setNew(false);
                } else {
                    TurbinePermissionPeer.doUpdate((TurbinePermission)this, con);
                }
            }
            if (this.isTurbineRolePermissionsInitialized()) {
                for (TurbineRolePermission collTurbineRolePermissions : this.getTurbineRolePermissions()) {
                    collTurbineRolePermissions.save(con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) {
        this.setEntityId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) {
        this.setEntityId(new Integer(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        return SimpleKey.keyFor((Number)this.getEntityId());
    }

    public TurbinePermission copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbinePermission copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbinePermission copy(boolean deepcopy) throws TorqueException {
        TurbinePermission turbinePermission = new TurbinePermission();
        return this.copyInto(turbinePermission, deepcopy);
    }

    public TurbinePermission copy(boolean deepcopy, Connection con) throws TorqueException {
        TurbinePermission turbinePermission = new TurbinePermission();
        return this.copyInto(turbinePermission, deepcopy, con);
    }

    public TurbinePermission copyInto(TurbinePermission copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TurbinePermission copyInto(TurbinePermission copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbinePermission copyInto(TurbinePermission copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        if (deepcopy) {
            if (this.collTurbineRolePermissions != null) {
                for (TurbineRolePermission obj : this.collTurbineRolePermissions) {
                    copyObj.addTurbineRolePermission(obj.copy());
                }
            } else {
                copyObj.collTurbineRolePermissions = null;
            }
        }
        return copyObj;
    }

    public TurbinePermission copyInto(TurbinePermission copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        if (deepcopy) {
            for (TurbineRolePermission obj : this.getTurbineRolePermissions(con)) {
                copyObj.addTurbineRolePermission(obj.copy());
            }
        }
        return copyObj;
    }

    public TurbinePermissionPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbinePermissionPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbinePermission:\n");
        str.append("entityId = ").append(this.getEntityId()).append("\n");
        str.append("entityName = ").append(this.getEntityName()).append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TurbinePermission other = (TurbinePermission)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TurbinePermission toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.entityId, toCompare.getEntityId())) {
            return false;
        }
        return Objects.equals(this.entityName, toCompare.getEntityName());
    }
}

