/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.io.read;

import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.io.read.BeanCreationChain;
import org.apache.commons.betwixt.io.read.ChainedBeanCreator;
import org.apache.commons.betwixt.io.read.ElementMapping;
import org.apache.commons.betwixt.io.read.ReadContext;
import org.apache.commons.logging.Log;

public class ChainedBeanCreatorFactory {
    private static final ChainedBeanCreator derivedBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping elementMapping, ReadContext context, BeanCreationChain chain) {
            String className = elementMapping.getAttributes().getValue(context.getClassNameAttribute());
            if (className != null) {
                try {
                    ClassLoader classLoader = context.getClassLoader();
                    if (classLoader == null) {
                        context.getLog().warn((Object)"Could not create derived instance: read context classloader not set.");
                    }
                    Class<?> clazz = classLoader.loadClass(className);
                    return clazz.newInstance();
                }
                catch (Exception e) {
                    context.getLog().warn((Object)("Could not create instance of type: " + className));
                    context.getLog().debug((Object)"Create new instance failed: ", (Throwable)e);
                    return null;
                }
            }
            return chain.create(elementMapping, context);
        }
    };
    private static final ChainedBeanCreator elementTypeBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping element, ReadContext context, BeanCreationChain chain) {
            Log log = context.getLog();
            Class theClass = null;
            ElementDescriptor descriptor = element.getDescriptor();
            if (descriptor != null) {
                if (descriptor.isPolymorphic()) {
                    theClass = context.getXMLIntrospector().getPolymorphicReferenceResolver().resolveType(element, context);
                }
                if (theClass == null) {
                    theClass = descriptor.getImplementationClass();
                }
            }
            if (theClass == null) {
                theClass = element.getType();
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("Creating instance of class " + theClass.getName() + " for element " + element.getName()));
            }
            try {
                return theClass.newInstance();
            }
            catch (Exception e) {
                context.getLog().warn((Object)("Could not create instance of type: " + theClass.getName()));
                context.getLog().debug((Object)"Create new instance failed: ", (Throwable)e);
                return null;
            }
        }
    };
    private static final ChainedBeanCreator idRefBeanCreator = new ChainedBeanCreator(){

        public Object create(ElementMapping elementMapping, ReadContext context, BeanCreationChain chain) {
            String idref;
            if (context.getMapIDs() && (idref = elementMapping.getAttributes().getValue("idref")) != null) {
                context.getLog().trace((Object)"Found IDREF");
                Object bean = context.getBean(idref);
                if (bean != null) {
                    if (context.getLog().isTraceEnabled()) {
                        context.getLog().trace((Object)("Matched bean " + bean));
                    }
                    return bean;
                }
                context.getLog().trace((Object)"No match found");
            }
            return chain.create(elementMapping, context);
        }
    };

    public static final ChainedBeanCreator createDerivedBeanCreator() {
        return derivedBeanCreator;
    }

    public static final ChainedBeanCreator createElementTypeBeanCreator() {
        return elementTypeBeanCreator;
    }

    public static final ChainedBeanCreator createIDREFBeanCreator() {
        return idRefBeanCreator;
    }
}

