/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.ClassNotPersistenceCapableException;
import ojb.broker.metadata.DescriptorRepository;

public class Identity
implements Serializable {
    private Class objectsClass;
    private Object[] pkValues;
    private transient String stringRepresentation = null;

    private Identity() {
    }

    public Identity(Object objectToIdentitify) {
        try {
            DescriptorRepository repository = DescriptorRepository.getInstance();
            ClassDescriptor mif = repository.getDescriptorFor(objectToIdentitify.getClass());
            this.objectsClass = repository.getExtentClass(objectToIdentitify.getClass());
            this.pkValues = mif.getKeyValues(objectToIdentitify);
        }
        catch (ClassNotPersistenceCapableException ex) {
            throw new org.odmg.ClassNotPersistenceCapableException(ex.getMessage());
        }
    }

    public static Identity fromByteArray(byte[] anArray) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(anArray);
            GZIPInputStream gis = new GZIPInputStream(bais);
            ObjectInputStream ois = new ObjectInputStream(gis);
            Identity result = (Identity)ois.readObject();
            ois.close();
            gis.close();
            bais.close();
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Class getObjectsClass() {
        return this.objectsClass;
    }

    public byte[] serialize() {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bao);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(this);
            oos.close();
            gos.close();
            bao.close();
            byte[] result = bao.toByteArray();
            return result;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.pkValues.length) {
                buf.append(buf.length() == 0 ? "{" : ",");
                buf.append(this.pkValues[i]);
                ++i;
            }
            buf.append("}");
            this.stringRepresentation = this.objectsClass.getName() + buf.toString();
        }
        return this.stringRepresentation;
    }

    public Identity(Class aClass, Object[] pkValues) {
        this.objectsClass = aClass;
        this.pkValues = pkValues;
    }

    public Object[] getPrimaryKeyValues() {
        return this.pkValues;
    }
}

