/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.QueryFactory;
import org.xml.sax.SAXException;
import test.ojb.broker.Article;

public class PerformanceTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$PerformanceTest == null ? (class$test$ojb$broker$PerformanceTest = PerformanceTest.class$("test.ojb.broker.PerformanceTest")) : class$test$ojb$broker$PerformanceTest;
    int articleCount = 100;
    int iterations = 10;
    int offsetId = 123456;
    static /* synthetic */ Class class$test$ojb$broker$PerformanceTest;

    public PerformanceTest(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Performance Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    protected void deleteArticle(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        this.broker.delete(a);
    }

    protected void deleteArticle(Article articleToDelete) throws PersistenceBrokerException {
        this.broker.delete(articleToDelete);
    }

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    protected Article readArticleByExample(int id) throws PersistenceBrokerException {
        Article example = new Article();
        example.setArticleId(id);
        return (Article)this.broker.getObjectByQuery(QueryFactory.newQuery(example));
    }

    protected Article readArticleByIdentity(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        Identity oid = new Identity(a);
        return (Article)this.broker.getObjectByIdentity(oid);
    }

    public void setUp() {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker("repository.xml");
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void tearDown() {
    }

    protected void deleteArticles(int count) throws PersistenceBrokerException {
        int i = 0;
        while (i < count) {
            Article a = this.readArticleByExample(this.offsetId + i);
            this.broker.delete(a);
            ++i;
        }
    }

    protected void insertNewArticles(int count) throws PersistenceBrokerException {
        int i = 0;
        while (i < count) {
            Article a = this.createArticle(this.offsetId + i);
            this.broker.store(a);
            ++i;
        }
    }

    protected void readArticles(int count) throws PersistenceBrokerException {
        int i = 0;
        while (i < count) {
            Article article = this.readArticleByIdentity(this.offsetId + i);
            ++i;
        }
    }

    protected void readArticlesAndUpdate(int count) throws PersistenceBrokerException {
        int i = 0;
        while (i < count) {
            Article a = this.readArticleByIdentity(this.offsetId + i);
            a.setPrice(a.getPrice() * 1.16);
            this.broker.store(a);
            ++i;
        }
    }

    public void testScenario2() {
        try {
            int i = 0;
            while (i < this.iterations) {
                long start = System.currentTimeMillis();
                this.broker.beginTransaction();
                this.insertNewArticles(this.articleCount);
                this.readArticles(this.articleCount);
                this.readArticlesAndUpdate(this.articleCount);
                this.deleteArticles(this.articleCount);
                this.broker.commitTransaction();
                long elapsed = System.currentTimeMillis() - start;
                System.out.println("TestScenario2: " + elapsed + " ms");
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

