/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.modules.Navigation;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class NavigationLoader
extends GenericLoader
implements Loader {
    private static final long serialVersionUID = 5062299200802529612L;
    private static Log log = LogFactory.getLog((Class)NavigationLoader.class);
    private static NavigationLoader instance = new NavigationLoader(Turbine.getConfiguration().getInt("navigation.cache.size", 10));
    private static AssemblerBrokerService ab = TurbineAssemblerBroker.getService();

    private NavigationLoader() {
    }

    private NavigationLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Navigation navigation) {
        if (this.cache()) {
            this.put(name, navigation);
        }
    }

    public ConcreteElement eval(RunData data, String name) throws Exception {
        return this.getInstance(name).build(data);
    }

    public void exec(RunData data, String name) throws Exception {
        this.eval(data, name);
    }

    public Assembler getAssembler(String name) throws Exception {
        return this.getInstance(name);
    }

    public Navigation getInstance(String name) throws Exception {
        Navigation navigation = null;
        if (this.cache() && this.containsKey(name)) {
            navigation = (Navigation)this.get(name);
            log.debug((Object)("Found Navigation " + name + " in the cache!"));
        } else {
            log.debug((Object)("Loading Navigation " + name + " from the Assembler Broker"));
            try {
                if (ab != null) {
                    navigation = (Navigation)ab.getAssembler("navigation", name);
                }
            }
            catch (ClassCastException cce) {
                navigation = null;
            }
            if (navigation == null) {
                List packages = Turbine.getConfiguration().getList("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Navigation not found: " + name + "\n\tTurbine looked in the following " + "modules.packages path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, navigation);
            }
        }
        return navigation;
    }

    public static NavigationLoader getInstance() {
        return instance;
    }
}

