/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.validator;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.CompareCallback;
import org.apache.turbine.services.intake.validator.Constraint;
import org.apache.turbine.services.intake.validator.DateStringValidator;
import org.apache.turbine.services.intake.validator.FieldReference;
import org.apache.turbine.services.intake.validator.InvalidMaskException;
import org.apache.turbine.services.intake.validator.ValidationException;

public class DateRangeValidator
extends DateStringValidator {
    List fieldReferences;
    CompareCallback compareCallback;

    public DateRangeValidator(Map paramMap) throws IntakeException {
        this.init(paramMap);
    }

    public DateRangeValidator() {
    }

    public void init(Map paramMap) throws InvalidMaskException {
        super.init(paramMap);
        this.compareCallback = new CompareCallback(){

            public boolean compareValues(int compare, Object thisValue, Object refValue) throws ClassCastException {
                boolean result = true;
                Date thisDate = (Date)thisValue;
                Date otherDate = (Date)refValue;
                switch (compare) {
                    case 1: {
                        result = thisDate.before(otherDate);
                        break;
                    }
                    case 3: {
                        result = !thisDate.after(otherDate);
                        break;
                    }
                    case 2: {
                        result = thisDate.after(otherDate);
                        break;
                    }
                    case 4: {
                        result = !thisDate.before(otherDate);
                    }
                }
                return result;
            }
        };
        this.fieldReferences = new ArrayList(10);
        Iterator i = paramMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            Constraint constraint = (Constraint)entry.getValue();
            int compare = FieldReference.getCompareType(key);
            if (compare == 0) continue;
            FieldReference fieldref = new FieldReference();
            fieldref.setCompare(compare);
            fieldref.setFieldName(constraint.getValue());
            fieldref.setMessage(constraint.getMessage());
            this.fieldReferences.add(fieldref);
        }
        if (this.fieldReferences.isEmpty()) {
            this.log.warn((Object)"No reference field rules have been found.");
        }
    }

    public void assertValidity(Field testField) throws ValidationException {
        super.assertValidity(testField);
        Group thisGroup = testField.getGroup();
        if (testField.isMultiValued()) {
            String[] stringValues = (String[])testField.getTestValue();
            for (int i = 0; i < stringValues.length; ++i) {
                this.assertValidity(stringValues[i], thisGroup);
            }
        } else {
            String testValue = (String)testField.getTestValue();
            this.assertValidity(testValue, thisGroup);
        }
    }

    public void assertValidity(String testValue, Group group) throws ValidationException {
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            Date testDate = null;
            try {
                testDate = this.parse(testValue);
            }
            catch (ParseException e) {
                this.errorMessage = this.getDateFormatMessage();
                throw new ValidationException(this.errorMessage);
            }
            try {
                FieldReference.checkReferences(this.fieldReferences, this.compareCallback, testDate, group);
            }
            catch (ValidationException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
    }
}

