/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.GroupPeerManagerConstants;
import org.apache.turbine.services.security.torque.TorqueGroup;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.GroupSet;

public class GroupPeerManager
implements GroupPeerManagerConstants {
    private static Class groupPeerClass = null;
    private static Class groupObject = null;
    private static String tableName = null;
    private static String nameColumn = null;
    private static String idColumn = null;
    private static PropertyDescriptor namePropDesc = null;
    private static PropertyDescriptor idPropDesc = null;
    static Log log = LogFactory.getLog((Class)GroupPeerManager.class);

    public static void init(Configuration conf) throws InitializationException {
        block6: {
            String groupPeerClassName = conf.getString("torque.groupPeer.class", GROUP_PEER_CLASS_DEFAULT);
            String groupObjectName = null;
            try {
                groupPeerClass = Class.forName(groupPeerClassName);
                tableName = (String)groupPeerClass.getField("TABLE_NAME").get(null);
                groupObject = GroupPeerManager.getPersistenceClass();
                groupObjectName = conf.getString("torque.group.class", groupObject.getName());
                groupObject = Class.forName(groupObjectName);
                nameColumn = (String)groupPeerClass.getField(conf.getString("torque.groupPeer.column.name", "GROUP_NAME")).get(null);
                idColumn = (String)groupPeerClass.getField(conf.getString("torque.groupPeer.column.id", "GROUP_ID")).get(null);
                namePropDesc = new PropertyDescriptor(conf.getString("torque.group.property.name", "Name"), groupObject);
                idPropDesc = new PropertyDescriptor(conf.getString("torque.group.property.id", "GroupId"), groupObject);
            }
            catch (Exception e) {
                if (groupPeerClassName == null || groupPeerClass == null) {
                    throw new InitializationException("Could not find GroupPeer class (" + groupPeerClassName + ")", e);
                }
                if (tableName == null) {
                    throw new InitializationException("Failed to get the table name from the Peer object", e);
                }
                if (groupObject == null || groupObjectName == null) {
                    throw new InitializationException("Failed to get the object type from the Peer object", e);
                }
                if (nameColumn == null || namePropDesc == null) {
                    throw new InitializationException("GroupPeer " + groupPeerClassName + " has no name column information!", e);
                }
                if (idColumn != null && idPropDesc != null) break block6;
                throw new InitializationException("GroupPeer " + groupPeerClassName + " has no id column information!", e);
            }
        }
    }

    public static String getTableName() {
        return tableName;
    }

    public static String getNameColumn() {
        return nameColumn;
    }

    public static String getIdColumn() {
        return idColumn;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(GroupPeerManager.getTableName());
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Persistent newPersistentInstance() {
        Persistent obj = null;
        if (groupObject == null) {
            return obj;
        }
        try {
            obj = (Persistent)groupObject.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a group object", (Throwable)e);
            obj = null;
        }
        return obj;
    }

    public static GroupSet retrieveSet() throws Exception {
        return GroupPeerManager.retrieveSet(new Criteria());
    }

    public static GroupSet retrieveSet(Criteria criteria) throws Exception {
        List results = GroupPeerManager.doSelect(criteria);
        GroupSet gs = new GroupSet();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            gs.add((Group)it.next());
        }
        return gs;
    }

    public static boolean checkExists(Group group) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(GroupPeerManager.getIdColumn());
        criteria.add(GroupPeerManager.getNameColumn(), (Object)group.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple groups named '" + group.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static Criteria buildCriteria(Group group) {
        Criteria crit;
        try {
            Class[] clazz = new Class[]{groupObject};
            Object[] params = new Object[]{((TorqueGroup)group).getPersistentObj()};
            crit = (Criteria)groupPeerClass.getMethod("buildCriteria", clazz).invoke(null, params);
        }
        catch (Exception e) {
            crit = null;
        }
        return crit;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            groupPeerClass.getMethod("doUpdate", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doUpdate failed", (Throwable)e);
        }
    }

    public static void doInsert(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            groupPeerClass.getMethod("doInsert", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doInsert failed", (Throwable)e);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        List list;
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            list = (List)groupPeerClass.getMethod("doSelect", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doSelect failed", (Throwable)e);
        }
        ArrayList<Group> newList = new ArrayList<Group>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Group dr = GroupPeerManager.getNewGroup((Persistent)it.next());
            newList.add(dr);
        }
        return newList;
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            groupPeerClass.getMethod("doDelete", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doDelete failed", (Throwable)e);
        }
    }

    public static void setGroupName(Persistent obj, String name) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{name};
            namePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Group Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getGroupName(Persistent obj) {
        String name = null;
        if (obj == null) {
            return null;
        }
        try {
            name = (String)namePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Group Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return name;
    }

    public static void setId(Persistent obj, int id) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{Integer.TYPE};
            idPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Group Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Integer getIdAsObj(Persistent obj) {
        Integer id = null;
        if (obj == null) {
            return new Integer(0);
        }
        try {
            id = (Integer)idPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Group Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return id;
    }

    private static Class getPersistenceClass() {
        Class persistenceClass = null;
        try {
            Object[] params = new Object[]{};
            persistenceClass = (Class)groupPeerClass.getMethod("getOMClass", null).invoke(null, params);
        }
        catch (Exception e) {
            persistenceClass = null;
        }
        return persistenceClass;
    }

    public static Group getNewGroup(Persistent p) {
        Group g = null;
        try {
            Class groupWrapperClass = TurbineSecurity.getGroupClass();
            Class[] clazz = new Class[]{Persistent.class};
            Object[] params = new Object[]{p};
            g = (Group)groupWrapperClass.getConstructor(clazz).newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a new group from supplied persistent: ", (Throwable)e);
        }
        return g;
    }
}

