/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;

public class JobQueue {
    private Vector<JobEntry> queue = new Vector(10);

    public JobEntry getNext() {
        if (this.queue.size() > 0) {
            return this.queue.elementAt(0);
        }
        return null;
    }

    public JobEntry getJob(JobEntry je) {
        int index = -1;
        if (je != null) {
            index = this.queue.indexOf((Object)je);
        }
        if (index < 0) {
            return null;
        }
        return this.queue.elementAt(index);
    }

    public Vector<JobEntry> list() {
        if (this.queue != null && this.queue.size() > 0) {
            return (Vector)this.queue.clone();
        }
        return null;
    }

    public synchronized void add(JobEntry je) {
        this.queue.addElement(je);
        this.sortQueue();
    }

    public synchronized void batchLoad(List<JobEntry> jobEntries) {
        if (jobEntries != null) {
            this.queue.addAll(jobEntries);
            this.sortQueue();
        }
    }

    public synchronized void remove(JobEntry je) {
        this.queue.removeElement((Object)je);
        this.sortQueue();
    }

    public synchronized void modify(JobEntry je) throws TurbineException {
        this.remove(je);
        je.calcRunTime();
        this.add(je);
        this.sortQueue();
    }

    public synchronized void updateQueue(JobEntry je) throws TurbineException {
        je.calcRunTime();
        this.sortQueue();
    }

    private void sortQueue() {
        Comparator<JobEntry> aComparator = new Comparator<JobEntry>(){

            @Override
            public int compare(JobEntry o1, JobEntry o2) {
                Long time1 = new Long(o1.getNextRuntime());
                Long time2 = new Long(o2.getNextRuntime());
                return time1.compareTo(time2);
            }
        };
        Collections.sort(this.queue, aComparator);
    }
}

