/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.util.Iterator;
import org.apache.torque.om.Persistent;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.RolePeerManager;
import org.apache.turbine.services.security.torque.TorqueObject;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TorqueRole
extends TorqueObject
implements Role,
Comparable {
    private static final long serialVersionUID = -7774684697021445523L;
    private PermissionSet permissionSet = null;

    public TorqueRole() {
    }

    public TorqueRole(String name) {
        super(name);
    }

    public TorqueRole(Persistent obj) {
        super(obj);
    }

    @Override
    public Persistent getPersistentObj() {
        if (this.obj == null) {
            this.obj = RolePeerManager.newPersistentInstance();
        }
        return this.obj;
    }

    @Override
    public String getName() {
        return RolePeerManager.getRoleName(this.getPersistentObj());
    }

    @Override
    public void setName(String name) {
        RolePeerManager.setRoleName(this.getPersistentObj(), name);
    }

    @Override
    public int getId() {
        return RolePeerManager.getIdAsObj(this.getPersistentObj());
    }

    @Override
    public Integer getIdAsObj() {
        return RolePeerManager.getIdAsObj(this.getPersistentObj());
    }

    @Override
    public void setId(int id) {
        RolePeerManager.setId(this.getPersistentObj(), id);
    }

    @Override
    public PermissionSet getPermissions() throws Exception {
        return this.permissionSet;
    }

    @Override
    public void setPermissions(PermissionSet permissionSet) {
        this.permissionSet = permissionSet;
    }

    @Override
    public Role create(String name) throws TurbineSecurityException {
        return TurbineSecurity.createRole(name);
    }

    @Override
    public void save() throws TurbineSecurityException {
        TurbineSecurity.saveRole(this);
    }

    @Override
    public void remove() throws TurbineSecurityException {
        TurbineSecurity.removeRole(this);
    }

    @Override
    public void rename(String name) throws TurbineSecurityException {
        TurbineSecurity.renameRole(this, name);
    }

    @Override
    public void grant(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.grant(this, permission);
    }

    @Override
    public void grant(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.grant(this, (Permission)permissions.next());
        }
    }

    @Override
    public void revoke(Permission permission) throws TurbineSecurityException {
        TurbineSecurity.revoke(this, permission);
    }

    @Override
    public void revoke(PermissionSet permissionSet) throws TurbineSecurityException {
        Iterator permissions = permissionSet.iterator();
        while (permissions.hasNext()) {
            TurbineSecurity.revoke(this, (Permission)permissions.next());
        }
    }
}

