/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.BaseSecurityService;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.GroupPeerManager;
import org.apache.turbine.services.security.torque.PermissionPeerManager;
import org.apache.turbine.services.security.torque.RolePeerManager;
import org.apache.turbine.services.security.torque.om.TurbineRolePermissionPeer;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public class TorqueSecurityService
extends BaseSecurityService {
    private static Log log = LogFactory.getLog(TorqueSecurityService.class);

    @Override
    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        GroupPeerManager.init(conf);
        RolePeerManager.init(conf);
        PermissionPeerManager.init(conf);
        super.init();
    }

    @Override
    public AccessControlList getACL(User user) throws DataBackendException, UnknownEntityException {
        if (!TurbineSecurity.accountExists(user)) {
            throw new UnknownEntityException("The account '" + user.getName() + "' does not exist");
        }
        try {
            Hashtable<Group, RoleSet> roles = new Hashtable<Group, RoleSet>();
            Hashtable<Group, PermissionSet> permissions = new Hashtable<Group, PermissionSet>();
            this.lockShared();
            for (Group group : this.getAllGroups()) {
                RoleSet groupRoles = RolePeerManager.retrieveSet(user, group);
                roles.put(group, groupRoles);
                PermissionSet groupPermissions = new PermissionSet();
                for (Role role : groupRoles) {
                    PermissionSet rolePermissions = PermissionPeerManager.retrieveSet(role);
                    groupPermissions.add(rolePermissions);
                }
                permissions.put(group, groupPermissions);
            }
            AccessControlList accessControlList = this.getAclInstance(roles, permissions);
            return accessControlList;
        }
        catch (Exception e) {
            throw new DataBackendException("Failed to build ACL for user '" + user.getName() + "'", e);
        }
        finally {
            this.unlockShared();
        }
    }

    @Override
    public synchronized void grant(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            this.lockExclusive();
            userExists = TurbineSecurity.accountExists(user);
            groupExists = this.checkExists(group);
            roleExists = this.checkExists(role);
            if (userExists && groupExists && roleExists) {
                Criteria criteria = new Criteria();
                criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)((Persistent)user).getPrimaryKey());
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)((Persistent)role).getPrimaryKey());
                TurbineUserGroupRolePeer.doInsert(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(User,Group,Role) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    @Override
    public synchronized void revoke(User user, Group group, Role role) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        boolean groupExists = false;
        boolean roleExists = false;
        try {
            this.lockExclusive();
            userExists = TurbineSecurity.accountExists(user);
            groupExists = this.checkExists(group);
            roleExists = this.checkExists(role);
            if (userExists && groupExists && roleExists) {
                Criteria criteria = new Criteria();
                criteria.add(TurbineUserGroupRolePeer.USER_ID, (Object)((Persistent)user).getPrimaryKey());
                criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
                criteria.add(TurbineUserGroupRolePeer.ROLE_ID, (Object)((Persistent)role).getPrimaryKey());
                TurbineUserGroupRolePeer.doDelete(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revoke(User,Role,Group) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        if (!userExists) {
            throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
        }
        if (!groupExists) {
            throw new UnknownEntityException("Unknown group '" + group.getName() + "'");
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
    }

    @Override
    public synchronized void revokeAll(User user) throws DataBackendException, UnknownEntityException {
        boolean userExists = false;
        try {
            this.lockExclusive();
            userExists = TurbineSecurity.accountExists(user);
            if (userExists) {
                int id = ((NumberKey)((Persistent)user).getPrimaryKey()).intValue();
                TurbineUserGroupRolePeer.deleteAll((String)TurbineUserGroupRolePeer.TABLE_NAME, (String)TurbineUserGroupRolePeer.USER_ID, (int)id);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revokeAll(User) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown user '" + user.getName() + "'");
    }

    @Override
    public synchronized void grant(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            permissionExists = this.checkExists(permission);
            if (roleExists && permissionExists) {
                Criteria criteria = new Criteria();
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)((Persistent)role).getPrimaryKey());
                criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)((Persistent)permission).getPrimaryKey());
                TurbineRolePermissionPeer.doInsert(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("grant(Role,Permission) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    @Override
    public synchronized void revoke(Role role, Permission permission) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        boolean permissionExists = false;
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            permissionExists = this.checkExists(permission);
            if (roleExists && permissionExists) {
                Criteria criteria = new Criteria();
                criteria.add(TurbineRolePermissionPeer.ROLE_ID, (Object)((Persistent)role).getPrimaryKey());
                criteria.add(TurbineRolePermissionPeer.PERMISSION_ID, (Object)((Persistent)permission).getPrimaryKey());
                TurbineRolePermissionPeer.doDelete(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revoke(Role,Permission) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        if (!roleExists) {
            throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
        }
        if (!permissionExists) {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    @Override
    public synchronized void revokeAll(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            if (roleExists) {
                int id = ((NumberKey)((Persistent)role).getPrimaryKey()).intValue();
                TurbineRolePermissionPeer.deleteAll((String)TurbineRolePermissionPeer.TABLE_NAME, (String)TurbineRolePermissionPeer.ROLE_ID, (int)id);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("revokeAll(Role) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    @Override
    public GroupSet getGroups(Object criteria) throws DataBackendException {
        if (criteria instanceof Criteria) {
            Criteria torqueCriteria = new Criteria();
            Criteria c = (Criteria)criteria;
            for (String key : c.keySet()) {
                torqueCriteria.put((Object)GroupPeerManager.getColumnName(key), c.get((Object)key));
            }
            ArrayList<Group> groups = new ArrayList(0);
            try {
                groups = GroupPeerManager.doSelect(torqueCriteria);
            }
            catch (TorqueException e) {
                throw new DataBackendException("getGroups(Object) failed", e);
            }
            return new GroupSet(groups);
        }
        throw new DataBackendException("getGroups(Object) failed with invalid criteria");
    }

    @Override
    public RoleSet getRoles(Object criteria) throws DataBackendException {
        if (criteria instanceof Criteria) {
            Criteria torqueCriteria = new Criteria();
            Criteria c = (Criteria)criteria;
            for (String key : c.keySet()) {
                torqueCriteria.put((Object)RolePeerManager.getColumnName(key), c.get((Object)key));
            }
            ArrayList<Role> roles = new ArrayList(0);
            try {
                roles = RolePeerManager.doSelect(torqueCriteria);
            }
            catch (TorqueException e) {
                throw new DataBackendException("getRoles(Criteria) failed", e);
            }
            return new RoleSet(roles);
        }
        throw new DataBackendException("getRoles(Object) failed with invalid criteria");
    }

    @Override
    public PermissionSet getPermissions(Object criteria) throws DataBackendException {
        if (criteria instanceof Criteria) {
            Criteria torqueCriteria = new Criteria();
            Criteria c = (Criteria)criteria;
            for (String key : c.keySet()) {
                torqueCriteria.put((Object)PermissionPeerManager.getColumnName(key), c.get((Object)key));
            }
            ArrayList<Permission> permissions = new ArrayList(0);
            try {
                permissions = PermissionPeerManager.doSelect(torqueCriteria);
            }
            catch (TorqueException e) {
                throw new DataBackendException("getPermissions(Object) failed", e);
            }
            return new PermissionSet(permissions);
        }
        throw new DataBackendException("getPermissions(Object) failed with invalid criteria");
    }

    @Override
    public PermissionSet getPermissions(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            this.lockShared();
            roleExists = this.checkExists(role);
            if (roleExists) {
                PermissionSet permissionSet = PermissionPeerManager.retrieveSet(role);
                return permissionSet;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("getPermissions(Role) failed", e);
        }
        finally {
            this.unlockShared();
        }
        throw new UnknownEntityException("Unknown role '" + role.getName() + "'");
    }

    @Override
    public void saveGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            groupExists = this.checkExists(group);
            if (groupExists) {
                Criteria criteria = GroupPeerManager.buildCriteria(group);
                GroupPeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveGroup(Group) failed", e);
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    @Override
    public void saveRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            roleExists = this.checkExists(role);
            if (roleExists) {
                Criteria criteria = RolePeerManager.buildCriteria(role);
                RolePeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("saveRole(Role) failed", e);
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    @Override
    public void savePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                Criteria criteria = PermissionPeerManager.buildCriteria(permission);
                PermissionPeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("savePermission(Permission) failed", e);
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    @Override
    public synchronized Group addGroup(Group group) throws DataBackendException, EntityExistsException {
        boolean groupExists = false;
        if (StringUtils.isEmpty((String)group.getName())) {
            throw new DataBackendException("Could not create a group with empty name!");
        }
        try {
            this.lockExclusive();
            groupExists = this.checkExists(group);
            if (!groupExists) {
                Criteria criteria = GroupPeerManager.buildCriteria(group);
                GroupPeerManager.doInsert(criteria);
                criteria = new Criteria();
                criteria.add(GroupPeerManager.getNameColumn(), (Object)group.getName());
                List results = GroupPeerManager.doSelect(criteria);
                if (results.size() != 1) {
                    throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                }
                Group newGroup = (Group)results.get(0);
                this.getAllGroups().add(newGroup);
                Group group2 = newGroup;
                return group2;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addGroup(Group) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new EntityExistsException("Group '" + group + "' already exists");
    }

    @Override
    public synchronized Role addRole(Role role) throws DataBackendException, EntityExistsException {
        boolean roleExists = false;
        if (StringUtils.isEmpty((String)role.getName())) {
            throw new DataBackendException("Could not create a role with empty name!");
        }
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            if (!roleExists) {
                Criteria criteria = RolePeerManager.buildCriteria(role);
                RolePeerManager.doInsert(criteria);
                criteria = new Criteria();
                criteria.add(RolePeerManager.getNameColumn(), (Object)role.getName());
                List results = RolePeerManager.doSelect(criteria);
                if (results.size() != 1) {
                    throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                }
                Role newRole = (Role)results.get(0);
                this.getAllRoles().add(newRole);
                Role role2 = newRole;
                return role2;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addRole(Role) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new EntityExistsException("Role '" + role + "' already exists");
    }

    @Override
    public synchronized Permission addPermission(Permission permission) throws DataBackendException, EntityExistsException {
        boolean permissionExists = false;
        if (StringUtils.isEmpty((String)permission.getName())) {
            throw new DataBackendException("Could not create a permission with empty name!");
        }
        try {
            this.lockExclusive();
            permissionExists = this.checkExists(permission);
            if (!permissionExists) {
                Criteria criteria = PermissionPeerManager.buildCriteria(permission);
                PermissionPeerManager.doInsert(criteria);
                criteria = new Criteria();
                criteria.add(PermissionPeerManager.getNameColumn(), (Object)permission.getName());
                List results = PermissionPeerManager.doSelect(criteria);
                if (results.size() != 1) {
                    throw new DataBackendException("Internal error - query returned " + results.size() + " rows");
                }
                Permission newPermission = (Permission)results.get(0);
                this.getAllPermissions().add(newPermission);
                Permission permission2 = newPermission;
                return permission2;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("addPermission(Permission) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new EntityExistsException("Permission '" + permission + "' already exists");
    }

    @Override
    public synchronized void removeGroup(Group group) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            this.lockExclusive();
            groupExists = this.checkExists(group);
            if (groupExists) {
                Criteria criteria = GroupPeerManager.buildCriteria(group);
                GroupPeerManager.doDelete(criteria);
                this.getAllGroups().remove(group);
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to delete a Group");
            log.error((Object)e);
            throw new DataBackendException("removeGroup(Group) failed", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    @Override
    public synchronized void removeRole(Role role) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            if (roleExists) {
                this.revokeAll(role);
                Criteria criteria = RolePeerManager.buildCriteria(role);
                RolePeerManager.doDelete(criteria);
                this.getAllRoles().remove(role);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("removeRole(Role)", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    @Override
    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            this.lockExclusive();
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                Criteria criteria = PermissionPeerManager.buildCriteria(permission);
                PermissionPeerManager.doDelete(criteria);
                this.getAllPermissions().remove(permission);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("removePermission(Permission)", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    @Override
    public synchronized void renameGroup(Group group, String name) throws DataBackendException, UnknownEntityException {
        boolean groupExists = false;
        try {
            this.lockExclusive();
            groupExists = this.checkExists(group);
            if (groupExists) {
                group.setName(name);
                Criteria criteria = GroupPeerManager.buildCriteria(group);
                GroupPeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("renameGroup(Group,String)", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown group '" + group + "'");
    }

    @Override
    public synchronized void renameRole(Role role, String name) throws DataBackendException, UnknownEntityException {
        boolean roleExists = false;
        try {
            this.lockExclusive();
            roleExists = this.checkExists(role);
            if (roleExists) {
                role.setName(name);
                Criteria criteria = RolePeerManager.buildCriteria(role);
                RolePeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("renameRole(Role,String)", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown role '" + role + "'");
    }

    @Override
    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        boolean permissionExists = false;
        try {
            this.lockExclusive();
            permissionExists = this.checkExists(permission);
            if (permissionExists) {
                permission.setName(name);
                Criteria criteria = PermissionPeerManager.buildCriteria(permission);
                PermissionPeerManager.doUpdate(criteria);
                return;
            }
        }
        catch (Exception e) {
            throw new DataBackendException("renamePermission(Permission,name)", e);
        }
        finally {
            this.unlockExclusive();
        }
        throw new UnknownEntityException("Unknown permission '" + permission + "'");
    }

    protected boolean checkExists(Group group) throws DataBackendException, Exception {
        return GroupPeerManager.checkExists(group);
    }

    protected boolean checkExists(Role role) throws DataBackendException, Exception {
        return RolePeerManager.checkExists(role);
    }

    protected boolean checkExists(Permission permission) throws DataBackendException, Exception {
        return PermissionPeerManager.checkExists(permission);
    }

    @Override
    public GroupSet getAllGroups() throws DataBackendException {
        return this.getGroups(new Criteria());
    }

    @Override
    public PermissionSet getAllPermissions() throws DataBackendException {
        return this.getPermissions(new Criteria());
    }

    @Override
    public RoleSet getAllRoles() throws DataBackendException {
        return this.getRoles(new Criteria());
    }

    @Override
    public List getUserList(Object criteria) throws DataBackendException {
        return this.getUserManager().retrieveList(criteria);
    }
}

