/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.jabsorb.JSONRPCBridge;
import org.jabsorb.JSONSerializer;
import org.jabsorb.client.ClientError;
import org.jabsorb.client.ErrorResponse;
import org.jabsorb.client.Session;
import org.jabsorb.serializer.FixUp;
import org.jabsorb.serializer.SerializerState;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
implements InvocationHandler {
    private static Logger log = LoggerFactory.getLogger(Client.class);
    private Session session;
    private JSONSerializer serializer;
    private int id = 0;
    private ProxyMap proxyMap = new ProxyMap();

    public JSONSerializer getSerializer() {
        return this.serializer;
    }

    public Client(Session session) {
        try {
            this.session = session;
            this.serializer = new JSONSerializer();
            this.serializer.registerDefaultSerializers();
        }
        catch (Exception e) {
            throw new ClientError(e);
        }
    }

    private synchronized int getId() {
        return this.id++;
    }

    public Object openProxy(String key, Class klass) {
        Object result = Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, (InvocationHandler)this);
        this.proxyMap.put(result, key);
        return result;
    }

    public void closeProxy(Object proxy) {
        this.proxyMap.remove(proxy);
    }

    public Object invoke(Object proxyObj, Method method, Object[] args) throws Exception {
        String methodName = method.getName();
        if (methodName.equals("hashCode")) {
            return new Integer(System.identityHashCode(proxyObj));
        }
        if (methodName.equals("equals")) {
            return proxyObj == args[0] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (methodName.equals("toString")) {
            return proxyObj.getClass().getName() + '@' + Integer.toHexString(proxyObj.hashCode());
        }
        return this.invoke(this.proxyMap.getString(proxyObj), method.getName(), args, method.getReturnType());
    }

    private Object invoke(String objectTag, String methodName, Object[] args, Class returnType) throws Exception {
        Object rawResult;
        JSONArray fixups;
        int id = this.getId();
        JSONObject message = new JSONObject();
        String methodTag = objectTag == null ? "" : objectTag + ".";
        methodTag = methodTag + methodName;
        message.put("method", methodTag);
        SerializerState state = new SerializerState();
        if (args != null) {
            JSONArray params = (JSONArray)this.serializer.marshall(state, null, args, "params");
            if (state.getFixUps() != null && state.getFixUps().size() > 0) {
                fixups = new JSONArray();
                for (FixUp fixup : state.getFixUps()) {
                    fixups.put(fixup.toJSONArray());
                }
                message.put("fixups", fixups);
            }
            message.put("params", params);
        } else {
            message.put("params", new JSONArray());
        }
        message.put("id", id);
        JSONObject responseMessage = this.session.sendAndReceive(message);
        if (!responseMessage.has("result")) {
            this.processException(responseMessage);
        }
        if ((rawResult = responseMessage.get("result")) == null) {
            this.processException(responseMessage);
        }
        if (returnType.equals(Void.TYPE)) {
            return null;
        }
        fixups = responseMessage.optJSONArray("fixups");
        if (fixups != null) {
            for (int i = 0; i < fixups.length(); ++i) {
                JSONArray assignment = fixups.getJSONArray(i);
                JSONArray fixup = assignment.getJSONArray(0);
                JSONArray original = assignment.getJSONArray(1);
                JSONRPCBridge.applyFixup(rawResult, fixup, original);
            }
        }
        return this.serializer.unmarshall(new SerializerState(), returnType, rawResult);
    }

    protected void processException(JSONObject responseMessage) throws JSONException {
        JSONObject error = (JSONObject)responseMessage.get("error");
        if (error != null) {
            Integer code = new Integer(error.has("code") ? error.getInt("code") : 0);
            String trace = error.has("trace") ? error.getString("trace") : null;
            String msg = error.has("msg") ? error.getString("msg") : null;
            throw new ErrorResponse(code, msg, trace);
        }
        throw new ErrorResponse(new Integer(590), "Unknown response:" + responseMessage.toString(2), null);
    }

    private static class ProxyMap
    extends HashMap {
        private ProxyMap() {
        }

        public String getString(Object key) {
            return (String)super.get(key);
        }

        public Object putString(String key, Object value) {
            return super.put(key, value);
        }
    }
}

