/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.extensions;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.extensions.DefaultEngineLoader;
import org.apache.uima.ruta.extensions.IEngineLoader;
import org.apache.uima.util.InvalidXMLException;

public class RutaEngineLoader
extends DefaultEngineLoader {
    private Map<String, IEngineLoader> loaders = new HashMap<String, IEngineLoader>();

    public AnalysisEngine loadEngine(String location, String viewName) throws InvalidXMLException, ResourceInitializationException, ResourceConfigurationException, IOException, URISyntaxException {
        String name = this.getEngineName(location);
        AnalysisEngine result = null;
        IEngineLoader engineLoader = this.loaders.get(name);
        result = engineLoader != null ? engineLoader.loadEngine(location, viewName) : this.loadEngineMyself(location, viewName);
        return result;
    }

    public AnalysisEngine loadEngineIS(String location, String viewName) throws InvalidXMLException, ResourceInitializationException, IOException, ResourceConfigurationException, URISyntaxException {
        String name = this.getEngineNameIS(location);
        AnalysisEngine result = null;
        IEngineLoader engineLoader = this.loaders.get(name);
        result = engineLoader != null ? engineLoader.loadEngine(location, viewName) : this.loadEngineMyselfIS(location);
        return result;
    }

    public void addLoader(String engine, IEngineLoader loader) {
        this.loaders.put(engine, loader);
    }

    private String getEngineName(String location) {
        File file;
        try {
            file = new File(location);
        }
        catch (NullPointerException e) {
            throw new NullPointerException("File[" + location + "] cannot be opened.");
        }
        location = file.getName();
        String[] split = location.split("[.]");
        return split[split.length - 2];
    }

    private String getEngineNameIS(String location) {
        String[] split = location.split("[.]");
        return split[split.length - 2];
    }

    public boolean isInitialized() {
        return !this.loaders.isEmpty();
    }

    public String[] getKnownEngines() {
        return this.loaders.keySet().toArray(new String[0]);
    }
}

