/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextNode {
    private char value;
    private boolean isWordEnd;
    private Map<Character, TextNode> children;

    public TextNode() {
        this.value = (char)32;
        this.isWordEnd = false;
        this.children = new HashMap<Character, TextNode>();
    }

    public TextNode(char value, boolean isWordEnd) {
        this.value = value;
        this.isWordEnd = isWordEnd;
        this.children = new HashMap<Character, TextNode>(5);
    }

    public boolean contains(char c) {
        return this.value == c;
    }

    public void addChild(char c, boolean isWordEnd) {
        this.children.put(Character.valueOf(c), new TextNode(c, isWordEnd));
    }

    public void addChild(TextNode n) {
        this.children.put(Character.valueOf(n.getValue()), n);
    }

    public void setWordEnd(boolean b) {
        this.isWordEnd = b;
    }

    public TextNode getChildNode(char c) {
        return this.children.get(Character.valueOf(c));
    }

    public char getValue() {
        return this.value;
    }

    public boolean isWordEnd() {
        return this.isWordEnd;
    }

    public Map<Character, TextNode> getChildren() {
        return this.children;
    }

    public String toString() {
        return this.value + (this.isWordEnd ? "+" : "");
    }
}

