/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.ruta.cde.IRutaConstraint;
import org.apache.uima.ruta.cde.utils.EvaluationMeasures;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.core.runtime.Path;

public class RutaGEConstraint
implements IRutaConstraint {
    private String constraintText;
    private String description;
    private AnalysisEngine ae;
    private boolean initalized = false;
    private HashMap<String, Double> rulesMap;

    public RutaGEConstraint(String constraintText, String description) {
        this.constraintText = constraintText;
        this.description = description;
    }

    public void initialize() throws Exception {
        this.rulesMap = this.createRuleSet();
        Iterator<Map.Entry<String, Double>> rulesIterator = this.rulesMap.entrySet().iterator();
        StringBuilder sb = new StringBuilder();
        sb.append("PACKAGE org.apache.uima.ruta;\n\n");
        int counter = 0;
        while (rulesIterator.hasNext()) {
            Map.Entry<String, Double> entry = rulesIterator.next();
            String rule = entry.getKey();
            sb.append(rule);
            sb.append("\n");
            if (++counter % 100 != 0) continue;
            sb.append("Document{-> LOG(\"" + counter + "/" + this.rulesMap.size() + "\")};");
        }
        URL aedesc = RutaEngine.class.getResource("BasicEngine.xml");
        XMLInputSource inae = new XMLInputSource(aedesc);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(inae);
        ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
        AnalysisEngineDescription aed = (AnalysisEngineDescription)specifier;
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)aed, (ResourceManager)resMgr, null);
        File tempFile = File.createTempFile("RutaCDE", ".ruta");
        tempFile.deleteOnExit();
        FileUtils.saveString2File((String)sb.toString(), (File)tempFile, (String)"UTF-8");
        String portableString = Path.fromOSString((String)tempFile.getParentFile().getPath()).toPortableString();
        this.ae.setConfigParameterValue("scriptPaths", (Object)new String[]{portableString});
        String name = tempFile.getName().substring(0, tempFile.getName().length() - 5);
        this.ae.setConfigParameterValue("mainScript", (Object)name);
        this.ae.setConfigParameterValue("debug", (Object)true);
        this.ae.setConfigParameterValue("debugWithMatches", (Object)true);
        this.ae.setConfigParameterValue("profile", (Object)false);
        this.ae.setConfigParameterValue("statistics", (Object)false);
        this.ae.reconfigure();
    }

    @Override
    public Double processConstraint(CAS cas) throws Exception {
        AnnotationFS fs;
        if (!this.initalized) {
            this.initialize();
        }
        boolean runCount = false;
        boolean printCount = false;
        ArrayList<Double[]> results = new ArrayList<Double[]>();
        Type matchedType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugMatchedRuleMatch");
        Type ruleApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugRuleApply");
        Type blockApplyType = cas.getTypeSystem().getType("org.apache.uima.ruta.type.DebugBlockApply");
        this.removeDebugAnnotations(cas, matchedType, ruleApplyType, blockApplyType);
        double applyAmount = 0.0;
        double triedAmount = 0.0;
        this.ae.process(cas);
        Feature innerApplyFeature = blockApplyType.getFeatureByBaseName("innerApply");
        Feature appliedFeature = ruleApplyType.getFeatureByBaseName("applied");
        Feature triedFeature = ruleApplyType.getFeatureByBaseName("tried");
        Feature elementFeature = ruleApplyType.getFeatureByBaseName("element");
        FSIterator iterator = cas.getAnnotationIndex(blockApplyType).iterator();
        if (iterator.isValid() && (fs = (AnnotationFS)iterator.get()).getType().equals(blockApplyType)) {
            FeatureStructure[] fsArray;
            FeatureStructure featureValue = fs.getFeatureValue(innerApplyFeature);
            FSArray array = (FSArray)featureValue;
            for (FeatureStructure featureStructure : fsArray = array.toArray()) {
                AnnotationFS ruleApply = (AnnotationFS)featureStructure;
                if (!ruleApply.getType().equals(ruleApplyType)) continue;
                applyAmount = ruleApply.getIntValue(appliedFeature);
                triedAmount = ruleApply.getIntValue(triedFeature);
                String ruleString = ruleApply.getStringValue(elementFeature);
                if (triedAmount == 0.0) continue;
                double ratioInDocument = applyAmount / triedAmount;
                String key = ruleString.trim() + ";";
                Double ratioInConstraint = this.rulesMap.get(key);
                if (ratioInConstraint == null) continue;
                results.add(new Double[]{ratioInConstraint, ratioInDocument});
            }
        }
        this.removeDebugAnnotations(cas, matchedType, ruleApplyType, blockApplyType);
        this.ae.destroy();
        return EvaluationMeasures.cosine(results);
    }

    private void removeDebugAnnotations(CAS cas, Type matchedType, Type ruleApplyType, Type blockApplyType) {
        ArrayList<AnnotationFS> toRemove = new ArrayList<AnnotationFS>();
        AnnotationIndex annotationIndex = cas.getAnnotationIndex(blockApplyType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        annotationIndex = cas.getAnnotationIndex(ruleApplyType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        annotationIndex = cas.getAnnotationIndex(matchedType);
        for (AnnotationFS annotationFS : annotationIndex) {
            toRemove.add(annotationFS);
        }
        for (AnnotationFS annotationFS : toRemove) {
            cas.removeFsFromIndexes((FeatureStructure)annotationFS);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public HashMap<String, Double> createRuleSet() {
        HashMap<String, Double> rulesMap = new HashMap<String, Double>();
        try {
            String[] constraintTextArray;
            String content = FileUtils.file2String((File)new File(this.constraintText));
            for (String constraintLine : constraintTextArray = content.split("\n")) {
                String[] singleEstimates;
                String[] patternAndEstimates = constraintLine.split(":");
                if (patternAndEstimates.length < 2) continue;
                String pattern = patternAndEstimates[0];
                pattern = pattern.trim();
                String estimates = patternAndEstimates[1];
                for (String singleEstimate : singleEstimates = estimates.split(",")) {
                    singleEstimate = singleEstimate.trim();
                    String[] typeAndRatio = singleEstimate.split("\\s+");
                    String typeName = typeAndRatio[0];
                    String ratio = typeAndRatio[1];
                    ratio = ratio.trim();
                    String rule = "";
                    rule = pattern.startsWith("\"") ? pattern + "{PARTOF(" + typeName + ")};" : pattern + "{PARTOF(" + typeName + ")};";
                    rulesMap.put(rule, Double.valueOf(ratio));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rulesMap;
    }

    @Override
    public String getData() {
        return this.constraintText;
    }

    @Override
    public void setData(String data) {
        this.constraintText = data;
    }
}

