/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.PrintWriter;
import java.io.Writer;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.trans.DynamicError;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StandardErrorHandler
implements ErrorHandler {
    private ErrorListener errorListener;
    private Writer errorOutput;

    public StandardErrorHandler(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    public void warning(SAXParseException sAXParseException) {
        if (sAXParseException.getMessage().indexOf("relative URI for namespace") >= 0) {
            return;
        }
        if (this.errorListener != null) {
            try {
                this.errorListener.warning(new TransformerException(sAXParseException));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, false);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, true);
        throw sAXParseException;
    }

    protected void reportError(SAXParseException sAXParseException, boolean bl) {
        block8: {
            if (this.errorListener != null) {
                try {
                    ExpressionLocation expressionLocation = new ExpressionLocation(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                    DynamicError dynamicError = new DynamicError("Error reported by XML parser", expressionLocation, sAXParseException);
                    dynamicError.setErrorCode("SXXP0003");
                    if (bl) {
                        this.errorListener.fatalError(dynamicError);
                        break block8;
                    }
                    this.errorListener.error(dynamicError);
                }
                catch (Exception exception) {}
            } else {
                try {
                    if (this.errorOutput == null) {
                        this.errorOutput = new PrintWriter(System.err);
                    }
                    String string = bl ? "Fatal error" : "Error";
                    this.errorOutput.write(string + " reported by XML parser: " + sAXParseException.getMessage() + '\n');
                    this.errorOutput.write("  URL:    " + sAXParseException.getSystemId() + '\n');
                    this.errorOutput.write("  Line:   " + sAXParseException.getLineNumber() + '\n');
                    this.errorOutput.write("  Column: " + sAXParseException.getColumnNumber() + '\n');
                    this.errorOutput.flush();
                }
                catch (Exception exception) {
                    System.err.println(sAXParseException);
                    System.err.println(exception);
                    exception.printStackTrace();
                }
            }
        }
    }
}

