/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.Err;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.event.HTMLURIEscaper;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class EscapeURI
extends SystemFunction {
    public static final int ENCODE_FOR_URI = 1;
    public static final int IRI_TO_URI = 2;
    public static final int HTML_URI = 3;
    public static boolean[] allowedASCII = new boolean[128];
    private static final String hex = "0123456789ABCDEF";
    private static String hexDigits;
    private static int[] UTF8RepresentationLength;

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        if (item == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = item.getStringValueCS();
        switch (this.operation) {
            case 1: {
                return StringValue.makeStringValue(EscapeURI.escape(charSequence, "-_.~"));
            }
            case 2: {
                return StringValue.makeStringValue(EscapeURI.iriToUri(charSequence));
            }
            case 3: {
                return StringValue.makeStringValue(HTMLURIEscaper.escapeURL(charSequence, false));
            }
        }
        throw new UnsupportedOperationException("Unknown escape operation");
    }

    public static CharSequence iriToUri(CharSequence charSequence) {
        if (EscapeURI.allAllowedAscii(charSequence)) {
            return charSequence;
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 20);
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c >= '\u007f' || !allowedASCII[c]) {
                EscapeURI.escapeChar(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }

    private static boolean allAllowedAscii(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u007f' && allowedASCII[c]) continue;
            return false;
        }
        return true;
    }

    public static CharSequence escape(CharSequence charSequence, String string) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                fastStringBuffer.append(c);
                continue;
            }
            if (c <= ' ' || c >= '\u007f') {
                EscapeURI.escapeChar(c, i + 1 < charSequence.length() ? charSequence.charAt(i + 1) : (char)' ', fastStringBuffer);
                continue;
            }
            if (string.indexOf(c) >= 0) {
                fastStringBuffer.append(c);
                continue;
            }
            EscapeURI.escapeChar(c, ' ', fastStringBuffer);
        }
        return fastStringBuffer;
    }

    private static void escapeChar(char c, char c2, FastStringBuffer fastStringBuffer) {
        byte[] byArray = new byte[4];
        int n = UnicodeCharacterSet.getUTF8Encoding(c, c2, byArray);
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            fastStringBuffer.append('%');
            fastStringBuffer.append(hex.charAt(n2 / 16));
            fastStringBuffer.append(hex.charAt(n2 % 16));
        }
    }

    public static void checkPercentEncoding(String string) throws XPathException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            byte[] byArray = null;
            int n2 = 0;
            if (c == '%') {
                int n3;
                if (n + 2 >= string.length()) {
                    throw new DynamicError("% sign in URI must be followed by two hex digits" + Err.wrap(string));
                }
                int n4 = hexDigits.indexOf(string.charAt(n + 1));
                if (n4 > 15) {
                    n4 -= 6;
                }
                if ((n3 = hexDigits.indexOf(string.charAt(n + 2))) > 15) {
                    n3 -= 6;
                }
                if (n4 >= 0 && n3 >= 0) {
                    int n5 = n4 << 4 | n3;
                    n2 = UTF8RepresentationLength[n4];
                    if (n2 == -1) {
                        throw new DynamicError("First %-encoded octet in URI is not valid as the start of a UTF-8 character: first two bits must not be '10'" + Err.wrap(string));
                    }
                    byArray = new byte[n2];
                    byArray[0] = (byte)n5;
                    n += 3;
                    for (int i = 1; i < n2; ++i) {
                        if (n + 2 > string.length() || string.charAt(n) != '%') {
                            throw new DynamicError("Incomplete %-encoded UTF-8 octet sequence in URI " + Err.wrap(string));
                        }
                        n4 = hexDigits.indexOf(string.charAt(n + 1));
                        if (n4 > 15) {
                            n4 -= 6;
                        }
                        if ((n3 = hexDigits.indexOf(string.charAt(n + 2))) > 15) {
                            n3 -= 6;
                        }
                        if (n4 < 0 || n3 < 0) {
                            throw new DynamicError("Invalid %-encoded UTF-8 octet sequence in URI" + Err.wrap(string));
                        }
                        if (UTF8RepresentationLength[n4] != -1) {
                            throw new DynamicError("In a URI, a %-encoded UTF-8 octet after the first must have '10' as the first two bits" + Err.wrap(string));
                        }
                        n5 = n4 << 4 | n3;
                        byArray[i] = (byte)n5;
                        n += 3;
                    }
                    continue;
                }
                throw new DynamicError("% sign in URI must be followed by two hex digits" + Err.wrap(string));
            }
            ++n;
        }
    }

    static {
        Arrays.fill(allowedASCII, 0, 32, false);
        Arrays.fill(allowedASCII, 33, 127, true);
        EscapeURI.allowedASCII[34] = false;
        EscapeURI.allowedASCII[60] = false;
        EscapeURI.allowedASCII[62] = false;
        EscapeURI.allowedASCII[92] = false;
        EscapeURI.allowedASCII[94] = false;
        EscapeURI.allowedASCII[96] = false;
        EscapeURI.allowedASCII[123] = false;
        EscapeURI.allowedASCII[124] = false;
        EscapeURI.allowedASCII[125] = false;
        hexDigits = "0123456789abcdefABCDEF";
        UTF8RepresentationLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, 2, 2, 3, 4};
    }
}

