/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparableAtomicValueComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.sort.EqualityComparer;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class GenericAtomicComparer
implements AtomicComparer,
Serializable {
    private StringCollator collator;
    private XPathContext conversionContext;

    public GenericAtomicComparer(StringCollator stringCollator, XPathContext xPathContext) {
        this.collator = stringCollator;
        if (stringCollator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
    }

    public GenericAtomicComparer(StringCollator stringCollator, Configuration configuration) {
        this.collator = stringCollator;
        if (stringCollator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = configuration.getConversionContext();
    }

    public static AtomicComparer makeAtomicComparer(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, StringCollator stringCollator, Configuration configuration) {
        int n;
        int n2 = builtInAtomicType.getFingerprint();
        if (n2 == (n = builtInAtomicType2.getFingerprint())) {
            switch (n2) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new CalendarValueComparer(configuration);
                }
                case 514: 
                case 633: 
                case 634: {
                    return ComparableAtomicValueComparer.getInstance();
                }
                case 527: 
                case 528: 
                case 530: 
                case 531: {
                    return EqualityComparer.getInstance();
                }
            }
        }
        if (builtInAtomicType.isPrimitiveNumeric() && builtInAtomicType2.isPrimitiveNumeric()) {
            return ComparableAtomicValueComparer.getInstance();
        }
        if ((builtInAtomicType.equals(BuiltInAtomicType.STRING) || builtInAtomicType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType.equals(BuiltInAtomicType.ANY_URI)) && (builtInAtomicType2.equals(BuiltInAtomicType.STRING) || builtInAtomicType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || builtInAtomicType2.equals(BuiltInAtomicType.ANY_URI))) {
            if (stringCollator instanceof CodepointCollator) {
                return CodepointCollatingComparer.getInstance();
            }
            return new CollatingAtomicComparer(stringCollator, Configuration.getPlatform());
        }
        return new GenericAtomicComparer(stringCollator, configuration);
    }

    public StringCollator getStringCollator() {
        return this.collator;
    }

    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue == null) {
            return atomicValue2 == null ? 0 : -1;
        }
        if (atomicValue2 == null) {
            return 1;
        }
        if (atomicValue instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue).compareTo(atomicValue2, this.collator, this.conversionContext);
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)atomicValue2).compareTo(atomicValue, this.collator, this.conversionContext);
        }
        if (atomicValue instanceof CalendarValue && atomicValue2 instanceof CalendarValue) {
            return ((CalendarValue)atomicValue).compareTo((CalendarValue)atomicValue2, this.conversionContext.getConfiguration());
        }
        if (atomicValue instanceof StringValue) {
            return this.collator.compareStrings(((StringValue)atomicValue).getStringValue(), ((StringValue)atomicValue2).getStringValue());
        }
        Comparable comparable = atomicValue.getXPathComparable();
        Comparable comparable2 = atomicValue2.getXPathComparable();
        if (comparable == null || comparable2 == null) {
            if (atomicValue instanceof AtomicValue && atomicValue2 instanceof AtomicValue) {
                throw new ClassCastException("Objects are not comparable (" + Type.displayTypeName(atomicValue) + ", " + Type.displayTypeName(atomicValue2) + ')');
            }
            throw new ClassCastException("Objects are not comparable (" + atomicValue.getClass() + ", " + atomicValue2.getClass() + ')');
        }
        return comparable.compareTo(comparable2);
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue).compareTo(atomicValue2, this.collator, this.conversionContext) == 0;
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue2).compareTo(atomicValue, this.collator, this.conversionContext) == 0;
        }
        if (atomicValue instanceof StringValue) {
            return this.collator.compareStrings(((StringValue)atomicValue).getStringValue(), ((StringValue)atomicValue2).getStringValue()) == 0;
        }
        if (atomicValue instanceof CalendarValue && atomicValue2 instanceof CalendarValue) {
            return ((CalendarValue)atomicValue).compareTo((CalendarValue)atomicValue2, this.conversionContext.getConfiguration()) == 0;
        }
        return atomicValue.equals(atomicValue2);
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        if (atomicValue instanceof StringValue) {
            Platform platform = Configuration.getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, this.collator.getCollationKey(((StringValue)atomicValue).getStringValue(), platform));
            }
            return new ComparisonKey(513, ((StringValue)atomicValue).getStringValue());
        }
        return new ComparisonKey(513, atomicValue);
    }
}

