/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Arrays;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.sort.IntSet;

public class IntHashSet
implements IntSet,
Serializable {
    private static final int NBIT = 30;
    public static final int MAX_SIZE = 0x40000000;
    public final int ndv;
    private int _nmax;
    private int _size;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _values;

    public IntHashSet() {
        this(8, Integer.MIN_VALUE);
    }

    public IntHashSet(int n) {
        this(n, Integer.MIN_VALUE);
    }

    public IntHashSet(int n, int n2) {
        this.ndv = n2;
        this.setCapacity(n);
    }

    public void clear() {
        this._size = 0;
        for (int i = 0; i < this._nmax; ++i) {
            this._values[i] = this.ndv;
        }
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int getFirst(int n) {
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] == this.ndv) continue;
            return this._values[i];
        }
        return n;
    }

    public int[] getValues() {
        int n = 0;
        int[] nArray = new int[this._size];
        for (int i = 0; i < this._values.length; ++i) {
            if (this._values[i] == this.ndv) continue;
            nArray[n++] = this._values[i];
        }
        return nArray;
    }

    public boolean contains(int n) {
        return this._values[this.indexOf(n)] != this.ndv;
    }

    public boolean remove(int n) {
        int n2 = this.indexOf(n);
        if (this._values[n2] == this.ndv) {
            return false;
        }
        --this._size;
        while (true) {
            int n3;
            this._values[n2] = this.ndv;
            int n4 = n2;
            do {
                if (this._values[n2 = n2 - 1 & this._mask] != this.ndv) continue;
                return true;
            } while (n2 <= (n3 = this.hash(this._values[n2])) && n3 < n4 || n3 < n4 && n4 < n2 || n4 < n2 && n2 <= n3);
            this._values[n4] = this._values[n2];
        }
    }

    public boolean add(int n) {
        if (n == this.ndv) {
            throw new IllegalArgumentException("Can't add the 'no data' value");
        }
        int n2 = this.indexOf(n);
        if (this._values[n2] == this.ndv) {
            ++this._size;
            this._values[n2] = n;
            if (this._size > 0x40000000) {
                throw new RuntimeException("Too many elements (> 1073741824)");
            }
            if (this._nlo < this._size && this._size <= this._nhi) {
                this.setCapacity(this._size);
            }
            return true;
        }
        return false;
    }

    private int hash(int n) {
        return 1327217885 * n >> this._shift & this._mask;
    }

    private int indexOf(int n) {
        int n2 = this.hash(n);
        while (this._values[n2] != this.ndv) {
            if (this._values[n2] == n) {
                return n2;
            }
            n2 = n2 - 1 & this._mask;
        }
        return n2;
    }

    private void setCapacity(int n) {
        int n2;
        if (n < this._size) {
            n = this._size;
        }
        int n3 = 1;
        for (n2 = 2; n2 < n * 4 && n2 < 0x40000000; n2 *= 2) {
            ++n3;
        }
        int n4 = this._nmax;
        if (n2 == n4) {
            return;
        }
        this._nmax = n2;
        this._nlo = n2 / 4;
        this._nhi = 0x10000000;
        this._shift = 31 - n3;
        this._mask = n2 - 1;
        this._size = 0;
        int[] nArray = this._values;
        this._values = new int[n2];
        Arrays.fill(this._values, this.ndv);
        if (nArray != null) {
            for (int i = 0; i < n4; ++i) {
                int n5 = nArray[i];
                if (n5 == this.ndv) continue;
                ++this._size;
                this._values[this.indexOf((int)n5)] = n5;
            }
        }
    }

    public IntIterator iterator() {
        return new IntHashSetIterator();
    }

    public IntHashSet union(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size() + intHashSet.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            intHashSet2.add(intIterator.next());
        }
        intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            intHashSet2.add(intIterator.next());
        }
        return intHashSet2;
    }

    public IntHashSet intersect(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!intHashSet.contains(n)) continue;
            intHashSet2.add(n);
        }
        return intHashSet2;
    }

    public IntHashSet except(IntHashSet intHashSet) {
        IntHashSet intHashSet2 = new IntHashSet(this.size());
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (intHashSet.contains(n)) continue;
            intHashSet2.add(n);
        }
        return intHashSet2;
    }

    public boolean containsAll(IntSet intSet) {
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            if (this.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsSome(IntHashSet intHashSet) {
        IntIterator intIterator = intHashSet.iterator();
        while (intIterator.hasNext()) {
            if (!this.contains(intIterator.next())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof IntSet) {
            IntHashSet intHashSet = (IntHashSet)object;
            return this.size() == intHashSet.size() && this.containsAll(intHashSet);
        }
        return false;
    }

    public int hashCode() {
        int n = 936247625;
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n += intIterator.next();
        }
        return n;
    }

    private class IntHashSetIterator
    implements IntIterator,
    Serializable {
        private int i = 0;

        public boolean hasNext() {
            while (this.i < IntHashSet.this._values.length) {
                if (IntHashSet.this._values[this.i] != IntHashSet.this.ndv) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public int next() {
            return IntHashSet.this._values[this.i++];
        }
    }
}

