/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.resource.ResourceManager;
import org.springframework.util.ClassUtils;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoader findClassloader() {
        ClassLoader uimaThreadContextClassLoader = ClassLoaderUtils.getExtensionClassloader(UimaContextHolder.getContext());
        if (uimaThreadContextClassLoader != null) {
            return uimaThreadContextClassLoader;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader uimaFITClassLoader = ClassLoaderUtils.class.getClassLoader();
        if (uimaFITClassLoader != null) {
            return uimaFITClassLoader;
        }
        return ClassUtils.getDefaultClassLoader();
    }

    public static ClassLoader findClassloader(ResourceManager aResMgr) {
        ClassLoader resourceManagerExtensionClassloader = ClassLoaderUtils.getExtensionClassloader(aResMgr);
        if (resourceManagerExtensionClassloader != null) {
            return resourceManagerExtensionClassloader;
        }
        return ClassLoaderUtils.findClassloader();
    }

    public static ClassLoader findClassloader(UimaContext aContext) {
        ClassLoader uimaContextExtensionClassloader = ClassLoaderUtils.getExtensionClassloader(aContext);
        if (uimaContextExtensionClassloader != null) {
            return uimaContextExtensionClassloader;
        }
        return ClassLoaderUtils.findClassloader((ResourceManager)null);
    }

    private static ClassLoader getExtensionClassloader(UimaContext aContext) {
        if (aContext instanceof UimaContextAdmin) {
            return ClassLoaderUtils.getExtensionClassloader(((UimaContextAdmin)aContext).getResourceManager());
        }
        return null;
    }

    private static ClassLoader getExtensionClassloader(ResourceManager aResMgr) {
        if (aResMgr == null) {
            return null;
        }
        ClassLoader cl = aResMgr.getExtensionClassLoader();
        if (cl != null) {
            return aResMgr.getExtensionClassLoader();
        }
        return null;
    }
}

