/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.uima.tools.cvd.IndexTreeNode;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.tools.cvd.TypeTreeNode;
import org.apache.uima.tools.cvd.control.ShowAnnotatedTextHandler;

public class IndexPopupListener
extends MouseAdapter {
    private final MainFrame main;

    public IndexPopupListener(MainFrame frame) {
        this.main = frame;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.main.getIndexTree().getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object userObject = node.getUserObject();
            String annotTitle = null;
            boolean isAnnotation = true;
            if (userObject instanceof IndexTreeNode) {
                IndexTreeNode iNode = (IndexTreeNode)userObject;
                if (!iNode.getName().equals("AnnotationIndex")) {
                    isAnnotation = false;
                }
                annotTitle = iNode.getType().getName();
            } else if (userObject instanceof TypeTreeNode) {
                TypeTreeNode tNode = (TypeTreeNode)userObject;
                if (!tNode.getLabel().equals("AnnotationIndex")) {
                    isAnnotation = false;
                }
                annotTitle = tNode.getType().getName();
            } else {
                isAnnotation = false;
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem item = null;
            if (isAnnotation) {
                item = new JMenuItem("Show annotations: " + annotTitle);
                item.addActionListener(new ShowAnnotatedTextHandler(this.main));
            } else {
                item = new JMenuItem("No annotations selected");
            }
            menu.add(item);
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

