/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.install;

import java.io.File;
import java.io.IOException;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstaller;
import org.apache.uima.pear.tools.PackageInstallerException;

public class InstallPearCli {
    public static void main(String[] args) {
        if (null == args || args.length == 0 || "?".equals(args[0]) || "-h".equals(args[0]) || "-help".equals(args[0])) {
            InstallPearCli.printUsageAndExit();
        }
        File pathToPear = new File(args[0]);
        File installDir = null;
        boolean doVerification = false;
        for (int i = 1; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-c") || a.equals("-check") || a.equals("-verify")) {
                doVerification = true;
                continue;
            }
            if (a.startsWith("-")) {
                InstallPearCli.printUsageAndExit();
                continue;
            }
            installDir = new File(a);
        }
        if (installDir == null) {
            installDir = new File(pathToPear.getName().replace(".pear", ""));
        }
        InstallPearCli.installPear(installDir, pathToPear, doVerification);
    }

    private static void installPear(File installDir, File pearFile, boolean doVerification) {
        try {
            PackageBrowser instPear = PackageInstaller.installPackage((File)installDir, (File)pearFile, (boolean)doVerification);
            String classpath = instPear.buildComponentClassPath();
            String datapath = instPear.getComponentDataPath();
            String mainComponentDescriptor = instPear.getInstallationDescriptor().getMainComponentDesc();
            String mainComponentID = instPear.getInstallationDescriptor().getMainComponentId();
            String pearDescPath = instPear.getComponentPearDescPath();
            System.out.println("PEAR package class path: " + classpath);
            System.out.println("PEAR package datapath: " + datapath);
            System.out.println("PEAR package mainComponentDescriptor: " + mainComponentDescriptor);
            System.out.println("PEAR package mainComponentID: " + mainComponentID);
            System.out.println("PEAR package specifier path: " + pearDescPath);
            System.out.println("PEAR installed successfully");
        }
        catch (PackageInstallerException ex) {
            ex.printStackTrace();
            System.out.println("PEAR installation failed");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("Error retrieving installed PEAR settings");
        }
    }

    private static void printUsageAndExit() {
        System.out.println("Usage: installPearCli pathToPearFile [directoryToInstallInto] [options]\n\n  *** items in [] are optional ***Install a Pear file into a specified directory\nInstall directory defaults to the current directory/pearFileName\nOptions:\n -c or -check or -verify: Run the Pear validation checks after installing\n");
        System.exit(1);
    }
}

