/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.packager;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.uima.internal.util.CommandLineParser;
import org.apache.uima.pear.tools.PackageCreator;

public class PearPackager {
    private static final String INSTALL_ACTION_PARAM = "-create";
    private static final String PACKAGE_ACTION_PARAM = "-package";
    private static final String COMPONENT_ID_PARAM = "-compID";
    private static final String MAIN_COMPONENT_DESC_PARAM = "-mainCompDesc";
    private static final String CLASSPATH_PARAM = "-classpath";
    private static final String DATAPATH_PARAM = "-datapath";
    private static final String ENV_VAR_PARAM = "-envVars";
    private static final String MAIN_COMPONENT_DIR_PARAM = "-mainCompDir";
    private static final String TARGET_DIR_PARAM = "-targetDir";

    private static final CommandLineParser createCmdLineParser() {
        CommandLineParser parser = new CommandLineParser();
        parser.addParameter(INSTALL_ACTION_PARAM, false);
        parser.addParameter(PACKAGE_ACTION_PARAM, false);
        parser.addParameter(COMPONENT_ID_PARAM, true);
        parser.addParameter(MAIN_COMPONENT_DESC_PARAM, true);
        parser.addParameter(CLASSPATH_PARAM, true);
        parser.addParameter(DATAPATH_PARAM, true);
        parser.addParameter(ENV_VAR_PARAM, true);
        parser.addParameter(MAIN_COMPONENT_DIR_PARAM, true);
        parser.addParameter(TARGET_DIR_PARAM, true);
        return parser;
    }

    private static final void printUsage() {
        System.out.println("The PearPackager can be used in three different modes: ");
        System.out.println("Mode 1: create a complete PEAR package (default mode)");
        System.out.println("Mode 2: just create the PEAR installation descriptor");
        System.out.println("Mode 3: just package a PEAR file \n");
        System.out.println("Mode 1 usage: java org.apache.uima.tools.pear.packager.PearPackager -compID <componentID> -mainCompDesc <mainComponentDesc> [-classpath <classpath>] [-datapath <datapath>] -mainCompDir <mainComponentDir> -targetDir <targetDir> [-envVars <propertiesFilePath>]\n");
        System.out.println("Mode 2 usage: java org.apache.uima.tools.pear.packager.PearPackager -create -compID <componentID> -mainCompDesc <mainComponentDesc> [-classpath <classpath>] [-datapath <datapath>] -mainCompDir <mainComponentDir> [-envVars <propertiesFilePath>]\n");
        System.out.println("Mode 3 usage: java org.apache.uima.tools.pear.packager.PearPackager -package -compID <componentID> -mainCompDir <mainComponentDir> -targetDir <targetDir>");
    }

    private static final boolean checkCmdLineSyntax(CommandLineParser clp) {
        if (!(!clp.isInArgsList(INSTALL_ACTION_PARAM) || clp.isInArgsList(COMPONENT_ID_PARAM) && clp.isInArgsList(MAIN_COMPONENT_DESC_PARAM) && clp.isInArgsList(MAIN_COMPONENT_DIR_PARAM))) {
            return false;
        }
        if (!(!clp.isInArgsList(PACKAGE_ACTION_PARAM) || clp.isInArgsList(COMPONENT_ID_PARAM) && clp.isInArgsList(TARGET_DIR_PARAM) && clp.isInArgsList(MAIN_COMPONENT_DIR_PARAM))) {
            return false;
        }
        return clp.isInArgsList(INSTALL_ACTION_PARAM) || clp.isInArgsList(PACKAGE_ACTION_PARAM) || clp.isInArgsList(COMPONENT_ID_PARAM) && clp.isInArgsList(MAIN_COMPONENT_DESC_PARAM) && clp.isInArgsList(MAIN_COMPONENT_DIR_PARAM) && clp.isInArgsList(TARGET_DIR_PARAM);
    }

    public static void main(String[] args) {
        String installDesc = null;
        String pearFile = null;
        try {
            CommandLineParser clp = PearPackager.createCmdLineParser();
            clp.parseCmdLine(args);
            if (!PearPackager.checkCmdLineSyntax(clp)) {
                PearPackager.printUsage();
                System.exit(2);
            }
            boolean doInstallAction = false;
            boolean doPackageAction = false;
            if (clp.isInArgsList(INSTALL_ACTION_PARAM)) {
                doInstallAction = true;
            }
            if (clp.isInArgsList(PACKAGE_ACTION_PARAM)) {
                doPackageAction = true;
            }
            if (!clp.isInArgsList(INSTALL_ACTION_PARAM) && !clp.isInArgsList(PACKAGE_ACTION_PARAM)) {
                doInstallAction = true;
                doPackageAction = true;
            }
            if (doInstallAction) {
                String filename = null;
                Properties properties = null;
                filename = clp.getParamArgument(ENV_VAR_PARAM);
                if (filename != null) {
                    properties = new Properties();
                    properties.load(new FileInputStream(filename));
                }
                installDesc = PackageCreator.createInstallDescriptor((String)clp.getParamArgument(COMPONENT_ID_PARAM), (String)clp.getParamArgument(MAIN_COMPONENT_DESC_PARAM), (String)clp.getParamArgument(CLASSPATH_PARAM), (String)clp.getParamArgument(DATAPATH_PARAM), (String)clp.getParamArgument(MAIN_COMPONENT_DIR_PARAM), (Properties)properties);
            }
            if (doPackageAction) {
                pearFile = PackageCreator.createPearPackage((String)clp.getParamArgument(COMPONENT_ID_PARAM), (String)clp.getParamArgument(MAIN_COMPONENT_DIR_PARAM), (String)clp.getParamArgument(TARGET_DIR_PARAM));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.out.println("Operation successfully finished");
        if (installDesc != null && pearFile == null) {
            System.out.println("Installation descriptor created at: " + installDesc);
        }
        if (pearFile != null) {
            System.out.println("Pear package created at: " + pearFile);
        }
    }
}

