/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.uima.tools.util.gui.ImageButton;

public class ListSelector
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 6426556774940666223L;
    private DefaultListModel listModel = new DefaultListModel();
    private JList list;
    private JTextField addField;
    private SmallButton addButton;
    private SmallButton removeButton;
    private ImageButton moveUpButton;
    private ImageButton moveDownButton;

    public ListSelector(Object[] listData) {
        for (int i = 0; i < listData.length; ++i) {
            this.listModel.addElement(listData[i]);
        }
        this.setLayout(new BorderLayout(4, 4));
        this.list = new JList(this.listModel);
        this.list.setFixedCellWidth(200);
        this.list.setVisibleRowCount(3);
        this.list.setSelectionMode(0);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.list.setBorder(etchedBorder);
        JScrollPane scrollPane = new JScrollPane(this.list, 22, 32);
        this.add((Component)scrollPane, "Center");
        JPanel controlPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        controlPanel.setLayout(gbl);
        this.addField = new JTextField(6);
        this.addField.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 12;
        controlPanel.add((Component)this.addField, gbc);
        gbc.gridx = 1;
        gbc.anchor = 18;
        this.addButton = new SmallButton("Add");
        this.addButton.addActionListener(this);
        controlPanel.add((Component)this.addButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        JPanel movePanel = new JPanel();
        movePanel.setLayout(new GridLayout(1, 2, 4, 4));
        this.moveUpButton = new ImageButton("/org/apache/uima/tools/images/up_24.gif");
        this.moveUpButton.addActionListener(this);
        movePanel.add(this.moveUpButton);
        this.moveDownButton = new ImageButton("/org/apache/uima/tools/images/down_24.gif");
        this.moveDownButton.addActionListener(this);
        movePanel.add(this.moveDownButton);
        controlPanel.add((Component)movePanel, gbc);
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.anchor = 17;
        this.removeButton = new SmallButton("Remove");
        this.removeButton.addActionListener(this);
        controlPanel.add((Component)this.removeButton, gbc);
        this.add((Component)controlPanel, "East");
    }

    public void populate(Object[] listData) {
        this.listModel.clear();
        for (int i = 0; i < listData.length; ++i) {
            this.listModel.addElement(listData[i]);
        }
        this.validate();
    }

    public String[] getValues() {
        Object[] valuesArray = this.listModel.toArray();
        if (valuesArray.length == 0) {
            return null;
        }
        String[] strArray = new String[valuesArray.length];
        for (int i = 0; i < valuesArray.length; ++i) {
            strArray[i] = valuesArray[i].toString();
        }
        return strArray;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addField || source == this.addButton) {
            String text = this.addField.getText();
            if (text.length() > 0 && !this.listModel.contains(text)) {
                this.listModel.addElement(text);
                this.list.ensureIndexIsVisible(this.listModel.getSize() - 1);
            }
            this.addField.setText("");
        } else if (source == this.removeButton) {
            Object selectedValue = this.list.getSelectedValue();
            if (selectedValue != null) {
                int rv = JOptionPane.showConfirmDialog((Component)source, "Are you sure you want to remove " + selectedValue, null, 0);
                if (rv == 0) {
                    this.listModel.remove(this.list.getSelectedIndex());
                }
            } else {
                JOptionPane.showMessageDialog(this, "You must first select an item to be removed", null, 2);
            }
        } else {
            Object selectedValue = this.list.getSelectedValue();
            int selectedIndex = this.list.getSelectedIndex();
            int maxIndex = this.listModel.getSize() - 1;
            if (selectedValue != null) {
                if (source == this.moveUpButton && selectedIndex == 0 || source == this.moveDownButton && selectedIndex == maxIndex) {
                    Toolkit.getDefaultToolkit().beep();
                    this.list.clearSelection();
                    return;
                }
                int newIndex = 0;
                newIndex = source == this.moveUpButton ? selectedIndex - 1 : selectedIndex + 1;
                this.listModel.remove(selectedIndex);
                this.listModel.insertElementAt(selectedValue, newIndex);
                this.list.setSelectedIndex(newIndex);
                this.list.ensureIndexIsVisible(newIndex);
            } else {
                JOptionPane.showMessageDialog(this, "You must first select an item to reorder", null, 2);
            }
        }
    }

    static class SmallButton
    extends JButton {
        private static final long serialVersionUID = -4311761385714783114L;

        public SmallButton(String s) {
            super(s);
        }

        @Override
        public Insets getInsets() {
            return new Insets(3, 6, 3, 6);
        }
    }
}

