/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.uima.UimaSerializableFSs;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.Id2FS;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;

class AllFSs {
    final CASImpl cas;
    private final MarkerImpl mark;
    private final PositiveIntSet foundFSs = new PositiveIntSet_impl(4096, 1, 4096);
    private final PositiveIntSet foundFSsBelowMark;
    private final ArrayList<TOP> toBeScanned = new ArrayList();
    private final Predicate<TOP> includeFilter;
    private final CasTypeSystemMapper typeMapper;

    AllFSs(CASImpl cas, MarkerImpl mark, Predicate<TOP> includeFilter, CasTypeSystemMapper typeMapper) {
        this.cas = cas;
        this.mark = mark;
        this.foundFSsBelowMark = mark != null ? new PositiveIntSet_impl(1024, 1, 1024) : null;
        this.includeFilter = includeFilter;
        this.typeMapper = typeMapper;
    }

    PositiveIntSet getAllBelowMark() {
        return this.foundFSsBelowMark;
    }

    PositiveIntSet getAllNew() {
        return this.foundFSs;
    }

    ArrayList<TOP> getAllFSs() {
        return this.toBeScanned;
    }

    ArrayList<TOP> getAllFSsSorted() {
        this.toBeScanned.sort(FeatureStructureImplC::compare);
        return this.toBeScanned;
    }

    AllFSs(CASImpl cas) {
        this.cas = cas;
        this.mark = null;
        this.foundFSsBelowMark = null;
        this.includeFilter = null;
        this.typeMapper = null;
    }

    private AllFSs getAllFSsAllViews_sofas() {
        this.cas.forAllSofas(sofa -> this.enqueueFS((TOP)sofa));
        this.cas.forAllViews(view -> this.getFSsForView(view.indexRepository.getIndexedFSs()));
        return this;
    }

    public AllFSs getAllFSsAllViews_sofas_reachable() {
        Id2FS table;
        this.getAllFSsAllViews_sofas();
        for (int i = 0; i < this.toBeScanned.size(); ++i) {
            this.enqueueFeatures(this.toBeScanned.get(i));
        }
        if (this.cas.isId2Fs() && null != (table = this.cas.getId2FSs())) {
            Iterator it = this.cas.getId2FSs().iterator();
            while (it.hasNext()) {
                this.enqueueFS((TOP)it.nextNvc());
            }
        }
        return this;
    }

    private void getFSsForView(Collection<TOP> fss) {
        for (TOP fs : fss) {
            this.enqueueFS(fs);
        }
    }

    private void enqueueFS(TOP fs) {
        if (null == fs || this.includeFilter != null && !this.includeFilter.test(fs)) {
            return;
        }
        int id = fs._id;
        if (this.mark == null || this.mark.isNew(fs)) {
            if (!this.foundFSs.contains(id)) {
                this.foundFSs.add(id);
                this.toBeScanned.add(fs);
            }
        } else if (!this.foundFSsBelowMark.contains(id)) {
            this.foundFSsBelowMark.add(id);
            this.toBeScanned.add(fs);
        }
    }

    private void enqueueFeatures(TOP fs) {
        if (fs instanceof FSArray) {
            for (TOP item : ((FSArray)fs)._getTheArray()) {
                this.enqueueFS(item);
            }
            return;
        }
        if (fs instanceof CommonArrayFS) {
            return;
        }
        TypeImpl srcType = fs._getTypeImpl();
        if (srcType.getStaticMergedNonSofaFsRefs().length > 0) {
            if (fs instanceof UimaSerializableFSs) {
                ((UimaSerializableFSs)((Object)fs))._save_fsRefs_to_cas_data();
            }
            for (FeatureImpl srcFeat : srcType.getStaticMergedNonSofaFsRefs()) {
                FeatureImpl tgtFeat;
                if (this.typeMapper != null && (tgtFeat = this.typeMapper.getTgtFeature(srcType, srcFeat)) == null) continue;
                this.enqueueFS(fs._getFeatureValueNc(srcFeat));
            }
        }
    }
}

