/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections;

import com.strobel.annotations.NotNull;
import com.strobel.collections.ImmutableList;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListBuffer<A>
extends AbstractQueue<A> {
    public ImmutableList<A> elements;
    public ImmutableList<A> last;
    public int count;
    public boolean shared;

    public static <T> ListBuffer<T> lb() {
        return new ListBuffer();
    }

    public static <T> ListBuffer<T> of(T x) {
        ListBuffer<T> lb = new ListBuffer<T>();
        lb.add(x);
        return lb;
    }

    public ListBuffer() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.elements = new ImmutableList<Object>(null, null);
        this.last = this.elements;
        this.count = 0;
        this.shared = false;
    }

    public int length() {
        return this.count;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        ImmutableList tail;
        this.elements = new ImmutableList(this.elements.head, this.elements.tail);
        ImmutableList p = this.elements;
        while ((tail = p.tail) != null) {
            tail = new ImmutableList(tail.head, tail.tail);
            p.setTail(tail);
            p = tail;
        }
        this.last = p;
        this.shared = false;
    }

    public ListBuffer<A> prepend(A x) {
        this.elements = this.elements.prepend(x);
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A x) {
        x.getClass();
        if (this.shared) {
            this.copy();
        }
        this.last.head = x;
        this.last.setTail(new ImmutableList<Object>(null, null));
        this.last = this.last.tail;
        ++this.count;
        return this;
    }

    public ListBuffer<A> appendList(ImmutableList<A> xs) {
        while (xs.nonEmpty()) {
            this.append(xs.head);
            xs = xs.tail;
        }
        return this;
    }

    public ListBuffer<A> appendList(ListBuffer<A> xs) {
        return this.appendList(xs.toList());
    }

    public ListBuffer<A> appendArray(A[] xs) {
        for (A x : xs) {
            this.append(x);
        }
        return this;
    }

    public ImmutableList<A> toList() {
        this.shared = true;
        return this.elements;
    }

    @Override
    public boolean contains(Object x) {
        return this.elements.contains(x);
    }

    @Override
    @NotNull
    public <T> T[] toArray(T[] vec) {
        return this.elements.toArray(vec);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public A first() {
        return this.elements.head;
    }

    public A next() {
        Object x = this.elements.head;
        if (this.elements != this.last) {
            this.elements = this.elements.tail;
            --this.count;
        }
        return x;
    }

    @Override
    @NotNull
    public Iterator<A> iterator() {
        return new Iterator<A>(){
            ImmutableList<A> elements;
            {
                this.elements = ListBuffer.this.elements;
            }

            @Override
            public boolean hasNext() {
                return this.elements != ListBuffer.this.last;
            }

            @Override
            public A next() {
                if (this.elements == ListBuffer.this.last) {
                    throw new NoSuchElementException();
                }
                Object elem = this.elements.head;
                this.elements = this.elements.tail;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(A a) {
        this.append(a);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object x : c) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends A> c) {
        for (A a : c) {
            this.append(a);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(A a) {
        this.append(a);
        return true;
    }

    @Override
    public A poll() {
        return this.next();
    }

    @Override
    public A peek() {
        return this.first();
    }
}

