/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.metadata.FlowControllerDeclaration;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.OperationalProperties;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.Messages;
import org.apache.uima.taeconfigurator.StandardStrings;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.MultiPageEditorContributor;
import org.apache.uima.taeconfigurator.editors.ui.ParameterDelegatesSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.model.BuiltInTypes;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.PopupList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractSection
extends SectionPart
implements Listener,
StandardStrings {
    protected FormToolkit toolkit;
    public MultiPageEditor editor;
    public static final String IMPORTABLE_PART_CONTEXT = "ipc";
    public static final String PLUGIN_ID = "org.apache.uima.desceditor";
    public static final boolean SELECTED = true;
    public static final boolean NOT_SELECTED = false;
    public static final boolean ENABLED = true;
    public static final boolean EQUAL_WIDTH = true;
    public static final TreeItem[] treeItemArray0 = new TreeItem[0];
    public static final ConfigurationGroup[] configurationGroup0 = new ConfigurationGroup[0];
    public static final ConfigurationParameter[] configurationParameter0 = new ConfigurationParameter[0];
    public static final Capability[] capabilityArray0 = new Capability[0];
    public static final FeatureDescription[] featureDescriptionArray0 = new FeatureDescription[0];
    public static final SofaMapping[] sofaMapping0 = new SofaMapping[0];
    public static final FsIndexDescription[] fsIndexDescription0 = new FsIndexDescription[0];
    public static final ExternalResourceBinding[] externalResourceBinding0 = new ExternalResourceBinding[0];
    public static final ExternalResourceDescription[] externalResourceDescription0 = new ExternalResourceDescription[0];
    public static final TypeDescription[] typeDescription0 = new TypeDescription[0];
    public static final TypePriorityList[] typePriorityList0 = new TypePriorityList[0];
    protected int initialFormWidth;
    public static final int VERTICAL_BUTTONS = 1;
    public static final int HORIZONTAL_BUTTONS = 2;
    public static final int NO_MIN_HEIGHT = -1;
    public static final int NOTHING_SELECTED = -1;
    public static final int LINES_VISIBLE = 1;
    public static final int HEADER_VISIBLE = 2;
    public static final int WIDTH_NOT_SPECIFIED = 0;
    public static final String[] stringArray0 = new String[0];
    public static final ConfigurationParameter[] configurationParameterArray0 = new ConfigurationParameter[0];
    public static final ConfigurationGroup[] configurationGroupArray0 = new ConfigurationGroup[0];
    public static final NameValuePair[] nameValuePairArray0 = new NameValuePair[0];
    protected boolean valueChanged;
    private static final int RIDICULOUSLY_LARGE = 10000;
    private static URL urlForResourceSpecifierSchema;
    private ResourceSpecifier lastResourceForDescription = null;
    private String lastDescriptionFromDescriptor = "";
    private long lastTimeDescriptionRequested = 0L;
    private static final long TABLE_HOVER_REQUERY_TIME = 15000L;

    public FormToolkit getToolkit() {
        return this.toolkit;
    }

    public AbstractSection(MultiPageEditor aEditor, Composite parent, String headerText, String description) {
        super(parent, aEditor.getToolkit(), (null != description ? 128 : 0) | 2 | 0x40);
        this.toolkit = aEditor.getToolkit();
        this.getSection().setText(headerText);
        this.getSection().setLayoutData((Object)new GridData(768));
        this.toolkit.createCompositeSeparator((Composite)this.getSection());
        if (null != description) {
            this.getSection().setDescription(description);
        }
        this.editor = aEditor;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.getSection().setLayoutData((Object)new GridData(1808));
    }

    public abstract void enable();

    protected void setFileDirty() {
        this.editor.setFileDirty();
    }

    public Composite newComposite(Composite parent) {
        return this.newNcolumnComposite(parent, 1);
    }

    public Composite new2ColumnComposite(Composite parent) {
        return this.newNcolumnComposite(parent, 2);
    }

    public Composite new3ColumnComposite(Composite parent) {
        return this.newNcolumnComposite(parent, 3);
    }

    public Composite new4ColumnComposite(Composite parent) {
        return this.newNcolumnComposite(parent, 4);
    }

    public Composite newNcolumnComposite(Composite parent, int cols) {
        Composite composite = this.toolkit.createComposite(parent);
        if (parent instanceof ExpandableComposite) {
            ((ExpandableComposite)parent).setClient((Control)composite);
        }
        GridLayout layout = new GridLayout(cols, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    public void setMargins(Composite composite, int height, int width) {
        GridLayout g = (GridLayout)composite.getLayout();
        g.marginHeight = height;
        g.marginWidth = width;
    }

    public void enableBorders(Composite composite) {
        GridLayout g = (GridLayout)composite.getLayout();
        if (g.marginHeight < 2) {
            g.marginHeight = 2;
        }
        if (g.marginWidth < 1) {
            g.marginWidth = 1;
        }
    }

    public Composite newButtonContainer(Composite parent) {
        return this.newButtonContainer(parent, 1, 0);
    }

    public Composite newButtonContainer(Composite parent, int style, int widthMin) {
        Composite buttonContainer = this.toolkit.createComposite(parent);
        GridLayout gl = new GridLayout();
        GridData gd = null;
        switch (style) {
            case 1: {
                gd = new GridData(2);
                gd.horizontalAlignment = 4;
                break;
            }
            case 2: {
                gl.marginWidth = 20;
                gl.numColumns = 2;
                gl.makeColumnsEqualWidth = true;
                gd = new GridData(64);
                gd.widthHint = widthMin;
            }
        }
        buttonContainer.setLayout((Layout)gl);
        buttonContainer.setLayoutData((Object)gd);
        return buttonContainer;
    }

    protected Text newLabeledTextField(Composite parent, String label, String tip) {
        return this.newLabeledTextField(parent, label, tip, 0);
    }

    protected Text newLabeledTextField(Composite parent, String labelKey, String textToolTip, int style) {
        this.enableBorders(parent);
        Label label = this.toolkit.createLabel(parent, labelKey);
        label.setToolTipText(textToolTip);
        if ((style & 0x200) == 512) {
            label.setLayoutData((Object)new GridData(2));
        }
        return this.newTextWithTip(parent, "", style, textToolTip);
    }

    protected Text newTextWithTip(Composite parent, String initialTxt, String tip) {
        return this.newTextWithTip(parent, initialTxt, 0, tip);
    }

    protected Text newTextWithTip(Composite parent, String text, int style, String tip) {
        Text t = this.toolkit.createText(parent, text, style);
        t.setToolTipText(tip);
        if ((style & 0x200) == 512) {
            t.setLayoutData((Object)new GridData(1808));
        } else {
            t.setLayoutData((Object)new GridData(768));
        }
        this.addListenerForPastableWidget((Widget)t);
        return t;
    }

    public Label newLabelWithData(Composite parent, String text) {
        return this.newLabelWithTip(parent, text, "");
    }

    public Label newLabelWithTip(Composite parent, String text, String tip) {
        return this.newLabelWithTip(parent, text, tip, 0);
    }

    public Label newUnUpdatableTextWithTip(Composite parent, String text, String tip) {
        Label label = this.newLabelWithTip(parent, text, tip, 2048);
        label.setLayoutData((Object)new GridData(768));
        return label;
    }

    public Label newLabelWithTip(Composite parent, String text, String tip, int style) {
        Label t = this.toolkit.createLabel(parent, text, style);
        if (tip != null && tip.length() > 0) {
            t.setToolTipText(tip);
        }
        return t;
    }

    protected CCombo newLabeledCComboWithTip(Composite parent, String labelKey, String tip) {
        this.newLabelWithTip(parent, labelKey, tip);
        return this.newCComboWithTip(parent, tip);
    }

    protected CCombo newCComboWithTip(Composite parent, String tip) {
        CCombo ccombo = new CCombo(parent, 0x800008);
        this.toolkit.adapt((Control)ccombo, false, false);
        ccombo.setToolTipText(tip);
        ccombo.setLayoutData((Object)new GridData(32));
        ccombo.addListener(13, (Listener)this);
        ccombo.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        return ccombo;
    }

    protected Text newDescriptionTextBox(Composite parent, String tip) {
        return this.newLabeledTextField(parent, "Description:", tip, 578);
    }

    public Button newRadioButton(Composite parent, String label, String toolTip, boolean selected) {
        Button button = this.toolkit.createButton(parent, label, 16);
        button.setToolTipText(toolTip);
        button.setSelection(selected);
        button.addListener(13, (Listener)this);
        return button;
    }

    public Button newPushButton(Composite parent, String label, String tip) {
        return this.newPushButton(parent, label, tip, true);
    }

    public Button newPushButton(Composite parent, String label, String tip, boolean enabled) {
        return this.newPushButton(parent, label, tip, enabled, 0);
    }

    public Button newPushButton(Composite parent, String label, String tip, boolean enabled, int style) {
        Button button = this.toolkit.createButton(parent, label, 8 | style);
        GridData gd = new GridData(770);
        button.setLayoutData((Object)gd);
        button.pack(false);
        button.setToolTipText(tip);
        button.setEnabled(enabled);
        button.addListener(13, (Listener)this);
        Point buttonSize = button.getSize();
        gd.heightHint = buttonSize.y - 2;
        gd.widthHint = buttonSize.x - 2;
        return button;
    }

    public Button newCheckBox(Composite parent, String label, String tip) {
        Button button = this.toolkit.createButton(parent, label, 32);
        button.setLayoutData((Object)new GridData(258));
        button.pack();
        button.setToolTipText(tip);
        button.addListener(13, (Listener)this);
        return button;
    }

    public static void spacer(Composite container) {
        Label label = new Label(container, 0);
        label.setVisible(false);
    }

    protected Table newTable(Composite parent) {
        return this.newTable(parent, 65536, -1, 0);
    }

    protected Table newTable(Composite parent, int style, int minHeight) {
        return this.newTable(parent, style, minHeight, 0);
    }

    protected Table newTable(Composite parent, int style, int minHeight, int flags) {
        Table table = this.toolkit.createTable(parent, style);
        GridData gd = new GridData(1808);
        if (minHeight != -1) {
            gd.heightHint = minHeight;
        }
        table.setLayoutData((Object)gd);
        table.setLinesVisible(0 != (flags & 1));
        table.setHeaderVisible(0 != (flags & 2));
        table.addListener(13, (Listener)this);
        table.addListener(2, (Listener)this);
        return table;
    }

    protected Tree newTree(Composite parent) {
        Tree local_tree = this.toolkit.createTree(parent, 4);
        local_tree.setLayoutData((Object)new GridData(1808));
        local_tree.addListener(13, (Listener)this);
        local_tree.addListener(2, (Listener)this);
        return local_tree;
    }

    protected TreeItem getPreviousSelection(TreeItem[] items, TreeItem nextItem) {
        TreeItem prevItem = nextItem.getParentItem();
        for (int i = 0; i < items.length; ++i) {
            if (nextItem == items[i]) {
                return prevItem;
            }
            prevItem = items[i];
        }
        return prevItem;
    }

    protected int getItemIndex(TreeItem[] items, TreeItem item) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] != item) continue;
            return i;
        }
        return -1;
    }

    protected Tree newTree(Composite parent, int style) {
        Tree tt = new Tree(parent, style);
        tt.setLayoutData((Object)new GridData(1808));
        this.toolkit.adapt((Control)tt, true, true);
        tt.addListener(13, (Listener)this);
        tt.addListener(2, (Listener)this);
        tt.addListener(8, (Listener)this);
        tt.addListener(17, (Listener)this);
        tt.addListener(18, (Listener)this);
        tt.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        return tt;
    }

    public void packTable(Table table) {
        TableColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].pack();
        }
    }

    public void packTree(Tree p_tree) {
        TreeColumn[] columns = p_tree.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            columns[i].pack();
        }
    }

    public static int getIndex(TableItem item) {
        Table parent = item.getParent();
        TableItem[] items = parent.getItems();
        for (int i = items.length - 1; i >= 0; --i) {
            if (items[i] != item) continue;
            return i;
        }
        throw new InternalErrorCDE("invalid state");
    }

    public static int getIndex(TreeItem item) {
        TreeItem parent = item.getParentItem();
        TreeItem[] items = null == parent ? item.getParent().getItems() : parent.getItems();
        for (int i = items.length - 1; i >= 0; --i) {
            if (items[i] != item) continue;
            return i;
        }
        throw new InternalErrorCDE("invalid state");
    }

    protected void removeChildren(TreeItem item) {
        TreeItem[] items = item.getItems();
        if (null != items) {
            for (int i = 0; i < items.length; ++i) {
                items[i].dispose();
            }
        }
    }

    protected TableColumn newTableColumn(Table table) {
        return this.newTableColumn(table, "");
    }

    protected TreeColumn newTreeColumn(Tree p_tree) {
        return this.newTreeColumn(p_tree, "");
    }

    protected TableColumn newTableColumn(Table container, String header) {
        return this.newTableColumn(container, 50, 16384, header);
    }

    protected TreeColumn newTreeColumn(Tree container, String header) {
        return this.newTreeColumn(container, 50, 16384, header);
    }

    protected TableColumn newTableColumn(Table container, int width, int alignment, String header) {
        TableColumn tc = new TableColumn(container, alignment);
        if (header != null && !header.equals("")) {
            tc.setText(header);
        }
        tc.setWidth(width);
        return tc;
    }

    protected TreeColumn newTreeColumn(Tree container, int width, int alignment, String header) {
        TreeColumn tc = new TreeColumn(container, alignment);
        if (header != null && !header.equals("")) {
            tc.setText(header);
        }
        tc.setWidth(width);
        return tc;
    }

    protected TableColumn newTableColumn(Table container, int width) {
        return this.newTableColumn(container, width, 16384, Messages.getString("AbstractSection.0"));
    }

    protected TreeColumn newTreeColumn(Tree container, int width) {
        return this.newTreeColumn(container, width, 16384, Messages.getString("AbstractSection.0"));
    }

    public boolean isPrimitive() {
        return this.editor.isPrimitive();
    }

    public boolean isAggregate() {
        return this.editor.isAggregate();
    }

    public boolean isAeDescriptor() {
        return this.editor.isAeDescriptor();
    }

    public boolean isTypeSystemDescriptor() {
        return this.editor.isTypeSystemDescriptor();
    }

    public boolean isIndexDescriptor() {
        return this.editor.isFsIndexCollection();
    }

    public boolean isTypePriorityDescriptor() {
        return this.editor.isTypePriorityDescriptor();
    }

    public boolean isExtResAndBindingsDescriptor() {
        return this.editor.isExtResAndBindingsDescriptor();
    }

    public boolean isCollectionReaderDescriptor() {
        return this.editor.isCollectionReaderDescriptor();
    }

    public boolean isCasInitializerDescriptor() {
        return this.editor.isCasInitializerDescriptor();
    }

    public boolean isCasConsumerDescriptor() {
        return this.editor.isCasConsumerDescriptor();
    }

    public boolean isFlowControllerDescriptor() {
        return this.editor.isFlowControllerDescriptor();
    }

    public boolean isLocalProcessingDescriptor() {
        return this.editor.isLocalProcessingDescriptor();
    }

    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return this.editor.getAeDescription().getAnalysisEngineMetaData();
    }

    public FlowControllerDeclaration getFlowControllerDeclaration() {
        return this.editor.getAeDescription().getFlowControllerDeclaration();
    }

    public void setFlowControllerDeclaration(FlowControllerDeclaration fcd) {
        this.editor.getAeDescription().setFlowControllerDeclaration(fcd);
    }

    public OperationalProperties getOperationalProperties() {
        return this.editor.getAeDescription().getAnalysisEngineMetaData().getOperationalProperties();
    }

    public SofaMapping[] getSofaMappings() {
        SofaMapping[] sofaMappings = this.editor.getAeDescription().getSofaMappings();
        return null == sofaMappings ? sofaMapping0 : sofaMappings;
    }

    public static SofaMapping[] getSofaMappings(MultiPageEditor pEditor) {
        SofaMapping[] sofaMappings = pEditor.getAeDescription().getSofaMappings();
        return null == sofaMappings ? sofaMapping0 : sofaMappings;
    }

    public Map getDelegateAnalysisEngineSpecifiersWithImports() {
        return this.editor.getAeDescription().getDelegateAnalysisEngineSpecifiersWithImports();
    }

    public Capability[] getCapabilities() {
        Capability[] c = this.getAnalysisEngineMetaData().getCapabilities();
        if (null == c) {
            return capabilityArray0;
        }
        return c;
    }

    protected TypeSystemDescription getMergedTypeSystemDescription() {
        return this.editor.getMergedTypeSystemDescription();
    }

    protected TypeSystemDescription getTypeSystemDescription() {
        return this.editor.getTypeSystemDescription();
    }

    protected TypePriorities getTypePriorities() {
        TypePriorities tps = this.getAnalysisEngineMetaData().getTypePriorities();
        if (null == tps) {
            tps = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
            this.getAnalysisEngineMetaData().setTypePriorities(tps);
        }
        return tps;
    }

    public String[] getAvailableTypeNames(Set excluded) {
        Map allTypes = this.editor.allTypes.get();
        ArrayList<String> availableTypes = new ArrayList<String>();
        for (String item : allTypes.keySet()) {
            if (excluded.contains(item)) continue;
            availableTypes.add(item);
        }
        return availableTypes.toArray(stringArray0);
    }

    public boolean isParmGroup() {
        ConfigurationParameterDeclarations lcpd = this.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        return lcpd.getCommonParameters() != null && lcpd.getCommonParameters().length > 0 || lcpd.getConfigurationGroups() != null && lcpd.getConfigurationGroups().length > 0;
    }

    public ConfigurationParameterDeclarations getConfigurationParameterDeclarations() {
        return this.editor.getAeDescription().getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
    }

    public ResourceManagerConfiguration getResourceManagerConfiguration() {
        ResourceManagerConfiguration rmc = this.editor.getAeDescription().getResourceManagerConfiguration();
        if (null == rmc) {
            rmc = UIMAFramework.getResourceSpecifierFactory().createResourceManagerConfiguration();
            this.editor.getAeDescription().setResourceManagerConfiguration(rmc);
        }
        return rmc;
    }

    public ExternalResourceDependency[] getExternalResourceDependencies() {
        ExternalResourceDependency[] erd = this.editor.getAeDescription().getExternalResourceDependencies();
        if (null == erd) {
            return new ExternalResourceDependency[0];
        }
        return erd;
    }

    public ExternalResourceBinding[] getExternalResourceBindings() {
        ExternalResourceBinding[] erb = this.getResourceManagerConfiguration().getExternalResourceBindings();
        if (null == erb) {
            erb = new ExternalResourceBinding[]{};
            this.getResourceManagerConfiguration().setExternalResourceBindings(erb);
        }
        return erb;
    }

    public ExternalResourceDescription[] getExternalResources() {
        ExternalResourceDescription[] erd = this.getResourceManagerConfiguration().getExternalResources();
        if (null == erd) {
            erd = new ExternalResourceDescription[]{};
            this.getResourceManagerConfiguration().setExternalResources(erd);
        }
        return erd;
    }

    protected void addListenerForPastableWidget(Widget w) {
        w.addListener(2, (Listener)this);
        w.addListener(4, (Listener)this);
    }

    protected String setValueChanged(String newValue, String oldValue) {
        if (null == newValue) {
            this.valueChanged = this.valueChanged || null != oldValue;
        } else if (!newValue.equals(oldValue)) {
            this.valueChanged = true;
        }
        return newValue;
    }

    protected int setValueChangedInt(int newValue, int oldValue) {
        if (newValue != oldValue) {
            this.valueChanged = true;
        }
        return newValue;
    }

    protected boolean setValueChangedBoolean(boolean newValue, boolean oldValue) {
        if (newValue != oldValue) {
            this.valueChanged = true;
        }
        return newValue;
    }

    protected Boolean setValueChangedCapitalBoolean(Boolean newValue, Boolean oldValue) {
        if (null == newValue) {
            this.valueChanged |= null != oldValue;
        } else if (null == oldValue) {
            this.valueChanged = true;
        } else if (newValue.booleanValue() != oldValue.booleanValue()) {
            this.valueChanged = true;
        }
        return newValue;
    }

    protected FsIndexKeyDescription[] setValueChangedKeys(FsIndexKeyDescription[] newKeys, FsIndexKeyDescription[] oldKeys) {
        if (!(this.valueChanged || oldKeys == null && newKeys == null || oldKeys != null && Arrays.equals(oldKeys, newKeys) || Arrays.equals(newKeys, oldKeys))) {
            this.valueChanged = true;
        }
        return newKeys;
    }

    protected boolean isValidAe() {
        return this.editor.isValidAE(this.editor.getAeDescription());
    }

    protected void revertTypeSystem(TypeSystemDescription tsd) {
        try {
            this.editor.setTypeSystemDescription(tsd);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            // empty catch block
        }
    }

    protected void revertMsg(String msgTitle, String msgTxt, String exceptionMessage) {
        Utility.popMessage(msgTitle, msgTxt + "\r\n" + exceptionMessage, 1);
    }

    public static boolean revertOrContinue(String msg, String msgDetails) {
        return 1 == Utility.popMessage(msg, msgDetails + "\nDo you want to continue, or Abort the last action?", 3, new String[]{"Continue", "Abort"});
    }

    public void markStale(IFormPart section) {
        if (section != null) {
            ((AbstractFormPart)section).markStale();
        }
    }

    protected void markRestOfPageStale(IManagedForm mform, AbstractSection section) {
        if (null == mform) {
            return;
        }
        IFormPart[] parts = mform.getParts();
        for (int i = 0; i < parts.length; ++i) {
            this.markStaleIfDifferent((IFormPart)section, parts[i]);
        }
    }

    protected void markStaleIfDifferent(IFormPart thisOne, IFormPart otherOne) {
        if (thisOne != otherOne) {
            this.markStale(otherOne);
        }
    }

    protected String multiLineFix(String s) {
        if (null == s) {
            return null;
        }
        return s.replaceAll("\\r\\n", "\n");
    }

    public String[] stringArrayAdd(String[] a, String s) {
        if (a == null) {
            return new String[]{s};
        }
        String[] newA = new String[a.length + 1];
        System.arraycopy(a, 0, newA, 0, a.length);
        newA[newA.length - 1] = s;
        return newA;
    }

    public String[] stringArrayRemove(String[] a, String s) {
        String[] result = new String[a.length - 1];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(s)) continue;
            result[j++] = a[i];
        }
        return result;
    }

    public TypeOrFeature[] typeOrFeatureArrayAdd(TypeOrFeature[] a, TypeOrFeature item) {
        if (null == a) {
            return new TypeOrFeature[]{item};
        }
        TypeOrFeature[] result = new TypeOrFeature[a.length + 1];
        System.arraycopy(a, 0, result, 0, a.length);
        result[result.length - 1] = item;
        return result;
    }

    public TypeOrFeature[] typeOrFeatureArrayRemove(TypeOrFeature[] a, TypeOrFeature item) {
        TypeOrFeature[] result = new TypeOrFeature[a.length - 1];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == item) continue;
            result[j++] = a[i];
        }
        return result;
    }

    public TypeOrFeature[] typeOrFeatureArrayRemove(TypeOrFeature[] a, String s) {
        TypeOrFeature[] result = new TypeOrFeature[a.length - 1];
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getName().equals(s)) continue;
            if (j == a.length - 1) {
                throw new InternalErrorCDE("feature or type not found: looking for " + s);
            }
            result[j++] = a[i];
        }
        return result;
    }

    public static TypeOrFeature getTypeOrFeature(TypeOrFeature[] a, String name) {
        if (null == a) {
            return null;
        }
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getName().equals(name)) continue;
            return a[i];
        }
        return null;
    }

    protected static String parseToFitInToolTips(String text) {
        if (null == text) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int MAGIC_LENGTH = 65;
        StringTokenizer tokenizer = new StringTokenizer(text);
        int lengthAccumulator = 0;
        while (tokenizer.hasMoreTokens()) {
            if (lengthAccumulator > 0) {
                buffer.append(' ');
            }
            String nextToken = tokenizer.nextToken();
            buffer.append(nextToken);
            if ((lengthAccumulator += nextToken.length() + 1) <= 65 || !tokenizer.hasMoreTokens()) continue;
            buffer.append("\n");
            lengthAccumulator = 0;
        }
        return new String(buffer);
    }

    public String formatName(String name) {
        if (null == name) {
            return "";
        }
        if (MultiPageEditorContributor.getUseQualifiedTypes()) {
            return name;
        }
        return AbstractSection.getShortName(name);
    }

    public static String getShortName(String name) {
        if (null == name) {
            return "";
        }
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getShortFeatureName(String name) {
        return name.substring(name.indexOf(58) + 1);
    }

    public static String getTypeFromFullFeatureName(String name) {
        return name.substring(0, name.indexOf(58));
    }

    public static String getNameSpace(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return name.substring(0, i);
    }

    public FeatureDescription getFeature(TypeDescription td, String featureName) {
        String supertypeName;
        FeatureDescription[] features = td.getFeatures();
        if (null != features) {
            for (int i = 0; i < features.length; ++i) {
                if (!featureName.equals(features[i].getName())) continue;
                return features[i];
            }
        }
        if (null != (supertypeName = td.getSupertypeName()) && !"uima.cas.TOP".equals(supertypeName)) {
            TypeDescription supertype = this.getMergedTypeSystemDescription().getType(supertypeName);
            if (null == supertype) {
                supertype = (TypeDescription)BuiltInTypes.typeDescriptions.get(supertypeName);
            }
            return this.getFeature(supertype, featureName);
        }
        return null;
    }

    public static boolean isIndexableRange(String rangeName) {
        return "uima.cas.Byte".equals(rangeName) || "uima.cas.Short".equals(rangeName) || "uima.cas.Integer".equals(rangeName) || "uima.cas.Long".equals(rangeName) || "uima.cas.Float".equals(rangeName) || "uima.cas.Double".equals(rangeName) || "uima.cas.String".equals(rangeName);
    }

    public static void setToolTipText(Control w, String text) {
        if (null != text) {
            w.setToolTipText(AbstractSection.parseToFitInToolTips(text));
        }
    }

    public static String maybeShortenFileName(String filePathName) {
        if (filePathName.length() > 65) {
            String pathName = filePathName.replace('\\', '/');
            int nLoc = pathName.lastIndexOf(47);
            return filePathName.substring(0, 61 - (pathName.length() - nLoc)) + ".../" + filePathName.substring(nLoc + 1);
        }
        return filePathName;
    }

    public static void swapTreeItems(TreeItem itemBelow, int newSelection) {
        TreeItem parent = itemBelow.getParentItem();
        if (null == parent) {
            throw new InternalErrorCDE("invalid arg");
        }
        int i = AbstractSection.getIndex(itemBelow);
        TreeItem itemAbove = parent.getItems()[i - 1];
        TreeItem newItemAbove = new TreeItem(parent, 0, i - 1);
        AbstractSection.copyTreeItem(newItemAbove, itemBelow);
        TreeItem newItemBelow = new TreeItem(parent, 0, i);
        AbstractSection.copyTreeItem(newItemBelow, itemAbove);
        itemAbove.dispose();
        itemBelow.dispose();
        parent.getParent().setSelection(new TreeItem[]{parent.getItems()[newSelection]});
    }

    public static void copyTreeItem(TreeItem target, TreeItem source) {
        int columnCount = target.getParent().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String text = source.getText(i);
            if (null == text) continue;
            target.setText(i, text);
        }
        target.setData(source.getData());
    }

    public static void swapIndexKeys(TreeItem itemBelow, int newSelection) {
        TreeItem parent = itemBelow.getParentItem();
        FsIndexDescription fsid = AbstractSection.getFsIndexDescriptionFromTableTreeItem(parent);
        int i = AbstractSection.getIndex(itemBelow);
        FsIndexKeyDescription[] keys = fsid.getKeys();
        FsIndexKeyDescription temp = keys[i];
        keys[i] = keys[i - 1];
        keys[i - 1] = temp;
        AbstractSection.swapTreeItems(itemBelow, newSelection);
    }

    public static void swapTableItems(TableItem itemBelow, int newSelection) {
        Table parent = itemBelow.getParent();
        int i = AbstractSection.getIndex(itemBelow);
        TableItem itemAbove = parent.getItems()[i - 1];
        TableItem newItemAbove = new TableItem(parent, 0, i - 1);
        AbstractSection.copyTableItem(newItemAbove, itemBelow);
        TableItem newItemBelow = new TableItem(parent, 0, i);
        AbstractSection.copyTableItem(newItemBelow, itemAbove);
        itemAbove.dispose();
        itemBelow.dispose();
        parent.setSelection(newSelection);
    }

    public static void copyTableItem(TableItem target, TableItem source) {
        int columnCount = target.getParent().getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String text = source.getText(i);
            if (null == text) continue;
            target.setText(i, text);
        }
        target.setData(source.getData());
    }

    public static FsIndexDescription getFsIndexDescriptionFromTableTreeItem(TreeItem item) {
        return (FsIndexDescription)item.getData();
    }

    public String[][] getCapabilitySofaNames() {
        Set[] inOut = AbstractSection.getCapabilitySofaNames((ResourceCreationSpecifier)this.editor.getAeDescription(), null);
        Object[] inputSofas = inOut[0].toArray(stringArray0);
        Object[] outputSofas = inOut[1].toArray(stringArray0);
        Arrays.sort(inputSofas);
        Arrays.sort(outputSofas);
        return new String[][]{inputSofas, outputSofas};
    }

    public static Capability[] getCapabilities(ResourceSpecifier rs) {
        if (rs instanceof ResourceCreationSpecifier) {
            return ((ProcessingResourceMetaData)((ResourceCreationSpecifier)rs).getMetaData()).getCapabilities();
        }
        return null;
    }

    protected static Set[] getCapabilitySofaNames(ResourceCreationSpecifier rs, String componentKey) {
        Capability[] cs = AbstractSection.getCapabilities((ResourceSpecifier)rs);
        TreeSet inputSofasSet = new TreeSet();
        TreeSet outputSofasSet = new TreeSet();
        for (int i = 0; i < cs.length; ++i) {
            Capability c = cs[i];
            AbstractSection.mergeSofaNames(inputSofasSet, c.getInputSofas(), componentKey);
            AbstractSection.mergeSofaNames(outputSofasSet, c.getOutputSofas(), componentKey);
        }
        return new Set[]{inputSofasSet, outputSofasSet};
    }

    private static void mergeSofaNames(Set set, String[] items, String componentKey) {
        if (null != items) {
            for (int i = 0; i < items.length; ++i) {
                if (null != componentKey) {
                    set.add(componentKey + '/' + items[i]);
                    continue;
                }
                set.add(items[i]);
            }
        } else if (null != componentKey) {
            set.add(componentKey);
        }
    }

    protected Capability addCapabilitySet() {
        Capability newCset = UIMAFramework.getResourceSpecifierFactory().createCapability();
        AnalysisEngineMetaData md = this.getAnalysisEngineMetaData();
        Capability[] c = this.getCapabilities();
        if (c == null) {
            md.setCapabilities(new Capability[]{newCset});
        } else {
            Capability[] newC = new Capability[c.length + 1];
            System.arraycopy(c, 0, newC, 0, c.length);
            newC[c.length] = newCset;
            md.setCapabilities(newC);
        }
        return newCset;
    }

    public ResourceMetaData getMetaDataFromDescription(ResourceSpecifier o) {
        if (o instanceof ResourceCreationSpecifier) {
            return ((ResourceCreationSpecifier)o).getMetaData();
        }
        if (o instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)o;
            AnalysisEngine ae = null;
            try {
                AbstractSection.setVnsHostAndPort(o);
                ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)uriSpec);
            }
            catch (ResourceInitializationException e) {
                return null;
            }
            AnalysisEngineMetaData aemd = ae.getAnalysisEngineMetaData();
            ae.destroy();
            return aemd;
        }
        throw new InternalErrorCDE("invalid call");
    }

    public static void setVnsHostAndPort(String vnsHost, String vnsPort) {
        MultiPageEditorContributor.setVnsHost(vnsHost);
        MultiPageEditorContributor.setVnsPort(vnsPort);
    }

    public static void setVnsHostAndPort(Object descriptor) {
        String vnsHost = MultiPageEditorContributor.getCDEVnsHost();
        String vnsPort = MultiPageEditorContributor.getCDEVnsPort();
        AbstractSection.setVnsHostAndPort(vnsHost, vnsPort);
    }

    protected void requestPopUpOverImport(Import importItem, Control control, Event event) {
        XMLizable inputDescription;
        String path = this.editor.getAbsolutePathFromImport(importItem);
        Path iPath = new Path(path);
        IFile[] files = this.editor.getProject().getWorkspace().getRoot().findFilesForLocation((IPath)iPath);
        if (null == files || files.length != 1) {
            return;
        }
        String filePathName = files[0].getLocation().toOSString();
        try {
            inputDescription = AbstractSection.parseDescriptor(new XMLInputSource(filePathName));
        }
        catch (InvalidXMLException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        PopupList popupList = new PopupList(control.getShell());
        String[] items = new String[]{"Open in new window..."};
        popupList.setItems(items);
        int HACK_MARGIN = 30;
        Point absPoint = this.getAbsoluteLocation(control, event.x, event.y + HACK_MARGIN);
        Rectangle rect = new Rectangle(absPoint.x, absPoint.y, 150, 25);
        control.setToolTipText("");
        String res = popupList.open(rect);
        if (null != res) {
            if (inputDescription instanceof URISpecifier || this.isJmsDescriptor(inputDescription)) {
                this.editor.openTextEditor(path);
            } else {
                this.editor.open(path);
            }
        }
    }

    protected boolean isJmsDescriptor(XMLizable inputDescription) {
        return inputDescription instanceof CustomResourceSpecifier && "org.apache.uima.aae.jms_adapter.JmsAnalysisEngineServiceAdapter".equals(((CustomResourceSpecifier)inputDescription).getResourceClassName());
    }

    private Point getAbsoluteLocation(Control control, int x, int y) {
        Point point = new Point(x, y);
        for (Composite composite = control.getParent(); composite != null; composite = composite.getParent()) {
            point.x += composite.getLocation().x;
            point.y += composite.getLocation().y;
        }
        return point;
    }

    public static String convertNull(String s) {
        if (null == s) {
            return "";
        }
        return s;
    }

    public Import createImport(String fileName, boolean isByName) {
        if (isByName) {
            return this.createByNameImport(fileName);
        }
        try {
            return this.createLocationImport(fileName);
        }
        catch (MalformedURLException e1) {
            throw new InternalErrorCDE("unhandled exception", e1);
        }
    }

    public Import createLocationImport(String location) throws MalformedURLException {
        String sDescriptorRelativePath = this.editor.getDescriptorRelativePath(location);
        if (sDescriptorRelativePath.indexOf("file:/") == -1 && sDescriptorRelativePath.indexOf(":/") > -1) {
            sDescriptorRelativePath = "file:/" + sDescriptorRelativePath;
        }
        Import_impl imp = new Import_impl();
        URL url = new File(this.editor.getDescriptorDirectory()).toURL();
        imp.setSourceUrl(url);
        imp.setLocation(sDescriptorRelativePath);
        return imp;
    }

    public Import createByNameImport(String fileName) {
        if (fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        fileName = fileName.replace('\\', '/');
        int i = (fileName = fileName.replace('/', '.')).indexOf(":");
        if (i >= 0) {
            fileName = fileName.substring(i + 1);
        }
        if (fileName.charAt(0) == '.') {
            fileName = fileName.substring(1);
        }
        int partStart = 0;
        Import imp = UIMAFramework.getResourceSpecifierFactory().createImport();
        ResourceManager rm = this.editor.createResourceManager();
        while (true) {
            imp.setName(fileName.substring(partStart));
            try {
                imp.findAbsoluteUrl(rm);
            }
            catch (InvalidXMLException e) {
                if (0 != (partStart = fileName.indexOf(46, partStart) + 1)) continue;
                return imp;
            }
            break;
        }
        return imp;
    }

    public static boolean isFSArrayOrListType(String type) {
        return null != type && (type.equals("uima.cas.FSArray") || type.equals("uima.cas.FSList"));
    }

    public static boolean isArrayOrListType(String type) {
        return null != type && (type.equals("uima.cas.FSArray") || type.equals("uima.cas.FSList") || type.equals("uima.cas.StringList") || type.equals("uima.cas.FloatList") || type.equals("uima.cas.IntegerList") || type.equals("uima.cas.StringArray") || type.equals("uima.cas.FloatArray") || type.equals("uima.cas.BooleanArray") || type.equals("uima.cas.ByteArray") || type.equals("uima.cas.ShortArray") || type.equals("uima.cas.IntegerArray") || type.equals("uima.cas.LongArray") || type.equals("uima.cas.DoubleArray"));
    }

    protected String produceUniqueComponentKey(String fileName) {
        HashSet existingKeyNames = new HashSet(this.getDelegateAnalysisEngineSpecifiersWithImports().keySet());
        FlowControllerDeclaration fcd = this.getFlowControllerDeclaration();
        if (null != fcd && null != fcd.getKey() && !"".equals(fcd.getKey())) {
            existingKeyNames.add(fcd.getKey());
        }
        String keyName = fileName;
        String keyNameLowerCase = keyName.toLowerCase();
        if (!existingKeyNames.contains(keyName = keyName.substring(0, keyNameLowerCase.indexOf(".xml")))) {
            return keyName;
        }
        for (int i = 2; i < 10000; ++i) {
            String sKeyName = keyName + i;
            if (existingKeyNames.contains(sKeyName)) continue;
            return sKeyName;
        }
        Utility.popMessage("Failed to create unique key", "The Flow Controller name, '" + fileName + "', could not be converted to a unique key name -- tried with 10000 different suffixes", 1);
        return null;
    }

    public static XMLizable parseDescriptor(XMLInputSource input) throws InvalidXMLException {
        return AbstractSection.parseDescriptor(input, false);
    }

    public static XMLizable parseDescriptor(XMLInputSource input, boolean preserveComments) throws InvalidXMLException {
        XMLParser.ParsingOptions parsingOptions = new XMLParser.ParsingOptions(false);
        parsingOptions.preserveComments = preserveComments;
        XMLParser parser = UIMAFramework.getXMLParser();
        return parser.parse(input, "http://uima.apache.org/resourceSpecifier", urlForResourceSpecifierSchema, parsingOptions);
    }

    protected void showExceptionReadingImportedDescriptor(Exception e) {
        StringBuffer msg = new StringBuffer(1000);
        msg.append("There was an exception raised while reading and parsing an imported descriptor. If this is a ''not found'' message for a remote descriptor imported by name, insure that the class path or data path includes an entry where this file should be found.\n");
        msg.append(this.editor.getMessagesToRootCause(e));
        Utility.popMessage("Exception reading Imported File", msg.toString(), 1);
    }

    protected boolean isValidAggregateChange() {
        if (!this.editor.isValidAE(this.editor.getAeDescription()) && AbstractSection.revertOrContinue("Continue or Abort", "Because of errors in validating the resulting Analysis Engine:\n")) {
            return false;
        }
        try {
            this.editor.setMergedTypeSystemDescription();
        }
        catch (ResourceInitializationException resourceInitializationException) {
            // empty catch block
        }
        try {
            this.editor.setResolvedExternalResourcesAndBindings();
        }
        catch (InvalidXMLException invalidXMLException) {
            // empty catch block
        }
        try {
            this.editor.setResolvedFlowControllerDeclaration();
        }
        catch (InvalidXMLException invalidXMLException) {
            // empty catch block
        }
        try {
            this.editor.setMergedFsIndexCollection();
        }
        catch (ResourceInitializationException resourceInitializationException) {
            // empty catch block
        }
        try {
            this.editor.setMergedTypePriorities();
        }
        catch (ResourceInitializationException resourceInitializationException) {
            // empty catch block
        }
        return true;
    }

    protected void finishAggregateChangeAction() {
        this.editor.setFileDirty();
        this.editor.getTypePage().markStale();
        this.editor.getIndexesPage().markStale();
        this.editor.getCapabilityPage().markStale();
        ParameterDelegatesSection s = this.editor.getParameterPage().getParameterDelegatesSection();
        if (null != s) {
            s.markStale();
        }
        this.editor.getResourcesPage().markStale();
    }

    protected XMLizable readImport(Import imp, String fileName, boolean isImportByName) {
        XMLizable inputDescription;
        XMLInputSource input;
        if (isImportByName) {
            URL byNameURL;
            try {
                byNameURL = imp.findAbsoluteUrl(this.editor.createResourceManager());
            }
            catch (InvalidXMLException e) {
                this.showExceptionReadingImportedDescriptor((Exception)((Object)e));
                return null;
            }
            try {
                input = new XMLInputSource(byNameURL.openStream(), new File(byNameURL.getFile()).getParentFile());
            }
            catch (IOException e) {
                this.showExceptionReadingImportedDescriptor(e);
                return null;
            }
        }
        try {
            input = new XMLInputSource(new File(fileName));
        }
        catch (IOException e) {
            throw new InternalErrorCDE("invalid state");
        }
        try {
            inputDescription = AbstractSection.parseDescriptor(input);
        }
        catch (InvalidXMLException e1) {
            this.showExceptionReadingImportedDescriptor((Exception)((Object)e1));
            return null;
        }
        return inputDescription;
    }

    protected static void enableCtrl(Control c, boolean enabled) {
        if (null != c) {
            c.setEnabled(enabled);
        }
    }

    protected static void setButtonSelection(Button c, boolean selected) {
        if (null != c) {
            c.setSelection(selected);
        }
    }

    protected String getDescriptionForDescriptor(String fileRef, ResourceSpecifier rs) {
        String description;
        ResourceMetaData resourceMetaData;
        if (null == fileRef || "".equals(fileRef) || null == rs) {
            return "";
        }
        long lCurrentTimeInMillis = System.currentTimeMillis();
        if (rs == this.lastResourceForDescription && lCurrentTimeInMillis - this.lastTimeDescriptionRequested < 15000L) {
            return this.lastDescriptionFromDescriptor;
        }
        String sDesc = fileRef + ":\n";
        sDesc = rs instanceof PearSpecifier ? sDesc + " (Pear descriptor)" : (null == (resourceMetaData = this.getMetaDataFromDescription(rs)) ? sDesc + "(Remote service is not responding)" : (null != (description = resourceMetaData.getDescription()) && !description.equals("") ? sDesc + AbstractSection.parseToFitInToolTips(description) : sDesc + "(No Description)"));
        this.lastResourceForDescription = rs;
        this.lastTimeDescriptionRequested = System.currentTimeMillis();
        this.lastDescriptionFromDescriptor = sDesc;
        return sDesc;
    }

    protected PrintWriter setupToPrintFile(String filePath) {
        if (new File(filePath).exists() && 1 == Utility.popOkCancel("File exists, OK to replace?", MessageFormat.format("The file ''{0}'' exists. Press OK if it can be replaced; otherwise press Cancel.", filePath), 4)) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            return new PrintWriter(fos);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected FsIndexCollection getFsIndexCollection() {
        FsIndexCollection fsic = this.getAnalysisEngineMetaData().getFsIndexCollection();
        if (null == fsic) {
            fsic = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
            this.getAnalysisEngineMetaData().setFsIndexCollection(fsic);
        }
        return fsic;
    }

    public static String handleDefaultIndexKind(String indexKind) {
        if (null == indexKind) {
            return "sorted";
        }
        return indexKind;
    }

    public static void setSelectionOneUp(Tree tt, TreeItem item) {
        int itemIndex = tt.indexOf(item);
        AbstractSection.maybeSetSelection(tt, itemIndex - 1);
    }

    public static void maybeSetSelection(Tree tt, int itemIndex) {
        TreeItem[] items = tt.getItems();
        if (itemIndex >= 0 && itemIndex < items.length) {
            tt.setSelection(items[itemIndex]);
        }
    }

    static {
        try {
            urlForResourceSpecifierSchema = new URL("file:resourceSpecifierSchema.xsd");
        }
        catch (MalformedURLException e) {
            urlForResourceSpecifierSchema = null;
        }
    }
}

