/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.util.Collection;
import java.util.Collections;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.caseditor.editor.ICasDocument;
import org.apache.uima.caseditor.editor.ICasDocumentListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;

public abstract class AbstractDocument
implements ICasDocument {
    private ListenerList mListener = new ListenerList();

    @Override
    public void addChangeListener(ICasDocumentListener listener) {
        this.mListener.add((Object)listener);
    }

    @Override
    public void removeChangeListener(ICasDocumentListener listener) {
        this.mListener.remove((Object)listener);
    }

    protected void fireAddedFeatureStructure(final FeatureStructure annotation) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.added(annotation);
                }
            });
        }
    }

    protected void fireAddedFeatureStructure(final Collection<? extends FeatureStructure> annotations) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.added(Collections.unmodifiableCollection(annotations));
                }
            });
        }
    }

    protected void fireRemovedFeatureStructure(final FeatureStructure annotation) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.removed(annotation);
                }
            });
        }
    }

    protected void fireRemovedFeatureStructure(final Collection<? extends FeatureStructure> annotations) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.removed(Collections.unmodifiableCollection(annotations));
                }
            });
        }
    }

    protected void fireUpdatedFeatureStructure(final FeatureStructure annotation) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.updated(annotation);
                }
            });
        }
    }

    protected void fireUpdatedFeatureStructure(final Collection<? extends FeatureStructure> annotations) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.updated(Collections.unmodifiableCollection(annotations));
                }
            });
        }
    }

    protected void fireChanged() {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.changed();
                }
            });
        }
    }

    protected void fireViewChanged(final String oldViewName, final String newViewName) {
        for (Object listener : this.mListener.getListeners()) {
            final ICasDocumentListener documentListener = (ICasDocumentListener)listener;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    documentListener.viewChanged(oldViewName, newViewName);
                }
            });
        }
    }

    @Override
    public String getTypeSystemText() {
        return null;
    }
}

