/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.EntityType;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.EntityDeclaration;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;

public class EnumValueDeclaration
extends EntityDeclaration {
    public final AstNodeCollection<Expression> getArguments() {
        return this.getChildrenByRole(Roles.ARGUMENT);
    }

    @Override
    public EntityType getEntityType() {
        return EntityType.ENUM_VALUE;
    }

    public final JavaTokenNode getLeftBraceToken() {
        return this.getChildByRole(Roles.LEFT_BRACE);
    }

    public final AstNodeCollection<EntityDeclaration> getMembers() {
        return this.getChildrenByRole(Roles.TYPE_MEMBER);
    }

    public final JavaTokenNode getRightBraceToken() {
        return this.getChildByRole(Roles.RIGHT_BRACE);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitEnumValueDeclaration(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof FieldDeclaration) {
            FieldDeclaration otherDeclaration = (FieldDeclaration)other;
            return !otherDeclaration.isNull() && EnumValueDeclaration.matchString(this.getName(), otherDeclaration.getName()) && this.matchAnnotationsAndModifiers(otherDeclaration, match) && this.getReturnType().matches(otherDeclaration.getReturnType(), match) && this.getMembers().matches(this.getMembers(), match);
        }
        return false;
    }
}

