/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.migratev3.jcas;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.decompiler.Decompiler;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.uima.internal.util.Misc;

public class UimaDecompiler {
    private static final byte[] errorMsg = "!!! ERROR: Failed to load class".getBytes(StandardCharsets.UTF_8);
    private final DecompilerSettings decompilerSettings = DecompilerSettings.javaDefaults();
    private final ClassLoader classLoader;
    private File outputDirectory = null;
    private static final Pattern cie_name = Pattern.compile("( class | interface | enum )\\s*(\\w*)");

    public UimaDecompiler() {
        this.classLoader = null;
    }

    public UimaDecompiler(ClassLoader classLoader, File outputDirectory) {
        this.classLoader = classLoader;
        this.outputDirectory = outputDirectory;
        if (classLoader != null) {
            this.setDecompilerSettingsForClassLoader();
        }
    }

    public ByteArrayOutputStream decompile(String className) {
        this.setDecompilerSettingsForClassLoader();
        return this.decompileCommon(className);
    }

    public ByteArrayOutputStream decompileCommon(String className) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PlainTextOutput plainTextOutput = null;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            plainTextOutput = new PlainTextOutput((Writer)writer);
            Decompiler.decompile((String)className.replace('.', '/'), (ITextOutput)plainTextOutput, (DecompilerSettings)this.decompilerSettings);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        return baos;
    }

    public String decompileToString(String className) {
        this.setDecompilerSettingsForClassLoader();
        return this.decompileToStringCommon(className);
    }

    private String decompileToStringCommon(String className) {
        PlainTextOutput pto = new PlainTextOutput();
        String classNameSlashes = className.replace('.', '/');
        Decompiler.decompile((String)classNameSlashes, (ITextOutput)pto, (DecompilerSettings)this.decompilerSettings);
        return pto.toString();
    }

    public String decompileToString(String className, byte[] byteArray) {
        this.setDecompilerSettingsForByteArray(className.replace('.', '/'), byteArray);
        return this.decompileToStringCommon(className);
    }

    public String decompile(byte[] b) {
        String classNameSlashes = Misc.classNameFromByteCode((byte[])b);
        return this.decompileToString(classNameSlashes);
    }

    public boolean decompileToOutputDirectory(String className) {
        ByteArrayOutputStream baos = this.decompile(className);
        return this.writeIfOk(baos, className);
    }

    public boolean writeIfOk(ByteArrayOutputStream baos, String className) {
        if (!this.decompiledFailed(baos)) {
            Misc.toFile((ByteArrayOutputStream)baos, (File)new File(this.outputDirectory, className));
            return true;
        }
        return false;
    }

    public boolean decompiledFailed(ByteArrayOutputStream baos) {
        return baos.size() == errorMsg.length && Arrays.equals(errorMsg, baos.toByteArray());
    }

    private void setDecompilerSettingsForByteArray(final String classNameSlashes, final byte[] byteArray) {
        ITypeLoader tl = new ITypeLoader(){

            public boolean tryLoadType(String internalName, Buffer buffer) {
                if (classNameSlashes.equals(internalName)) {
                    int length = byteArray.length;
                    buffer.reset(length);
                    System.arraycopy(byteArray, 0, buffer.array(), 0, length);
                    return true;
                }
                return false;
            }
        };
        CompositeTypeLoader tc = new CompositeTypeLoader(new ITypeLoader[]{tl, this.getClasspathTypeLoader(), new InputTypeLoader()});
        this.decompilerSettings.setTypeLoader((ITypeLoader)tc);
    }

    private void setDecompilerSettingsForClassLoader() {
        CompositeTypeLoader tc = new CompositeTypeLoader(new ITypeLoader[]{this.getClasspathTypeLoader(), new InputTypeLoader()});
        this.decompilerSettings.setTypeLoader((ITypeLoader)tc);
    }

    private ITypeLoader getClasspathTypeLoader() {
        return new ITypeLoader(){

            public boolean tryLoadType(String internalName, Buffer buffer) {
                InputStream stream = UimaDecompiler.this.classLoader.getResourceAsStream((String)(internalName = ((String)internalName).replace('.', '/') + ".class"));
                if (stream == null) {
                    return false;
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
                byte[] b = new byte[16384];
                try {
                    int numberRead;
                    while (0 <= (numberRead = stream.read(b))) {
                        baos.write(b, 0, numberRead);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                int length = baos.size();
                b = baos.toByteArray();
                buffer.reset(length);
                System.arraycopy(b, 0, buffer.array(), 0, length);
                return true;
            }
        };
    }
}

