/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.impl.XmiSerializationSharedData;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.EmptyStringList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.StringList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmiCasSerializer {
    static final char[] URIPFX = new char[]{'h', 't', 't', 'p', ':', '/', '/', '/'};
    static final char[] URISFX = new char[]{'.', 'e', 'c', 'o', 'r', 'e'};
    private static final String CDATA_TYPE = "CDATA";
    public static final String XMLNS_NS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XMI_NS_URI = "http://www.omg.org/XMI";
    public static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMI_NS_PREFIX = "xmi";
    public static final String ID_ATTR_NAME = "xmi:id";
    public static final String XMI_TAG_LOCAL_NAME = "XMI";
    public static final String XMI_TAG_QNAME = "xmi:XMI";
    public static final XmlElementName XMI_TAG = new XmlElementName("http://www.omg.org/XMI", "XMI", "xmi:XMI");
    public static final String XMI_VERSION_LOCAL_NAME = "version";
    public static final String XMI_VERSION_QNAME = "xmi:version";
    public static final String XMI_VERSION_VALUE = "2.0";
    public static final String DEFAULT_NAMESPACE_URI = "http:///uima/noNamespace.ecore";
    public static final String SYSTEM_LINE_FEED;
    public static final char[] INT_TO_HEX;
    private final CasSerializerSupport css = new CasSerializerSupport();
    private Map<String, String> nsUriToSchemaLocationMap = null;

    public XmiCasSerializer(TypeSystem ts) {
        this(ts, (Map<String, String>)null);
    }

    public XmiCasSerializer(TypeSystem ts, Map<String, String> nsUriToSchemaLocationMap) {
        this(ts, nsUriToSchemaLocationMap, false);
    }

    public XmiCasSerializer(TypeSystem ts, Map<String, String> nsUriToSchemaLocationMap, boolean isFormattedOutput) {
        this.css.filterTypeSystem = (TypeSystemImpl)ts;
        this.nsUriToSchemaLocationMap = nsUriToSchemaLocationMap;
        this.css.logger = UIMAFramework.getLogger(XmiCasSerializer.class);
        this.css.isFormattedOutput = isFormattedOutput;
    }

    @Deprecated
    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext, Map<String, String> nsUriToSchemaLocationMap) {
        this(ts, nsUriToSchemaLocationMap);
    }

    @Deprecated
    public XmiCasSerializer(TypeSystem ts, UimaContext uimaContext) {
        this(ts);
    }

    public static void serialize(CAS aCAS, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, null, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream) throws SAXException {
        XmiCasSerializer.serialize(aCAS, aTargetTypeSystem, aStream, false, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData) throws SAXException {
        XmiCasSerializer.serialize(aCAS, aTargetTypeSystem, aStream, aPrettyPrint, aSharedData, null);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData, Marker aMarker) throws SAXException {
        XmiCasSerializer.serialize(aCAS, aTargetTypeSystem, aStream, aPrettyPrint, aSharedData, aMarker, false);
    }

    public static void serialize(CAS aCAS, TypeSystem aTargetTypeSystem, OutputStream aStream, boolean aPrettyPrint, XmiSerializationSharedData aSharedData, Marker aMarker, boolean useXml_1_1) throws SAXException {
        XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(aTargetTypeSystem);
        XMLSerializer sax2xml = new XMLSerializer(aStream, aPrettyPrint);
        if (useXml_1_1) {
            sax2xml.setOutputProperty(XMI_VERSION_LOCAL_NAME, "1.1");
        }
        xmiCasSerializer.serialize(aCAS, sax2xml.getContentHandler(), null, aSharedData, aMarker);
    }

    public void serialize(CAS cas, ContentHandler contentHandler) throws SAXException {
        this.serialize(cas, contentHandler, (ErrorHandler)null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        this.serialize(cas, contentHandler, errorHandler, null, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData sharedData) throws SAXException {
        this.serialize(cas, contentHandler, errorHandler, sharedData, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData sharedData, Marker marker) throws SAXException {
        contentHandler.startDocument();
        if (errorHandler != null) {
            this.css.setErrorHandler(errorHandler);
        }
        XmiDocSerializer ser = new XmiDocSerializer(contentHandler, ((CASImpl)cas).getBaseCAS(), sharedData, (MarkerImpl)marker);
        try {
            ser.cds.serialize();
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new UIMARuntimeException(e);
        }
        contentHandler.endDocument();
    }

    void serialize(CAS cas, ContentHandler contentHandler, XmiDocSerializer ser) throws SAXException {
        contentHandler.startDocument();
        try {
            ser.cds.serialize();
        }
        catch (Exception e) {
            throw (SAXException)e;
        }
        contentHandler.endDocument();
    }

    public XmiCasSerializer setPrettyPrint(boolean pp) {
        this.css.setPrettyPrint(pp);
        return this;
    }

    public XmiCasSerializer setFilterTypes(TypeSystemImpl ts) {
        this.css.setFilterTypes(ts);
        return this;
    }

    public XmiCasSerializer setErrorHandler(ErrorHandler eh) {
        this.css.errorHandler = eh;
        return this;
    }

    static {
        String lf = System.getProperty("line.separator");
        SYSTEM_LINE_FEED = lf == null ? "\n" : lf;
        INT_TO_HEX = "0123456789ABCDEF".toCharArray();
    }

    class XmiDocSerializer
    extends CasSerializerSupport.CasSerializerSupportSerialize {
        private final CasSerializerSupport.CasDocSerializer cds;
        private final ContentHandler ch;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private final AttributesImpl workAttrs = new AttributesImpl();

        private XmiDocSerializer(ContentHandler ch, CASImpl cas, XmiSerializationSharedData sharedData, MarkerImpl marker) {
            CasSerializerSupport casSerializerSupport = XmiCasSerializer.this.css;
            Objects.requireNonNull(casSerializerSupport);
            this.cds = casSerializerSupport.new CasSerializerSupport.CasDocSerializer(ch, cas, sharedData, marker, this);
            this.ch = ch;
        }

        @Override
        protected void initializeNamespaces() {
            this.cds.nsUriToPrefixMap.put(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_NS_PREFIX);
            if (this.cds.sharedData != null) {
                for (XmiSerializationSharedData.OotsElementData oed : this.cds.sharedData.getOutOfTypeSystemElements()) {
                    String nsUri = oed.elementName.nsUri;
                    String qname = oed.elementName.qName;
                    String localName = oed.elementName.localName;
                    String prefix = qname.substring(0, qname.indexOf(localName) - 1);
                    this.cds.nsUriToPrefixMap.put(nsUri, prefix);
                    this.cds.nsPrefixesUsed.add(prefix);
                }
            }
            Iterator<Type> it = this.cds.tsi.getTypeIterator();
            while (it.hasNext()) {
                TypeImpl t = (TypeImpl)it.next();
                this.cds.typeCode2namespaceNames[t.getCode()] = this.uimaTypeName2XmiElementName(t.getName());
            }
        }

        @Override
        protected void writeFeatureStructures(int iElementCount) throws Exception {
            this.workAttrs.clear();
            this.computeNamespaceDeclarationAttrs(this.workAttrs);
            this.workAttrs.addAttribute(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_VERSION_LOCAL_NAME, XmiCasSerializer.XMI_VERSION_QNAME, XmiCasSerializer.CDATA_TYPE, XmiCasSerializer.XMI_VERSION_VALUE);
            this.startElement(XMI_TAG, this.workAttrs, iElementCount);
            this.writeNullObject();
            this.cds.encodeIndexed();
            this.cds.encodeQueued();
            if (!this.cds.isDelta) {
                this.serializeOutOfTypeSystemElements();
            }
        }

        @Override
        protected void writeViews() throws Exception {
            this.cds.writeViewsCommons();
        }

        @Override
        protected void writeEndOfSerialization() throws SAXException {
            this.endElement(XMI_TAG);
            this.endPrefixMappings();
        }

        @Override
        protected void writeView(Sofa sofa, Collection<TOP> members) throws Exception {
            String sofaXmiId;
            this.workAttrs.clear();
            String string = sofaXmiId = sofa == null ? null : this.cds.getXmiId(sofa);
            if (sofaXmiId != null && sofaXmiId.length() > 0) {
                this.addAttribute(this.workAttrs, "sofa", sofaXmiId);
            }
            StringBuilder membersString = new StringBuilder();
            boolean isPastFirstElement = this.writeViewMembers(membersString, members);
            if (this.cds.sharedData != null) {
                List<String> ootsMembers = this.cds.sharedData.getOutOfTypeSystemViewMembers(sofaXmiId);
                this.writeViewMembers(membersString, ootsMembers, isPastFirstElement);
            }
            if (membersString.length() > 0) {
                this.workAttrs.addAttribute("", "members", "members", XmiCasSerializer.CDATA_TYPE, membersString.toString());
                if (membersString.length() > 0) {
                    XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.View");
                    this.startElement(elemName, this.workAttrs, 0);
                    this.endElement(elemName);
                }
            }
        }

        private StringBuilder writeViewMembers(StringBuilder sb, Collection<String> members, boolean isPastFirstElement) {
            if (members != null) {
                for (String member : members) {
                    if (isPastFirstElement) {
                        sb.append(' ');
                    } else {
                        isPastFirstElement = true;
                    }
                    sb.append(member);
                }
            }
            return sb;
        }

        private boolean writeViewMembers(StringBuilder sb, Collection<TOP> members) throws SAXException {
            boolean isPastFirstElement = false;
            int nextBreak = ((sb.length() - 1) / CasSerializerSupport.PP_LINE_LENGTH + 1) * CasSerializerSupport.PP_LINE_LENGTH;
            for (TOP member : members) {
                int xmiId = this.cds.getXmiIdAsInt(member);
                if (xmiId == 0) continue;
                if (isPastFirstElement) {
                    sb.append(' ');
                } else {
                    isPastFirstElement = true;
                }
                sb.append(xmiId);
                if (!this.cds.isFormattedOutput_inner || sb.length() <= nextBreak) continue;
                sb.append(SYSTEM_LINE_FEED);
                nextBreak += CasSerializerSupport.PP_LINE_LENGTH;
            }
            return isPastFirstElement;
        }

        private void writeViewForDeltas(String kind, Collection<TOP> deltaMembers) throws SAXException {
            StringBuilder sb = new StringBuilder();
            this.writeViewMembers(sb, deltaMembers);
            if (sb.length() > 0) {
                this.addAttribute(this.workAttrs, kind, sb.toString());
            }
        }

        @Override
        protected void writeView(Sofa sofa, Collection<TOP> added, Collection<TOP> deleted, Collection<TOP> reindexed) throws SAXException {
            String sofaXmiId = this.cds.getXmiId(sofa);
            this.workAttrs.clear();
            if (sofaXmiId != null && sofaXmiId.length() > 0) {
                this.addAttribute(this.workAttrs, "sofa", sofaXmiId);
            }
            this.writeViewForDeltas("added_members", added);
            this.writeViewForDeltas("deleted_members", deleted);
            this.writeViewForDeltas("reindexed_members", reindexed);
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.View");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        void writeNullObject() throws SAXException {
            this.workAttrs.clear();
            this.addIdAttribute(this.workAttrs, "0");
            XmlElementName elemName = this.uimaTypeName2XmiElementName("uima.cas.NULL");
            this.startElement(elemName, this.workAttrs, 0);
            this.endElement(elemName);
        }

        @Override
        protected void writeFs(TOP fs, int typeCode) throws SAXException {
            this.writeFsOrLists(fs, typeCode, false);
        }

        @Override
        protected void writeListsAsIndividualFSs(TOP fs, int typeCode) throws SAXException {
            this.writeFsOrLists(fs, typeCode, true);
        }

        private void writeFsOrLists(TOP fs, int typeCode, boolean isListAsFSs) throws SAXException {
            List<XmlElementNameAndContents> childElements = this.encodeFeatures(fs, this.workAttrs, isListAsFSs);
            XmlElementName xmlElementName = this.cds.typeCode2namespaceNames[typeCode];
            this.startElement(xmlElementName, this.workAttrs, childElements.size());
            this.sendElementEvents(childElements);
            this.endElement(xmlElementName);
        }

        @Override
        protected void writeArrays(TOP fsArray, int typeCode, int typeClass) throws SAXException {
            XmlElementName xmlElementName = this.cds.typeCode2namespaceNames[typeCode];
            if (fsArray instanceof StringArray && ((StringArray)fsArray).size() != 0) {
                ArrayList childElements = new ArrayList();
                this.stringArrayToElementList("elements", (StringArray)fsArray, childElements);
                this.startElement(xmlElementName, this.workAttrs, childElements.size());
                this.sendElementEvents(childElements);
                this.endElement(xmlElementName);
            } else {
                this.workAttrs.addAttribute("", "elements", "elements", XmiCasSerializer.CDATA_TYPE, this.arrayToString(fsArray, typeClass));
                this.startElement(xmlElementName, this.workAttrs, 0);
                this.endElement(xmlElementName);
            }
        }

        private void endPrefixMappings() throws SAXException {
            for (Map.Entry<String, String> entry : this.cds.nsUriToPrefixMap.entrySet()) {
                String prefix = entry.getValue();
                this.ch.endPrefixMapping(prefix);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.ch.endPrefixMapping("xsi");
            }
        }

        private void computeNamespaceDeclarationAttrs(AttributesImpl workAttrs2) throws SAXException {
            for (Map.Entry<String, String> entry : this.cds.nsUriToPrefixMap.entrySet()) {
                String nsUri = entry.getKey();
                String prefix = entry.getValue();
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, prefix, "xmlns:" + prefix, XmiCasSerializer.CDATA_TYPE, nsUri);
                this.ch.startPrefixMapping(prefix, nsUri);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.workAttrs.addAttribute(XmiCasSerializer.XMLNS_NS_URI, "xsi", "xmlns:xsi", XmiCasSerializer.CDATA_TYPE, XmiCasSerializer.XSI_NS_URI);
                this.ch.startPrefixMapping("xsi", XmiCasSerializer.XSI_NS_URI);
                StringBuilder buf = new StringBuilder();
                for (Map.Entry<String, String> entry : XmiCasSerializer.this.nsUriToSchemaLocationMap.entrySet()) {
                    buf.append(entry.getKey()).append(' ').append(entry.getValue()).append(' ');
                }
                this.workAttrs.addAttribute(XmiCasSerializer.XSI_NS_URI, "xsi", "xsi:schemaLocation", XmiCasSerializer.CDATA_TYPE, buf.toString());
            }
        }

        private void serializeOutOfTypeSystemElements() throws SAXException {
            if (this.cds.marker != null || this.cds.sharedData == null) {
                return;
            }
            for (XmiSerializationSharedData.OotsElementData oed : this.cds.sharedData.getOutOfTypeSystemElements()) {
                this.workAttrs.clear();
                this.addIdAttribute(this.workAttrs, oed.xmiId);
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                if (oed.elementName.qName.endsWith("[]")) {
                    Misc.internalError(new Exception("XMI Cas Serialization: out of type system data has type name ending with []"));
                }
                this.startElement(oed.elementName, this.workAttrs, oed.childElements.size());
                for (XmlElementNameAndContents child : oed.childElements) {
                    this.workAttrs.clear();
                    for (XmlAttribute attr : child.attributes) {
                        this.addAttribute(this.workAttrs, attr.name, attr.value);
                    }
                    if (child.contents != null) {
                        this.startElement(child.name, this.workAttrs, 1);
                        this.addText(child.contents);
                    } else {
                        this.startElement(child.name, this.workAttrs, 0);
                    }
                    this.endElement(child.name);
                }
                this.endElement(oed.elementName);
            }
        }

        private List<XmlElementNameAndContents> encodeFeatures(TOP fs, AttributesImpl attrs, boolean insideListNode) throws SAXException {
            XmiSerializationSharedData.OotsElementData oed;
            ArrayList<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();
            for (FeatureImpl fi : fs._getTypeImpl().getFeatureImpls()) {
                String fullFeatName;
                if (this.cds.isFiltering && this.cds.filterTypeSystem_inner.getFeatureByFullName(fullFeatName = fi.getName()) == null) continue;
                String featName = fi.getShortName();
                int featureValueClass = fi.rangeTypeClass;
                String attrValue = switch (featureValueClass) {
                    case 1, 2, 9, 10, 11, 12, 13 -> fs.getFeatureValueAsString(fi);
                    case 3 -> fs.getFeatureValueAsString(fi);
                    case 4, 5, 7, 14, 15, 16, 17, 18 -> {
                        if (this.cds.isStaticMultiRef(fi)) {
                            yield this.cds.getXmiId(fs.getFeatureValue(fi));
                        }
                        yield this.arrayToString(fs.getFeatureValue(fi), featureValueClass);
                    }
                    case 6 -> {
                        StringArray stringArray = (StringArray)fs.getFeatureValue(fi);
                        if (this.cds.isStaticMultiRef(fi)) {
                            yield this.cds.getXmiId(stringArray);
                        }
                        if (stringArray != null && stringArray.size() == 0) {
                            yield "";
                        }
                        this.stringArrayToElementList(featName, (StringArray)fs.getFeatureValue(fi), childElements);
                        yield null;
                    }
                    case 101, 102, 104 -> {
                        TOP startNode = fs.getFeatureValue(fi);
                        if (insideListNode || this.cds.isStaticMultiRef(fi)) {
                            yield this.cds.getXmiId(startNode);
                        }
                        yield this.listToString((CommonList)((Object)fs.getFeatureValue(fi)));
                    }
                    case 103 -> {
                        if (insideListNode || this.cds.isStaticMultiRef(fi)) {
                            yield this.cds.getXmiId(fs.getFeatureValue(fi));
                        }
                        StringList stringList = (StringList)fs.getFeatureValue(fi);
                        if (stringList == null) {
                            yield null;
                        }
                        if (stringList instanceof EmptyStringList) {
                            yield "";
                        }
                        List<String> listOfStrings = stringList.anyListToStringList(null, this.cds);
                        for (String string : listOfStrings) {
                            childElements.add(new XmlElementNameAndContents(new XmlElementName("", featName, featName), string));
                        }
                        yield null;
                    }
                    default -> this.cds.getXmiId(fs.getFeatureValue(fi));
                };
                if (attrValue == null || featName == null) continue;
                this.addAttribute(attrs, featName, attrValue, "");
            }
            if (this.cds.sharedData != null && (oed = this.cds.sharedData.getOutOfTypeSystemFeatures(fs)) != null) {
                for (XmlAttribute attr : oed.attributes) {
                    this.addAttribute(this.workAttrs, attr.name, attr.value);
                }
                childElements.addAll(oed.childElements);
            }
            return childElements;
        }

        private String arrayToString(TOP fsIn, int arrayType) throws SAXException {
            String[] fsvalues;
            if (fsIn == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            CommonArrayFS fs = (CommonArrayFS)((Object)fsIn);
            String elemStr = null;
            if (fs instanceof FSArray) {
                List<XmiSerializationSharedData.XmiArrayElement> ootsArrayElementsList = this.cds.sharedData == null ? null : this.cds.sharedData.getOutOfTypeSystemArrayElements((FSArray)fs);
                int ootsIndex = 0;
                int j = -1;
                for (TOP elemFS : ((FSArray)fs)._getTheArray()) {
                    ++j;
                    if (elemFS == null) {
                        elemStr = "0";
                        if (ootsArrayElementsList != null) {
                            while (ootsIndex < ootsArrayElementsList.size()) {
                                XmiSerializationSharedData.XmiArrayElement arel = ootsArrayElementsList.get(ootsIndex++);
                                if (arel.index != j) continue;
                                elemStr = arel.xmiId;
                                break;
                            }
                        }
                    } else {
                        String typeName;
                        String xmiId = this.cds.getXmiId(elemFS);
                        if (this.cds.isFiltering && this.cds.filterTypeSystem_inner.getType(typeName = elemFS._getTypeImpl().getName()) == null) {
                            xmiId = "0";
                        }
                        elemStr = xmiId;
                    }
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(elemStr);
                }
                return buf.toString();
            }
            if (fs instanceof ByteArray) {
                byte[] ba = ((ByteArray)fs)._getTheArray();
                char[] r = new char[ba.length * 2];
                int i = 0;
                for (byte b : ba) {
                    r[i++] = INT_TO_HEX[(b & 0xF0) >>> 4];
                    r[i++] = INT_TO_HEX[b & 0xF];
                }
                return new String(r);
            }
            for (String s : fsvalues = fs.toStringArray()) {
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(s);
            }
            return buf.toString();
        }

        private void stringArrayToElementList(String featName, StringArray stringArray, List<? super XmlElementNameAndContents> resultList) {
            if (stringArray == null) {
                return;
            }
            for (String s : stringArray._getTheArray()) {
                resultList.add(new XmlElementNameAndContents(new XmlElementName("", featName, featName), s));
            }
        }

        private String listToString(CommonList fs) throws SAXException {
            if (fs == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            fs.anyListToOutput(this.cds.sharedData, this.cds, s -> {
                if (sb.length() > 0) {
                    sb.append(' ').append((String)s);
                } else {
                    sb.append((String)s);
                }
            });
            return sb.toString();
        }

        private void sendElementEvents(List<? extends XmlElementNameAndContents> elements) throws SAXException {
            for (XmlElementNameAndContents xmlElementNameAndContents : elements) {
                if (xmlElementNameAndContents.contents != null) {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 1);
                    this.addText(xmlElementNameAndContents.contents);
                } else {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 0);
                }
                this.endElement(xmlElementNameAndContents.name);
            }
        }

        private void startElement(XmlElementName name, Attributes attrs, int aNumChildren) throws SAXException {
            this.ch.startElement(name.nsUri, name.localName, name.qName, attrs);
        }

        private void endElement(XmlElementName name) throws SAXException {
            this.ch.endElement(name.nsUri, name.localName, name.qName);
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue) {
            this.addAttribute(attrs, attrName, attrValue, XmiCasSerializer.CDATA_TYPE);
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue, String type) {
            attrs.addAttribute("", attrName, attrName, type, attrValue);
        }

        private void addIdAttribute(AttributesImpl attrs, String attrValue) {
            attrs.addAttribute(XmiCasSerializer.XMI_NS_URI, "id", XmiCasSerializer.ID_ATTR_NAME, XmiCasSerializer.CDATA_TYPE, attrValue);
        }

        private void addText(String text) throws SAXException {
            this.ch.characters(text.toCharArray(), 0, text.length());
        }

        @Override
        protected void checkForNameCollision(XmlElementName xmlElementName) {
        }

        @Override
        protected void addNameSpace(XmlElementName xmlElementName) {
        }

        @Override
        protected boolean writeFsStart(TOP fs, int typeCode) {
            this.workAttrs.clear();
            this.addIdAttribute(this.workAttrs, this.cds.getXmiId(fs));
            return false;
        }

        @Override
        protected XmlElementName uimaTypeName2XmiElementName(String uimaTypeName) {
            String nsUri;
            String shortName;
            int lastDotIndex;
            if (uimaTypeName.endsWith("[]")) {
                uimaTypeName = "uima.cas.FSArray";
            }
            if ((lastDotIndex = uimaTypeName.lastIndexOf(46)) == -1) {
                shortName = uimaTypeName;
                nsUri = XmiCasSerializer.DEFAULT_NAMESPACE_URI;
            } else {
                int i;
                shortName = uimaTypeName.substring(lastDotIndex + 1);
                char[] sb = new char[lastDotIndex + URIPFX.length + URISFX.length];
                System.arraycopy(URIPFX, 0, sb, 0, URIPFX.length);
                for (i = 0; i < lastDotIndex; ++i) {
                    char c = uimaTypeName.charAt(i);
                    sb[XmiCasSerializer.URIPFX.length + i] = c == '.' ? 47 : (int)c;
                }
                System.arraycopy(URISFX, 0, sb, URIPFX.length + i, URISFX.length);
                nsUri = this.cds.getUniqueString(new String(sb));
            }
            shortName = this.cds.getUniqueString(shortName);
            String prefix = this.cds.getNameSpacePrefix(uimaTypeName, nsUri, lastDotIndex);
            return new XmlElementName(nsUri, shortName, this.cds.getUniqueString(prefix + ":" + shortName));
        }

        @Override
        protected void writeEndOfIndividualFs() {
        }

        @Override
        protected void writeFsRef(TOP fs) throws Exception {
        }
    }
}

