/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.fit.descriptor.FsIndex;
import org.apache.uima.fit.descriptor.FsIndexKey;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.fit.internal.MetaDataType;
import org.apache.uima.fit.internal.MetaDataUtil;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.FsIndexCollection_impl;
import org.apache.uima.resource.metadata.impl.FsIndexDescription_impl;
import org.apache.uima.resource.metadata.impl.FsIndexKeyDescription_impl;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.spi.FsIndexCollectionProvider;
import org.apache.uima.spi.TypeSystemProvider;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FsIndexFactory {
    private static Logger LOG = LoggerFactory.getLogger(FsIndexFactory.class);
    public static final int STANDARD_COMPARE = 0;
    public static final int REVERSE_STANDARD_COMPARE = 1;
    private static final Object SCAN_LOCK = new Object();
    private static final Object CREATE_LOCK = new Object();
    private static final FsIndexCollection PLACEHOLDER = new FsIndexCollection_impl();
    private static WeakHashMap<String, FsIndexCollection> fsIndexCollections = new WeakHashMap();
    private static WeakHashMap<ClassLoader, String[]> fsIndexLocationsByClassloader = new WeakHashMap();
    private static WeakHashMap<ClassLoader, FsIndexCollection> fsIndexCollectionsByClassloader = new WeakHashMap();

    private FsIndexFactory() {
    }

    public static FsIndexCollection createFsIndexCollection(Class<?> componentClass) {
        FsIndex anFsIndex;
        ArrayList<FsIndex> anFsIndexList = new ArrayList<FsIndex>();
        org.apache.uima.fit.descriptor.FsIndexCollection anIndexCollection = ReflectionUtil.getInheritableAnnotation(org.apache.uima.fit.descriptor.FsIndexCollection.class, componentClass);
        if (anIndexCollection != null) {
            anFsIndexList.addAll(Arrays.asList(anIndexCollection.fsIndexes()));
        }
        if ((anFsIndex = ReflectionUtil.getInheritableAnnotation(FsIndex.class, componentClass)) != null) {
            if (anIndexCollection != null) {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not declare " + org.apache.uima.fit.descriptor.FsIndexCollection.class.getSimpleName() + " and " + FsIndex.class.getSimpleName() + " at the same time.");
            }
            anFsIndexList.add(anFsIndex);
        }
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        for (FsIndex anIdx : anFsIndexList) {
            String typeName;
            ArrayList<FsIndexKeyDescription> keys = new ArrayList<FsIndexKeyDescription>();
            for (FsIndexKey anIndexKey : anIdx.keys()) {
                keys.add(FsIndexFactory.createFsIndexKeyDescription(anIndexKey.featureName(), anIndexKey.comparator()));
            }
            if (!anIdx.typeName().equals("org.apache.uima.fit.descriptor.FsIndex.NO_NAME_TYPE_SET") && anIdx.type() != FsIndex.NoClassSet.class) {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not declare an " + FsIndex.class.getSimpleName() + " with type and typeName both set at the same time.");
            }
            if (!anIdx.typeName().equals("org.apache.uima.fit.descriptor.FsIndex.NO_NAME_TYPE_SET")) {
                typeName = anIdx.typeName();
            } else if (anIdx.type() != FsIndex.NoClassSet.class) {
                typeName = anIdx.type().getName();
            } else {
                throw new IllegalStateException("Class [" + componentClass.getName() + "] must not declare an " + FsIndex.class.getSimpleName() + " with neither type nor typeName set.");
            }
            fsIndexCollection.addFsIndex(FsIndexFactory.createFsIndexDescription(anIdx.label(), anIdx.kind(), typeName, anIdx.typePriorities(), keys.toArray(new FsIndexKeyDescription[keys.size()])));
        }
        return fsIndexCollection;
    }

    public static FsIndexDescription createFsIndexDescription(String label, String kind, String typeName, boolean useTypePriorities, FsIndexKeyDescription ... keys) {
        FsIndexDescription_impl fsIndexDescription = new FsIndexDescription_impl();
        fsIndexDescription.setLabel(label);
        fsIndexDescription.setKind(kind);
        fsIndexDescription.setTypeName(typeName);
        fsIndexDescription.setKeys(keys);
        return fsIndexDescription;
    }

    public static FsIndexCollection createFsIndexCollection(FsIndexDescription ... descriptions) {
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setFsIndexes(descriptions);
        return fsIndexCollection;
    }

    public static FsIndexCollection createFsIndexCollection(Collection<? extends FsIndexDescription> descriptions) {
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setFsIndexes(descriptions.toArray(new FsIndexDescription[descriptions.size()]));
        return fsIndexCollection;
    }

    public static FsIndexKeyDescription createFsIndexKeyDescription(String featureName) {
        return FsIndexFactory.createFsIndexKeyDescription(featureName, 0);
    }

    public static FsIndexKeyDescription createFsIndexKeyDescription(String featureName, int comparator) {
        FsIndexKeyDescription_impl key = new FsIndexKeyDescription_impl();
        key.setFeatureName(featureName);
        key.setComparator(comparator);
        key.setTypePriority(false);
        return key;
    }

    public static FsIndexCollection createFsIndexCollection(String ... descriptorNames) {
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorName : descriptorNames) {
            Import_impl imp = new Import_impl();
            imp.setName(descriptorName);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setImports(imports.toArray(importArray));
        return fsIndexCollection;
    }

    public static FsIndexCollection createTypeSystemDescriptionFromPath(String ... descriptorURIs) {
        ArrayList<Import_impl> imports = new ArrayList<Import_impl>();
        for (String descriptorURI : descriptorURIs) {
            Import_impl imp = new Import_impl();
            imp.setLocation(descriptorURI);
            imports.add(imp);
        }
        Import[] importArray = new Import[imports.size()];
        FsIndexCollection_impl fsIndexCollection = new FsIndexCollection_impl();
        fsIndexCollection.setImports(imports.toArray(importArray));
        return fsIndexCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FsIndexCollection createFsIndexCollection() throws ResourceInitializationException {
        ClassLoader cl = ClassLoaderUtils.findClassloader();
        FsIndexCollection aggFsIdxCol = fsIndexCollectionsByClassloader.get(cl);
        if (aggFsIdxCol == null) {
            Object object = CREATE_LOCK;
            synchronized (object) {
                ResourceManager resMgr = ResourceManagerFactory.newResourceManager();
                ArrayList<FsIndexDescription> fsIndexList = new ArrayList<FsIndexDescription>();
                FsIndexFactory.loadFsIndexCollectionsFromScannedLocations(fsIndexList, resMgr);
                FsIndexFactory.loadFsIndexCollectionsfromSPIs(fsIndexList);
                aggFsIdxCol = FsIndexFactory.createFsIndexCollection(fsIndexList.toArray(new FsIndexDescription[fsIndexList.size()]));
                fsIndexCollectionsByClassloader.put(cl, aggFsIdxCol);
            }
        }
        return (FsIndexCollection)aggFsIdxCol.clone();
    }

    static void loadFsIndexCollectionsFromScannedLocations(List<FsIndexDescription> fsIndexList, ResourceManager aResMgr) throws ResourceInitializationException {
        for (String location : FsIndexFactory.scanIndexDescriptors()) {
            try {
                FsIndexCollection fsIdxCol = fsIndexCollections.get(location);
                if (fsIdxCol == PLACEHOLDER) {
                    fsIdxCol = UIMAFramework.getXMLParser().parseFsIndexCollection(new XMLInputSource(location));
                    fsIdxCol.resolveImports(aResMgr);
                    fsIndexCollections.put(location, fsIdxCol);
                }
                fsIndexList.addAll(Arrays.asList(fsIdxCol.getFsIndexes()));
                LOG.debug("Detected index at [{}]", (Object)location);
            }
            catch (IOException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
            catch (InvalidXMLException e) {
                LOG.warn("[{}] is not a index descriptor file. Ignoring.", (Object)location, (Object)e);
            }
        }
    }

    static void loadFsIndexCollectionsfromSPIs(List<FsIndexDescription> fsIndexList) {
        Set loaded = Collections.newSetFromMap(new IdentityHashMap());
        ServiceLoader.load(FsIndexCollectionProvider.class).forEach(provider -> {
            for (FsIndexCollection fsIdxCol : provider.listFsIndexCollections()) {
                loaded.add(fsIdxCol);
                fsIndexList.addAll(Arrays.asList(fsIdxCol.getFsIndexes()));
                LOG.debug("Loaded legacy SPI-provided index collection at [{}]", (Object)fsIdxCol.getSourceUrlString());
            }
        });
        ServiceLoader.load(TypeSystemProvider.class).forEach(provider -> {
            for (FsIndexCollection fsIdxCol : provider.listFsIndexCollections()) {
                if (loaded.contains(fsIdxCol)) continue;
                fsIndexList.addAll(Arrays.asList(fsIdxCol.getFsIndexes()));
                LOG.debug("Loaded SPI-provided index collection at [{}]", (Object)fsIdxCol.getSourceUrlString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] scanIndexDescriptors() throws ResourceInitializationException {
        Object object = SCAN_LOCK;
        synchronized (object) {
            ClassLoader cl = ClassLoaderUtils.findClassloader();
            String[] indexLocations = fsIndexLocationsByClassloader.get(cl);
            if (indexLocations == null) {
                indexLocations = MetaDataUtil.scanDescriptors(MetaDataType.FS_INDEX);
                FsIndexFactory.internFsIndexCollectionLocations(indexLocations);
                fsIndexLocationsByClassloader.put(cl, indexLocations);
            }
            return indexLocations;
        }
    }

    private static void internFsIndexCollectionLocations(String[] indexDescriptorLocations) {
        HashMap<String, String> locationStrings = new HashMap<String, String>();
        fsIndexCollections.keySet().stream().forEach(loc -> locationStrings.put((String)loc, (String)loc));
        for (int i = 0; i < indexDescriptorLocations.length; ++i) {
            String existingLocString = (String)locationStrings.get(indexDescriptorLocations[i]);
            if (existingLocString == null) {
                fsIndexCollections.put(indexDescriptorLocations[i], PLACEHOLDER);
                locationStrings.put(indexDescriptorLocations[i], indexDescriptorLocations[i]);
                continue;
            }
            indexDescriptorLocations[i] = existingLocString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceIndexDescriptorsScan() {
        Object object = SCAN_LOCK;
        synchronized (object) {
            fsIndexLocationsByClassloader.clear();
            fsIndexCollectionsByClassloader.clear();
            fsIndexCollections.clear();
        }
    }
}

