BEGIN {
    RS = " "
    modules[n++] = "core"
    pmodules[pn++] = "core"
} 
{
    modules[n] = $1;
    pmodules[pn] = $1;
    gsub("\n","",modules[n]);
    gsub("\n","",pmodules[pn]);
    ++n;
    ++pn;
} 
END {
    print "/*"
    print " * modules.c --- automatically generated by Apache"
    print " * configuration script.  DO NOT HAND EDIT!!!!!"
    print " */"
    print ""
    print "#include \"ap_config.h\""
    print "#include \"httpd.h\""
    print "#include \"http_config.h\""
    print ""
    for (i = 0; i < pn; ++i) {
        printf ("extern module %s_module;\n", pmodules[i])
    }
    print ""
    print "/*"
    print " *  Modules which implicitly form the"
    print " *  list of activated modules on startup,"
    print " *  i.e. these are the modules which are"
    print " *  initially linked into the Apache processing"
    print " *  [extendable under run-time via AddModule]"
    print " */"
    print "module *ap_prelinked_modules[] = {"
    for (i = 0 ; i < n; ++i) {
        printf "  &%s_module,\n", modules[i]
    }
    print "  NULL"
    print "};"
    print ""
    print "/*"
    print " *  Modules which initially form the"
    print " *  list of available modules on startup,"
    print " *  i.e. these are the modules which are"
    print " *  initially loaded into the Apache process"
    print " *  [extendable under run-time via LoadModule]"
    print " */"
    print "module *ap_preloaded_modules[] = {"
    for (i = 0; i < pn; ++i) {
        printf "  &%s_module,\n", pmodules[i]
    }
    print "  NULL"
    print "};"
    print ""
}
