/************************************************************************/
/*  File name : Common.cpp                                              */
/************************************************************************/
/*  Contents  : ʊ֐Q                                              */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.00    2000.09.12          */
/*                                  Version 0.10    2000.09.27          */
/*                                  Version 0.20    2000.10.02          */
/*                                  Version 0.30    2000.10.08          */
/*                                  Version 0.32    2000.10.26          */
/*                                  Version 1.0.0   2000.11.08          */
/************************************************************************/

/**** Incude Files ****/
#include <mbstring.h>
#include "BkGnuPGDef.h"
#include "BkGnuPGInfo.h"
#include "LogFile.h"
using namespace std;

#include "debug.h" //Ōɒ`


/**** Internal Macro ****/


/**** Typedef ****/


/**** Prototyping ****/


/*----------------------------------------------------------------------*/
/* Purpose        : ObZ[W\                        */
/* Inputs         : Window nh                                     */
/*                  bZ[WID                                        */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void ErrorMessage(HWND hWnd, UINT uID)
{
    try {
        char szError[256];
        if((LoadString(g_Info.m_hInstance, uID, szError, 256))>0) {
            g_LogFile.AppendMessage(szError);
            MessageBox(hWnd, szError, "Message from BkGnuPG", MB_OK | MB_ICONWARNING);
            g_LogFile.AppendMessage(szError);
        }
    }
    catch(...) {
        FatalErrorMessage(hWnd, __FILE__, __LINE__); //G[eo
    }
}

/*----------------------------------------------------------------------*/
/* Purpose        : vIG[bZ[W\                    */
/* Inputs         : Ȃ                                                */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void FatalErrorMessage(HWND hWnd, const char* fileName, int lineno, const char* pMsg)
{
    try {
        DWORD errNo = GetLastError();
        string ferrMsg;
        if(pMsg==NULL) {
            LPVOID p;
            FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
                        NULL,
                        errNo,
                        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                        (LPTSTR)&p, 0, NULL);
            ferrMsg = (char*)p;
            LocalFree(p);
        }
        else {
            ferrMsg = pMsg;
        }
        char szError[256];
        if((LoadString(g_Info.m_hInstance, IDS_GPG_EXCEPTION, szError, 256))>0) {
            string errMsg = szError;
            errMsg += "\n\n\"" + ferrMsg;
            TrimSpace(errMsg);
            errMsg += "\" ";
            if(errNo) { //G[R[h0ȊO?
                MessageBox(hWnd, errMsg.c_str(), "Message from BkGnuPG", MB_OK | MB_ICONERROR);
            }
            string file = fileName;
            string::size_type idx = file.find_last_of("\\");
            if(idx!=string::npos) {
                errMsg += file.substr(idx+1);
            }
            else {
                errMsg += file;
            }
            g_LogFile.AppendValue(errMsg.c_str(), lineno); //lo͂
        }
    }
    catch(...) {
        return ; //ǂ悤Ȃ̂ŉȂ
    }
}

/*----------------------------------------------------------------------*/
/* Purpose        : t@CƂėp\ȖOɕϊ            */
/* Inputs         : Cӂ̖O                                          */
/*                  t@Ci[obt@                              */
/* Ootput         : t@C                                          */
/*                                                                      */
/*  BkCommon.cpp ̓֐STL                                */
/*----------------------------------------------------------------------*/
string& GetLegalFileName(const char* name, string& fileName)
{
    string namebuf = name;
    fileName = "";
    //Ő󔒕폜
    TrimSpace(namebuf);

    //ϊ
    string::size_type len = namebuf.length();
    if(len==0) { //󔒕Ȃ
        return fileName;
    }
    for(string::size_type i=0; i<len; i++) {
        unsigned char c = (unsigned char)namebuf[i];
        if ((_ismbblead(c))!=0) { //}`oCg1byte
            fileName += (char)c;
            i++;
            fileName += namebuf[i];
        }
        else if(c<' ' || c==0x7f) { //ASCIIȊO
            c = ' ';
            fileName += (char)c;
        }
        else {
            switch (c) {
            case '*':
            case '<':
            case '>':
            case '?':
            case '\\':
            case '|':
            case '/':
                c = '=';
                break;
            case ':':
                c = ';';
                break;
            case '\"':
                c = '\'';
                break;
            default:
                break;
            }
            fileName += (char)c;
        }
    }

    //Ő󔒕폜
    TrimSpace(fileName);

    //'.'΍폜
    len = fileName.length();
    if(len>0 && fileName[len-1]=='.') {
        fileName = fileName.substr(0, len-1);
    }

    return fileName;
}

/*----------------------------------------------------------------------*/
/* Purpose        : eLXgt@Ce𕶎ƂăɃ[h*/
/* Inputs         : t@Cւ̃pX                                  */
/* Ootput         : t@Ce()                                */
/*                                                                      */
/*  BkCommon.cpp ̓֐̕ʎB̊mۂ CBeckyAPI::Alloc  */
/*    gp̂Ŏ舵                                        */
/*----------------------------------------------------------------------*/
char* FileToString(const string& filepath)
{
    //t@CI[v
    HANDLE hFile = CreateFile(filepath.c_str(), GENERIC_READ, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if(hFile==INVALID_HANDLE_VALUE) {
        return NULL;
    }
    DWORD nSize = GetFileSize(hFile, NULL); //4GBȏ̃TCYɂ͑ΉȂ
    if(nSize==0) {
        CloseHandle(hFile);
        return NULL;
    }

    //t@CẽRs[
    char* strBuf = (char*)g_Info.m_BkApi.Alloc(nSize+4);
    if(strBuf!=NULL) {
        DWORD lSize;
        if((ReadFile(hFile, strBuf, nSize, &lSize, NULL))==FALSE) {
            g_Info.m_BkApi.Free(strBuf);
            strBuf = NULL;
        }
        else {
            strBuf[lSize] = '\0';
        }
    }

    //t@CN[Y
    CloseHandle(hFile);
    return strBuf;
}

/*----------------------------------------------------------------------*/
/* Purpose        : uname <email>v`̕vfɕ        */
/* Inputs         : ɂȂ镶                                      */
/*                  Oi[obt@                                    */
/*                  e-maili[obt@                                  */
/* Ootput         : Ȃ                                                */
/*                                                                      */
/*  BkCommon.cpp ̓֐STL                                */
/*----------------------------------------------------------------------*/
void GetNameAndAddr(const char* src, string& name, string& email)
{
    name = email = "";
    string srcStr = src;
    TrimSpace(srcStr); //Ő󔒂
    string::size_type len = srcStr.length();
    if(len==0) { //gȂ
        return;
    }

    // name <email> `Ō
    bool bQuote = false;
    string::size_type idx;
    for(idx=0; idx<len; idx++) {
        unsigned char c = (unsigned char)srcStr[idx];
        if ((_ismbblead(c))!=0) { //}`oCg1byte
            idx++;
        }
        else if(c=='\"') {
            bQuote = !bQuote;
        }
        else if(c=='<' && bQuote==false) {
            break;
        }
    }
    if(idx!=len) { //f~^o
        string sbuf = srcStr.substr(idx+1);
        string::size_type idx2 = sbuf.find_first_of('>');
        email = sbuf.substr(0, idx2);
        TrimSpace(email); //Ő󔒂
        if(idx>0) {
            name = srcStr.substr(0, idx);
            TrimSpace(name); //Ő󔒂
        }
        if((name.length())==0 && idx2!=string::npos) { // <email> name Ȃ
            idx2++;
            if((sbuf.length())<idx2) {
                name = sbuf.substr(idx2);
                TrimSpace(name); //Ő󔒂
            }
        }
        return;
    }
    else { // email (name) `ŒTĂ݂
        idx = srcStr.find_first_of('(');
        if(idx==string::npos) { //e-mail݂̂̋Lq?
            email = srcStr;
        }
        else {
            string sbuf = srcStr.substr(idx+1);
            string::size_type idx2 = sbuf.find_first_of(')');
            name = sbuf.substr(0, idx2);
            TrimSpace(name); //Ő󔒂
            if(idx>0) {
                email = srcStr.substr(0, idx);
                TrimSpace(email); //Ő󔒂
            }
            if((sbuf.length())==0 && idx2!=string::npos) { // (name) email Ȃ
                idx2++;
                if((sbuf.length())<idx2) {
                    email = sbuf.substr(idx2);
                    TrimSpace(email); //Ő󔒂
                }
            }
        }
    }

    return;
}

/*----------------------------------------------------------------------*/
/* Purpose        : t@C̗L₢킹                        */
/* Inputs         : t@C(tpX)                                */
/* Ootput         : Boolearn                                            */
/*                                                                      */
/*  BkCommon.cpp ̓֐STL                                */
/*----------------------------------------------------------------------*/
bool IsFileExist(const string& path)
{
    WIN32_FIND_DATA FindData;
    HANDLE hFind = ::FindFirstFile(path.c_str(), &FindData);
    if (hFind != INVALID_HANDLE_VALUE) {
        ::FindClose(hFind);
        if((FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)==0) { //fBNgłȂ
            return true;
        }
    }
    return false;
}

/*----------------------------------------------------------------------*/
/* Purpose        : t@C폜 (ChJ[hL)                   */
/* Inputs         : t@C(tpX)                                */
/* Ootput         : Ȃ                                                */
/*----------------------------------------------------------------------*/
void RemoveFiles(const string& path)
{
    string dpath;
    try {
        //fBNg擾
        string::size_type idx = path.find_last_of("\\");
        string dir = "";
        if(idx!=string::npos) {
            dir = path.substr(0, idx+1);
        }
        //t@Cƍ폜
        WIN32_FIND_DATA FindData;
        HANDLE hFind = ::FindFirstFile(path.c_str(), &FindData);
        if (hFind != INVALID_HANDLE_VALUE) {
            do {
                if((FindData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)==0) { //fBNgłȂ
                    dpath = dir + FindData.cFileName; //pX쐬
                    DeleteFile(dpath.c_str()); //폜!
#ifdef _DEBUG
                    g_LogFile.AppendValue("delete file", dpath);
#endif
                }
            } while((FindNextFile(hFind, &FindData))!=FALSE);
            ::FindClose(hFind);
        }
    }
    catch(...) {
        g_LogFile.AppendValue("cannot delete file", dpath);
    }
    return;
}

/*----------------------------------------------------------------------*/
/* Purpose        : Ő󔒕菜                            */
/* Inputs         : f[^                                        */
/* Ootput         : ̕f[^                                */
/*----------------------------------------------------------------------*/
string& TrimSpace(string& element)
{
    string::size_type idx = element.find_first_not_of(" \t\r\n");
    string str;
    if(idx!=string::npos) {
        element = str = element.substr(idx); //擪̋󔒕
    }
    else { //󔒕Ȃ(^^;)
        return element = "";
    }
    idx = str.find_last_not_of(" \t\r\n");
    if(idx!=string::npos) {
        element = str.substr(0, idx+1); //̋󔒕
    }

    return element;
}

/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
