/************************************************************************/
/*  File name : SetupDialog.h                                           */
/************************************************************************/
/*  Contents  : Setting _CAO                                      */
/*                                                                      */
/*  Auther    : Yasuhiro ARAKAWA    Version 0.00    2000.09.12          */
/*                                  Version 0.10    2000.09.27          */
/*                                  Version 0.20    2000.10.03          */
/*                                  Version 0.30    2000.10.06          */
/*                                  Version 0.40    2000.10.31          */
/*                                  Version 1.0.0   2000.11.08          */
/************************************************************************/
#ifndef _SETUPDIALOG_H_
#define _SETUPDIALOG_H_

/**** Incude Files ****/
#include <windows.h>
#include "BkGnuPGInfo.h"

#include <string>


/**** Global Macro ****/


/**** Typedef ****/


/**** External Declarelation ****/


/**** Prototyping ****/


/*----------------------------------------------------------------------*/
/* Class Name : CSetupDialog                                            */
/* Purpose    : Setting _CAONX                                */
/*----------------------------------------------------------------------*/
class CSetupDialog
{
// oCX^X
private:
    //萔`
    //ϐ(static)
    static CSetupDialog* m_Instance; //̃NX̃CX^X
    //ϐ
    std::string m_CmdPath;
    std::string m_DefUserID; //ftHg[UID
    bool m_bPGPMIME; //PGP/MIMEΉ
    bool m_bPGPCompatible; //PGP݊̏EÍs (m_bOpenPGP, m_ThrowKey ͖ɂȂ)
    bool m_bOpenPGP; //OpenPGPɏÍs (m_bPGPCompatible D)
    bool m_bThrowKeyID; //M҂𓽖ɂ (m_bPGPMIME==true ł͖)
    bool m_bRFC1991; //RFC1991ɏ] (m_bPGPCompatible==true ł̂ݗL)
    bool m_bMD5; //bZ[W_CWFXgMD5gp
    bool m_bEnableCcUser; //Í̌JIDCcAhX܂߂
    bool m_bEnableBccUser; //Í̌JIDBccAhX܂߂
    bool m_bEnableFromUser; //Í̌JIDFromAhX܂߂
    bool m_bEnableDefUser; //Í̌JIDɃftHg[U܂߂
public:
    //萔`

// o\bh
private:
    //CX^X̃Rs[点Ȃ߂̑[u
    CSetupDialog(const CSetupDialog& org); //Rs[RXgN^
    CSetupDialog& operator=(const CSetupDialog& org); //Zq
    //֐
public:
    //RXgN^EfXgN^
    CSetupDialog(); //ftHgRXgN^
    virtual ~CSetupDialog() {} //fXgN^
    //Zq
    //C^tF[X֐
    static CSetupDialog* GetInstatnce(void) { return m_Instance; } //݋ÑCX^XԂ
    bool ExecDialog(HWND hWnd, LPARAM lParam, CBkGnuPGInfo& info); //_CAŐN
    inline const char* GetCmdPath(void) { return m_CmdPath.c_str(); } //GnuPG W[ւ̃pX
    inline void SetCmdPath(const char* cmdPath) { m_CmdPath = cmdPath; }
    inline const char* GetDefUserID(void) { return m_DefUserID.c_str(); } //ftHg[UID
    inline void SetDefUserID(const char* defUserID) { m_DefUserID = defUserID; }
    inline bool IsPGPMIME(void) { return m_bPGPMIME; } //PGP/MIME Ή
    inline void SetOptPGPMIME(bool bPGPMIME) { m_bPGPMIME = bPGPMIME; }
    inline bool IsPGPCompatible(void) { return m_bPGPCompatible; } //PGP݊
    inline void SetOptPGPCompatible(bool bPGPCompatible) { m_bPGPCompatible = bPGPCompatible; }
    inline bool IsOpenPGP(void) { return m_bOpenPGP; } //OpenPGP݊
    inline void SetOptOpenPGP(bool bOpenPGP) { m_bOpenPGP = bOpenPGP; }
    inline bool IsThrowKeyID(void) { return m_bThrowKeyID; } //M҂𓽖ɂ
    inline void SetOptThrowKeyID(bool bThrowKeyID) { m_bThrowKeyID = bThrowKeyID; }
    inline bool IsRFC1991(void) const { return m_bRFC1991; }  //RFC1991ɏ]?
    inline void SetOptRFC1991(const bool bRFC1991) { m_bRFC1991 = bRFC1991; return; } //RFC1991ݒ
    inline bool IsMD5(void) const { return m_bMD5; }  //bZ[W_CWFXgMD5gp
    inline void SetOptMD5(const bool bMD5) { m_bMD5 = bMD5; return; } //MD5ݒ
    inline bool IsEnableCcUser(void) { return m_bEnableCcUser; } //Í̌JIDCcAhX܂߂
    inline void SetOptEnableCcUser(bool bEnableCcUser) { m_bEnableCcUser = bEnableCcUser; }
    inline bool IsEnableBccUser(void) { return m_bEnableBccUser; } //Í̌JIDBccAhX܂߂
    inline void SetOptEnableBccUser(bool bEnableBccUser) { m_bEnableBccUser = bEnableBccUser; }
    inline bool IsEnableFromUser(void) { return m_bEnableFromUser; } //Í̌JIDFromAhX܂߂
    inline void SetOptEnableFromUser(bool bEnableFromUser) { m_bEnableFromUser = bEnableFromUser; }
    inline bool IsEnableDefUser(void) { return m_bEnableDefUser; } //Í̌JIDɃftHg[U܂߂
    inline void SetOptEnableDefUser(bool bEnableDefUser) { m_bEnableDefUser = bEnableDefUser; }
};


#endif // _SETUPDIALOG_H_
/* Copyright (C) Yasuhiro ARAKAWA  **************************************/
