//---------------------------------------------------------------------------
//
// Ruby/Becky!  Becky! API ANZXCuwb_
//
// Copyright(c) 2000,2001 T.Shimomura/netlife.gr.jp , All rights reserved.
// $Id: BeckyLib.cpp,v 1.19 2002/01/29 15:49:49 redbug Exp $
//

//---------------------------------------------------------------------------
#include <windows.h>					// Windows SDK

#include <vcl.h>						// Borland's Visual Component Library

#define USE_WIN32_DYNAMIC_LINK
#include "ruby/ruby.h"					// Ruby API

#include "b2pinsdk/BeckyAPI.h"			// Becky! Plug-in SDK
#include "b2pinsdk/BkCommon.h"			// Becky! Plug-in SDK

#pragma hdrstop

#include "BeckyLib.h"
#include "RubyItpr.h"
#include "Edit.h"
#include "Manager.h"
#include "version.h"

#include "extern.h"


//---------------------------------------------------------------------------

LRESULT BeckyLib_SendMessage( HWND hWnd, WPARAM wParam, LPARAM lParam );

void BeckyAPI_Method( VALUE module );
VALUE BeckyAPI_MtGetVersion( VALUE self );
VALUE BeckyAPI_MtCommand( VALUE self , VALUE cmd );
VALUE BeckyAPI_MtGetWindowHandles( VALUE self );
// RegisterCommand
// RegisterUICallback
VALUE BeckyAPI_MtGetDataFolder( VALUE self );
VALUE BeckyAPI_MtGetTempFolder( VALUE self );
VALUE BeckyAPI_MtGetTempFileName( VALUE self, VALUE type );
VALUE BeckyAPI_MtSetMessageText( VALUE self, VALUE msg );
VALUE BeckyAPI_MtConnect( VALUE self, VALUE bConnect );
VALUE BeckyAPI_MtGetCurrentMailBox( VALUE self );
VALUE BeckyAPI_MtSetCurrentMailBox( VALUE self, VALUE mbx );
VALUE BeckyAPI_MtGetCurrentFolder( VALUE self );
VALUE BeckyAPI_MtSetCurrentFolder( VALUE self, VALUE folder );
VALUE BeckyAPI_MtGetFolderDisplayName( VALUE self, VALUE folder );
VALUE BeckyAPI_MtGetCurrentMail( VALUE self );
VALUE BeckyAPI_MtSetCurrentMail( VALUE self, VALUE mail );
VALUE BeckyAPI_MtGetNextMail( VALUE self, VALUE nStart, VALUE bSelected );
VALUE BeckyAPI_MtSetSel( VALUE self, VALUE mail, VALUE bSel );
VALUE BeckyAPI_MtAppendMessage( VALUE self, VALUE folder, VALUE msg );
VALUE BeckyAPI_MtMoveSelectedMessages( VALUE self, VALUE folder, VALUE bCopy );
VALUE BeckyAPI_MtGetStatus( VALUE self, VALUE mail );
VALUE BeckyAPI_MtSetStatus( VALUE self, VALUE mail, VALUE dwSet, VALUE dwReset );
VALUE BeckyAPI_MtGetCharSet( VALUE self, VALUE mail );
VALUE BeckyAPI_MtGetSource( VALUE self, VALUE mail );
VALUE BeckyAPI_MtSetSource( VALUE self, VALUE mail, VALUE src );
VALUE BeckyAPI_MtGetHeader( VALUE self, VALUE mail );
VALUE BeckyAPI_MtGetSpecifiedHeader( VALUE self, VALUE header );
VALUE BeckyAPI_MtSetSpecifiedHeader( VALUE self, VALUE header, VALUE data );
VALUE BeckyAPI_MtGetText( VALUE self );
VALUE BeckyAPI_MtSetText( VALUE self, VALUE nMode, VALUE text );
// Alloc
// ReAlloc
// Free
VALUE BeckyAPI_MtISO_2022_JP( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtISO_2022_KR( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtHZ_GB2312( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtISO_8859_2( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtEUC_JP( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtUTF_7( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtUTF_8( VALUE self, VALUE src, VALUE bEncode );
VALUE BeckyAPI_MtB64Convert( VALUE self, VALUE destfile, VALUE srcfile, VALUE bEncode );
VALUE BeckyAPI_MtQPConvert( VALUE self, VALUE destfile, VALUE srcfile, VALUE bEncode );
VALUE BeckyAPI_MtMIMEHeaderEncode( VALUE self, VALUE in, VALUE charset );
VALUE BeckyAPI_MtMIMEHeaderDecode( VALUE self, VALUE in );
VALUE BeckyAPI_MtSerializeRcpts( VALUE self, VALUE lpaddress );
VALUE BeckyAPI_MtRegisterObject( VALUE self, VALUE obj_name );
VALUE BeckyAPI_MtCheckObject( VALUE self, VALUE obj_name );
VALUE BeckyAPI_MtRemoveObject( VALUE self, VALUE obj_name );

VALUE BeckyAPI_MtEject( VALUE self );
VALUE BeckyAPI_MtGetObject( VALUE self );


void BkComposeAPI_Method( VALUE klass );
VALUE BkComposeAPI_MtSetWindowHandle( VALUE self , VALUE window );
VALUE BkComposeAPI_MtComposeMail( VALUE self , VALUE url );
VALUE BkComposeAPI_MtCommand( VALUE self , VALUE cmd );
VALUE BkComposeAPI_MtGetCharSet( VALUE self );
VALUE BkComposeAPI_MtGetSource( VALUE self );
VALUE BkComposeAPI_MtSetSource( VALUE self, VALUE src );
VALUE BkComposeAPI_MtGetHeader( VALUE self );
VALUE BkComposeAPI_MtGetSpecifiedHeader( VALUE self, VALUE header );
VALUE BkComposeAPI_MtSetSpecifiedHeader( VALUE self, VALUE header, VALUE data );
VALUE BkComposeAPI_MtGetText( VALUE self );
VALUE BkComposeAPI_MtSetText( VALUE self, VALUE nMode, VALUE text );
VALUE BkComposeAPI_MtAttachFile( VALUE self, VALUE file, VALUE mimetype );
VALUE BkComposeAPI_MtSetMessageText( VALUE self, VALUE msg );

void RubyBecky_Method( VALUE module );
VALUE RubyBecky_MtVersion( VALUE self );
VALUE RubyBecky_MtSetDebugLevel( VALUE self, VALUE level );
VALUE RubyBecky_MtGetDebugLevel( VALUE self );


extern UINT RubyBeckyMsg_APICall;


VALUE CallBackObject[ CALLBACKOBJECT_MAX ];


LRESULT BeckyLib_SendMessage( HWND hWnd, WPARAM wParam, LPARAM lParam )
{
	LRESULT ret;

//	if ( ruby->GetStatus() == ITPR_STS_CALLBACK ) {
//		;
//	}
//	else {
		ret = SendMessage( hWnd, RubyBeckyMsg_APICall, wParam, lParam );
//	}

	return ret;
}

// Becky ֘ÅgNXAW[Ȃǂ Ruby ɓo^
void BeckyLib_initialize( void )
{
	// BeckyAPI W[o^
	{
		VALUE module;

		module = rb_define_module( "BeckyAPI" );
		// BeckyAPI W[̃\bh`
		BeckyAPI_Method( module );
	}

	// BkComposeAPI NXo^
	{
		VALUE klass;

		klass = rb_define_class( "BkComposeAPI" , NULL );
		// BkComposeAPI NX̃\bh`
		BkComposeAPI_Method( klass );
	}

	// RubyBecky W[o^
	{
		VALUE module;

		module = rb_define_module( "RubyBecky" );
		// BeckyAPI W[̃\bh`
		RubyBecky_Method( module );
	}


}


void BeckyAPI_Method( VALUE module )
{
	rb_define_module_function( module , "GetVersion" , (unsigned long(*)())BeckyAPI_MtGetVersion , 0 );
	rb_define_module_function( module , "Command" , (unsigned long(*)())BeckyAPI_MtCommand , 1 );
	rb_define_module_function( module , "GetWindowHandles" , (unsigned long(*)())BeckyAPI_MtGetWindowHandles , 0 );
	rb_define_module_function( module , "GetDataFolder" , (unsigned long(*)())BeckyAPI_MtGetDataFolder , 0 );
	rb_define_module_function( module , "GetTempFolder" , (unsigned long(*)())BeckyAPI_MtGetTempFolder , 0 );
	rb_define_module_function( module , "GetTempFileName" , (unsigned long(*)())BeckyAPI_MtGetTempFileName , 1 );
	rb_define_module_function( module , "SetMessageText" , (unsigned long(*)())BeckyAPI_MtSetMessageText , 1 );
	rb_define_module_function( module , "Connect" , (unsigned long(*)())BeckyAPI_MtConnect , 1 );
	rb_define_module_function( module , "GetCurrentMailBox" , (unsigned long(*)())BeckyAPI_MtGetCurrentMailBox , 0 );
	rb_define_module_function( module , "SetCurrentMailBox" , (unsigned long(*)())BeckyAPI_MtSetCurrentMailBox , 1 );
	rb_define_module_function( module , "GetCurrentFolder" , (unsigned long(*)())BeckyAPI_MtGetCurrentFolder , 0 );
	rb_define_module_function( module , "SetCurrentFolder" , (unsigned long(*)())BeckyAPI_MtSetCurrentFolder , 1 );
	rb_define_module_function( module , "GetFolderDisplayName" , (unsigned long(*)())BeckyAPI_MtGetFolderDisplayName , 1 );
	rb_define_module_function( module , "GetCurrentMail" , (unsigned long(*)())BeckyAPI_MtGetCurrentMail , 0 );
	rb_define_module_function( module , "SetCurrentMail" , (unsigned long(*)())BeckyAPI_MtSetCurrentMail , 1 );
	rb_define_module_function( module , "GetNextMail" , (unsigned long(*)())BeckyAPI_MtGetNextMail , 2 );
	rb_define_module_function( module , "SetSel" , (unsigned long(*)())BeckyAPI_MtSetSel , 2 );
	rb_define_module_function( module , "AppendMessage" , (unsigned long(*)())BeckyAPI_MtAppendMessage , 2 );
	rb_define_module_function( module , "MoveSelectedMessages" , (unsigned long(*)())BeckyAPI_MtMoveSelectedMessages , 2 );
	rb_define_module_function( module , "GetStatus" , (unsigned long(*)())BeckyAPI_MtGetStatus , 1 );
	rb_define_module_function( module , "SetStatus" , (unsigned long(*)())BeckyAPI_MtSetStatus , 3 );
	rb_define_module_function( module , "GetCharSet" , (unsigned long(*)())BeckyAPI_MtGetCharSet , 1 );
	rb_define_module_function( module , "GetSource" , (unsigned long(*)())BeckyAPI_MtGetSource , 1 );
	rb_define_module_function( module , "SetSource" , (unsigned long(*)())BeckyAPI_MtSetSource , 2 );
	rb_define_module_function( module , "GetHeader" , (unsigned long(*)())BeckyAPI_MtGetHeader , 1 );
	rb_define_module_function( module , "GetSpecifiedHeader" , (unsigned long(*)())BeckyAPI_MtGetSpecifiedHeader , 1 );
	rb_define_module_function( module , "SetSpecifiedHeader" , (unsigned long(*)())BeckyAPI_MtSetSpecifiedHeader , 2 );
	rb_define_module_function( module , "GetText" , (unsigned long(*)())BeckyAPI_MtGetText , 0 );
	rb_define_module_function( module , "SetText" , (unsigned long(*)())BeckyAPI_MtSetText , 2 );

	rb_define_module_function( module , "ISO_2022_JP" , (unsigned long(*)())BeckyAPI_MtISO_2022_JP , 2 );
	rb_define_module_function( module , "ISO_2022_KR" , (unsigned long(*)())BeckyAPI_MtISO_2022_KR , 2 );
	rb_define_module_function( module , "HZ_GB2312" , (unsigned long(*)())BeckyAPI_MtHZ_GB2312 , 2 );
	rb_define_module_function( module , "ISO_8859_2" , (unsigned long(*)())BeckyAPI_MtISO_8859_2 , 2 );
	rb_define_module_function( module , "EUC_JP" , (unsigned long(*)())BeckyAPI_MtEUC_JP , 2 );
	rb_define_module_function( module , "UTF_7" , (unsigned long(*)())BeckyAPI_MtUTF_7 , 2 );
	rb_define_module_function( module , "UTF_8" , (unsigned long(*)())BeckyAPI_MtUTF_8 , 2 );
	rb_define_module_function( module , "B64Convert" , (unsigned long(*)())BeckyAPI_MtB64Convert , 3 );
	rb_define_module_function( module , "QPConvert" , (unsigned long(*)())BeckyAPI_MtQPConvert , 3 );
	rb_define_module_function( module , "MIMEHeaderEncode" , (unsigned long(*)())BeckyAPI_MtMIMEHeaderEncode, 2 );
	rb_define_module_function( module , "MIMEHeaderDecode" , (unsigned long(*)())BeckyAPI_MtMIMEHeaderDecode, 1 );
	rb_define_module_function( module , "SerializeRcpts" , (unsigned long(*)())BeckyAPI_MtSerializeRcpts, 1 );

	rb_define_module_function( module , "RegisterObject" , (unsigned long(*)())BeckyAPI_MtRegisterObject, 1 );
	rb_define_module_function( module , "CheckObject" , (unsigned long(*)())BeckyAPI_MtCheckObject, 1 );
	rb_define_module_function( module , "RemoveObject" , (unsigned long(*)())BeckyAPI_MtRemoveObject, 1 );

	rb_define_module_function( module , "Eject" , (unsigned long(*)())BeckyAPI_MtEject, 0 );
	rb_define_module_function( module , "GetObject" , (unsigned long(*)())BeckyAPI_MtGetObject, 0 );
}

// BeckyAPI.GetVersion()
VALUE BeckyAPI_MtGetVersion( VALUE self )
{
	BeckyAPI_GetVersion_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETVERSION, (unsigned int)&param );
	ret = rb_str_new2( param.str );

	return( ret );
}

// BeckyAPI.Command( cmd )
VALUE BeckyAPI_MtCommand( VALUE self , VALUE cmd )
{
	BeckyAPI_Command_t param;

	if ( TYPE(cmd) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.command = RSTRING(cmd)->ptr;
		BeckyLib_SendMessage( hMainWnd, BECKYAPI_COMMAND, (unsigned int)&param );
	}

	return( Qnil );
}

// BeckyAPI.GetWindowHandles()
VALUE BeckyAPI_MtGetWindowHandles( VALUE self )
{
	BeckyAPI_GetWindowHandle_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETWINDOWHANDLE, (unsigned int)&param );
	ret = rb_ary_new();
	rb_ary_push( ret , INT2FIX( param.hWnds[0] ) );
	rb_ary_push( ret , INT2FIX( param.hWnds[1] ) );
	rb_ary_push( ret , INT2FIX( param.hWnds[2] ) );
	rb_ary_push( ret , INT2FIX( param.hWnds[3] ) );

	return( ret );
}

// BeckyAPI.GetDataFolder()
VALUE BeckyAPI_MtGetDataFolder( VALUE self )
{
	BeckyAPI_GetDataFolder_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETDATAFOLDER, (unsigned int)&param );
	ret = rb_str_new2( param.str );

	return( ret );
}

// BeckyAPI.GetTempFolder()
VALUE BeckyAPI_MtGetTempFolder( VALUE self )
{
	BeckyAPI_GetTempFolder_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETTEMPFOLDER, (unsigned int)&param );
	ret = rb_str_new2( param.str );

	return( ret );
}

// BeckyAPI.GetTempFileName( type )
VALUE BeckyAPI_MtGetTempFileName( VALUE self, VALUE type )
{
	BeckyAPI_GetTempFileName_t param;
	VALUE ret;

	if ( TYPE(type) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.type = RSTRING(type)->ptr;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETTEMPFILENAME, (unsigned int)&param );
	ret = rb_str_new2( param.str );

	return( ret );
}

// BeckyAPI.SetMessageText( msg )
VALUE BeckyAPI_MtSetMessageText( VALUE self, VALUE msg )
{
	BeckyAPI_SetMessageText_t param;
	VALUE ret;

	if ( TYPE(msg) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.msg = RSTRING(msg)->ptr;
		param.hWnd = hMainWnd;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETMESSAGETEXT, (unsigned int)&param );

	return( Qnil );
}

// BeckyAPI.Connect()
VALUE BeckyAPI_MtConnect( VALUE self, VALUE bConnect )
{
	BeckyAPI_Connect_t param;

	if ( bConnect == Qtrue ) {
		param.bConnect = TRUE;
	}
	else {
		param.bConnect = FALSE;
	}
	BeckyLib_SendMessage( hMainWnd, BECKYAPI_CONNECT, (unsigned int)&param );
	if ( param.result ) {
		return Qtrue;
	}
	return Qfalse;
}

// BeckyAPI.GetCurrentMailBox()
VALUE BeckyAPI_MtGetCurrentMailBox( VALUE self )
{
	BeckyAPI_GetCurrentMailBox_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETCURRENTMAILBOX, (unsigned int)&param );
	ret = rb_str_new2( param.mbx );

	return ret;
}

// BeckyAPI.SetCurrentMailBox( mbx )
VALUE BeckyAPI_MtSetCurrentMailBox( VALUE self, VALUE mbx )
{
	BeckyAPI_SetCurrentMailBox_t param;

	if ( TYPE(mbx) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.mbx = RSTRING(mbx)->ptr;
	}
	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETCURRENTMAILBOX, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.GetCurrentFolder()
VALUE BeckyAPI_MtGetCurrentFolder( VALUE self )
{
	BeckyAPI_GetCurrentFolder_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETCURRENTFOLDER, (unsigned int)&param );
	ret = rb_str_new2( param.folder );

	return ret;
}

// BeckyAPI.SetCurrentFolder( folder )
VALUE BeckyAPI_MtSetCurrentFolder( VALUE self, VALUE folder )
{
	BeckyAPI_SetCurrentFolder_t param;

	if ( TYPE(folder) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.folder = RSTRING(folder)->ptr;
	}
	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETCURRENTFOLDER, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.GetFolderDisplayName( folder )
VALUE BeckyAPI_MtGetFolderDisplayName( VALUE self, VALUE folder )
{
	BeckyAPI_GetFolderDisplayName_t param;
	VALUE ret;

	if ( TYPE(folder) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.folder = RSTRING(folder)->ptr;
	}
	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETFOLDERDISPLAYNAME, (unsigned int)&param );
	ret = rb_str_new2( param.name );

	return ret;
}

// BeckyAPI.GetCurrentMail()
VALUE BeckyAPI_MtGetCurrentMail( VALUE self )
{
	BeckyAPI_GetCurrentMail_t param;
	VALUE ret;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETCURRENTMAIL, (unsigned int)&param );
	ret = rb_str_new2( param.mail );

	return ret;
}

// BeckyAPI.SetCurrentMail( mail )
VALUE BeckyAPI_MtSetCurrentMail( VALUE self, VALUE mail )
{
	BeckyAPI_SetCurrentMail_t param;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.mail = RSTRING(mail)->ptr;
	}
	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETCURRENTMAIL, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.GetNextMail( nStart, mail, nBuf, bSelected )
VALUE BeckyAPI_MtGetNextMail( VALUE self, VALUE nStart, VALUE bSelected )
{
	BeckyAPI_GetNextMail_t param;
	VALUE ret;

	if ( TYPE(nStart) != T_FIXNUM ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bSelected) != T_TRUE && TYPE(bSelected) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.nStart = FIX2LONG(nStart);
	param.nBuf = sizeof(char)*1024;
	if ( bSelected == Qtrue ) {
		param.bSelected = TRUE;
	}
	else {
		param.bSelected = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETNEXTMAIL, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_str_new2( param.mailid ) );
	rb_ary_push( ret , rb_int2inum( param.pos ) );

	return ret;
}

// BeckyAPI.SetSel( mail, select )
VALUE BeckyAPI_MtSetSel( VALUE self, VALUE mail, VALUE bSel )
{
	BeckyAPI_SetSel_t param;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bSel) != T_TRUE && TYPE(bSel) != T_FALSE ) {
		rb_eval_string( "raise" );
	}
	param.mail = RSTRING(mail)->ptr;
	if ( bSel == Qtrue ) {
		param.bSel = TRUE;
	}
	else {
		param.bSel = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETSEL, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.AppendMessage( folder, msg )
VALUE BeckyAPI_MtAppendMessage( VALUE self, VALUE folder, VALUE msg )
{
	BeckyAPI_AppendMessage_t param;

	if ( TYPE(folder) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(msg) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	param.folder = RSTRING(folder)->ptr;
	param.msg = RSTRING(msg)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_APPENDMESSAGE, (unsigned int)&param );

	if ( param.result == TRUE ) {
		return Qtrue;
	}
	return Qfalse;
}

// BeckyAPI.MoveSelectedMessages( folder, bool_copy )
VALUE BeckyAPI_MtMoveSelectedMessages( VALUE self, VALUE folder, VALUE bCopy )
{
	BeckyAPI_MoveSelectedMessages_t param;

	if ( TYPE(folder) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bCopy) != T_TRUE && TYPE(bCopy) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.folder = RSTRING(folder)->ptr;
	if ( bCopy == Qtrue ) {
		param.bCopy = TRUE;
	}
	else {
		param.bCopy = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_MOVESELECTEDMESSAGES, (unsigned int)&param );

	if ( param.result == TRUE ) {
		return Qtrue;
	}
	return Qfalse;
}

// BeckyAPI.GetStatus( mail )
VALUE BeckyAPI_MtGetStatus( VALUE self, VALUE mail )
{
	BeckyAPI_GetStatus_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETSTATUS, (unsigned int)&param );
	ret = rb_int2inum(param.status);

	return ret;
}

// BeckyAPI.SetStatus( mail, set, reset )
VALUE BeckyAPI_MtSetStatus( VALUE self, VALUE mail, VALUE dwSet, VALUE dwReset )
{
	BeckyAPI_SetStatus_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;
	param.dwSet = FIX2LONG(dwSet);
	param.dwReset = FIX2LONG(dwReset);

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETSTATUS, (unsigned int)&param );
	ret = rb_int2inum(param.status);

	return ret;
}

// BeckyAPI.GetCharSet( mail )
VALUE BeckyAPI_MtGetCharSet( VALUE self, VALUE mail )
{
	BeckyAPI_GetCharSet_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;
	param.nBuf = sizeof(char)*1024;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETCHARSET, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_int2inum( param.code ) );
	rb_ary_push( ret , rb_str_new2( param.charset ) );

	return ret;
}

// BeckyAPI.GetSource( mail )
VALUE BeckyAPI_MtGetSource( VALUE self, VALUE mail )
{
	BeckyAPI_GetSource_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETSOURCE, (unsigned int)&param );

	ret = rb_str_new2( param.src );

	return ret;
}

// BeckyAPI.SetSource( mail )
VALUE BeckyAPI_MtSetSource( VALUE self, VALUE mail, VALUE src )
{
	BeckyAPI_SetSource_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;
	param.src = RSTRING(src)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETSOURCE, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.GetHeader( mail )
VALUE BeckyAPI_MtGetHeader( VALUE self, VALUE mail )
{
	BeckyAPI_GetHeader_t param;
	VALUE ret;

	if ( TYPE(mail) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.mail = RSTRING(mail)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETHEADER, (unsigned int)&param );

	ret = rb_str_new2( param.header );

	return ret;
}

// BeckyAPI.GetSpecifiedHeader( header )
VALUE BeckyAPI_MtGetSpecifiedHeader( VALUE self, VALUE header )
{
	BeckyAPI_GetSpecifiedHeader_t param;
	VALUE ret;

	if ( TYPE(header) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.header = RSTRING(header)->ptr;
	param.nBuf = sizeof(char)*4096;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETSPECIFIEDHEADER, (unsigned int)&param );

	ret = rb_str_new2( param.data );

	return ret;
}

// BeckyAPI.SetSpecifiedHeader( header, data )
VALUE BeckyAPI_MtSetSpecifiedHeader( VALUE self, VALUE header, VALUE data )
{
	BeckyAPI_SetSpecifiedHeader_t param;

	if ( TYPE(header) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(data) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.header = RSTRING(header)->ptr;
	param.data = RSTRING(data)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETSPECIFIEDHEADER, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.GetText()
VALUE BeckyAPI_MtGetText( VALUE self )
{
	BeckyAPI_GetText_t param;
	VALUE ret;

	param.nBuf = sizeof(char)*1024;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_GETTEXT, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_str_new2( param.text ) );
	rb_ary_push( ret , rb_str_new2( param.mimetype ) );

	return ret;
}

// BeckyAPI.SetText()
VALUE BeckyAPI_MtSetText( VALUE self, VALUE nMode, VALUE text )
{
	BeckyAPI_SetText_t param;

	if ( TYPE(nMode) != T_FIXNUM ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(text) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	param.nMode = FIX2LONG(nMode);
	param.text = RSTRING(text)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SETTEXT, (unsigned int)&param );

	return Qnil;
}

// BeckyAPI.ISO_2022_JP( src, bEncode )
VALUE BeckyAPI_MtISO_2022_JP( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_ISO_2022_JP, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.ISO_2022_KR( src, bEncode )
VALUE BeckyAPI_MtISO_2022_KR( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_ISO_2022_KR, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.HZ_GB2312( src, bEncode )
VALUE BeckyAPI_MtHZ_GB2312( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_HZ_GB2312, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.ISO_8859_2( src, bEncode )
VALUE BeckyAPI_MtISO_8859_2( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_ISO_8859_2, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.EUC_JP( src, bEncode )
VALUE BeckyAPI_MtEUC_JP( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_EUC_JP, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.UTF_7( src, bEncode )
VALUE BeckyAPI_MtUTF_7( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_UTF_7, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

// BeckyAPI.UTF_8( src, bEncode )
VALUE BeckyAPI_MtUTF_8( VALUE self, VALUE src, VALUE bEncode )
{
	BeckyAPI_ISO_2022_JP_t param;
	VALUE ret;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.src = RSTRING(src)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_UTF_8, (unsigned int)&param );

	ret = rb_str_new2( param.dest );

	return ret;
}

VALUE BeckyAPI_MtB64Convert( VALUE self, VALUE destfile, VALUE srcfile, VALUE bEncode )
{
	BeckyAPI_B64Convert_t param;
	VALUE ret;

	if ( TYPE(srcfile) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(destfile) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.srcfile = RSTRING(srcfile)->ptr;
	param.destfile = RSTRING(destfile)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_B64CONVERT, (unsigned int)&param );

	if ( param.result == TRUE ) {
		ret = Qtrue;
	}
	else {
		ret = Qfalse;
	}

	return ret;
}

VALUE BeckyAPI_MtQPConvert( VALUE self, VALUE destfile, VALUE srcfile, VALUE bEncode )
{
	BeckyAPI_B64Convert_t param;
	VALUE ret;

	if ( TYPE(srcfile) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(destfile) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(bEncode) != T_TRUE && TYPE(bEncode) != T_FALSE ) {
		rb_eval_string( "raise" );
	}

	param.srcfile = RSTRING(srcfile)->ptr;
	param.destfile = RSTRING(destfile)->ptr;
	if ( bEncode == Qtrue ) {
		param.bEncode = TRUE;
	}
	else {
		param.bEncode = FALSE;
	}

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_QPCONVERT, (unsigned int)&param );

	if ( param.result == TRUE ) {
		ret = Qtrue;
	}
	else {
		ret = Qfalse;
	}

	return ret;
}

VALUE BeckyAPI_MtMIMEHeaderEncode( VALUE self, VALUE in, VALUE charset )
{
	BeckyAPI_MIMEHeaderEncode_t param;
	VALUE ret;

	if ( TYPE(in) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(charset) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.in = RSTRING(in)->ptr;
	param.charset = RSTRING(charset)->ptr;
	param.bEncode = TRUE;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_MIMEHEADERENCODE, (unsigned int)&param );

	ret = rb_str_new2( param.out );

	return ret;
}

VALUE BeckyAPI_MtMIMEHeaderDecode( VALUE self, VALUE in )
{
	BeckyAPI_MIMEHeaderDecode_t param;
	VALUE ret;

	if ( TYPE(in) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.in = RSTRING(in)->ptr;
	param.nBuf = sizeof(char)*1024;
	param.bEncode = FALSE;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_MIMEHEADERDECODE, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_str_new2( param.out ) );
	rb_ary_push( ret , rb_str_new2( param.charset ) );

	return ret;
}

VALUE BeckyAPI_MtSerializeRcpts( VALUE self, VALUE lpaddress )
{
	BeckyAPI_SerializeRcpts_t param;
	VALUE ret;

	if ( TYPE(lpaddress) != T_STRING ) {
		rb_eval_string( "raise" );
	}

	param.lpaddress = RSTRING(lpaddress)->ptr;

	BeckyLib_SendMessage( hMainWnd, BECKYAPI_SERIALIZERCPTS, (unsigned int)&param );

	ret = rb_str_new2( param.out );

	return ret;
}

VALUE BeckyAPI_MtRegisterObject( VALUE self, VALUE obj_name )
{
	int i;

	if ( TYPE(obj_name) == T_OBJECT ) {
		for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
			if ( CallBackObject[i] == Qnil ) {
				CallBackObject[i] = obj_name;
				return Qtrue;
			}
		}
	}

	return Qfalse;
}

VALUE BeckyAPI_MtCheckObject( VALUE self, VALUE obj_name )
{
	int i;

	if ( TYPE(obj_name) == T_OBJECT ) {
		for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
			if ( CallBackObject[i] != Qnil ) {
				if ( RBASIC(CallBackObject[i])->klass == RBASIC(obj_name)->klass ) {
					return Qtrue;
				}
			}
		}
	}

	return Qfalse;
}

VALUE BeckyAPI_MtRemoveObject( VALUE self, VALUE obj_name )
{
	int i;

	if ( TYPE(obj_name) == T_OBJECT ) {
		for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
			if ( CallBackObject[i] != Qnil ) {
				if ( RBASIC(CallBackObject[i])->klass == RBASIC(obj_name)->klass ) {
					CallBackObject[i] = Qnil;
					return Qtrue;
				}
			}
		}
	}

	return Qfalse;
}

VALUE BeckyAPI_MtEject( VALUE self )
{
	EditForm->MediaPlayer1->DeviceType = dtCDAudio;
	EditForm->MediaPlayer1->Open();
	EditForm->MediaPlayer1->Eject();
	EditForm->MediaPlayer1->Close();

	return Qfalse;
}

VALUE BeckyAPI_MtGetObject( VALUE self )
{
	VALUE ret;
	int i;

	ret = rb_ary_new();

	for ( i=0; i != CALLBACKOBJECT_MAX; i++ ) {
		rb_ary_push( ret, CallBackObject[i] );
	}

	return ret;
}


void BkComposeAPI_Method( VALUE klass )
{
	rb_define_method( klass , "SetWindowHandle" , (unsigned long(*)())BkComposeAPI_MtSetWindowHandle , 1 );
	rb_define_method( klass , "ComposeMail" , (unsigned long(*)())BkComposeAPI_MtComposeMail , 1 );
	rb_define_method( klass , "Command" , (unsigned long(*)())BkComposeAPI_MtCommand , 1 );
	rb_define_method( klass , "GetCharSet" , (unsigned long(*)())BkComposeAPI_MtGetCharSet , 0 );
	rb_define_method( klass , "GetSource" , (unsigned long(*)())BkComposeAPI_MtGetSource , 0 );
	rb_define_method( klass , "SetSource" , (unsigned long(*)())BkComposeAPI_MtSetSource , 1 );
	rb_define_method( klass , "GetHeader" , (unsigned long(*)())BkComposeAPI_MtGetHeader , 0 );
	rb_define_method( klass , "GetSpecifiedHeader" , (unsigned long(*)())BkComposeAPI_MtGetSpecifiedHeader , 1 );
	rb_define_method( klass , "SetSpecifiedHeader" , (unsigned long(*)())BkComposeAPI_MtSetSpecifiedHeader , 2 );
	rb_define_method( klass , "GetText" , (unsigned long(*)())BkComposeAPI_MtGetText , 0 );
	rb_define_method( klass , "SetText" , (unsigned long(*)())BkComposeAPI_MtSetText , 2 );
	rb_define_method( klass , "AttachFile" , (unsigned long(*)())BkComposeAPI_MtAttachFile , 2 );
	rb_define_method( klass , "SetMessageText" , (unsigned long(*)())BkComposeAPI_MtSetMessageText , 1 );
}


VALUE BkComposeAPI_MtSetWindowHandle( VALUE self , VALUE window )
{
	rb_iv_set( self , "handle" , window );

	return( self );
}

VALUE BkComposeAPI_MtComposeMail( VALUE self , VALUE url )
{
	BkComposeAPI_ComposeMail_t param;
	HWND hWnd;

	if ( TYPE(url) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	param.url = RSTRING(url)->ptr;

	BeckyLib_SendMessage( hMainWnd, BKCOMPOSEAPI_COMPOSEMAIL, (unsigned int)&param );

	hWnd = param.hWnd;
	rb_iv_set( self , "handle" , rb_int2inum((int)hWnd) );

	return( rb_int2inum((int)hWnd) );
}

VALUE BkComposeAPI_MtCommand( VALUE self , VALUE cmd )
{
	BeckyAPI_Command_t param;
	HWND hWnd;

	if ( TYPE(cmd) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.command = RSTRING(cmd)->ptr;
		hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
		BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_COMMAND, (unsigned int)&param );
	}

	return( Qnil );
}

VALUE BkComposeAPI_MtGetCharSet( VALUE self )
{
	BkComposeAPI_GetCharSet_t param;
	HWND hWnd;
	VALUE ret;

	param.nBuf = sizeof(char)*1024;
	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_GETCHARSET, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_str_new2( param.charset ) );
	rb_ary_push( ret , rb_int2inum( param.code ) );
	return( ret );
}

VALUE BkComposeAPI_MtGetSource( VALUE self )
{
	BkComposeAPI_GetSource_t param;
	HWND hWnd;
	VALUE ret;

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_GETSOURCE, (unsigned int)&param );

	ret = rb_str_new2( param.src );
	return( ret );
}

VALUE BkComposeAPI_MtSetSource( VALUE self, VALUE src )
{
	BkComposeAPI_SetSource_t param;
	HWND hWnd;

	if ( TYPE(src) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	param.src = RSTRING(src)->ptr;
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_SETSOURCE, (unsigned int)&param );

	return( Qnil );
}

VALUE BkComposeAPI_MtGetHeader( VALUE self )
{
	BkComposeAPI_GetHeader_t param;
	HWND hWnd;
	VALUE ret;

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_GETHEADER, (unsigned int)&param );

	ret = rb_str_new2( param.header );
	return( ret );
}

VALUE BkComposeAPI_MtGetSpecifiedHeader( VALUE self, VALUE header )
{
	BkComposeAPI_GetSpecifiedHeader_t param;
	HWND hWnd;
	VALUE ret;

	if ( TYPE(header) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	param.header = RSTRING(header)->ptr;
	param.nBuf = sizeof(char)*4096;
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_GETSPECIFIEDHEADER, (unsigned int)&param );

	ret = rb_str_new2( param.data );
	return( ret );
}

VALUE BkComposeAPI_MtSetSpecifiedHeader( VALUE self, VALUE header, VALUE data )
{
	BkComposeAPI_SetSpecifiedHeader_t param;
	HWND hWnd;
	VALUE ret;

	if ( TYPE(header) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(data) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	param.header = RSTRING(header)->ptr;
	param.data = RSTRING(data)->ptr;
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_SETSPECIFIEDHEADER, (unsigned int)&param );

	return( Qnil );
}

// BkComposeAPI.GetText()
VALUE BkComposeAPI_MtGetText( VALUE self )
{
	BkComposeAPI_GetText_t param;
	HWND hWnd;
	VALUE ret;

	param.nBuf = sizeof(char)*1024;

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_GETTEXT, (unsigned int)&param );

	ret = rb_ary_new();
	rb_ary_push( ret , rb_str_new2( param.text ) );
	rb_ary_push( ret , rb_str_new2( param.mimetype ) );

	return ret;
}

// BkComposeAPI.SetText()
VALUE BkComposeAPI_MtSetText( VALUE self, VALUE nMode, VALUE text )
{
	BkComposeAPI_SetText_t param;
	HWND hWnd;

	if ( TYPE(nMode) != T_FIXNUM ) {
		rb_eval_string( "raise" );
	}
	if ( TYPE(text) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	param.nMode = FIX2LONG(nMode);
	param.text = RSTRING(text)->ptr;

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_SETTEXT, (unsigned int)&param );

	return Qnil;
}

// BkComposeAPI.SetText()
VALUE BkComposeAPI_MtAttachFile( VALUE self, VALUE file, VALUE mimetype )
{
	BkComposeAPI_AttachFile_t param;
	HWND hWnd;

	if ( TYPE(file) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	param.file = RSTRING(file)->ptr;

	if ( TYPE(mimetype) != T_STRING ) {
		if ( TYPE(mimetype) != T_NIL ) {
			rb_eval_string( "raise" );
		}
		param.mimetype = NULL;
	}
	else {
		param.mimetype = RSTRING(mimetype)->ptr;
	}

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BKCOMPOSEAPI_ATTACHFILE, (unsigned int)&param );

	return Qnil;
}

// BkComposeAPI.SetMessageText( msg )
VALUE BkComposeAPI_MtSetMessageText( VALUE self, VALUE msg )
{
	BeckyAPI_SetMessageText_t param;
	HWND hWnd;

	if ( TYPE(msg) != T_STRING ) {
		rb_eval_string( "raise" );
	}
	else {
		param.msg = RSTRING(msg)->ptr;
		param.hWnd = hMainWnd;
	}

	hWnd = (void *)NUM2INT(rb_iv_get( self , "handle" ));
	BeckyLib_SendMessage( hWnd, BECKYAPI_SETMESSAGETEXT, (unsigned int)&param );

	return( Qnil );
}

void RubyBecky_Method( VALUE module )
{
	rb_define_module_function( module , "version" , (unsigned long(*)())RubyBecky_MtVersion , 0 );
	rb_define_module_function( module , "debug_level=" , (unsigned long(*)())RubyBecky_MtSetDebugLevel , 1 );
	rb_define_module_function( module , "debug_level" , (unsigned long(*)())RubyBecky_MtGetDebugLevel , 0 );
}

VALUE RubyBecky_MtVersion( VALUE self )
{
	VALUE ret = Qnil;

// 1.0.0 ɂȂLɂ
#if 0
	ret = rb_str_new2( RUBYBECKY_VERSION );
#endif

	return ret;
}

VALUE RubyBecky_MtSetDebugLevel( VALUE self, VALUE level )
{
	Debug_Level = NUM2INT(level);
	return level;
}

VALUE RubyBecky_MtGetDebugLevel( VALUE self )
{
	VALUE ret;

	ret = rb_int2inum( Debug_Level );
	return ret;
}


#pragma package(smart_init)


