//---------------------------------------------------------------------------
//
// Ruby/Becky!  Becky! API ANZXCuwb_
//
// Copyright(c) 2000,2001 T.Shimomura/netlife.gr.jp , All rights reserved.
// $Id: BeckyLib.h,v 1.15 2002/01/15 17:55:55 redbug Exp $
//

//---------------------------------------------------------------------------

#ifndef BeckyLibH
#define BeckyLibH

#define BECKYAPI_START					0
#define BECKYAPI_GETVERSION				1
#define BECKYAPI_COMMAND				2
#define BECKYAPI_GETWINDOWHANDLE		3
#define BECKYAPI_GETDATAFOLDER			4
#define BECKYAPI_GETTEMPFOLDER			5
#define BECKYAPI_GETTEMPFILENAME		6
#define BECKYAPI_SETMESSAGETEXT			7
#define BECKYAPI_CONNECT				8
#define BECKYAPI_GETCURRENTMAILBOX		9
#define BECKYAPI_SETCURRENTMAILBOX		10
#define BECKYAPI_GETCURRENTFOLDER		11
#define BECKYAPI_SETCURRENTFOLDER		12
#define BECKYAPI_GETFOLDERDISPLAYNAME	13
#define BECKYAPI_GETCURRENTMAIL			14
#define BECKYAPI_SETCURRENTMAIL			15
#define BECKYAPI_GETNEXTMAIL			16
#define BECKYAPI_SETSEL					17
#define BECKYAPI_APPENDMESSAGE			18
#define BECKYAPI_MOVESELECTEDMESSAGES	19
#define BECKYAPI_GETSTATUS				20
#define BECKYAPI_SETSTATUS				21
#define BECKYAPI_GETCHARSET				22
#define BECKYAPI_GETSOURCE				23
#define BECKYAPI_SETSOURCE				24
#define BECKYAPI_GETHEADER				25
#define BECKYAPI_GETSPECIFIEDHEADER		26
#define BECKYAPI_SETSPECIFIEDHEADER		27
#define BECKYAPI_GETTEXT				28
#define BECKYAPI_SETTEXT				29

#define BECKYAPI_ISO_2022_JP			30
#define BECKYAPI_ISO_2022_KR			31
#define BECKYAPI_HZ_GB2312				32
#define BECKYAPI_ISO_8859_2				33
#define BECKYAPI_EUC_JP					34
#define BECKYAPI_UTF_7					35
#define BECKYAPI_UTF_8					36
#define BECKYAPI_B64CONVERT				37
#define BECKYAPI_QPCONVERT				38
#define BECKYAPI_MIMEHEADERENCODE		39
#define BECKYAPI_MIMEHEADERDECODE		40
#define BECKYAPI_SERIALIZERCPTS			41

#define BKCOMPOSEAPI_COMPOSEMAIL		42
#define BKCOMPOSEAPI_COMMAND			43
#define BKCOMPOSEAPI_GETCHARSET			44
#define BKCOMPOSEAPI_GETSOURCE			45
#define BKCOMPOSEAPI_SETSOURCE			46
#define BKCOMPOSEAPI_GETHEADER			47
#define BKCOMPOSEAPI_GETSPECIFIEDHEADER	48
#define BKCOMPOSEAPI_SETSPECIFIEDHEADER	49
#define BKCOMPOSEAPI_GETTEXT			50
#define BKCOMPOSEAPI_SETTEXT			51
#define BKCOMPOSEAPI_ATTACHFILE			52

#define BKCALLBACK_START				1
#define BKCALLBACK_EXIT					2
#define BKCALLBACK_OPENFOLDER			3
#define BKCALLBACK_OPENMAIL				4
#define BKCALLBACK_MINUTE				5
#define BKCALLBACK_COMPOSE				6
#define BKCALLBACK_OUTGOING				7
#define BKCALLBACK_KEYDISPATCH			8
#define BKCALLBACK_RETRIEVE				9
#define BKCALLBACK_SEND					10
#define BKCALLBACK_FINISHRETRIEVE		11



#define CALLBACKOBJECT_MAX				100

void BeckyLib_initialize( void );


typedef struct {
	const char *str;
	bool result;
} BeckyAPI_GetVersion_t;

typedef struct {
	char *command;
	bool result;
} BeckyAPI_Command_t;

typedef struct {
	HWND hWnds[4];
	bool result;
} BeckyAPI_GetWindowHandle_t;

typedef struct {
	const char *str;
	bool result;
} BeckyAPI_GetDataFolder_t;

typedef struct {
	const char *str;
	bool result;
} BeckyAPI_GetTempFolder_t;

typedef struct {
	const char *str;
	char *type;
	bool result;
} BeckyAPI_GetTempFileName_t;

typedef struct {
	const char *msg;
	HWND hWnd;
	bool result;
} BeckyAPI_SetMessageText_t;

typedef struct {
	bool bConnect;
	bool result;
} BeckyAPI_Connect_t;

typedef struct {
	const char *mbx;
	bool result;
} BeckyAPI_GetCurrentMailBox_t;

typedef struct {
	char *mbx;
	bool result;
} BeckyAPI_SetCurrentMailBox_t;

typedef struct {
	const char *folder;
	bool result;
} BeckyAPI_GetCurrentFolder_t;

typedef struct {
	char *folder;
	bool result;
} BeckyAPI_SetCurrentFolder_t;

typedef struct {
	const char *folder;
	const char *name;
	bool result;
} BeckyAPI_GetFolderDisplayName_t;

typedef struct {
	const char *mail;
	bool result;
} BeckyAPI_GetCurrentMail_t;

typedef struct {
	char *mail;
	bool result;
} BeckyAPI_SetCurrentMail_t;

typedef struct {
	int nStart;
	char mailid[1024];
	int nBuf;
	bool bSelected;
	int pos;
	bool result;
} BeckyAPI_GetNextMail_t;

typedef struct {
	char *mail;
	bool bSel;
	bool result;
} BeckyAPI_SetSel_t;

typedef struct {
	char *folder;
	char *msg;
	bool result;
} BeckyAPI_AppendMessage_t;

typedef struct {
	char *folder;
	bool bCopy;
	bool result;
} BeckyAPI_MoveSelectedMessages_t;

typedef struct {
	char *mail;
	DWORD status;
	bool result;
} BeckyAPI_GetStatus_t;

typedef struct {
	char *mail;
	DWORD dwSet;
	DWORD dwReset;
	DWORD status;
	bool result;
} BeckyAPI_SetStatus_t;

typedef struct {
	char *mail;
	char charset[1024];
	int nBuf;
	int code;
	bool result;
} BeckyAPI_GetCharSet_t;

typedef struct {
	char *mail;
	char *src;
	bool result;
} BeckyAPI_GetSource_t;

typedef struct {
	char *mail;
	char *src;
	bool result;
} BeckyAPI_SetSource_t;

typedef struct {
	char *mail;
	char *header;
	bool result;
} BeckyAPI_GetHeader_t;

typedef struct {
	char *header;
	char data[4096];
	int nBuf;
	bool result;
} BeckyAPI_GetSpecifiedHeader_t;

typedef struct {
	char *header;
	char *data;
	bool result;
} BeckyAPI_SetSpecifiedHeader_t;

typedef struct {
	char mimetype[1024];
	int nBuf;
	char *text;
	bool result;
} BeckyAPI_GetText_t;

typedef struct {
	int nMode;
	char *text;
	bool result;
} BeckyAPI_SetText_t;

typedef struct {
	char *src;
	char *dest;
	bool bEncode;
	bool result;
} BeckyAPI_ISO_2022_JP_t;

typedef struct {
	char *srcfile;
	char *destfile;
	bool bEncode;
	bool result;
} BeckyAPI_B64Convert_t;

typedef struct {
	char *in;
	char *charset;
	bool bEncode;
	char *out;
	bool result;
} BeckyAPI_MIMEHeaderEncode_t;

typedef struct {
	char *in;
	char charset[1024];
	int nBuf;
	bool bEncode;
	char *out;
	bool result;
} BeckyAPI_MIMEHeaderDecode_t;

typedef struct {
	char *lpaddress;
	char *out;
	bool result;
} BeckyAPI_SerializeRcpts_t;

typedef struct {
	bool result;
} BeckyAPI_GetObject_t;


typedef struct {
	char *url;
	HWND hWnd;
	bool result;
} BkComposeAPI_ComposeMail_t;

typedef struct {
	char charset[1024];
	int nBuf;
	int code;
	bool result;
} BkComposeAPI_GetCharSet_t;

typedef struct {
	char *src;
	bool result;
} BkComposeAPI_GetSource_t;

typedef struct {
	char *src;
	bool result;
} BkComposeAPI_SetSource_t;

typedef struct {
	char *header;
	bool result;
} BkComposeAPI_GetHeader_t;

typedef struct {
	char *header;
	char data[4096];
	int nBuf;
	bool result;
} BkComposeAPI_GetSpecifiedHeader_t;

typedef struct {
	char *header;
	char *data;
	bool result;
} BkComposeAPI_SetSpecifiedHeader_t;

typedef struct {
	char mimetype[1024];
	int nBuf;
	char *text;
	bool result;
} BkComposeAPI_GetText_t;

typedef struct {
	int nMode;
	char *text;
	bool result;
} BkComposeAPI_SetText_t;

typedef struct {
	char *file;
	char *mimetype;
	bool result;
} BkComposeAPI_AttachFile_t;


typedef struct {
	HWND hWnd;
	int nMode;
} BkCallBack_Compose_t;

typedef struct {
	HWND hWnd;
	int nKey;
	int nShift;
} BkCallBack_Keydispatch_t;

//---------------------------------------------------------------------------
#endif

