//---------------------------------------------------------------------------
//
// Ruby/Becky!  XNvgҏWGfB^@\
//
// Copyright(c) 2000,2001 T.Shimomura/netlife.gr.jp , All rights reserved.
// $Id: Edit.cpp,v 1.22 2002/01/28 17:01:39 redbug Exp $
//

//---------------------------------------------------------------------------
#include <windows.h>					// Windows SDK

#include <vcl.h>						// Borland's Visual Component Library

#define USE_WIN32_DYNAMIC_LINK
#include "ruby/ruby.h"					// Ruby API

#include "b2pinsdk/BeckyAPI.h"			// Becky! Plug-in SDK
#include "b2pinsdk/BkCommon.h"			// Becky! Plug-in SDK

#pragma hdrstop

#include "RubyItpr.h"
#include "Edit.h"

#include "extern.h"


//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "EditorEx"
#pragma link "HEditor"
#pragma resource "*.dfm"
TEditForm *EditForm;



//---------------------------------------------------------------------------
// XNvgҏWEChE
__fastcall TEditForm::TEditForm(TComponent* Owner)
	: TForm(Owner)
{
	SaveDialog1->InitialDir = RubyBeckyIni.ScriptPath;
	OpenDialog1->InitialDir = SaveDialog1->InitialDir;

	FormCaption = "Ruby/Becky! Script Editor";
}


//---------------------------------------------------------------------------
// Wo̓EChEł̃L[
void __fastcall TEditForm::RichEdit2KeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if ( Shift.Contains(ssShift) || Shift.Contains(ssAlt) || Shift.Contains(ssCtrl) ) {
		return;
	}

	EditorEx1KeyDown( Sender, Key, Shift );
}


//---------------------------------------------------------------------------
// fobOEChEł̃L[
void __fastcall TEditForm::RichEdit3KeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	if ( Shift.Contains(ssShift) || Shift.Contains(ssAlt) || Shift.Contains(ssCtrl) ) {
		return;
	}

	switch ( Key ) {
		case VK_F1 :
			RichEdit3->Lines->Text = "";
			break;
		default :
			EditorEx1KeyDown( Sender, Key, Shift );
			break;
	}
}


//---------------------------------------------------------------------------
// XNvgGfB^ł̃L[
void __fastcall TEditForm::EditorEx1KeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
	// Alt p
	if ( Shift.Contains(ssAlt) ) {
		;
	}
	// Ctrl p
	else if ( Shift.Contains(ssCtrl) ) {
		switch ( Key ) {
			case 'C' :					// Ctrl+C : Copy
				EditorEx1->CopyToClipboard();
				break;
			case 'X' :					// Ctrl+X : Cut
				EditorEx1->CutToClipboard();
				break;
			case 'V' :					// Ctrl+V : Paste
				EditorEx1->PasteFromClipboard();
				break;
			case 'Y' :					// Ctrl+Y : Redo
				EditorEx1->Redo();
				break;
			case 'Z' :					// Ctrl+Z : Undo
				EditorEx1->Undo();
				break;
		}
	}
	// Shift p
	else if ( Shift.Contains(ssShift) ) {
		switch ( Key ) {
			case VK_F1 :				// Shift+F1 : new
				EditorEx1->Lines->Text = "";
				OpenDialog1->FileName = "";
				SaveDialog1->FileName = "";
				EditForm->Caption = FormCaption;
				EditorEx1->Modified = false;
				break;
			case VK_F2 :				// Shift+F2 : overwrite
				if ( SaveDialog1->FileName != "" ) {
					EditorEx1->Lines->SaveToFile( SaveDialog1->FileName );
					EditForm->Caption = FormCaption+" ["+OpenDialog1->FileName+"]";
					EditorEx1->Modified = false;
				}
				break;
			case VK_F4 :				// Shift+F4 : reload
				if ( OpenDialog1->FileName != "" ) {
					EditorEx1->Lines->LoadFromFile( OpenDialog1->FileName );
					EditForm->Caption = FormCaption+" ["+OpenDialog1->FileName+"]";
					EditorEx1->Modified = false;
				}
				break;
		}
	}
	// Alt,Ctrl,Shift ĂȂ
	else {
		switch ( Key ) {
			case VK_F1 :				// F1 : stdout clear
				RichEdit2->Lines->Text = "";
				break;
			case VK_F2 :				// F2 : save
				Application->Handle = EditForm->Handle;
				SaveDialog1->DefaultExt = "rb";
				if ( SaveDialog1->Execute() ) {
					EditorEx1->Lines->SaveToFile( SaveDialog1->FileName );
					EditForm->Caption = FormCaption+" ["+OpenDialog1->FileName+"]";
					EditorEx1->Modified = false;
				}
				break;
			case VK_F4 :				// F4 : load
				Application->Handle = EditForm->Handle;
				OpenDialog1->DefaultExt = "rb";
				if ( OpenDialog1->Execute() ) {
					EditorEx1->Lines->LoadFromFile( OpenDialog1->FileName );
					SaveDialog1->FileName = OpenDialog1->FileName;
					EditForm->Caption = FormCaption+" ["+OpenDialog1->FileName+"]";
					EditorEx1->Modified = false;
				}
				break;
			case VK_F5 :				// F5 : run
				if ( ruby->GetStatus() == ITPR_STS_NOTWORK ) {
					PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, NULL, NULL );
				}
				break;
		}
	}
}


//---------------------------------------------------------------------------
void __fastcall TEditForm::EditorEx1Change(TObject *Sender)
{
	if ( EditorEx1->Modified ) {
		EditForm->Caption = FormCaption+" ["+OpenDialog1->FileName+"*]";
	}
}

//---------------------------------------------------------------------------
// fobOpbZ[W̏o
void DEBUG_OUT( int level, char *msg, ... )
{
	static char buf[2048];

	// Oõ͕͕XbhĂ΂̂ŃNeBJZNVň͂
	logout_lock->Acquire();
	{
		int index = 0;
		va_list args;

		if ( (Debug_Level & 0x00ff) > 0 ) {
			va_start( args, msg );

			if ( level == DBG_WINDOWMSG ) {
				strcpy( &buf[0], "### " );
				index = 4;
			}
			else if ( level == DBG_BECKY_3 ) {
				strcpy( &buf[0], "\t" );
				index = 1;
			}
			else if ( level == DBG_RUBY_3 ) {
				strcpy( &buf[0], "\t\t\t\t\t\t\t\t\t" );
				index = 9;
			}
			else if ( level == DBG_BECKY_0 ) {
				strcpy( &buf[0], "Err!! " );
				index = 6;
			}
			else if ( level == DBG_RUBY_0 ) {
				strcpy( &buf[0], "\t\t\t\t\t\t\t\tErr!! " );
				index = 14;
			}
			else if ( level >= DBG_RUBY ) {
				strcpy( &buf[0], "\t\t\t\t\t\t\t\t" );
				index = 8;
			}
			vsprintf( &buf[index], msg, args );

			if ( log_fp && (Debug_Level & DBG_FILE) ) {
				fprintf( log_fp, buf );
				fprintf( log_fp, "\n" );
				fflush( log_fp );
			}
		}
	}
	logout_lock->Release();
/*
	if ( EditForm ) {
		EditForm->RichEdit3->Lines->Add( buf );
	}
*/
}
