//---------------------------------------------------------------------------
//
// Ruby/Becky!  DLL Main
//
// Copyright(c) 2000,2001 T.Shimomura/netlife.gr.jp , All rights reserved.
// $Id: RubyBecky.cpp,v 1.34 2002/01/29 15:49:23 redbug Exp $
//

//---------------------------------------------------------------------------
// Include
#include <windows.h>					// Windows SDK

#include <vcl.h>						// Borland's Visual Component Library

#define USE_WIN32_DYNAMIC_LINK
#include "ruby/ruby.h"					// Ruby API

#include "b2pinsdk/BeckyAPI.h"			// Becky! Plug-in SDK
#include "b2pinsdk/BkCommon.h"			// Becky! Plug-in SDK

#pragma hdrstop

#include "BeckyLib.h"
#include "RubyItpr.h"
#include "Edit.h"
#include "Manager.h"
#include "version.h"

#include "IniFiles.hpp"

#define MAIN_SOURCE
#include "extern.h"
#undef MAIN_SOURCE


//---------------------------------------------------------------------------
// Prototype
LONG WINAPI _export rubyMainProc( HWND w, UINT cmd, WPARAM wParam, LPARAM lParam );
LONG WINAPI _export rubyComposeProc( HWND w, UINT cmd, WPARAM wParam, LPARAM lParam );

void WINAPI Cmd_ScriptEdit( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_ScriptManager( HWND hWnd , LPARAM lParam );

void WINAPI Cmd_RunMainMenu( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunListView( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunTreeView( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunMsgView( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunMsgEdit( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunTaskTray( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunComposeMenu( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunComposeEdit( HWND hWnd , LPARAM lParam );
void WINAPI Cmd_RunComposeRef( HWND hWnd , LPARAM lParam );

AnsiString Utl_GetFileName( AnsiString fullpath );
void LoadIni( AnsiString b2path );
void SaveIni( void );
bool DllLoad( void );


//---------------------------------------------------------------------------
// Local
static FARPROC originalMainProc;
static FARPROC originalComposeProc;
static TIniFile *IniFile;
static HANDLE BeckyMainThread;			// Becky! ̃CXbh
static HINSTANCE g_hInstance = NULL;

typedef struct {
	HANDLE hComposeWindow;
	FARPROC originalComposeProc;
	void *next;
} CompProcInfo_t;
static CompProcInfo_t *pCompProcInfo = NULL;

void freeCompWindowProc( HWND hWnd );
FARPROC getCompWindowProc( HWND hWnd );

void BeckyAPI_Call( WPARAM wParam, LPARAM lParam );
void BkComposeAPI_Call( HWND w, WPARAM wParam, LPARAM lParam );


void freeCompWindowProc( HWND hWnd )
{
	CompProcInfo_t *current;
	CompProcInfo_t *old;

	if ( pCompProcInfo == NULL ) {
		return;
	}

	current = pCompProcInfo;
	if ( current->hComposeWindow == hWnd ) {
		if ( current->next != NULL ) {
			SetWindowLongPtr( hWnd, GWLP_WNDPROC, (long)(current->originalComposeProc) );
			pCompProcInfo = (CompProcInfo_t *)(current->next);
		}
		else {
			pCompProcInfo = NULL;
		}
		free( current );
		return;
	}

	for (;;) {
		old = current;
		current = (CompProcInfo_t *)(old->next);

		if ( current->hComposeWindow == hWnd ) {
			SetWindowLongPtr( hWnd, GWLP_WNDPROC, (long)(current->originalComposeProc) );
			old->next = current->next;
			free( current );
			return;
		}
	}
}

// malloc 炿 free 悤ˁ
FARPROC getCompWindowProc( HWND hWnd )
{
	CompProcInfo_t *current;

	if ( pCompProcInfo == NULL ) {
		pCompProcInfo = (CompProcInfo_t *)malloc( sizeof(CompProcInfo_t) );
		pCompProcInfo->hComposeWindow = hWnd;
		pCompProcInfo->originalComposeProc = (FARPROC)GetWindowLongPtr( hWnd, GWLP_WNDPROC );;
		pCompProcInfo->next = NULL;
		return ( pCompProcInfo->originalComposeProc );
	}
	current = pCompProcInfo;

	for (;;) {
		if ( hWnd == current->hComposeWindow ) {
			return ( current->originalComposeProc );
		}

		if ( current->next == NULL ) {
			current->next = malloc( sizeof(CompProcInfo_t) );
			current = (CompProcInfo_t *)(current->next);
			current->hComposeWindow = hWnd;
			current->originalComposeProc = (FARPROC)GetWindowLongPtr( hWnd, GWLP_WNDPROC );
			current->next = NULL;
			return ( current->originalComposeProc );
		}
		current = (CompProcInfo_t *)(current->next);
	}
}

void BeckyAPI_Call( WPARAM wParam, LPARAM lParam )
{
	switch ( wParam ) {
		case BECKYAPI_GETVERSION:
			{
				BeckyAPI_GetVersion_t *pParam = (BeckyAPI_GetVersion_t *)lParam;
				pParam->str = bka.GetVersion();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_COMMAND:
			{
				BeckyAPI_Command_t *pParam = (BeckyAPI_Command_t *)lParam;
				bka.Command( NULL, pParam->command );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETWINDOWHANDLE:
			{
				BeckyAPI_GetWindowHandle_t *pParam = (BeckyAPI_GetWindowHandle_t *)lParam;
				bka.GetWindowHandles( &(pParam->hWnds[0]),
										&(pParam->hWnds[1]),
										&(pParam->hWnds[2]),
										&(pParam->hWnds[3]) );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETDATAFOLDER:
			{
				BeckyAPI_GetDataFolder_t *pParam = (BeckyAPI_GetDataFolder_t *)lParam;
				pParam->str = bka.GetDataFolder();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETTEMPFOLDER:
			{
				BeckyAPI_GetTempFolder_t *pParam = (BeckyAPI_GetTempFolder_t *)lParam;
				pParam->str = bka.GetTempFolder();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETTEMPFILENAME:
			{
				BeckyAPI_GetTempFileName_t *pParam = (BeckyAPI_GetTempFileName_t *)lParam;
				pParam->str = bka.GetTempFileName( pParam->type );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETMESSAGETEXT:
			{
				BeckyAPI_SetMessageText_t *pParam = (BeckyAPI_SetMessageText_t *)lParam;
				bka.SetMessageText( pParam->hWnd, pParam->msg );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_CONNECT:
			{
				BeckyAPI_Connect_t *pParam = (BeckyAPI_Connect_t *)lParam;
				pParam->result = bka.Connect( pParam->bConnect );
			}
			break;
		case BECKYAPI_GETCURRENTMAILBOX:
			{
				BeckyAPI_GetCurrentMailBox_t *pParam = (BeckyAPI_GetCurrentMailBox_t *)lParam;
				pParam->mbx = bka.GetCurrentMailBox();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETCURRENTMAILBOX:
			{
				BeckyAPI_SetCurrentMailBox_t *pParam = (BeckyAPI_SetCurrentMailBox_t *)lParam;
				bka.SetCurrentMailBox( pParam->mbx );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETCURRENTFOLDER:
			{
				BeckyAPI_GetCurrentFolder_t *pParam = (BeckyAPI_GetCurrentFolder_t *)lParam;
				pParam->folder = bka.GetCurrentFolder();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETCURRENTFOLDER:
			{
				BeckyAPI_SetCurrentFolder_t *pParam = (BeckyAPI_SetCurrentFolder_t *)lParam;
				bka.SetCurrentFolder( pParam->folder );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETFOLDERDISPLAYNAME:
			{
				BeckyAPI_GetFolderDisplayName_t *pParam = (BeckyAPI_GetFolderDisplayName_t *)lParam;
				pParam->name = bka.GetFolderDisplayName( pParam->folder );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETCURRENTMAIL:
			{
				BeckyAPI_GetCurrentMail_t *pParam = (BeckyAPI_GetCurrentMail_t *)lParam;
				pParam->mail = bka.GetCurrentMail();
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETCURRENTMAIL:
			{
				BeckyAPI_SetCurrentMail_t *pParam = (BeckyAPI_SetCurrentMail_t *)lParam;
				bka.SetCurrentMail( pParam->mail );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETNEXTMAIL:
			{
				BeckyAPI_GetNextMail_t *pParam = (BeckyAPI_GetNextMail_t *)lParam;
				pParam->pos = bka.GetNextMail( pParam->nStart, pParam->mailid, pParam->nBuf, pParam->bSelected );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETSEL:
			{
				BeckyAPI_SetSel_t *pParam = (BeckyAPI_SetSel_t *)lParam;
				bka.SetSel( pParam->mail, pParam->bSel );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_APPENDMESSAGE:
			{
				BeckyAPI_AppendMessage_t *pParam = (BeckyAPI_AppendMessage_t *)lParam;
				pParam->result = bka.AppendMessage( pParam->folder, pParam->msg );
			}
			break;
		case BECKYAPI_MOVESELECTEDMESSAGES:
			{
				BeckyAPI_MoveSelectedMessages_t *pParam = (BeckyAPI_MoveSelectedMessages_t *)lParam;
				pParam->result = bka.MoveSelectedMessages( pParam->folder, pParam->bCopy );
			}
			break;
		case BECKYAPI_GETSTATUS:
			{
				BeckyAPI_GetStatus_t *pParam = (BeckyAPI_GetStatus_t *)lParam;
				pParam->status = bka.GetStatus( pParam->mail );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETSTATUS:
			{
				BeckyAPI_SetStatus_t *pParam = (BeckyAPI_SetStatus_t *)lParam;
				pParam->status = bka.SetStatus( pParam->mail, pParam->dwSet, pParam->dwReset );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETCHARSET:
			{
				BeckyAPI_GetCharSet_t *pParam = (BeckyAPI_GetCharSet_t *)lParam;
				pParam->code = bka.GetCharSet( pParam->mail, pParam->charset, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETSOURCE:
			{
				BeckyAPI_GetSource_t *pParam = (BeckyAPI_GetSource_t *)lParam;
				pParam->src = bka.GetSource( pParam->mail );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETSOURCE:
			{
				BeckyAPI_SetSource_t *pParam = (BeckyAPI_SetSource_t *)lParam;
				bka.SetSource( pParam->mail, pParam->src );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETHEADER:
			{
				BeckyAPI_GetHeader_t *pParam = (BeckyAPI_GetHeader_t *)lParam;
				pParam->header = bka.GetHeader( pParam->mail );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETSPECIFIEDHEADER:
			{
				BeckyAPI_GetSpecifiedHeader_t *pParam = (BeckyAPI_GetSpecifiedHeader_t *)lParam;
				bka.GetSpecifiedHeader( pParam->header, pParam->data, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETSPECIFIEDHEADER:
			{
				BeckyAPI_SetSpecifiedHeader_t *pParam = (BeckyAPI_SetSpecifiedHeader_t *)lParam;
				bka.SetSpecifiedHeader( pParam->header, pParam->data );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_GETTEXT:
			{
				BeckyAPI_GetText_t *pParam = (BeckyAPI_GetText_t *)lParam;
				pParam->text = bka.GetText( pParam->mimetype, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETTEXT:
			{
				BeckyAPI_SetText_t *pParam = (BeckyAPI_SetText_t *)lParam;
				bka.SetText( pParam->nMode, pParam->text );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_ISO_2022_JP:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.ISO_2022_JP( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_ISO_2022_KR:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.ISO_2022_KR( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_HZ_GB2312:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.HZ_GB2312( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_ISO_8859_2:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.ISO_8859_2( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_EUC_JP:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.EUC_JP( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_UTF_7:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.UTF_7( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_UTF_8:
			{
				BeckyAPI_ISO_2022_JP_t *pParam = (BeckyAPI_ISO_2022_JP_t *)lParam;
				pParam->dest = bka.UTF_8( pParam->src, pParam->bEncode );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_B64CONVERT:
			{
				BeckyAPI_B64Convert_t *pParam = (BeckyAPI_B64Convert_t *)lParam;
				pParam->result = bka.B64Convert( pParam->destfile, pParam->srcfile, pParam->bEncode );
			}
			break;
		case BECKYAPI_QPCONVERT:
			{
				BeckyAPI_B64Convert_t *pParam = (BeckyAPI_B64Convert_t *)lParam;
				pParam->result = bka.QPConvert( pParam->destfile, pParam->srcfile, pParam->bEncode );
			}
			break;
		case BECKYAPI_MIMEHEADERENCODE:
			{
				BeckyAPI_MIMEHeaderEncode_t *pParam = (BeckyAPI_MIMEHeaderEncode_t *)lParam;
				pParam->out = bka.MIMEHeader( pParam->in, pParam->charset, 0, TRUE );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_MIMEHEADERDECODE:
			{
				BeckyAPI_MIMEHeaderDecode_t *pParam = (BeckyAPI_MIMEHeaderDecode_t *)lParam;
				pParam->out = bka.MIMEHeader( pParam->in, pParam->charset, pParam->nBuf, FALSE );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SERIALIZERCPTS:
			{
				BeckyAPI_SerializeRcpts_t *pParam = (BeckyAPI_SerializeRcpts_t *)lParam;
				pParam->out = bka.SerializeRcpts( pParam->lpaddress );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_COMPOSEMAIL:
			{
				BkComposeAPI_ComposeMail_t *pParam = (BkComposeAPI_ComposeMail_t *)lParam;
				pParam->hWnd = bka.ComposeMail( pParam->url );
				pParam->result = TRUE;
			}
			break;
		default:
			break;
	}
}

void BkComposeAPI_Call( HWND w, WPARAM wParam, LPARAM lParam )
{
	switch ( wParam ) {
		case BKCOMPOSEAPI_COMMAND:
			{
				BeckyAPI_Command_t *pParam = (BeckyAPI_Command_t *)lParam;
				bka.Command( w, pParam->command );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_GETCHARSET:
			{
				BkComposeAPI_GetCharSet_t *pParam = (BkComposeAPI_GetCharSet_t *)lParam;
				pParam->code = bka.CompGetCharSet( w, pParam->charset, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_GETSOURCE:
			{
				BkComposeAPI_GetSource_t *pParam = (BkComposeAPI_GetSource_t *)lParam;
				pParam->src = bka.CompGetSource( w );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_SETSOURCE:
			{
				BkComposeAPI_SetSource_t *pParam = (BkComposeAPI_SetSource_t *)lParam;
				bka.CompSetSource( w, pParam->src );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_GETHEADER:
			{
				BkComposeAPI_GetHeader_t *pParam = (BkComposeAPI_GetHeader_t *)lParam;
				pParam->header = bka.CompGetHeader( w );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_GETSPECIFIEDHEADER:
			{
				BkComposeAPI_GetSpecifiedHeader_t *pParam = (BkComposeAPI_GetSpecifiedHeader_t *)lParam;
				bka.CompGetSpecifiedHeader( w, pParam->header, pParam->data, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_SETSPECIFIEDHEADER:
			{
				BkComposeAPI_SetSpecifiedHeader_t *pParam = (BkComposeAPI_SetSpecifiedHeader_t *)lParam;
				bka.CompSetSpecifiedHeader( w, pParam->header, pParam->data );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_GETTEXT:
			{
				BkComposeAPI_GetText_t *pParam = (BkComposeAPI_GetText_t *)lParam;
				pParam->text = bka.CompGetText( w, pParam->mimetype, pParam->nBuf );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_SETTEXT:
			{
				BkComposeAPI_SetText_t *pParam = (BkComposeAPI_SetText_t *)lParam;
				bka.CompSetText( w, pParam->nMode, pParam->text );
				pParam->result = TRUE;
			}
			break;
		case BKCOMPOSEAPI_ATTACHFILE:
			{
				BkComposeAPI_AttachFile_t *pParam = (BkComposeAPI_AttachFile_t *)lParam;
				bka.CompAttachFile( w, pParam->file, pParam->mimetype );
				pParam->result = TRUE;
			}
			break;
		case BECKYAPI_SETMESSAGETEXT:
			{
				BeckyAPI_SetMessageText_t *pParam = (BeckyAPI_SetMessageText_t *)lParam;
				bka.SetMessageText( w, pParam->msg );
				pParam->result = TRUE;
			}
			break;
		default:
			break;
	}
}


LONG WINAPI _export rubyMainProc( HWND w, UINT cmd, WPARAM wParam, LPARAM lParam )
{
	LRESULT ret = 0;

	if ( cmd == RubyBeckyMsg_APICall ) {
		DEBUG_OUT( DBG_BECKY_3, "GetMessage( cmd:0x%x, wParam:%d, lParam:%d )", cmd, wParam, lParam );
		BeckyAPI_Call( wParam, lParam );
	}
	else if ( cmd == RubyBeckyMsg_InterfaceCall ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_InterfaceCall, wParam, lParam );
	}
	else {
//		DEBUG_OUT( DBG_WINDOWMSG, "OriginalMessage( cmd:0x%x, wParam:%d, lParam:%d )", cmd, wParam, lParam );
		ret = CallWindowProc( originalMainProc, w, cmd, wParam, lParam );
	}

	return ret;
}

LONG WINAPI _export rubyComposeProc( HWND w, UINT cmd, WPARAM wParam, LPARAM lParam )
{
	LRESULT ret = 0;

	if ( cmd == RubyBeckyMsg_APICall ) {
		DEBUG_OUT( DBG_BECKY_3, "GetMessage( cmd:0x%x, wParam:%d, lParam:%d )", cmd, wParam, lParam );
		BkComposeAPI_Call( w, wParam, lParam );
	}
	else if ( cmd == RubyBeckyMsg_InterfaceCall ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_InterfaceCall, wParam, lParam );
	}
	else {
//		DEBUG_OUT( DBG_WINDOWMSG, "OriginalMessage( window:0x%x, cmd:0x%x, wParam:%d, lParam:%d )", w, cmd, wParam, lParam );
		ret = CallWindowProc( getCompWindowProc( w ), w, cmd, wParam, lParam );
		if ( cmd == WM_CLOSE ) {
			freeCompWindowProc( w );
		}
	}

	return ret;
}


/////////////////////////////////////////////////////////////////////////////
// DLL entry point
BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved )
{
	g_hInstance = (HINSTANCE)hModule;

	switch (ul_reason_for_call) {
		case DLL_PROCESS_ATTACH:
			{
				char szIni[_MAX_PATH+2];		// Ini file to save your plugin settings.
				AnsiString b2path;

				GetModuleFileName( (HINSTANCE)hModule, szIni, _MAX_PATH );

				// B2.exe ̃pX擾
				{
					char path[_MAX_PATH+2];
					LPSTR lpExt = strrchr(szIni, '.');

					if ( lpExt ) {
						strcpy(lpExt, ".ini");
					}
					else {
						// just in case
						strcat(szIni, ".ini");
					}

					strcpy( path, szIni );				// C:\Program Files\RIMArts\Becky\Plugins\RubyBecky.dll
					*(strrchr(path, '\\')) = '\0';		// C:\Program Files\RIMArts\Becky\Plugins
					*(strrchr(path, '\\')) = '\0';		// C:\Program Files\RIMArts\Becky
					b2path = AnsiString( &path[0] );
				}

				// fobOo͏
				{
					Debug_Level = 0xffff;
					AnsiString fname = b2path+"\\RubyBecky.log";

					logout_lock = new TCriticalSection();
					log_fp = fopen( fname.c_str(), "r+b" );
					if ( log_fp ) {
						fclose( log_fp );
						log_fp = fopen( fname.c_str(), "w+b" );
					}
				}

				DEBUG_OUT( DBG_BECKY_1, "Ruby/Becky! LOG FILE (Version : %s)\n", RUBYBECKY_VERSION );
				DEBUG_OUT( DBG_BECKY_1, "Becky!\t\t\t\t\t\t\t\tRuby" );
				DEBUG_OUT( DBG_BECKY_1, "------------------------------------------------------------------------------------------------\n" );
				DEBUG_OUT( DBG_BECKY_1, "Ruby/Becky! Jn" );
				DEBUG_OUT( DBG_BECKY_3, "Program Path = '%s'", b2path.c_str() );

				if ( !bka.InitAPI() ) {
					return FALSE;
				}

				IniFile = new TIniFile(szIni);
				LoadIni( b2path );
				IniFile->WriteString( "Global" , "ScriptPath", RubyBeckyIni.ScriptPath );
				IniFile->WriteString( "Global" , "LibPath", RubyBeckyIni.LibPath );
				IniFile->WriteString( "Global" , "RubyDllName", RubyBeckyIni.RubyDllName );
				IniFile->WriteString( "Global" , "BeckyLibPath", RubyBeckyIni.BeckyLibPath );

				DEBUG_OUT( DBG_BECKY_3, "RubyBecky.ini /Ǎ " );

				if ( !DllLoad() ) {
					DEBUG_OUT( DBG_BECKY_0, "Ruby Dll Ǎs" );
					return false;
				}
				DEBUG_OUT( DBG_BECKY_1, "Ruby Dll Ǎ" );
			}
			break;
		case DLL_THREAD_ATTACH:
			break;
		case DLL_THREAD_DETACH:
			break;
		case DLL_PROCESS_DETACH:
			break;
	}
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// Callbacks from Becky!

#ifdef __cplusplus
extern "C"{
#endif

////////////////////////////////////////////////////////////////////////
// Called when the program is started and the main window is created.
int WINAPI BKC_OnStart()
{
	int ret = 0;
	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnStart() {" );

	/*
	Since BKC_OnStart is called after Becky!'s main window is
	created, at least BKC_OnMenuInit with BKC_MENU_MAIN is called
	before BKC_OnStart. So, do not assume BKC_OnStart is called
	prior to any other callback.
	*/
	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_START, NULL );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when the main window is closing.
int WINAPI BKC_OnExit()
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnExit() {" );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_EXIT, NULL );
	}

	SaveIni();

	// Return -1 if you don't want to quit.

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when menu is intialized.
int WINAPI BKC_OnMenuInit(HWND hWnd, HMENU hMenu, int nType)
{
	char cname[256];
	UINT nID;
	int nItem;
	int i;
	HMENU hSubMenu;
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnMenuInit() {" );

	switch (nType) {
	case BKC_MENU_MAIN:
		{
			VersionForm = new TVersionForm(NULL);
			EditForm = new TEditForm(NULL);
			ManagerForm = new TManagerForm(NULL);

			IniFile->ReadSection( "Initial" , ManagerForm->ListBox1->Items );
			IniFile->ReadSection( "MainMenu" , ManagerForm->ListBox2->Items );
			IniFile->ReadSection( "ListView" , ManagerForm->ListBox3->Items );
			IniFile->ReadSection( "TreeView" , ManagerForm->ListBox4->Items );
			IniFile->ReadSection( "MessageView" , ManagerForm->ListBox5->Items );
			IniFile->ReadSection( "MessageEdit" , ManagerForm->ListBox6->Items );
			IniFile->ReadSection( "TaskTray" , ManagerForm->ListBox7->Items );
			IniFile->ReadSection( "ComposeMenu" , ManagerForm->ListBox8->Items );
			IniFile->ReadSection( "ComposeEdit" , ManagerForm->ListBox9->Items );
			IniFile->ReadSection( "ComposeView" , ManagerForm->ListBox10->Items );

			// Nɂ\
			{
				EditForm->Width = 1;
				EditForm->Height = 2;
				EditForm->PageControl1->Height = 1;

				EditForm->Show();
				EditForm->Hide();

				EditForm->Top = RubyBeckyIni.Editor_Top;
				EditForm->Left = RubyBeckyIni.Editor_Left;
				EditForm->Width = RubyBeckyIni.Editor_Width;
				EditForm->Height = RubyBeckyIni.Editor_Height;
				EditForm->PageControl1->Height = RubyBeckyIni.Editor_OutputHeight;
			}

			Application->Handle = hWnd;

			BeckyMainThread = GetCurrentThread();
//			DEBUG_OUT( DBG_BECKY_3, "Becky! Main Thread : %d", BeckyMainThread );

			// Ruby/Becky! gp Window Message o^
			RubyBeckyMsg_APICall = RegisterWindowMessage( "RubyBeckyAPI" );
			RubyBeckyMsg_ScriptCall = RegisterWindowMessage( "RubyBeckyScript" );
			RubyBeckyMsg_EventCall = RegisterWindowMessage( "RubyBeckyCallBack" );
			RubyBeckyMsg_InterfaceCall = RegisterWindowMessage( "RubyBeckyInterface" );

			// EChEvV[W rubyMainProc() ֍ւ
			originalMainProc = (FARPROC)GetWindowLongPtr( hWnd, GWLP_WNDPROC );
			SetWindowLongPtr( hWnd, GWLP_WNDPROC, (long)rubyMainProc );

			hMainWnd = hWnd;
			DEBUG_OUT( DBG_BECKY_3, "Becky! MainWindow Handle : %d", hMainWnd );

			// Becky! ̃j[ɁuXNvgvǉ
			hSubMenu = CreateMenu();
			nID = bka.RegisterCommand( "ScriptEdit" , nType , Cmd_ScriptEdit );
			InsertMenu( hSubMenu , 0 , MF_BYPOSITION | MF_ENABLED , nID , "ҏW(&E)" );

			nID = bka.RegisterCommand( "ScriptManager" , nType , Cmd_ScriptManager );
			InsertMenu( hSubMenu , 1 , MF_BYPOSITION | MF_ENABLED , nID , "}l[W(&M)" );

			// j[ĂяoXNvg
			for ( i = 0 ; i < ManagerForm->ListBox2->Items->Count ; i++ ) {
				nID = bka.RegisterCommand( ManagerForm->ListBox2->Items->Strings[i].c_str() , nType , Cmd_RunMainMenu );
				if( i == 0 ) {
					InsertMenu( hSubMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
					ManagerForm->ListBox2->Tag = nID;
				}
				InsertMenu( hSubMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox2->Items->Strings[i]).c_str() );
			}

			nItem = GetMenuItemCount( hMenu );
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_POPUP | MF_ENABLED , (UINT)hSubMenu , "XNvg(&S)" );

			// Ruby sXbh
			DEBUG_OUT( DBG_BECKY_1, "Becky! sXbhv" );
			ruby = new RubyItpr(false);

			DEBUG_OUT( DBG_BECKY_1, "Ruby/Becky! I" );
		}
		break;
	case BKC_MENU_LISTVIEW:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox3->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox3->Items->Strings[i].c_str() , nType , Cmd_RunListView );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox3->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox3->Items->Strings[i]).c_str() );
		}
		break;
	case BKC_MENU_TREEVIEW:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox4->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox4->Items->Strings[i].c_str() , nType , Cmd_RunTreeView );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox4->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox4->Items->Strings[i]).c_str() );
		}
		break;
	case BKC_MENU_MSGVIEW:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox5->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox5->Items->Strings[i].c_str() , nType , Cmd_RunMsgView );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox5->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox5->Items->Strings[i]).c_str() );
		}
		InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
		break;
	case BKC_MENU_MSGEDIT:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox6->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox6->Items->Strings[i].c_str() , nType , Cmd_RunMsgEdit );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox6->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox6->Items->Strings[i]).c_str() );
		}
		InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
		break;
	case BKC_MENU_TASKTRAY:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox7->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox7->Items->Strings[i].c_str() , nType , Cmd_RunTaskTray );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox7->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox7->Items->Strings[i]).c_str() );
		}
		break;
	case BKC_MENU_COMPOSE:
		// uXNvgvj[𐶐
		hSubMenu = CreateMenu();

		// Cj[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox8->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox8->Items->Strings[i].c_str() , nType , Cmd_RunComposeMenu );
			if( i == 0 ) {
			    ManagerForm->ListBox8->Tag = nID;
			}
			InsertMenu( hSubMenu , i , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox8->Items->Strings[i]).c_str() );
		}

		// uXNvgvj[Cj[̍ŌォQԖڂɑ}
		nItem = GetMenuItemCount( hMenu );
		InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_POPUP | MF_ENABLED , (UINT)hSubMenu , "XNvg(&S)" );
		break;
	case BKC_MENU_COMPEDIT:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox9->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox9->Items->Strings[i].c_str() , nType , Cmd_RunComposeEdit );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox9->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox9->Items->Strings[i]).c_str() );
		}
		break;
	case BKC_MENU_COMPREF:
		nItem = GetMenuItemCount( hMenu );
		// j[ĂяoXNvg
		for ( i = 0 ; i < ManagerForm->ListBox10->Items->Count ; i++ ) {
			nID = bka.RegisterCommand( ManagerForm->ListBox10->Items->Strings[i].c_str() , nType , Cmd_RunComposeRef );
			if( i == 0 ) {
				InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
				ManagerForm->ListBox10->Tag = nID;
			}
			InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_ENABLED , nID , Utl_GetFileName(ManagerForm->ListBox10->Items->Strings[i]).c_str() );
		}
		InsertMenu( hMenu , nItem-1 , MF_BYPOSITION | MF_SEPARATOR , 0 , "" );
		break;
	default:
		break;
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a folder is opened.
int WINAPI BKC_OnOpenFolder(LPCTSTR lpFolderID)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnOpenFolder( \"%s\" ) {", lpFolderID );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_OPENFOLDER, (long)lpFolderID );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a mail is selected.
int WINAPI BKC_OnOpenMail(LPCTSTR lpMailID)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnOpenMail( \"%s\" ) {", lpMailID );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_OPENMAIL, (long)lpMailID );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called every minute.
int WINAPI BKC_OnEveryMinute()
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnEveryMinute() {" );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_MINUTE, NULL );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a compose windows is opened.
int WINAPI BKC_OnOpenCompose(HWND hWnd, int nMode/* See COMPOSE_MODE_* in BeckyApi.h */)
{
	static BkCallBack_Compose_t comp;
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnOpenCompose( %d, %d ) {", hWnd, nMode );

	/* [ҏWEChẼEChEvV[Wւ */
	getCompWindowProc( hWnd );
	SetWindowLongPtr( hWnd, GWLP_WNDPROC, (long)rubyComposeProc );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		comp.hWnd = hWnd;
		comp.nMode = nMode;

		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_COMPOSE, (long)&comp );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when the composing message is saved.
int WINAPI BKC_OnOutgoing(HWND hWnd, int nMode/* 0:SaveToOutbox, 1:SaveToDraft, 2:SaveToReminder*/) 
{
	static BkCallBack_Compose_t comp;
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnOutgoing( %d, %d ) {", hWnd, nMode );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		comp.hWnd = hWnd;
		comp.nMode = nMode;

		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_OUTGOING, (long)&comp );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Return -1 if you do not want to send it yet.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a key is pressed.
int WINAPI BKC_OnKeyDispatch(HWND hWnd, int nKey/* virtual key code */, int nShift/* Shift state. 0x40=Shift, 0x20=Ctrl, 0x60=Shift+Ctrl, 0xfe=Alt*/)
{
	static BkCallBack_Keydispatch_t key;
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnKeyDispatch( %d, %d, %d ) {", hWnd, nKey, nShift );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		key.hWnd = hWnd;
		key.nKey = nKey;
		key.nShift = nShift;
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_KEYDISPATCH, (long)&key );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Return TRUE if you want to suppress subsequent command associated to this key.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a message is retrieved and saved to a folder
int WINAPI BKC_OnRetrieve(LPCTSTR lpMessage/* Message source*/, LPCTSTR lpMailID/* Mail ID*/)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnRetrieve( \"%s\" ) {", lpMailID );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_RETRIEVE, (long)lpMailID );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when a message is spooled
int WINAPI BKC_OnSend(LPCTSTR lpMessage/* Message source */)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnSend() {" );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_SEND, (long)lpMessage );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Return BKC_ONSEND_PROCESSED, if you have processed this message
	// and don't need Becky! to send it.
	// Becky! will move this message to Sent box when the sending
	// operation is done.
	// CAUTION: You are responsible for the destination of this
	// message if you return BKC_ONSEND_PROCESSED.

	// Return BKC_ONSEND_ERROR, if you want to cancel the sending operation.
	// You are responsible for displaying an error message.

	// Return 0 to proceed the sending operation.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when all messages are retrieved
int WINAPI BKC_OnFinishRetrieve(int nNumber/* Number of messages*/)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnFinishRetrieve( %d ) {", nNumber );

	if ( GetCurrentThread() == BeckyMainThread && ruby->GetStatus() == ITPR_STS_NOTWORK ) {
		PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_EventCall, BKCALLBACK_FINISHRETRIEVE, (long)nNumber );
	}

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}


////////////////////////////////////////////////////////////////////////
// Called when plug-in setup is needed.
int WINAPI BKC_OnPlugInSetup(HWND hWnd)
{
	int ret = 1;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnPlugInSetup( %d ) {", hWnd );

	VersionForm->Show();

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Return nonzero if you have processed.
	// return 1;
	return ret;
}


////////////////////////////////////////////////////////////////////////
// Called when plug-in information is being retrieved.
typedef struct tagBKPLUGININFO
{
	char szPlugInName[80]; // Name of the plug-in
	char szVendor[80]; // Name of the vendor
	char szVersion[80]; // Version string
	char szDescription[256]; // Short description about this plugin
} BKPLUGININFO, *LPBKPLUGININFO;

int WINAPI BKC_OnPlugInInfo(LPBKPLUGININFO lpPlugInInfo)
{
	int ret = 0;

	/* You MUST specify at least szPlugInName and szVendor.
		otherwise Becky! will silently ignore your plug-in.
	strcpy(lpPlugInInfo->szPlugInName, "Becky! PGP plug-in");
	strcpy(lpPlugInInfo->szVendor, "RimArts, Inc.");
	strcpy(lpPlugInInfo->szVersion, "1.0");
	strcpy(lpPlugInInfo->szDescription, "Enables Becky! to use PGP.");
	*/

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnPlugInInfo() {" );

	strcpy(lpPlugInInfo->szPlugInName, "Ruby/Becky!");
	strcpy(lpPlugInInfo->szVendor, "T.Shimomura/netlife.gr.jp");
	strcpy(lpPlugInInfo->szVersion, RUBYBECKY_VERSION);
	strcpy(lpPlugInInfo->szDescription, "");

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	// Always return 0.
	return ret;
}

////////////////////////////////////////////////////////////////////////
// Called when drag and drop operation occurs.
int WINAPI BKC_OnDragDrop(LPCSTR lpTgt, LPCSTR lpSrc, int nCount, int dropEffect)
{
	int ret = 0;

	DEBUG_OUT( DBG_BECKY_2, "CallBack:BKC_OnDragDrop( %s, %d, %d ) {", lpTgt, nCount, dropEffect );

	/*
	lpTgt:	A folder ID of the target folder.
			You can assume it is a root mailbox, if the string
			contains only one '\' character.
	lpSrc:	Either a folder ID or mail IDs. Multiple mail IDs are
			separated by '\n' (0x0a).
			You can assume it is a folder ID, if the string
			doesn't contain '?' character.
	nCount:	Number of items to be dropped.
			It can be more than one, if you drop mail items.
	dropEffect: Type of drag and drop operation
			1: Copy
			2: Move
			4: Link (Used for filtering setup in Becky!)
	*/
	// If you want to cancel the default drag and drop action,
	// return -1;
	// Do not assume the default action (copy, move, etc.) is always
	// processed, because other plug-ins might cancel the operation.

	DEBUG_OUT( DBG_BECKY_3, "return( %d )", ret );
	DEBUG_OUT( DBG_BECKY_2, "}" );

	return ret;
}

#ifdef __cplusplus
}
#endif

// XNvgҏW
void WINAPI Cmd_ScriptEdit( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_1, "XNvgGfB^\" );

	EditForm->Show();
	EditForm->RichEdit2->Repaint();
	EditForm->RichEdit3->Repaint();
}

// XNvg}l[W
void WINAPI Cmd_ScriptManager( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_1, "}l[W\" );

	ManagerForm->Show();
}

void WINAPI Cmd_RunMainMenu( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunMainMenu( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox2->Items->Strings[lParam-ManagerForm->ListBox2->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

// Xgr[j[̃XNvgs
void WINAPI Cmd_RunListView( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunListView( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox3->Items->Strings[lParam-ManagerForm->ListBox3->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunTreeView( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunTreeView( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox4->Items->Strings[lParam-ManagerForm->ListBox4->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunMsgView( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunMsgView( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox5->Items->Strings[lParam-ManagerForm->ListBox5->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunMsgEdit( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunMsgEdit( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox6->Items->Strings[lParam-ManagerForm->ListBox6->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunTaskTray( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunTaskTray( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox7->Items->Strings[lParam-ManagerForm->ListBox7->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunComposeMenu( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunComposeMenu( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox8->Items->Strings[lParam-ManagerForm->ListBox8->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunComposeEdit( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunComposeEdit( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox9->Items->Strings[lParam-ManagerForm->ListBox9->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}

void WINAPI Cmd_RunComposeRef( HWND hWnd , LPARAM lParam )
{
	DEBUG_OUT( DBG_BECKY_2, "Execute:Cmd_RunComposeRef( %d, %d ) {", hWnd, lParam );

	ManagerForm->Memo1->Lines->LoadFromFile( ManagerForm->ListBox10->Items->Strings[lParam-ManagerForm->ListBox10->Tag] );
	PostThreadMessage( ruby->ThreadID, RubyBeckyMsg_ScriptCall, (WPARAM)(ManagerForm->Memo1->Text.c_str()), NULL );

	DEBUG_OUT( DBG_BECKY_2, "}" );
}


// tpXt@C𔲂o
AnsiString Utl_GetFileName( AnsiString fullpath )
{
	int x,y;

	x = fullpath.LastDelimiter( "\\" );
	y = fullpath.LastDelimiter( "." );
	return( fullpath.SubString( x+1 , y-x-1 ) );
}


// RubyBecky.Ini ǂݍ
void LoadIni( AnsiString b2path )
{
	AnsiString scriptPath;			// XNvg̃pXilj
	AnsiString libPath;				// CũpXilj
	AnsiString beckylibPath;				// CũpXilj
	AnsiString dllName;
	AnsiString logFile;

	scriptPath = b2path+"\\Scripts";
	libPath = b2path+"\\lib";
	beckylibPath = libPath+"\\becky";
	dllName = b2path+"\\mswin32-ruby16.dll";

	RubyBeckyIni.Editor_Top = IniFile->ReadInteger( "Editor", "Top", 0 );
	RubyBeckyIni.Editor_Left = IniFile->ReadInteger( "Editor", "Left", 0 );
	RubyBeckyIni.Editor_Height = IniFile->ReadInteger( "Editor", "Height", 400 );
	RubyBeckyIni.Editor_Width = IniFile->ReadInteger( "Editor", "Width", 600 );
	RubyBeckyIni.Editor_OutputHeight = IniFile->ReadInteger( "Editor", "OutPutHeight", 150 );

	RubyBeckyIni.ScriptPath = IniFile->ReadString( "Global", "ScriptPath", scriptPath );
	RubyBeckyIni.LibPath = IniFile->ReadString( "Global", "LibPath", libPath );
	RubyBeckyIni.BeckyLibPath = IniFile->ReadString( "Global", "BeckyLibPath", beckylibPath );
	RubyBeckyIni.RubyDllName = IniFile->ReadString( "Global", "RubyDllName", dllName );
}


// RubyBecky.Ini 
void SaveIni( void )
{
	int i;

	if ( IniFile ) {
		IniFile->WriteString( "Global" , "ScriptPath", RubyBeckyIni.ScriptPath );
		IniFile->WriteString( "Global" , "LibPath", RubyBeckyIni.LibPath );
		IniFile->WriteString( "Global" , "RubyDllName", RubyBeckyIni.RubyDllName );
		IniFile->WriteString( "Global" , "BeckyLibPath", RubyBeckyIni.BeckyLibPath );

		IniFile->WriteInteger( "Editor", "Top", EditForm->Top );
		IniFile->WriteInteger( "Editor", "Left", EditForm->Left );
		IniFile->WriteInteger( "Editor", "Width", EditForm->Width );
		IniFile->WriteInteger( "Editor", "Height", EditForm->Height );
		IniFile->WriteInteger( "Editor", "OutPutHeight", EditForm->PageControl1->Height );

		IniFile->EraseSection( "Initial" );
		for ( i = 0 ; i < ManagerForm->ListBox1->Items->Count ; i++ ) {
			IniFile->WriteString( "Initial" , ManagerForm->ListBox1->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "MainMenu" );
		for ( i = 0 ; i < ManagerForm->ListBox2->Items->Count ; i++ ) {
			IniFile->WriteString( "MainMenu" , ManagerForm->ListBox2->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "ListView" );
		for ( i = 0 ; i < ManagerForm->ListBox3->Items->Count ; i++ ) {
			IniFile->WriteString( "ListView" , ManagerForm->ListBox3->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "TreeView" );
		for ( i = 0 ; i < ManagerForm->ListBox4->Items->Count ; i++ ) {
			IniFile->WriteString( "TreeView" , ManagerForm->ListBox4->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "MessageView" );
		for ( i = 0 ; i < ManagerForm->ListBox5->Items->Count ; i++ ) {
			IniFile->WriteString( "MessageView" , ManagerForm->ListBox5->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "MessageEdit" );
		for ( i = 0 ; i < ManagerForm->ListBox6->Items->Count ; i++ ) {
			IniFile->WriteString( "MessageEdit" , ManagerForm->ListBox6->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "TaskTray" );
		for ( i = 0 ; i < ManagerForm->ListBox7->Items->Count ; i++ ) {
			IniFile->WriteString( "TaskTray" , ManagerForm->ListBox7->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "ComposeMenu" );
		for ( i = 0 ; i < ManagerForm->ListBox8->Items->Count ; i++ ) {
			IniFile->WriteString( "ComposeMenu" , ManagerForm->ListBox8->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "ComposeEdit" );
		for ( i = 0 ; i < ManagerForm->ListBox9->Items->Count ; i++ ) {
			IniFile->WriteString( "ComposeEdit" , ManagerForm->ListBox9->Items->Strings[i] , "" );
		}
		IniFile->EraseSection( "ComposeView" );
		for ( i = 0 ; i < ManagerForm->ListBox10->Items->Count ; i++ ) {
			IniFile->WriteString( "ComposeView" , ManagerForm->ListBox10->Items->Strings[i] , "" );
		}

		delete IniFile;
	}
}


bool DllLoad( void )
{
	RubyDll.dllentry = LoadLibrary( RubyBeckyIni.RubyDllName.c_str() );
	if ( !RubyDll.dllentry ) {
		return false;
	}

	ruby_init = (RUBY_INIT)GetProcAddress( RubyDll.dllentry, "ruby_init" );
	ruby_incpush = (RUBY_INCPUSH)GetProcAddress( RubyDll.dllentry, "ruby_incpush" );
	rb_eval_string = (RB_EVAL_STRING)GetProcAddress( RubyDll.dllentry, "rb_eval_string" );
	rb_eval_string_protect = (RB_EVAL_STRING_PROTECT)GetProcAddress( RubyDll.dllentry, "rb_eval_string_protect" );

	rb_ary_new = (RB_ARY_NEW)GetProcAddress( RubyDll.dllentry, "rb_ary_new" );
	rb_ary_push = (RB_ARY_PUSH)GetProcAddress( RubyDll.dllentry, "rb_ary_push" );

	rb_str_new2 = (RB_STR_NEW2)GetProcAddress( RubyDll.dllentry, "rb_str_new2" );

	rb_funcall = (RB_FUNCALL)GetProcAddress( RubyDll.dllentry, "rb_funcall" );
	rb_respond_to = (RB_RESPOND_TO)GetProcAddress( RubyDll.dllentry, "rb_respond_to" );
	rb_obj_as_string = (RB_OBJ_AS_STRING)GetProcAddress( RubyDll.dllentry, "rb_obj_as_string" );

	rb_define_class = (RB_DEFINE_CLASS)GetProcAddress( RubyDll.dllentry, "rb_define_class" );
	rb_define_module = (RB_DEFINE_MODULE)GetProcAddress( RubyDll.dllentry, "rb_define_module" );
	rb_define_module_function = (RB_DEFINE_MODULE_FUNCTION)GetProcAddress( RubyDll.dllentry, "rb_define_module_function" );
	rb_define_method = (RB_DEFINE_METHOD)GetProcAddress( RubyDll.dllentry, "rb_define_method" );

	rb_iv_get = (RB_IV_GET)GetProcAddress( RubyDll.dllentry, "rb_iv_get" );
	rb_iv_set = (RB_IV_SET)GetProcAddress( RubyDll.dllentry, "rb_iv_set" );

	rb_intern = (RB_INTERN)GetProcAddress( RubyDll.dllentry, "rb_intern" );
	rb_require = (RB_REQUIRE)GetProcAddress( RubyDll.dllentry, "rb_require" );

	rb_int2inum = (RB_INT2INUM)GetProcAddress( RubyDll.dllentry, "rb_int2inum" );
	rb_num2long = (RB_NUM2LONG)GetProcAddress( RubyDll.dllentry, "rb_num2long" );

	return true;
}

