#TITLE=Analog 4.03 cfg file
#INFO
Analog Server Log Tool 4.03 cfg file cliptext 
http://www.analog.cx/
Written by Chris Bloom on 08/16/01
cbloom@lifespan.org, xangelusx@hotmail.com
#SORT=n

#T=============================
#T== Notation
#T=============================
#T=The syntax for each command is given using the following notation.
#T=(notation    ::    definition).
#T= 
#T="stuff"    ::    the word stuff
#T=x y    ::    x followed by y
#T=(x | y)    ::    x or y
#T=[x]    ::    optional x
#T=subset("...")    ::    any letters from the string, in any order
#T=perm("...")    ::    all the letters from the string, in any order
#T=*x    ::    x may contain wildcards * and ? (and often comma-separated list)
#T=x := y    ::    x is defined to be y
#T=COMMAND    ::    the command under discussion
#T= 
#T=In addition, I use the following names for different types of argument. 
#T=char    ::    a single character
#T=string    ::    a string
#T=digit    ::    a digit
#T=number    ::    a non-negative integer (i.e. a string of digits)
#T=real    ::    a non-negative real number
#T=regexp    ::    a POSIX extended regular expression
#T=file    ::    a filename within your server's filespace; e.g. /index.html
#T=localfile    ::    a filename within your system's filespace; e.g. /usr/local/analog.html
#T=localfmtfile    ::    as localfile, but may contain date codes; e.g. /usr/local/analog%y%M.html
#T=referrer    ::    a URL of a referring page; e.g. http://search.yahoo.com/
#T=URL    ::    a URL which may be absolute, or relative to the output page; e.g. images/ or /~fred/images/ or http://www.fred.com/images/
#T= 
#T=Remember that an argument which contains a hash or a space must be put in quotes or parentheses. 

#T=============================
#T== Input and output files
#T=============================
#T=LOGFILE
LOGFILE (^!*localfile | "-" | "none") [prefix_string] 
#T=OUTFILE
OUTFILE (^!localfmtfile | "-" | "none") 
#T=CACHEFILE
CACHEFILE (^!*localfile | "-" | "none") 
#T=CACHEOUTFILE
CACHEOUTFILE (^!localfmtfile | "-" | "none") 
#T=UNCOMPRESS
UNCOMPRESS ^!*localfile program 
#T=- Examples 
#T=    LOGFILE /httpd/logs/* 
#T=    LOGFILE c:\logs\log1,c:\logs\log2 
#T=    OUTFILE "Hard Disk:Report%Y%M.html" 
#T=    UNCOMPRESS *.gz "/usr/bin/gzip -cd"

#T=============================
#T== LOGFORMAT commands
#T=============================
#T=format_string := (see documentation)
#T=Apache_format_string := (see Apache documentation)
#T=logformat := ("COMMON" | "COMBINED" | "REFERRER" | "BROWSER" | "EXTENDED" |
#T=               "MICROSOFT-NA" | "MICROSOFT-INT" | "WEBSITE-NA" | "WEBSITE-INT" |
#T=               "MS-EXTENDED" | "MS-COMMON" | "NETSCAPE" | "WEBSTAR" | "AUTO" |
#T=               format_string)
#T=LOGFORMAT
LOGFORMAT ^!logformat
#T=DEFAULTLOGFORMAT
DEFAULTLOGFORMAT ^!logformat
#T=APACHELOGFORMAT
APACHELOGFORMAT ^!Apache_format_string
#T=APACHEDEFAULTLOGFORMAT
APACHEDEFAULTLOGFORMAT ^!Apache_format_string
#T=- Notes 
#T=    LOGFORMAT and APACHELOGFORMAT only affect logfiles occurring later in the same configuration file. 
#T=- Examples 
#T=    LOGFORMAT (%S - %u [%d/%M/%Y:%h:%n:%j %j] "%j %r %j" %c %b) 
#T=    DEFAULTLOGFORMAT MS-EXTENDED 
#T=    APACHELOGFORMAT (%h %l %u %t \"%r\" %s %b) 

#T=============================
#T== ALIAS commands
#T=============================
#T=1. Commands (items) 
#T=FILEALIAS
FILEALIAS ^!
#T=HOSTALIAS
HOSTALIAS ^!
#T=BROWALIAS
BROWALIAS ^!
#T=REFALIAS
REFALIAS ^!
#T=USERALIAS
USERALIAS ^!
#T=VHOSTALIAS
VHOSTALIAS ^!
#T=- Syntax 
#T=    COMMAND *olditem newitem 
#T=    COMMAND ("REGEXP:" | "REGEXPI:")regexp newitem 
#T=- Notes 
#T=    Aliases item in all reports. Items with the same resultant name are combined. newitem may contain $1, $2 etc., representing the *'s in olditem or the bracketed subexpressions in regexp. Regular expressions are only available on some platforms. 
#T=- Examples 
#T=    FILEALIAS /*/football/* /$1/soccer/$2 
#T=    USERALIAS REGEXP:^([^U].*) U$1 
#T=--------------------------------------------------------
#T=2. Commands (reports) 
#T=TYPEOUTPUTALIAS
TYPEOUTPUTALIAS ^!
#T=HOSTOUTPUTALIAS
HOSTOUTPUTALIAS ^!
#T=REQOUTPUTALIAS
REQOUTPUTALIAS ^!
#T=REDIROUTPUTALIAS
REDIROUTPUTALIAS ^!
#T=FAILOUTPUTALIAS
FAILOUTPUTALIAS ^!
#T=DIROUTPUTALIAS
DIROUTPUTALIAS ^!
#T=DOMOUTPUTALIAS
DOMOUTPUTALIAS ^!
#T=ORGOUTPUTALIAS
ORGOUTPUTALIAS ^!
#T=REFOUTPUTALIAS
REFOUTPUTALIAS ^!
#T=REFSITEOUTPUTALIAS
REFSITEOUTPUTALIAS ^!
#T=REDIRREFOUTPUTALIAS
REDIRREFOUTPUTALIAS ^!
#T=FAILREFOUTPUTALIAS
FAILREFOUTPUTALIAS ^!
#T=BROWOUTPUTALIAS
BROWOUTPUTALIAS ^!
#T=FULLBROWOUTPUTALIAS
FULLBROWOUTPUTALIAS ^!
#T=OSOUTPUTALIAS
OSOUTPUTALIAS ^!
#T=VHOSTOUTPUTALIAS
VHOSTOUTPUTALIAS ^!
#T=USEROUTPUTALIAS
USEROUTPUTALIAS ^!
#T=FAILUSEROUTPUTALIAS
FAILUSEROUTPUTALIAS ^!
#T=- Syntax 
#T=    COMMAND *item string 
#T=    COMMAND ("REGEXP:" | "REGEXPI:")regexp string 
#T=- Notes 
#T=    Aliases item on one line of one report only. string may contain $1, $2 etc., representing the *'s in item or the bracketed subexpressions in regexp. Regular expressions are only available on some platforms. 
#T=- Examples 
#T=    REQOUTPUTALIAS /football/ "/football/ (Main football page)" 
#T=    REFOUTPUTALIAS REGEXP:^(http://([^/]*\.)?(maths|stats)\.uxy\.edu.*) ([$3] $1) 
#T=--------------------------------------------------------
#T=3. Other commands: syntax 
#T=CASE
CASE (^!"SENSITIVE" | "INSENSITIVE") 
#T=USERCASE
USERCASE (^!"SENSITIVE" | "INSENSITIVE") 
#T=SEARCHCHARCONVERT
SEARCHCHARCONVERT (^!"ON" | "OFF") 
#T=DIRSUFFIX
DIRSUFFIX ^!suffix 
#T=LOGTIMEOFFSET
LOGTIMEOFFSET [^!"+" | "-"] number 
#T=TIMEOFFSET
TIMEOFFSET [^!"+" | "-"] number 
#T=- Examples 
#T=    CASE SENSITIVE 
#T=    DIRSUFFIX index.htm 
#T=    LOGTIMEOFFSET -300 

#T=============================
#T== INCLUDE/EXCLUDE commands
#T=============================
#T=1. Commands (items) 
#T=FILEINCLUDE
FILEINCLUDE ^!
#T=FILEEXCLUDE
FILEEXCLUDE ^!
#T=HOSTINCLUDE
HOSTINCLUDE ^!
#T=HOSTEXCLUDE
HOSTEXCLUDE ^!
#T=BROWINCLUDE
BROWINCLUDE ^!
#T=BROWEXCLUDE
BROWEXCLUDE ^!
#T=REFINCLUDE
REFINCLUDE ^!
#T=REFEXCLUDE
REFEXCLUDE ^!
#T=USERINCLUDE
USERINCLUDE ^!
#T=USEREXCLUDE
USEREXCLUDE ^!
#T=VHOSTINCLUDE
VHOSTINCLUDE ^!
#T=VHOSTEXCLUDE
VHOSTEXCLUDE ^!
#T=- Syntax 
#T=    COMMAND (*item | "") 
#T=    COMMAND ("REGEXP:" | "REGEXPI:")regexp 
#T=- Notes 
#T=    Excludes all logfile entries containing an excluded item from all reports. Includes and excludes are done after aliases, so the item is the aliased name, if applicable. Regular expressions are only available on some platforms. 
#T=- Examples 
#T=    FILEINCLUDE /jim/* 
#T=    FILEINCLUDE REGEXP:^/~[^/]*/$ 
#T=    HOSTEXCLUDE proxy*.aol.com 
#T=    USEREXCLUDE "" 
#T=--------------------------------------------------------
#T=2. Syntax (including and excluding dates) 
#T=partdate := ["+" | "-"] digit digit 
#T=date := partdate partdate partdate [":" partdate partdate] 
#T=FROM
FROM ^!date
#T=TO
TO ^!date
#T=- Examples 
#T=    FROM 990719:1200 
#T=    TO -00-0101 
#T=--------------------------------------------------------
#T=3. Commands (reports) 
#T=REQINCLUDE
REQINCLUDE ^!
#T=REQEXCLUDE
REQEXCLUDE ^!
#T=REDIRINCLUDE
REDIRINCLUDE ^!
#T=REDIREXCLUDE
REDIREXCLUDE ^!
#T=FAILINCLUDE
FAILINCLUDE ^!
#T=FAILEXCLUDE
FAILEXCLUDE ^!
#T=TYPEINCLUDE
TYPEINCLUDE ^!
#T=TYPEEXCLUDE
TYPEEXCLUDE ^!
#T=DIRINCLUDE
DIRINCLUDE ^!
#T=DIREXCLUDE
DIREXCLUDE ^!
#T=HOSTREPINCLUDE
HOSTREPINCLUDE ^!
#T=HOSTREPEXCLUDE
HOSTREPEXCLUDE ^!
#T=DOMINCLUDE
DOMINCLUDE ^!
#T=DOMEXCLUDE
DOMEXCLUDE ^!
#T=ORGINCLUDE
ORGINCLUDE ^!
#T=ORGEXCLUDE
ORGEXCLUDE ^!
#T=REFREPINCLUDE
REFREPINCLUDE ^!
#T=REFREPEXCLUDE
REFREPEXCLUDE ^!
#T=REFSITEINCLUDE
REFSITEINCLUDE ^!
#T=REFSITEEXCLUDE
REFSITEEXCLUDE ^!
#T=SEARCHQUERYINCLUDE
SEARCHQUERYINCLUDE ^!
#T=SEARCHQUERYEXCLUDE
SEARCHQUERYEXCLUDE ^!
#T=SEARCHWORDINCLUDE
SEARCHWORDINCLUDE ^!
#T=SEARCHWORDEXCLUDE
SEARCHWORDEXCLUDE ^!
#T=REDIRREFINCLUDE
REDIRREFINCLUDE ^!
#T=REDIRREFEXCLUDE
REDIRREFEXCLUDE ^!
#T=FAILREFINCLUDE
FAILREFINCLUDE ^!
#T=FAILREFEXCLUDE
FAILREFEXCLUDE ^!
#T=BROWSUMINCLUDE
BROWSUMINCLUDE ^!
#T=BROWSUMEXCLUDE
BROWSUMEXCLUDE ^!
#T=FULLBROWINCLUDE
FULLBROWINCLUDE ^!
#T=FULLBROWEXCLUDE
FULLBROWEXCLUDE ^!
#T=OSINCLUDE
OSINCLUDE ^!
#T=OSEXCLUDE
OSEXCLUDE ^!
#T=VHOSTREPINCLUDE
VHOSTREPINCLUDE ^!
#T=VHOSTREPEXCLUDE
VHOSTREPEXCLUDE ^!
#T=USERREPINCLUDE
USERREPINCLUDE ^!
#T=USERREPEXCLUDE
USERREPEXCLUDE ^!
#T=FAILUSERINCLUDE
FAILUSERINCLUDE ^!
#T=FAILUSEREXCLUDE
FAILUSEREXCLUDE ^!
#T=- Syntax 
#T=    COMMAND *item 
#T=    COMMAND ("REGEXP:" | "REGEXPI:")regexp 
#T=- Notes 
#T=    Excludes an excluded item from one report only. Regular expressions are only available on some platforms. 
#T=Example 
#T=    REQINCLUDE pages 
#T=--------------------------------------------------------
#T=4. Syntax (miscellaneous) 
#T=PAGEINCLUDE
PAGEINCLUDE ^!*file
#T=PAGEEXCLUDE
PAGEEXCLUDE ^!*file 
#T=ARGSINCLUDE
ARGSINCLUDE ^!*file 
#T=ARGSEXCLUDE
ARGSEXCLUDE ^!*file 
#T=REFARGSINCLUDE
REFARGSINCLUDE ^!*referrer 
#T=REFARGSEXCLUDE
REFARGSEXCLUDE ^!*referrer 
#T=- Notes 
#T=    These can be regular expressions too, on suitable platforms. 
#T=Example 
#T=    PAGEINCLUDE *.asp 

#T=============================
#T== DNS commands
#T=============================
#T=- Syntax 
#T=DNSFILE
DNSFILE ^!localfile 
#T=DNS
DNS (^!"NONE" | "READ" | "LOOKUP" | "WRITE") 
#T=DNSLOCKFILE
DNSLOCKFILE ^!localfile 
#T=DNSGOODHOURS
DNSGOODHOURS ^!number 
#T=DNSBADHOURS
DNSBADHOURS ^!number 
#T=- Examples 
#T=    DNSFILE dnscache.txt 
#T=    DNS WRITE 
#T=    DNSBADHOURS 48 

#T=============================
#T== Sub-item commands
#T=============================
#T=- Syntax 
#T=SUBDIR
SUBDIR ^!*file 
#T=SUBDOMAIN
SUBDOMAIN ^!*subdomain 
#T=SUBORG
SUBORG ^!*subdomain 
#T=SUBTYPE
SUBTYPE ^!*extension 
#T=SUBBROW
SUBBROW ^!*browser 
#T=REFDIR
REFDIR ^!*referrer 
#T=- Examples 
#T=    SUBDIR /jim/*/* 
#T=    SUBTYPE *.gz 

#T=============================
#T== LOWMEM commands
#T=============================
#T=Commands 
#T=FILELOWMEM
FILELOWMEM ^!
#T=HOSTLOWMEM
HOSTLOWMEM ^!
#T=BROWLOWMEM
BROWLOWMEM ^!
#T=REFLOWMEM
REFLOWMEM ^!
#T=USERLOWMEM
USERLOWMEM ^!
#T=VHOSTLOWMEM
VHOSTLOWMEM ^!
#T=- Syntax 
#T=    COMMAND ("0" | "1" | "2" | "3") 
#T=Example 
#T=    HOSTLOWMEM 3 

#T=============================
#T== Report commands
#T=============================
#T=Commands 
#T=GENERAL
GENERAL ^!
#T=ALL
ALL ^!
#T=MONTHLY
MONTHLY ^!
#T=WEEKLY
WEEKLY ^!
#T=FULLDAILY
FULLDAILY ^!
#T=DAILY
DAILY ^!
#T=FULLHOURLY
FULLHOURLY ^!
#T=HOURLY
HOURLY ^!
#T=QUARTER
QUARTER ^!
#T=FIVE
FIVE ^!
#T=HOST
HOST ^!
#T=ORGANISATION
ORGANISATION ^!
#T=DOMAIN
DOMAIN ^!
#T=REQUEST
REQUEST ^!
#T=DIRECTORY
DIRECTORY ^!
#T=FILETYPE
FILETYPE ^!
#T=SIZE
SIZE ^!
#T=PROCTIME
PROCTIME ^!
#T=REDIR
REDIR ^!
#T=FAILURE
FAILURE ^!
#T=REFERRER
REFERRER ^!
#T=REFSITE
REFSITE ^!
#T=SEARCHQUERY
SEARCHQUERY ^!
#T=SEARCHWORD
SEARCHWORD ^!
#T=REDIRREF 
REDIRREF ^!
#T=FAILREF
FAILREF ^!
#T=FULLBROWSER
FULLBROWSER ^!
#T=BROWSER
BROWSER ^!
#T=OSREP
OSREP ^!
#T=VHOST
VHOST ^!
#T=USER
USER ^!
#T=FAILUSER
FAILUSER ^!
#T=STATUS
STATUS ^!
#T=- Syntax 
#T=    REPORTCOMMAND ("ON" | "OFF") 
#T=- Examples 
#T=    ALL OFF 
#T=    FULLHOURLY ON 

#T=============================
#T== GRAPH commands
#T=============================
#T=Commands 
#T=ALLGRAPH
ALLGRAPH ^!
#T=MONTHGRAPH
MONTHGRAPH ^!
#T=WEEKGRAPH
WEEKGRAPH ^!
#T=DAYGRAPH
DAYGRAPH ^!
#T=FULLDAYGRAPH
FULLDAYGRAPH ^!
#T=HOURGRAPH
HOURGRAPH ^!
#T=FULLHOURGRAPH
FULLHOURGRAPH ^!
#T=QUARTERGRAPH
QUARTERGRAPH ^!
#T=FIVEGRAPH
FIVEGRAPH ^!
#T=- Syntax 
#T=    COMMAND ("R" | "r" | "P" | "p" | "B" | "b") 
#T=Example 
#T=    ALLGRAPH B 

#T=============================
#T== BACK commands
#T=============================
#T=Commands 
#T=ALLBACK
ALLBACK ^!
#T=MONTHBACK
MONTHBACK ^!
#T=WEEKBACK
WEEKBACK ^!
#T=FULLDAYBACK
FULLDAYBACK ^!
#T=FULLHOURBACK
FULLHOURBACK ^!
#T=QUARTERBACK
QUARTERBACK ^!
#T=FIVEBACK
FIVEBACK  ^!
#T=- Syntax 
#T=    COMMAND ("ON" | "OFF") 
#T=Example 
#T=    ALLBACK ON 

#T=============================
#T== ROWS commands
#T=============================
#T=Commands 
#T=MONTHROWS
MONTHROWS ^!
#T=WEEKROWS
WEEKROWS ^!
#T=FULLDAYROWS
FULLDAYROWS ^!
#T=FULLHOURROWS
FULLHOURROWS ^!
#T=QUARTERROWS
QUARTERROWS ^!
#T=FIVEROWS
FIVEROWS ^!
#T=- Syntax 
#T=    COMMAND number 
#T=Example 
#T=    QUARTERROWS 192 
#T=============================
#T== COLS commands
#T=============================
#T=1. Commands (time reports) 
#T=TIMECOLS
TIMECOLS ^!
#T=MONTHCOLS
MONTHCOLS ^!
#T=WEEKCOLS
WEEKCOLS ^!
#T=DAYCOLS
DAYCOLS ^!
#T=FULLDAYCOLS
FULLDAYCOLS ^!
#T=HOURCOLS
HOURCOLS ^!
#T=FULLHOURCOLS
FULLHOURCOLS ^!
#T=QUARTERCOLS
QUARTERCOLS ^!
#T=FIVECOLS
FIVECOLS ^!
#T=- Syntax 
#T=    cols1 := subset("RrPpBb") 
#T=    COMMAND cols1 
#T=Example 
#T=    MONTHCOLS bRP
#T=--------------------------------------------------------
#T=2. Commands (most success reports) 
#T=HOSTCOLS
HOSTCOLS ^!
#T=ORGCOLS
ORGCOLS ^!
#T=DOMCOLS
DOMCOLS ^!
#T=DIRCOLS
DIRCOLS ^!
#T=REFCOLS
REFCOLS ^!
#T=REFSITECOLS
REFSITECOLS ^!
#T=SEARCHQUERYCOLS
SEARCHQUERYCOLS ^!
#T=SEARCHWORDCOLS
SEARCHWORDCOLS ^!
#T=FULLBROWCOLS
FULLBROWCOLS ^!
#T=BROWCOLS
BROWCOLS ^!
#T=OSCOLS
OSCOLS ^!
#T=VHOSTCOLS
VHOSTCOLS ^!
#T=USERCOLS
USERCOLS ^!
#T=- Syntax 
#T=    cols2 := subset("NDRrPpBb") 
#T=    COMMAND cols2 
#T=Example 
#T=    USERCOLS BD 
#T=--------------------------------------------------------
#T=3. Commands (Request and File Type Reports) 
#T=REQCOLS
REQCOLS ^!
#T=TYPECOLS 
TYPECOLS ^!
#T=- Syntax 
#T=    cols3 := subset("NDRrpBb") 
#T=    COMMAND cols3 
#T=Example 
#T=    TYPECOLS NRb 
#T=--------------------------------------------------------
#T=4. Commands (failure, redirection and Status Code reports) 
#T=REDIRCOLS
REDIRCOLS ^!
#T=FAILCOLS
FAILCOLS ^!
#T=REDIRREFCOLS
REDIRREFCOLS ^!
#T=FAILREFCOLS
FAILREFCOLS ^!
#T=FAILUSERCOLS
FAILUSERCOLS ^!
#T=STATUSCOLS
STATUSCOLS ^!
#T=- Syntax 
#T=    cols4 := subset("NDRr") 
#T=    COMMAND cols4 
#T=Example 
#T=    FAILCOLS D 
#T=--------------------------------------------------------
#T=5. Commands (Size and Processing Time Reports) 
#T=SIZECOLS
SIZECOLS ^!
#T=PROCTIMECOLS
PROCTIMECOLS ^!
#T=- Syntax 
#T=    cols5 := subset("DRrPpBb") 
#T=    COMMAND cols5 
#T=Example 
#T=    SIZECOLS RB 

#T=============================
#T== SORTBY commands
#T=============================
#T=1. Commands (most success reports) 
#T=HOSTSORTBY
HOSTSORTBY ^!
#T=ORGSORTBY
ORGSORTBY ^!
#T=DOMSORTBY
DOMSORTBY ^!
#T=DIRSORTBY
DIRSORTBY ^!
#T=REFSORTBY
REFSORTBY ^!
#T=REFSITESORTBY
REFSITESORTBY ^!
#T=SEARCHQUERYSORTBY
SEARCHQUERYSORTBY ^!
#T=SEARCHWORDSORTBY
SEARCHWORDSORTBY ^!
#T=FULLBROWSORTBY
FULLBROWSORTBY ^!
#T=BROWSORTBY
BROWSORTBY ^!
#T=OSSORTBY
OSSORTBY ^!
#T=VHOSTSORTBY
VHOSTSORTBY ^!
#T=USERSORTBY
USERSORTBY ^!
#T=SUBDIRSORTBY
SUBDIRSORTBY ^!
#T=SUBDOMSORTBY
SUBDOMSORTBY ^!
#T=SUBORGSORTBY
SUBORGSORTBY ^!
#T=SUBBROWSORTBY
SUBBROWSORTBY ^!
#T=SUBOSSORTBY
SUBOSSORTBY ^!
#T=REFDIRSORTBY
REFDIRSORTBY ^!
#T=REFARGSSORTBY
REFARGSSORTBY ^!
#T=- Syntax 
#T=    sortby1 := ("REQUESTS" | "PAGES" | "BYTES" | "DATE" | "ALPHABETICAL" | "RANDOM") 
#T=    COMMAND sortby1 
#T=Example 
#T=    DOMSORTBY ALPHABETICAL 
#T=--------------------------------------------------------
#T=2. Commands (Request and File Type Reports) 
#T=REQSORTBY
REQSORTBY ^!
#T=TYPESORTBY
TYPESORTBY ^!
#T=REQARGSSORTBY
REQARGSSORTBY ^!
#T=SUBTYPESORTBY
SUBTYPESORTBY ^!
#T=- Syntax 
#T=    sortby2 := ("REQUESTS" | "BYTES" | "DATE" | "ALPHABETICAL" | "RANDOM") 
#T=    COMMAND sortby2 
#T=Example 
#T=    REQSORTBY REQUESTS 
#T=--------------------------------------------------------
#T=3. Commands (failure, redirection and Status Code reports) 
#T=REDIRSORTBY
REDIRSORTBY ^!
#T=FAILSORTBY 
FAILSORTBY ^!
#T=REDIRREFSORTBY
REDIRREFSORTBY ^!
#T=FAILREFSORTBY
FAILREFSORTBY ^!
#T=FAILUSERSORTBY
FAILUSERSORTBY ^!
#T=STATUSSORTBY
STATUSSORTBY ^!
#T=REDIRARGSSORTBY
REDIRARGSSORTBY ^!
#T=FAILARGSSORTBY
FAILARGSSORTBY ^!
#T=REDIRREFARGSSORTBY
REDIRREFARGSSORTBY ^!
#T=FAILREFARGSSORTBY
FAILREFARGSSORTBY ^!
#T=- Syntax 
#T=    sortby3 := ("REQUESTS" | "DATE" | "ALPHABETICAL" | "RANDOM") 
#T=    COMMAND sortby3 
#T=Example 
#T=    FAILSORTBY DATE 

#T=============================
#T== FLOOR commands
#T=============================
#T=Commands (top-level) 
#T=HOSTFLOOR
HOSTFLOOR ^!
#T=ORGFLOOR
ORGFLOOR ^!
#T=DOMFLOOR
DOMFLOOR ^!
#T=REQFLOOR
REQFLOOR ^!
#T=DIRFLOOR
DIRFLOOR ^!
#T=TYPEFLOOR
TYPEFLOOR ^!
#T=REDIRFLOOR
REDIRFLOOR ^!
#T=FAILFLOOR
FAILFLOOR ^!
#T=REFFLOOR
REFFLOOR ^!
#T=REFSITEFLOOR
REFSITEFLOOR ^!
#T=SEARCHQUERYFLOOR
SEARCHQUERYFLOOR ^!
#T=SEARCHWORDFLOOR
SEARCHWORDFLOOR ^!
#T=REDIRREFFLOOR
REDIRREFFLOOR ^!
#T=FAILREFFLOOR
FAILREFFLOOR ^!
#T=FULLBROWFLOOR
FULLBROWFLOOR ^!
#T=BROWFLOOR
BROWFLOOR ^!
#T=OSFLOOR
OSFLOOR ^!
#T=VHOSTFLOOR
VHOSTFLOOR ^!
#T=USERFLOOR
USERFLOOR ^!
#T=FAILUSERFLOOR
FAILUSERFLOOR ^!
#T=STATUSFLOOR
STATUSFLOOR ^!
#T=--------------------------------------------------------
#T=Commands (lower levels) 
#T=REQARGSFLOOR
REQARGSFLOOR ^!
#T=REDIRARGSFLOOR
REDIRARGSFLOOR ^!
#T=FAILARGSFLOOR
FAILARGSFLOOR ^!
#T=REFARGSFLOOR
REFARGSFLOOR ^!
#T=REDIRREFARGSFLOOR
REDIRREFARGSFLOOR ^!
#T=FAILREFARGSFLOOR
FAILREFARGSFLOOR ^!
#T=SUBDIRFLOOR
SUBDIRFLOOR ^!
#T=SUBDOMFLOOR
SUBDOMFLOOR ^!
#T=SUBORGFLOOR
SUBORGFLOOR ^!
#T=SUBTYPEFLOOR
SUBTYPEFLOOR ^!
#T=SUBBROWFLOOR
SUBBROWFLOOR ^!
#T=SUBOSFLOOR
SUBOSFLOOR ^!
#T=REFDIRFLOOR
REFDIRFLOOR ^!
#T=- Syntax 
#T=    partdate := ["+" | "-"] digit digit 
#T=    date := partdate partdate partdate [":" partdate partdate] 
#T=    COMMAND number ("r" | "p") 
#T=    COMMAND number ["k" | "M" | "G" | "T"] "b" 
#T=    COMMAND real ("%" | ":") ("r" | "p" | "b") 
#T=    COMMAND date "d" 
#T=    COMMAND "-" number ("r" | "p" | "b" | "d") 
#T=- Notes 
#T=    Actually, this syntax isn't quite correct. REQFLOOR, TYPEFLOOR, REQARGSFLOOR and SUBTYPEFLOOR aren't allowed to be of type "p"; and REDIRFLOOR, FAILFLOOR, REDIRREFFLOOR, FAILREFFLOOR, FAILUSERFLOOR, STATUSFLOOR, REDIRARGSFLOOR, FAILARGSFLOOR, REDIRREFARGSFLOOR and FAILREFARGSFLOOR aren't allowed to be of types "p" or "b". 
#T=- Examples 
#T=    TYPEFLOOR -20r 
#T=    REQARGSFLOOR 0.1%b 

#T=============================
#T== Hyperlink Commands
#T=============================
#T=- Syntax 
#T=LINKINCLUDE
LINKINCLUDE ^!*file 
#T=LINKEXCLUDE
LINKEXCLUDE ^!*file 
#T=REFLINKINCLUDE
REFLINKINCLUDE ^!*referrer 
#T=REFLINKEXCLUDE
REFLINKEXCLUDE ^!*referrer 
#T=BASEURL
BASEURL ^!prefix_string 
#T=- Examples 
#T=    LINKINCLUDE pages 
#T=    REFLINKINCLUDE *.cgi 
#T=    BASEURL http://www.mycompany.com 

#T=============================
#T== Language commands
#T=============================
#T=- Syntax 
#T=    LANGUAGE ("ARMENIAN" | "BOSNIAN" | "CATALAN" | "SIMP-CHINESE" |
#T=            "TRAD-CHINESE" | "CZECH" | "DANISH" | "DUTCH" | "ENGLISH" |
#T=            "US-ENGLISH" | "FINNISH" | "FRENCH" | "GERMAN" | "GREEK" |
#T=            "ITALIAN" | "JAPANESE" | "NORWEGIAN" | "NYNORSK" | "POLISH" |
#T=            "PORTUGUESE" | "BR-PORTUGUESE" | "RUSSIAN" | "SERBIAN" | "SLOVAK" |
#T=            "SLOVENE" | "SPANISH" | "SWEDISH" | "TURKISH" | "UKRAINIAN")
#T=LANGFILE
LANGFILE ^!localfile
#T=DOMAINSFILE
DOMAINSFILE ^!localfile
#T=- Notes 
#T=    Other languages were available in version 3 of analog, and should be available for version 4 soon. 
#T=- Examples 
#T=    LANGUAGE ITALIAN 
#T=    LANGFILE lang/hindi.lng 

#T=============================
#T== Cosmetic & misc commands
#T=============================
#T=- Syntax 
#T=OUTPUT
OUTPUT (^!"HTML" | "ASCII" | "COMPUTER" | "NONE") 
#T=GOTOS
GOTOS (^!"ON" | "OFF" | "FEW") 
#T=RUNTIME
RUNTIME (^!"ON" | "OFF") 
#T=LASTSEVEN
LASTSEVEN (^!"ON" | "OFF") 
#T=REPORTORDER
REPORTORDER perm("^!xcmdDhH45WriSoEItzsfKkuJvbB") 
#T=IMAGEDIR
IMAGEDIR URL 
#T=NOROBOTS
NOROBOTS (^!"ON" | "OFF") 
#T=LOGO
LOGO (^!URL | "none") 
#T=HOSTNAME
HOSTNAME ^!string 
#T=HOSTURL
HOSTURL (^!URL | "none") 
#T=HEADERFILE
HEADERFILE (^!localfile | "none") 
#T=FOOTERFILE
FOOTERFILE (^!localfile | "none") 
#T=STYLESHEET
STYLESHEET (^!URL | "none") 
#T=SEPCHAR
SEPCHAR (^!char | "none") 
#T=REPSEPCHAR
REPSEPCHAR (^!char | "none") 
#T=DECPOINT
DECPOINT ^!char 
#T=COMPSEP
COMPSEP ^!string 
#T=RAWBYTES
RAWBYTES (^!"ON" | "OFF") 
#T=HTMLPAGEWIDTH
HTMLPAGEWIDTH ^!number 
#T=ASCIIPAGEWIDTH
ASCIIPAGEWIDTH ^!number 
#T=BARSTYLE
BARSTYLE (^!"a" | "b" | "c" | "d" | "e" | "f" | "g" | "h") 
#T=MARKCHAR
MARKCHAR ^!char 
#T=MINGRAPHWIDTH
MINGRAPHWIDTH ^!number 
#T=WEEKBEGINSON
WEEKBEGINSON (^!"SUNDAY" | "MONDAY" | "TUESDAY" | "WEDNESDAY" | "THURSDAY" | "FRIDAY" | "SATURDAY") 
#T=SEARCHENGINE
SEARCHENGINE ^!*referrer comma-separated-strings 
#T=- Examples 
#T=    Too many to list. See the documentation on each individual command. 

#T=============================
#T== Diagnostics
#T=============================
#T=- Syntax 
#T=SETTINGS
SETTINGS (^!"ON" | "OFF") 
#T=DEBUG
DEBUG (^!"ON" | "OFF" | ["+" | "-"] subset("CDFSU")) 
#T=WARNINGS
WARNINGS (^!"ON" | "OFF" | ["+" | "-"] subset("CDEFLMR")) 
#T=PROGRESSFREQ
PROGRESSFREQ ^!number 
#T=ERRFILE
ERRFILE ^!localfile 
#T=ERRLINELENGTH
ERRLINELENGTH ^!number 
#T=- Examples 
#T=    DEBUG ON 
#T=    DEBUG CF 
#T=    WARNINGS -DL 
#T=    PROGRESSFREQ 50000
#