#TITLE=AutoIt Script Commands
#INFO
EditPlus cliptext library file for AutoIt 2.60
Cliptext file written by Brett Pantalone
AutoIt (C)1999 - 2001 Jonathan Bennett

#SORT=y

#T=AdlibOn
AdlibOn
#T=AdlibOff
AdlibOff
#T=BlockInput
BlockInput, <on | off>
#T=Break
Break, <on | off>
#T=DetectHiddenText
DetectHiddenText, <on | off>
#T=EndRepeat
EndRepeat
#T=EnvAdd
EnvAdd, <Variable>, <Value>
#T=EnvDiv
EnvDiv, <Variable>, <Value>
#T=EnvMult
EnvMult, <Variable>, <Value>
#T=EnvSub
EnvSub, <Variable>, <Value>
#T=Exit
Exit [,<exit code>]
#T=FileAppend
FileAppend, <Text>, <Filename>
#T=FileReadLine
FileReadLine, <Variable>, <Filename>, <Line>
#T=FileSelectFile
FileSelectFile, <Filename Var>, <1 | 0> [,<Working Directory>]
#T=Gosub
Gosub,<label>^!
Return
#T=Goto
Goto, <label>
#T=HideAutoItWin
HideAutoItWin, <on | off>
#T=IfExist
IfExist, <file or directory>, <Command>
#T=IfNotExist
IfNotExist,<file or directory>,<Command>
#T=IfEqual
IfEqual, <variable>, <text>, <Command>
#T=IfNotEqual
IfNotEqual,<variable>, <text>, <Command>
#T=IfGreater
IfGreater, <variable>, <number>, <Command>
#T=IfGreaterOrEqual
IfGreaterOrEqual, <variable>, <number>, <Command>
#T=IfLess
IfLess, <variable>, <number>, <Command>
#T=IfLessOrEqual
IfLessOrEqual, <variable>, <number>, <Command>
#T=IfInString
IfInString, <String Variable>, <Search String>, <Command>
#T=IfNotInString
IfNotInString, <String Variable>, <Search String>, <Command>
#T=IfWinActive
IfWinActive, <Window Title>, [<Window Text>], <Command>
#T=IfWinNotActive
IfWinNotActive, <Window Title>, [<Window Text>], <Command>
#T=IfWinExist
IfWinExist, <Window Title>, [<Window Text>], <Command>
#T=IfWinNotExist
IfWinNotExist, <Window Title>, [<Window Text>], <Command>
#T=IfMsgBox
IfMsgBox, ^!<return value>, <Command>
;Return values: ABORT, CANCEL, IGNORE, NO, OK, RETRY, YES
#T=IniRead
IniRead,<variable>, <filename>, <section>, <key>
#T=IniWrite
IniWrite,<value>, <filename>, <section>, <key>
#T=IniDelete
IniDelete, <Filename>, <Section>, <Key>
#T=InputBox
InputBox, <variable>, <title>, <message> [,hide]
#T=LeftClick
LeftClick, <x>, <y>
#T=LeftClickDrag
LeftClickDrag, <x1>, <y1>, <x2>, <y2>
#T=MouseGetPos
MouseGetPos, <x Variable>, <y Variable>
#T=MouseMove
MouseMove, <x>, <y>
#T=MsgBox
MsgBox, <display mode>, <title>, <message>
#T=Random
Random, <Output Variable>, <Min Value>, <Max Value>
#T=RegRead
RegRead, <Variable>, <ValueType>, <RegKey>, <RegSubKey>, <ValueName>
#T=RegWrite
RegWrite, <ValueType>, <RegKey>, <RegSubKey>, <ValueName>, <Value>
#T=RegDelete
RegDelete, <RegKey>, <RegSubKey>, <ValueName>
#T=Repeat
Repeat, ^!<Count>
EndRepeat
#T=Return
Return
#T=RightClick
RightClick, <x>, <y>
#T=RightClickDrag
RightClickDrag, <x1>, <y1>, <x2>, <y2>
#T=Run
Run, <Program path and name> [,<Working directory> [,<max | min | hide>]]
#T=RunWait
RunWait, <Program path and name> [,<Working directory> [,<max | min | hide>]]
#T=Send
Send, ^!<Series of key presses>
;Modifiers: '!' ALT, '+' SHIFT, '^^' CONTROL, '#' delimiter
#T=SetBatchLines
SetBatchLines, <lines>
#T=SetEnv
SetEnv, <variable>, <value>
#T=SetKeyDelay
SetKeyDelay, <milliseconds>
#T=SetTitleMatchMode
SetTitleMatchMode, <mode>
#T=SetWinDelay
SetWinDelay, <Milliseconds>
#T=Shutdown
Shutdown, ^!<Flag>
;Flag: LogOff 0, Shutdown 1, Reboot 2, Force 4, Poweroff 8
#T=Sleep
Sleep, <milliseconds>
#T=SplashTextOn
SplashTextOn, <Width>, <Height>, <Title>, <Message>
#T=SplashTextOff
SplashTextOff
#T=StringCaseSense
StringCaseSense, <On | Off>
#T=StringGetPos
StringGetPos, <Output Variable> , <Input Variable>, <Search Text>
#T=StringLeft
StringLeft, <Output Variable> , <Input Variable>, <Number of chars to extract>
#T=StringRight
StringRight, <Output Variable> , <Input Variable>, <Number of chars to extract>
#T=StringMid
StringMid, <Output Variable> , <Input Variable>, <Start char>, <Number of chars to extract>
#T=StringLen
StringLen, <Output Variable> , <Input Variable>
#T=StringReplace
StringReplace, <Output Variable> , <Input Variable>, <Search String>, <Replace String>
#T=StringTrimLeft
StringTrimLeft, <Output Variable> , <Input Variable>, <Number of chars to trim>
#T=StringTrimRight
StringTrimRight, <Output Variable> , <Input Variable>, <Number of chars to trim>
#T=WinActivate
WinActivate, <Window Title> [,<Window Text>]
#T=WinClose
WinClose, <Window Title> [,<Window Text>]
#T=WinGetActiveStats
WinGetActiveStats, <Title Var>, <Width Var>, <Height Var>, <Xpos Var>, <Ypos Var>
#T=WinGetActiveTitle
WinGetActiveTitle, <Variable>
#T=WinKill
WinKill, <Window Title> [,<Window Text>]
#T=WinSetTitle
WinSetTitle, <Window Title>, [Window Text], <New Title>
#T=WinHide
WinHide, <Window Title> [,<Window Text>]
#T=WinShow
WinShow, <Window Title> [,<Window Text>]
#T=WinMove
WinMove, <Window Title>, [<Window Text>], <X>, <Y>, <Width>, <Height>
#T=WinMaximize
WinMaximize, <Window Title> [,<Window Text>]
#T=WinMinimize
WinMinimize, <Window Title> [,<Window Text>]
#T=WinMinimizeAll
WinMinimizeAll
#T=WinMinimizeAllUndo
WinMinimizeAllUndo
#T=WinRestore
WinRestore, <Window Title> [,<Window Text>]
#T=WinWait
WinWait, <Window Title> [,<Window Text> [,<Timeout>]]
#T=WinWaitActive
WinWaitActive, <Window Title> [,<Window Text> [,<Timeout>]]
#T=WinWaitNotActive
WinWaitNotActive, <Window Title> [,<Window Text> [,<Timeout>]]
#T=WinWaitClose
WinWaitClose, <Window Title> [,<Window Text> [,<Timeout>]]
#