#TITLE=DNS Stuff (Public DNS)
#INFO
Mainly based on requirements for www.granitecanyon.com - Free DNS Service
#SORT=n

#T=   GENERAL SETTINGS 
;;

#T=   Usage (inserted as comment)
;; REPLACE ALL OCCURENCES OF <domain> WITH YOUR DOMAIN, e.g. johndoe.com / tobeornotto.be
;; 

#T=A) NS - Define name servers
;; DEFINE DNS SERVERS
<domain>.  IN  NS ns1.granitecanyon.com.
<domain>.  IN  NS ns2.granitecanyon.com.

#T=B) RP - Editor info
;; THIS ALLOWS your.name@server.com TO CHANGE THE DNS (server.com is not same as <domain> !!)
<domain>. IN RP your.name.server.com. info.<domain>.

#T=C) TXT - Contact info
;; DNS CONTACT INFO
info.<domain>. IN TXT "Your name/telephone number/NIC Handle"

#T=_________________________
;;------------------------------------------

#T=   CNAME - WEB SERVERS 
;;

#T=1) Map localhost
;; MAP LOCALHOST
localhost.<domain>. IN A 127.0.0.1

#T=2) Define IP address
;; REPLACE WITH YOUR IP-ADDRESS
<domain>. IN  A 192.168.0.1
;; OR ftp.<domain>.  IN  A 192.168.0.99

#T=3) Create DNS aliases (single)
;; MAP A SUBDOMAIN XXX.<domain> ON ANOTHER DOMAIN
ftp.<domain>.  IN  CNAME  <domain>.
;; ftp.<domain>.  IN  CNAME  yyy.<domain>.
;; listbot.james.com. IN CNAME james.listbot.com. ; EXTREF

#T=4) Create DNS aliases (wildcard)
;; MAP ANY NON-DEFINED XXX.<domain>
*.<domain>. IN CNAME <domain>.; GLOBALOK

#T=5) Create DNS aliases (external)
;; MAP SUBDOMAIN ON EXTERNAL DOMAIN
ftp.<domain>. IN CNAME <otherdomain>.com.; EXTREF

#T=_________________________
;;------------------------------------------

#T=   MX - MAIL SERVERS 
;;

#T=1) Define IP address (if local)
;; MAIL SERVER CAN NOT BE CNAME (so IP address should be specified!)
mail.<domain>. IN  A  192.168.0.8

#T=2) Define DNS alias (single)
;; SEND ALL EMAIL @<domain> TO mail.<domain>
<domain>. IN  MX  10  mail.<domain>.
;; OR users.<domain>. IN MX 10 mail.<domain>

#T=3) Define DNS alias (wildcard)
;; SEND ALL EMAIL @xxx.<domain> TO mail.<domain>
*.<domain>.     IN  MX  10  mail.<domain>.	; GLOBALOK

#T=4) Define DNS alias (external)
;; THIS DEFINES AN EXTERNAL MAIL SERVER
<domain>. IN MX 10 <otherdomain>.net.; EXTREF
;; YOU CAN CREATE EXTERNAL WILDCARD ALIASES LIKE:
;; *.<domain>.     IN  MX  10 mail.uu.net.	; EXTREF GLOBALOK

#