//~ 2002 - Formatted by jFormat - jlbalder@netscape.net
/**
*   Formats the Named File from CommandLine,
*   (or from inside TextPad as per instructions),
*   and then automatically Saves the file over itself!
*
*   @author John L Balderston
*   @see jlbalder@netscape.net
*   @version 2219
*
*   Copyright  2002 John L Balderston.  All rights reserved.
*   It is provided AS-IS, WITHOUT ANY WARRANTY either expressed or implied.
*   You may study, use, and modify it for any non-commercial purpose.
*   You may distribute it non-commercially as long as you retain this notice.
*
*   --+-- TextPad SETINGS --+-- TextPad SETINGS --+-- TextPad SETINGS --+--
*   CLASSPATH=.;C:\jlbalder\jFormat.jar     //Verify this is your EXACT path!
*   Command = C:\jdk1.3\bin\java.exe        //Verify this is your EXACT path!
*   Parameters = jFormat $File              //Same on ALL machines
*   Initial_Folder = $FileDir
*   DOS_Command = CHECKED
*  From DOS CommandLine, Navigate to subDir where *.java file located.
*  Then issue command;
*  java jFormat C:\subDir\absolutePathTo\FileName.java
*  java jFormat C:\MyAppsJV\jFormat\LogRkiverX.java
*
*  FROM TEXTPAD USING PASSED PARAMETERS:
*  In Configure|Preferences|Tools|RunJavaApplication
*     CHECKBOX Prompt for Parameters = CHECKED, Then Click OK
*  Then Ctrl+2, In Parameters INPUT_TEXTFIELD add *.java filename,
*     so it looks something like below.
*        jFormat C:\MyAppsJV\jFormat\LogRkiverX.java
*  or    jFormat C:\MyAppsJV\jFormat\jFileFormat2.java -c -t 4
*

*   --+-- EditPlus SETINGS --+-- EditPlus SETINGS --+-- EditPlus SETINGS --+--
* Suppose you are adding it in Tool->UserToolGroups->Group2 
* open tool.ini file which is in your EditPlus installation directory
* for default installation of EditPlus this directory is C:\Program Files\EditPlus 2

* ----------  Add following lines in your tool.ini file ------------
* [Tools\1\0]
* Text=Format Source
* Command=C:\j2sdk1.4.0\bin\java.exe
* Argument= -classpath .;C:\PROGRA~1\EDITPL~1\JFORMAT.JAR jFormat $(FileName) -d
* InitDir=$(FileDir)
* RedirOut=0
* Prompt=0
* Plugin=0
* Pattern=0
* Pattern Regex=
* Close=0
* Help=0
* -------------------------------------------------------------------
* Put jFormat.jar in C:\Program Files\EditPlus2  directory
*   --+-- EditPlus SETINGS --+-- EditPlus SETINGS --+-- EditPlus SETINGS --+--

*  There are some USER PREFERENCE VARIABLES below and in GVC interface at end of file.
*/

import java.io.*;
import java.util.*;

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
public class jFormat implements GVC  {
   protected static String m_fileName = null;
   protected static AryFile m_data = null;
   protected static int m_tabWidth = TAB_WIDTH;//See GVC at end...
   protected static boolean bCopyRight = false;
   //USER PREFERENCE VARIABLES...
   protected static int m_formatStyle = J_STYLE;//Set J_STYLE or C_STYLE
   protected static boolean m_addBlkComments = true;
   protected static boolean m_rmvEndComments = false;

   // --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   public static void main(String argv[])  {
      if(argv.length > 0)  {
         String m_fileName = null;
         String strTab = null;
         for (int i=0; i<argv.length; i++)  {
            if(i==0) m_fileName = argv[0];

            //~C_Style, or lack thereof...
            else if ("-c".equals(argv[i]))  {
               m_formatStyle = C_STYLE; continue;
            }

            else if("-d".equals(argv[i]))  {
               m_addBlkComments = false; continue;
            }

            else if("-r".equals(argv[i]))  {
               m_rmvEndComments = true; continue;
            }

            else if("-t".equals(argv[i]))  {
               strTab = argv[i+1];
               m_tabWidth = Integer.parseInt(strTab);
            }
         }//~for (int i=0; i<argv.len...

         File f = new File(m_fileName);
         if(f.canWrite())  {
            openFile(f);//Need the File obj to check file attributes
            scrubFileMain();
            saveFile(m_fileName);
         }

         else  {
            System.out.println("\n --*-- --*-- --*-- --*-- --*-- --*-- --*-- --*-- --*-- -jlb-");
            System.out.println(" The File Attribute is SET to READ_ONLY\n");
            System.out.println("\t jFormat cannot work on a READ_ONLY file.\n");
            System.out.println("\t\t UnSet the attribute, and try again.");
            System.out.println(" ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- \n");
         }
      }//~if(argv.length > 0)...

      else  {
         usage();
      }
   }//~public static void main(...

   // --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   //A convenience method used by main()
   public static void usage()  {
      System.out.println("\n --*-- --*-- --*-- --*-- --*-- --*-- --*-- --*-- --*-- -jlb-");
      System.out.println(" Usage: java jFormat dirPath\\fileName.ext [args]  ");
      System.out.println(" (e.g.) java jFormat C:\\MyAppsJV\\fileName.java -t 3 -c");
      System.out.println(" Command above would reformat with 3 TabSpaces in C_Style");
      System.out.println("\nWHERE [args] are:");
      System.out.println("\t[-c]   = format in (what I call) C_Style");
      System.out.println("\t[-d]   = DON'T add block end comments.");
      System.out.println("\t[-r]   = REMOVE block end comments if they exist...");
      System.out.println("\t[-t n] = TabSize WHERE n is a number >1");
      System.out.println("\nDEFAULTS:");
      System.out.println(" (e.g.) java jFormat C:\\MyAppsJV\\fileName.java");
      System.out.println(" Command above would reformat with 4 TabSpaces in J_Style");
      System.out.println("\tStyle     = J_Style");
      System.out.println("\tTabSize   = 4\n");
      System.out.println("From DOS Commandline; Navigate to subDir where file located.");
      System.out.println("\tThen issue command to run jFormat on FileName.java:");
      System.out.println("\tjava jFormat C:\\subDir\\absolutePathTo\\FileName.java");
      System.out.println("(e.g.)\tjava jFormat C:\\MyAppsJV\\LogRkiv\\LogRkiv.java");
      System.out.println("(or)\tjava jFormat C:\\MyAppsJV\\LogRkiv\\LogRkiv.java -c -t 3");
      System.out.println(" ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- \n");
      System.exit(0);// C:\MyAppsJV\Polymorphism\Sandwich.java -t 4 -c
   }//~public static void usage... C:\MyDocs\RexArea\MethTest2.java

   // --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void openFile(File fileName)  {
      m_data = new AryFile();
      try  {
         String str;
         m_fileName = fileName.getAbsolutePath();
         FileReader fr = new FileReader(fileName);
         BufferedReader br = new BufferedReader(fr);//A line reader

         //Be sure not empty file
         if((str = br.readLine()) != null)  {
            while(str != null)  {
               m_data.addToEnd(str);
               str = br.readLine();
            }
         }//~if((str = br.readLine())...

         fr.close();
      }//~try...

      catch (IOException ex)  {
         ex.printStackTrace();
      }
   }//~private static void open...

   // --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void saveFile(String fileName)  {
      try  {
         String txtLn = null;
         PrintWriter pw = new PrintWriter(new FileWriter(fileName));
         String str = m_data.get(0);
         int iC = str.indexOf(jlbalder);
         if(iC > -1) bCopyRight = true;
         if(bCopyRight == false) pw.println(CopyRightjF + jlbalder);
         for(int i=0; i<m_data.size(); i++)  {
            txtLn = (String)m_data.get(i);
            pw.println(txtLn);
         }

         pw.close();
      }//~try...

      catch (IOException ex)  {
         ex.printStackTrace();
      }
   }//~private static void save...

   // --+-- START OF COMMON CODE --+-- --+-- START OF COMMON CODE --+-- --+-- START OF COMMON CODE --+-- --+-- START OF COMMON CODE --+--

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void scrubFileMain()  {
      //~After a file is Opened, everything is managed from here...
      //Remove all Xtra blank lines and leading spaces...
      m_data.addToEnd("//" + jlbalder);//An END marker
      LoPntr.ZERO();//Starting point
      removeXtraLines();//Remove excessive (Blank_lines > 1), TABs & SPCs

      //Moves Comments that have been placed between a Block Statement Line and BlckBGN
      bCustomArea.unset();
      LoPntr.ZERO();
      check4BlockCmnts();
      bCustomArea.unset();

      //Separate the StartBlck to its own line
      bComment.unset();//Set to Known state...(FALSE)
      LoPntr.ZERO();
      sepStrtBlck();

      //Separate the EndBlck from preceding code...
      bComment.unset();
      LoPntr.ZERO();
      sepEndBlck();

      //Remove any blank lines after an EndBlck
      bComment.unset();
      LoPntr.ZERO();
      suckUpLineAfterEndBlck();

      //Adds a blank line after an EndBlck, See Code for more info.
      LoPntr.ZERO();
      blankLinAfterEndBlk();

      //Puts everything back together with spaces (NOT real Tabs) and sew on...
      bComment.unset();
      bCustomArea.unset();
      LoPntr.ZERO();
      addTabSpaces();

      if(m_formatStyle == C_STYLE)  {
         //~See interface GVC for information...
         bComment.unset();
         LoPntr.ZERO();
         format_C_Style();
      }

      //Included to parallel jFormat structure - Toggle button disabled above
      if(m_rmvEndComments == true)  {
         removeBlckEndComments();
      }

      String str = m_data.get(m_data.size()-1);
      int iC = str.indexOf("//" + jlbalder);
      if(iC>-1) m_data.remove(m_data.size()-1);
      //------------------------------------------------------------*/

   }//~private static void scru...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void removeXtraLines()  {
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();
      String txtLn;
      String txtL2;

      while(iJ < iUprEnd -1)  {
         if(iJ < m_data.size() -1)  {
            txtLn = m_data.get(iJ).trim();
            txtL2 = m_data.get(iJ+1).trim();
            if(txtLn.length() == 0 && txtL2.length() == 0)  {
               //Found 2 blank lines
               m_data.remove(iJ+1);//Removes next element and decrements array
               removeXtraLines();//Calls itself again
            }
         }//~if(iJ < m_data.size() -1...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd -1)...
   }//~private static void remo...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void check4BlockCmnts()  {
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();
      int iK = 0;
      int iL = 0;
      int iM = 0;
      int iPos = 0;
      String txtLn;
      String txtL2;

      while(iJ < iUprEnd -1)  {
         if(iJ < m_data.size() -1)  {
            txtLn = m_data.get(iJ).trim();

            if(!isCustomArea(txtLn))  {
               txtL2 = m_data.get(iJ+1).trim();
               iK = txtL2.indexOf(BlckBGN);
               if(iK == 0)  {
                  //Found a BlckBGN
                  iL = txtLn.indexOf(DblSLASH);
                  iM = txtLn.indexOf(CmntSTART);
                  if(iL > 0 || iM > 0)  {
                     //~Found a Comment in line b4, But NOT at start of line
                     if(iL > iM) iPos = iL;
                     else iPos = iM;
                     //~Cut the Comment away from the Block Statement,
                     //~ and place it AFTER the BlckBGN character...
                     m_data.overWrite(iJ, txtLn.substring(0, iPos));//Plugs in the Block Statement
                     m_data.overWrite(iJ+1, BlckBGN);
                     m_data.insertInto(iJ+2, txtLn.substring(iPos));
                     check4BlockCmnts();//RECURSION
                  }//~if(iL > 0 || iM > 0)...

                  else if(iL == 0 || iM == 0)  {
                     m_data.overWrite(iJ, txtL2);//Swap the two around
                     m_data.overWrite(iJ+1, txtLn);
                  }
               }//~if(iK == 0)...
            }//~if(!isCustomArea(txtLn))...
         }//~if(iJ < m_data.size() -1...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd -1)...
   }//~private static void chec...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void sepStrtBlck()  {
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();
      int iPos = 0;
      String txtLn;
      String txtL2;

      //"smiles".substring(1, 5) returns "mile"
      while(iJ < iUprEnd - 1)  {
         txtLn = m_data.get(iJ).trim();
         if(!isComment(txtLn))  {
            iPos = txtLn.indexOf(BlckBGN);//~a BlckBGN
            //~Check to see if we're inside a Quote...
            if(isInQuote(txtLn, iPos)) iPos = -1;//~Abort if we are...

            if(iPos > -1)  {
               //A BlckBGN found
               if(iPos > 0)  {
                  //A BlckBGN, but not in 1st pos
                  txtL2 = txtLn.substring(0, iPos);//Gets front part
                  m_data.overWrite(iJ, txtL2);//put it back into array
                  txtLn = txtLn.substring(iPos).trim();//Gets trimmed remainder
               }

               else  {
                  //~(iPos !> 1), i.e. BlckBGN is in 1st pos
                  txtL2 = txtLn.substring(0, 1);//Gets BlckBGN
                  m_data.overWrite(iJ, txtL2);//put it back into array
                  if(txtLn.length() > 1)  {
                     //if txtLn == 1 char, goes to else
                     txtLn = txtLn.substring(iPos+1).trim();//Gets trimmed remainder
                  }

                  else  {
                     txtLn = "";//Empties it of BlckBGN
                  }
               }//~else...

               if(txtLn.length() > 0)  {
                  //This catches, and keeps, any remainder
                  m_data.insertInto(iJ+1, txtLn);
                  LoPntr.incr();//incr in array, iJ gets (re)set on reentry
                  sepStrtBlck();//Calls itself again
               }
            }//~if(iPos > -1)...
         }//~if(!isComment(txtLn))...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd - 1)...
   }//~private static void sepS...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void sepEndBlck()  {
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();
      int iPos = 0;
      String txtLn;
      String txtL2;

      while(iJ < iUprEnd - 1)  {
         txtLn = m_data.get(iJ).trim();
         if(!isComment(txtLn))  {
            iPos = txtLn.indexOf(BlckEND);//An EndBlck
            //~Check to see if we're inside a Quote...
            if(isInQuote(txtLn, iPos)) iPos = -1;//~Abort if we are..

            if(iPos > -1)  {
               //An EndBlck found
               if(iPos > 0)  {
                  //An EndBlck, but not in 1st pos
                  //~(xxx + EndBlck + yyy) OR (xxx + EndBlck)
                  txtL2 = txtLn.substring(0, iPos);//Gets front part up TO iPos
                  m_data.overWrite(iJ, txtL2);//put it back into array
                  txtLn = txtLn.substring(iPos).trim();//Gets trimmed remainder
               }

               else  {
                  //~(iPos !> 1), i.e. EndBlck is in 1st pos
                  //(EndBlck + yyy) OR (EndBlck)
                  txtL2 = txtLn.substring(0, 1);//Gets EndBlck
                  m_data.overWrite(iJ, txtL2);//put back into array

                  if(txtLn.length() > 1)  {
                     //if txtLn == 1 char, goes to else
                     //(EndBlck + yyy)
                     txtLn = txtLn.substring(iPos+1).trim();//Gets the trimmed remainder
                     int iK = txtLn.indexOf(DblSLASH);
                     int iL = txtLn.indexOf(CmntSTART);
                     if(iK == 0 || iL == 0)  {
                        //Found a comment start, otherwise remainder put away below
                        //Reunite EndBlck and Comment or SemiColon
                        m_data.overWrite(iJ, m_data.get(iJ) + txtLn);//put back into array
                        txtLn = "";//Empties remainder
                     }//txtLn holds remainder if NOT a '// | /* | ; | ,', drops to 'if(txtLn.length() > 0)'
                  }//~if(txtLn.length() > 1)...

                  else  {
                     //~ txtLn==BlckEND
                     txtLn = "";//Empties it of the BlckEND
                  }
               }//~else...

               if(txtLn.length() > 0)  {
                  //This catches any remainder
                  m_data.insertInto(iJ+1, txtLn);
                  LoPntr.incr();//incr in array, iJ gets (re)set on reentry
                  sepEndBlck();//Calls itself again --+-- RECURSION --+--
               }
            }//~if(iPos > -1)...
         }//~if(!isComment(txtLn))...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd - 1)...
   }//~private static void sepE...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void suckUpLineAfterEndBlck()  {
      //This method looks at the chars immediately following an end block.
      //If they are a comma, semicolon, right_paranthesis, or a JLB_comment (//~),
      //then it is rejoined with the endblock.
      //These are generally inner classes, blocked lists, and etc...
      //ALSO, Sucks up blank lines immediately following a Block Begin
      int iB = 0;
      int iK = 0;
      int iL = 0;
      int iM = 0;
      int iP = 0;
      int iQ = 0;
      String txtLn;
      String txtL2;
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();

      while(iJ < iUprEnd -1)  {
         if(iJ < m_data.size() -1)  {
            //THIS ONE STAYS !!!
            txtLn = m_data.get(iJ).trim();

            if(!isComment(txtLn))  {
               iB = txtLn.indexOf(BlckBGN);
               iK = txtLn.indexOf(BlckEND);
               txtL2 = m_data.get(iJ+1).trim();
               iL = txtL2.indexOf(DaComma);
               iM = txtL2.indexOf(RtParen);
               iP = txtL2.indexOf(JLB_Cmnt);
               iQ = txtL2.indexOf(SemColon);

               //Found (BlckBGN AND BlankLine)
               if(iB == 0 && txtL2.length() == 0)  {
                  m_data.remove(iJ+1);//Removes next element and decrements array
                  suckUpLineAfterEndBlck();//Calls itself again
               }

               //Found (BlckEND AND BlankLine)
               else if(iK == 0 && txtL2.length() == 0)  {
                  m_data.remove(iJ+1);//Removes next element and decrements array
                  suckUpLineAfterEndBlck();//Calls itself again
               }

               //Found BlckEND AND [',' OR ')' OR '//~' OR ';']
               else if(iK == 0 && (iL == 0 || iM == 0 || iP == 0 || iQ == 0))  {
                  txtLn = txtLn + txtL2;//Concats the two lines
                  m_data.overWrite(iJ, txtLn);// into one cell
                  m_data.remove(iJ+1);
                  suckUpLineAfterEndBlck();//Calls itself again
               }
            }//~if(!isComment(txtLn))...
         }//~if(iJ < m_data.size() -1...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd -1)...
   }//~private static void suck...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void blankLinAfterEndBlk()  {
      //This inserts blank lines after an BlckEND
      //unless there is already a blank line there, or another EndBlock
      int iUprEnd = m_data.size();
      int iJ = LoPntr.get();
      int iK = 0;
      int iL = 0;
      String txtLn;
      String txtL2;

      while(iJ < iUprEnd - 1)  {
         txtLn = m_data.get(iJ).trim();
         txtL2 = m_data.get(iJ+1).trim();
         iK = txtLn.indexOf(BlckEND);
         iL = txtL2.indexOf(BlckEND);
         if(iK == 0 && iL == 0)  {
            // Two EndBlcks together, DoNothing
         }

         else if(iK == 0 && txtL2.length() > 0)  {
            //Otherwise insert a blank line
            m_data.insertInto(iJ+1, "");
            LoPntr.incr();
            blankLinAfterEndBlk();
         }

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd - 1)...
   }//~private static void blan...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void addTabSpaces()  {
      //This method formats each line by adding tabs (actually spaces)
      //It also adds BlkEnd Comments after a certain number of lines,
      //set by BLOCK_LINE_LIMIT, i.e. after 7 lines a comment is inserted,
      //consisting of '//~' + the 1st 24 chars of the line + '...'
      int iJ = 0;
      int iUprEnd = m_data.size();//UpperEnd pointer of the array
      int iBlkLinCntr = BLOCK_LINE_LIMIT;//Threshhold for Num lines b4 an EOB_Comment is written
      int iTabCntr = 0;//Tracks Tab offset
      int iTC = 0;
      int iBE = 0;
      String protoTab = new String("                                                            ");
      String sTab = "";
      //~ These arrays are indexed by iTabCntr
      String aryBlkInitLn[] = new String[29];//Holds BlckInit lines
      int aBlckLinCntr[] = new int[29];//Holds int count since BlckInit started
      String txtLn;
      String txtL0;
      String txtL2;

      for(iJ=0; iJ < iUprEnd; iJ++)  {
         for(iTC=0; iTC<=iTabCntr; iTC++)  {
            //An array to track the number of lines in each code block for block-end comments
            //This increments each cell as nest grows deeper...
            aBlckLinCntr[iTC]++;//Nesting blocks take us further into array
         }

         txtL0 = m_data.get(iJ);
         sTab = protoTab.substring(0, (m_tabWidth * iTabCntr));

         //This LOGIC allows Single line comments in, but not Multi-Line comments
         if(!(isComment(txtL0) & bComment.get()))  {
            //BlockBegin in 1st Pos Only
            txtLn = m_data.get(iJ).trim();
            //m_textArea.append(protoTab.substring(0, (m_tabWidth * iTabCntr)) + txtLn + "\n");

            //BlockBegin in 1st Pos Only
            //Is there a BlockBegin & NOT in a DontFormat area?
            if(txtLn.indexOf(BlckBGN) == 0 & !bCustomArea.get())  {
               aryBlkInitLn[iTabCntr] = m_data.get(iJ-1);//Save line b4 BlckBGN
               //m_textArea.append(protoTab.substring(0, (m_tabWidth * iTabCntr)) + ">" + iJ + "\n");
               iTabCntr++;

            }

            iBE = txtLn.indexOf(BlckEND);
            //BlckEND in 1st position
            if(iBE == 0)  {
               if((txtLn.indexOf(DblSLASH) > iBE) || (txtLn.indexOf(CmntSTART) > iBE))  {
                  //DoNothing, theres a comment somewhere after the BlckEND on this line
               }

               else if(m_addBlkComments == true)  {
                  //There is NOT a Comment here already.
                  if(aBlckLinCntr[iTabCntr] > iBlkLinCntr)  {
                     if(iTabCntr > 0)  {
                        txtL2 = aryBlkInitLn[iTabCntr-1].trim();//Gets the BlckInit line
                        if(txtL2.length() > 24) txtL2 = txtL2.substring(0,24);
                        txtLn = txtLn + "//~" + txtL2 + "...";//~ We Wrote it...
                     }
                  }
               }//~else if(m_addBlkComments...

               aBlckLinCntr[iTabCntr] = 0;//Clears this Cell of num of Tab lines in block

               if(iTabCntr > 0) iTabCntr--;//Decrement the TAB Counter cause we just went past a BlckEND
               //UNLESS it is the last one, in which case we don't want to go negative
               //m_textArea.append(protoTab.substring(0, (m_tabWidth * iTabCntr)) + "<" + iJ + "\n");
               sTab = protoTab.substring(0, (m_tabWidth * iTabCntr));//Resets Tab size
            }//~if(iBE == 0)...

            m_data.overWrite(iJ, sTab + txtLn);//Writes tabbed line in array
         }//~if(!(isComment(txtL0) & ...
      }//~for(iJ=0; iJ < iUprEnd; ...

      //m_textArea.append("-----------------------------------------\n");
      if(iTabCntr != 0) System.out.println("\t {} Brackets don't match! " + iTabCntr + "\n");

      /** --+-- --+-- --+-- Adds an extra indent to -Continued- lines --+-- --+-- */
      sTab = protoTab.substring(0, m_tabWidth);//One TAB size
      int iK = 0;
      int iL = 0;
      int iP = 0;
      int iQ = 0;
      bComment.unset();//Set to Known state...(FALSE)

      for(iJ=0; iJ < iUprEnd -1; iJ++)  {
         if(!isComment(m_data.get(iJ).trim()))  {
            txtLn = m_data.get(iJ);//~NO TRIM() !!!
            txtL2 = m_data.get(iJ+1);
            iK = txtLn.lastIndexOf(DaComma);
            iL = txtLn.lastIndexOf(LtParen);
            iQ = txtLn.lastIndexOf(Plus);
            //~Check to see if we're inside a Quote...
            if(isInQuote(txtLn, iK)) iK = -1;//~Abort if we are...
            if(isInQuote(txtLn, iL)) iL = -1;//~Abort if we are...

            iP = txtLn.length();

            //If the last char is a Comma or LtParen or PlusSign THEN
            //  add an extra Tab to the next line
            if(iP > 0 && (iP == iK+1 || iP == iL+1 || iP == iQ+1))  {
               txtL2 = sTab + txtL2;
               m_data.overWrite(iJ+1, txtL2);//Writes new tabbed line in array
            }
         }//~if(!isComment(m_data.get...
      }//~for(iJ=0; iJ < iUprEnd -...
   }//~private static void addT...

   // --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void format_C_Style()  {
      int iUprEnd = m_data.size();//Gets the (new) size
      int iJ = LoPntr.get();//Gets the lower pointer...
      String txtLn;
      String txtL2;
      String txtL3;
      int iJslash;
      int iJstar;
      int iPos;

      while(iJ < iUprEnd -1)  {
         if(iJ < m_data.size() -1)  {
            //THIS ONE STAYS
            txtLn = m_data.get(iJ);

            if(!isComment(txtLn))  {
               txtL2 = m_data.get(iJ+1).trim();

               if(txtL2.indexOf(BlckBGN) == 0)  {
                  txtL3 = txtLn + "  " + BlckBGN;
                  m_data.overWrite(iJ, txtL3);
                  m_data.remove(iJ+1);//Removes next element and decrements array
                  format_C_Style();//Calls itself again
               }
            }//~if(!isComment(txtLn))...
         }//~if(iJ < m_data.size() -1...

         iJ++;
         LoPntr.incr();
      }//~while(iJ < iUprEnd -1)...
   }//~private static void form...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static void removeBlckEndComments()  {
      int iUprEnd = m_data.size();
      int iJ = 0;
      int iB = 0;
      int iC = 0;
      String txtLn;
      String txtL2;

      for(iJ=0; iJ < iUprEnd; iJ++)  {
         txtLn = m_data.get(iJ);
         iB = txtLn.indexOf(BlckEND);
         if(iB > -1)  {
            iC = txtLn.indexOf(JLB_Cmnt);
            if(iC > iB)  {
               txtL2 = txtLn.substring(0, iC);
               m_data.overWrite(iJ, txtL2);
            }
         }
      }//~for(iJ=0; iJ < iUprEnd; ...
   }//~private static void remo...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static boolean isComment(String txt2)  {
      //This method returns true ONLY if the line starts with DblSLASH,
      //OR STARTS with a multi-line comment, SlashStar or Slash2Star
      //OR position is inside a multi-line comment,
      //OR inside a Don't_Format area...
      String txt = txt2.trim();
      int iDblSLASH = txt.indexOf(DblSLASH);
      int iCmntSTART = txt.indexOf(CmntSTART);
      int iCmntENDS = txt.lastIndexOf(CmntENDS);
      int iCustomAreaBGN = txt.indexOf(DntFrmtBEGIN);// setup for bCustomArea
      int iCustomAreaEND = txt.indexOf(DntFrmtEND);//   setup for bCustomArea
      boolean bCmntSGL = false;//Reset on every entrance

      // If CustomAreaEND found, set bCustomArea==false
      if(iCustomAreaEND > -1) bCustomArea.unset();//~i.e. set to false
      if(!bCustomArea.get())  {
         //if NOT in a CustomArea THEN
         if(iCustomAreaBGN > -1) bCustomArea.set();//~ set bCustomArea==true

         //If inside a multi-line comment, hold it's condition until next re-entrance.
         if(bComment.get()) bCmntSGL = true;// To HOLD multi-line condition for re-entrance.

         // Another way to set the Single Line Flag, if it is at the beginning of a line.
         if(iDblSLASH == 0) bCmntSGL = true;//~A single line comment
         else if(iCmntSTART == 0) bComment.set();//~A multi-line comment begins here

         //Clears the MultiLine Comment Flag if it ends on this line
         int iLen = txt.length();
         if(iLen>1 & iCmntENDS+2==iLen & bComment.get())  bComment.unset();
      }//~if(!bCustomArea.get())...

      else  {
         //~ If we get here, we are in a DontFormat region
         bCmntSGL = true;//And therefore, Don't do any formatting...
      }

      return (bCmntSGL || bComment.get());//TRUE if either is TRUE
   }//~private static boolean i...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static boolean isCustomArea(String txt)  {
      int iCustomAreaBGN = txt.indexOf(DntFrmtBEGIN);
      int iCustomAreaEND = txt.indexOf(DntFrmtEND);
      if(iCustomAreaEND > -1) bCustomArea.unset();//~i.e. false
      if(bCustomArea.get() == false)  {
         if(iCustomAreaBGN > -1) bCustomArea.set();//~ i.e. true
      }

      return (bCustomArea.get());
   }//~private static boolean i...

   //--+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+--
   private static boolean isInQuote(String txt, int iPos)  {
      boolean isIt = false;
      int iJ = txt.lastIndexOf(DblQuote, iPos);//Counts backward from iPos to find a DblQuote
      if(iJ == -1) iJ = txt.lastIndexOf(SglQuote, iPos);//Single Quote ???
      int iK = txt.indexOf(DblQuote, iPos);//Counts from iPos right to find a DblQuote...
      if(iK == -1) iK = txt.indexOf(SglQuote, iPos);//Single Quote ???
      if(iJ > -1 && iPos > iJ && iK > iPos) isIt = true;
      //txt = 'fjgju"X"mfd;jr' iJ==5, iPos==6, iK==7
      return isIt;
   }//~private static boolean i...
}//~public class jFileFormat...

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
class bComment  {
   private static boolean bComment = false;
   /*>BEGIN*/
   public static boolean get()
   {   return bComment;}
   public static void unset()
   {   bComment = false;}
   public static void set()
   {   bComment = true;}
   /*<END*/
}//~class bComment...

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
class bCustomArea  {
   private static boolean bCustomArea = false;
   /*>BEGIN*/
   public static boolean get()
   {   return bCustomArea;}
   public static void unset()
   {   bCustomArea = false;}
   public static void set()
   {   bCustomArea = true;}
   /*<END*/
}//~class bCustomArea...

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
class LoPntr  {
   private static int LoPntr;
   /*>BEGIN*/
   public static void incr()
   {   LoPntr++;}
   public static void decr()
   {   LoPntr--;}
   public static void ZERO()
   {   LoPntr = 0;}
   public static int get()
   {   return LoPntr;}
   /*<END*/
}//~class LoPntr...

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
class AryFile  {
   private ArrayList AryListFile = new ArrayList();
   /*>BEGIN*/
   public void clear()
   {   AryListFile.clear();}
   public void addToEnd(String str)//Adds to end of AryListFile
   {   AryListFile.add(str);}
   public String get(int indx)//Gets String from AryListFile
   {   return (String)AryListFile.get(indx);}
   public void overWrite(int indx, String str)//Overwrites element w/String in AryListFile
   {   AryListFile.set(indx, str);}
   public void insertInto(int indx, String str)//Inserts String into AryListFile
   {   AryListFile.add(indx, str);}
   public void remove(int indx)//Removes element from AryListFile
   {   AryListFile.remove(indx);}
   public int size()
   {   return AryListFile.size();}
   /*<END*/
}//~class AryFile...

/** --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- --+-- */
//~Global Var Constants: Static Final by being an Interface
interface GVC  {
   //~Some constants...
   int C_STYLE = 0;//~ OLD COFFEE, as in 'C Spot, C Dick, C Jane, C Spot, Dick, Jane...
   int J_STYLE = 1;//~ REAL JAVA, Better than Maui Wowie
   int TAB_WIDTH = 4;//~Width of a tab in spaces
   int BLOCK_LINE_LIMIT = 7;//~Number of lines counted in a BLOCK b4 a COMMENT is appended to BLOCK_END

   //For Disassembly/Reassembly of Java file.
   String BlckBGN = "{";//'\u007B';
   String BlckEND = "}";//'\u007D';
   String DblSLASH = "//";
   String JLB_Cmnt = "//~";
   String CmntSTART = "/*";
   String Cmnt2STAR = "/**";
   String CmntENDS = "*/";
   String LtParen = "(";
   String RtParen = ")";
   String DaComma = ",";
   String SemColon = ";";
   String Colon = ":";
   String Plus = "+";
   String DblQuote = "\"";//'\u0022';//~a quote char in unicode
   String SglQuote = "\'";//'\u0027';//~a single quote char
   String DntFrmtBEGIN = "/*>";
   String DntFrmtEND = "/*<";
   String CopyRightjF = "//~ 2002 - Formatted by jFormat - ";
   String CopyRightjFF = "//~ 2002 - Formatted by jFileFormat - ";
   String jlbalder = "jlbalder@netscape.net";

}//~interface GVC...

/** --+-- END OF COMMON CODE --+-- --+-- END OF COMMON CODE --+-- --+-- END OF COMMON CODE --+-- */