import java.lang.reflect.*;
import java.io.*;
import java.util.*;

class CTL
{
	private Class theClass;
	
	private String[] fields;
	private String[] constructors;
	private String[] methods;
	private String[] _methods;
	
	private final static char BYTE		= 'B';
	private final static char CHAR		= 'C';
	private final static char SHORT		= 'S';
	private final static char INT		= 'I';
	private final static char LONG		= 'J';
	private final static char FLOAT		= 'F';
	private final static char DOUBLE	= 'D';
	private final static char BOOLEAN	= 'Z';
	private final static char OBJECT	= 'L';
	
	private char type;

	CTL( String _theClass )
	{
		try
		{
			theClass = Class.forName( _theClass );
			getFields();
			getConstructors();
			getMethods();
		} catch ( ClassNotFoundException cnfe ) { }

	}

	private void getFields()
	{
		Field[] m = theClass.getFields();
			
		fields = new String[m.length];

		for (int i = 0; i < m.length; i++ )
		{
			if ( Modifier.isStatic(m[i].getModifiers()) )
				fields[i] = purge(theClass)+"."+m[i].getName();
			else fields[i] = m[i].getName();
		}
	}

	private void getConstructors()
	{
		Constructor[] m = theClass.getConstructors();
			
		constructors = new String[m.length];

		for (int i = 0; i < m.length; i++ )
			constructors[i] = format( m[i]);
	}

	private void getMethods()
	{
		Method[] m = theClass.getMethods();
			
		methods = new String[m.length];
		_methods = new String[m.length];

		for (int i = 0; i < m.length; i++ )
		{
			methods[i] = format( m[i]);
			if ( Modifier.isStatic( m[i].getModifiers()) )
				_methods[i] = purge(theClass) + "." +
					m[i].getName()+"( ^! )";
			else _methods[i] = m[i].getName()+"( ^! )";

		}
	}

	private String format( Method m )
	{
		StringBuffer theMethod = new StringBuffer();
		
		//.Modificatore.
		theMethod.append( getModifier(m) );
		
		//.Tipo restituito..
		Class rt = m.getReturnType();
		theMethod.append( getParameter(rt) +" ");
		
		//.Nome del metodo..
		theMethod.append( m.getName() +"( ");

		//.Parametri del metodo..
		Class[] pars = m.getParameterTypes();
		if ( pars.length == 0 ) theMethod.append( " )" );
		else {
			for (int j = 0; j < (pars.length-1); j++ )
				theMethod.append( getParameter(pars[j]) +", " );
			theMethod.append( getParameter(pars[pars.length-1]) +" )" );
		}
		
		//.Eccezioni...
		Class[] ex = m.getExceptionTypes();

		if ( ex.length > 0 ) 
		{	
			theMethod.append(" throws " );
			for (int i = 0; i < ex.length-1; i++ )
				theMethod.append( purge(ex[i]) +", " );
			theMethod.append( purge(ex[ex.length-1]) );
		}

		return theMethod.toString();
	}

	private String format( Constructor c )
	{
		StringBuffer theMethod = new StringBuffer();
		
		//.Nome del metodo..
		theMethod.append( purge(theClass) +"( ");

		//.Parametri del metodo..
		Class[] pars = c.getParameterTypes();
		if ( pars.length == 0 ) theMethod.append( " )" );
		else {
			for (int j = 0; j < (pars.length-1); j++ )
				theMethod.append( getParameter(pars[j]) +", " );
			theMethod.append( getParameter(pars[pars.length-1]) +" )" );
		}

		return theMethod.toString();
	}
	
	private String getType( char type )
	{
		switch ( type)
		{
			case BYTE	: return "byte[]";
			case CHAR	: return "char[]";
			case SHORT	: return "short[]";
			case INT	: return "int[]";
			case LONG	: return "long[]";
			case FLOAT	: return "float[]";
			case DOUBLE : return "double[]";
			case BOOLEAN: return "boolean[]";
			default		: return new String(""+type);
		}
	}

	private String getParameter( Class c )
	{
		String param = c.getName();
		
		if ( param.startsWith("[L") )
		{	
			String _tmp = purge(c);
			_tmp = _tmp.substring(0, _tmp.length()-1);
			return new String( _tmp+"[]");
		}
		if ( param.startsWith("[[L") )
		{	
			String _tmp = purge(c);
			_tmp = _tmp.substring(0, _tmp.length()-1);
			return new String( _tmp+"[][]");
		}
		
		if ( param.startsWith("[[") )
			return getType(param.charAt(2))+"[]";
			
		if ( param.startsWith("[") )
			return getType(param.charAt(1));

		return purge( c );
	}

	private String purge( Class c )
	{
		int idx = c.getName().lastIndexOf('.');
		if ( idx > 0 ) 
			return c.getName().substring( idx + 1 );
		return c.getName();

	}
	
	//.REstituisce un simbolo che rappresenta il
	//.modificatore del metodo.
	private String getModifier( Method met )
	{
		int mod = met.getModifiers();

		StringBuffer sb = new StringBuffer();

		if ( Modifier.isPrivate( mod ) ) sb.append('-');
		if ( Modifier.isPublic( mod ) ) sb.append('+');
		if ( Modifier.isProtected( mod ) ) sb.append('#');
		
		if ( Modifier.isAbstract( mod ) ) sb.append('a');
		
		if ( Modifier.isFinal( mod ) ) sb.append('f');
		
		if ( Modifier.isNative( mod ) ) sb.append('n');
		if ( Modifier.isStatic( mod ) ) sb.append('s');
		if ( Modifier.isSynchronized( mod ) ) sb.append('*');
		
		sb.append(" ");
		return sb.toString();
	}

	public String[] getSignatures() 
	{
		return methods;
	}

	public void toFile( String path ) throws IOException
	{
		File file = new File(path);
		if ( !file.exists() ) file.mkdirs();
		
		String clName = theClass.getName();
		System.out.println(">> Saving ... " + clName );
		
		BufferedWriter out = new BufferedWriter(
					new FileWriter( new File( file,clName+".ctl")) );
		
		out.write("#TITLE=" + purge(theClass) +
			 " ( " + 
			clName.substring( 0, clName.lastIndexOf("."))
			+ " ) " + "\r\n" );
		out.write("#INFO\r\n" );
		out.write("Created by Jar2Html by ...");
		out.newLine();
		out.write("   LuS '71 \r\n");
		out.write("#SORT=n\r\n\r\n");

		for (int i=0; i < fields.length; i++ )
			out.write( "#T=" + fields[i] +"\r\n" );

		for (int i=0; i < constructors.length; i++ )
			out.write( "#T=" + constructors[i] +"\r\n" );
		
		for (int i=0; i < methods.length; i++ )
		{
			out.write( "#T=" + methods[i] +"\r\n" );
			out.write( _methods[i] +"\r\n" );
		}		
	
		out.write("#");
		out.close();	
	}
	
	static public void main( String[] args ) throws Exception
	{
		new CTL( args[0] ).toFile(".");
	}
}