#TITLE=KiXtart 2001
#INFO
; Prague September 26, 2001
; EditPlus Cliptext Library v 1.0 written by Petr Navratil - PENsoft.
; This file is provided as a default Cliptext Library for KiXtart 2001.
;
#SORT=N

#T=COMMANDS 
#T===================
#T=:LABEL	
:^!LABEL				; Defines label

#T=; Comment			; Subsequent characters are treat as comment
#T=? Prints new line
? "^!My_Variable = " + $VARIABLE	; Prints content of variable

#T=BEEP
Beep				; System beep

#T=BIG
Big				; Changes the vharacter mode to large characters

#T=BREAK
Break On^!|Off			; Enables/Disables CTRL+C/BREAK keys and Close command

#T=CALL
Call "^!script_name"		; Runs a separate KiXtart script

#T=CD
CD "^!directory"		; Changes current working directory

#T=CLS
Cls

#T=COLOR
Color ^!FgColor['+'=high intesity]/BgColor['+'=blinking] 
; Colors: Normal, Blue, Green, Cyan, Red, Magenta, Yelow / Brown, White
; Color n+/b+

#T=COOKIE1
Cookie1				; Creates cookie or semaphore file

#T=COPY
Copy "^!source" "target" /h	; /h= copies also files with hidden or system attribute

#T=DEL
Del "^!file_name"		; Deletes file(s), wildcards are supported

#T=DIM
Dim $^!VAR_1 [,..., $VAR_n]	; Declares one or more variables

#T=DISPLAY
Display "^!file_name"		; Displays contents of file on the screen

#T=DO
Do				; Loops, until expression becomes true=0
   statements
Until "^!expresion"

#T=EXIT
Exit ^!error_level|exit_code	; Exits current KiXtart script and sets error level

#T=FLUSHKB
Flushkb				; Flushes all pending chars from the keyboard buffer

#T=FOREACH
For Each $^!element In $group_of_elements
   statements			; Repeats statements for all element in array or collection
Next

#T=FOR
For $COUNTER=^!start To end [Step step]
   statements			; Repeats statements specified number of times
Next

#T=FUNCTION
Function ^!name [arg1, arg2, ..., argn]
   statements			; Declares name, args and code of Function procedure
  [name=expresion]		; In the name of Function it can return value
EndFunction

#T=GET
Get $^!character		; Gets single character from keyboard

#T=GETS
Gets $^!string			; Reads chars from keyboard, until Enter is pressed

#T=GLOBAL
Global $^!VAR1 [, $VAR2, $VARn]	; Declares one or more Global variables

#T=GO
Go "^!drive"			; Changes current drive

#T=GOSUB
GoSub <^!label>			; Script execution continues at the 1st statement after label
				; When the Return command is encountered, execution continues
				; at the statement after GoSub statement

#T=GOTO
GoTo ^!<label>			; Script execution continues at the 1st statement after label

#T=IF				
If ^!expresion			; Conditionally executes statements
   statements
Else
   statements
Endif

#T=MD
MD "^!directory"		; Creates neew directory

#T=PASSWORD
Password "^!password"		; No function, supported only for compatibility with KiXtart 2.3

#T=PLAY
Play [file "^!path\file.spk"|"string"|"path\file.wav"] ; Plays music on the computer speaker

#T=QUIT
Quit ^![error Level]		; Exits KiXtart

#T=RD
RD "^!directory"		; Removes specified directory

#T=REDIM
Redim [Preserve] "$^!VAR1" [, $VAR2, $VARn] ; Declares dynamic-array variables at procedure level

#T=RETURN
Return ^!			; Script execution continues at the statement after CALL or GoSub

#T=RUN
Run "^!command"			; Runs a command ( RUN "%COMSPEC% /e:1024 /c DIR C:\" )

#T=SELECT
Select				; Efficient way to write series of IF ELSE statements
 case ^!expresion
   statements
 case expresion
   statements
EndSelect

#T=SET
Set "$^!VAR = String"		; Does not work on Windows 9x Use Shell to run Winset.exe

#T=SETL
Setl "$^!VAR = String"		; Sets environment variables in the local environment session

#T=SETM
Setm "$^!VAR = String"		; Sets environment variables in the local computer

#T=SETTIME
SetTime "^!source"		; Synchronizes system clocks with time on specified source

#T=SHELL
Shell "[%comspec%] ^!command"	; Loads and runs a program

#T=SLEEP
Sleep ^!<seconds>		; Halts script execution for the number of specified seconds

#T=SMALL
Small				; Changes the vharacter mode to small (normal) characters

#T=USE
				; Connect, disconnect or list network connections
Use <*|"device"|"resource">/delete [/persistent]
Use ["^!device"]<"resource">[/user:user][/password:password][/persistent]

#T=WHILE
While ^!expression		; Loops statements, until expresion becomes true=0
   statements
Loop

#T=				;

#T=Function Reference
#T===================
#T=AddKey
AddKey ("^!subkey")		; Adds subkey to the registry

#T=AddPrinterConnection
AddPrinterConnection ("^!")	; Adds connection to specified printer for specified user

#T=AddProgramGroup
AddProgramGroup ("^!group_name", common_group_flag 0=personal|1=common)
				; Program Manager creates new program group				

#T=AddProgramItem
AddProgramItem ("^!command line", "name", "icon path", icon index, "default directory", minimaze, replace, run in own space)
				; Program Manager adds icon to the active program group

#T=Asc
Asc ("^!")			; Returns ASCII code of specified char $ASCII = Asc("H")

#T=At
At (^!row, column)		; Places cursor to the specified position on the screen

#T=BackupEventLog
BackupEventLog ("^!Application|Security|System", "backupfile") 
				;Backs up Windows NT event log

#T=Box
Box (^!top_left_row, top_left_column, bottom_right_row, bottom_right_column, "line_style_one_of <single|double|full|grig>")
				; Draws a box

#T=Chr				
Chr (^!character_code)		; Inserts char in a string eg. chr(13), chr(10),...

#T=ClearEventLog
ClearEventLog ("^!Application|Security|System") ; Clears Windows NT event log

#T=Close
Close (^!file_number)		; Closes file previously opened by the Open function

#T=CompareFileTimes
CompareFileTimes ("^!file1", "file2")	; Compares date and time of two files

#T=CreateObject
CreateObject ("^!servername.typename")	; Launches OLE Automat. server and returns handle

#T=DecToHex
DecToHex (^!decimal_value)	; Returns HEX representation of decimal value

#T=DelKey 
DelKey ("^!subkey")		; Deletes specified subkey from the registry

#T=DelProgramGroup
DelProgramGroup ("^!group_name", common_group_flag<0=personal|1=common>)
				; Program Manager deletes existing program group

#T=DelProgramItem
DelProgramItem ("^!item_name")	; Program Manager deletes item from program group

#T=DelTree
DelTree ("^!subkey")		; Deletes subkey from the registry incl. subkeys

#T=DelValue
DelValue ("^!subkey", "entry")	; Deletes value entry from the registry

#T=Dir
Dir ("^!path", index<0|1>)	; Enumerates files in a directory (simultanously to 2 dirs handle=index=0|1)
; To get all files run Dir repeatedly, until Dir returns zero lenght string (While...loop)

#T=EnumGroup
EnumGroup (^!index)		; Enumerates all groups of which is current user a member

#T=EnumIPinfo
EnumIPinfo (^!index, type <0=IP addr, 1=SubnetMask, 2=Adapt.Description, 3=Def.gateway>)
; Enumerates TCP/IP information of all network adapters of the local system

#T=EnumKey
EnumKey ("^!subkey", index)	; Lists names of subkeys contained in registry key or subkey

#T=EnumLocalGroup
EnumLocalGroup (^!index, "source") ; Enumerates local groups of which is current user member

#T=EnumValue
EnumValue ("^!subkey", index)	; Lists names of reg.entries in a specified key or subkey

#T=Execute
Execute (^!script_code)		; Executes a piece of KiXtart script code

#T=Exist
Exist ("^!file_name")		; Returns 0=file not found, 1=file found

#T=ExistKey	
ExistKey			; Obsolet, use KeyExist function

#T=ExpandEnvironmentVars
ExpandEnvironmentVars ("^!string") ; Expands environment variables inside string to corresponding value

#T=GetDiskSpace
GetDiskSpace ("^!drive")	; Returns available free disk space in kB

#T=GetFileAttr
GetFileAttr ("^!file_name")	; Returns attributes of file
;return	  1=Read only,	 128=Normal
;	  2=Hidden	 256=Temporary
;	  4=System	 512=Sparse file
;	 16=Directory	1024=Reparse point
;	 32=Archive	2048=Compressed
;	 64=Encrypted	4096=Offline

#T=GetFileSize
GetFileSize ("^!file_name")	; Returns size of file in bytes

#T=GetFileTime
GetFileTime ("^!file_name")	; Returns date and time of specified file

#T=GetFileVersion
GetFileVersion ("^!file_name", "version_field")
; Returns version information string of file.
; Version field:  "Comments"		"LegalTrademarks"  
;		  "CompanyName"      	"OriginalFilename" 
;		  "FileDescription"  	"PrivateBuild"     
;		  "FileVersion"      	"ProductName"      
;		  "InternalName"     	"ProductVersion"   
;		  "Language"         	"SpecialBuild"     
;		  "LegalCopyright"   		

#T=GetObject
GetObject ("^!object_name")	; Gets object from file or handle to it

#T=InGroup
InGroup ("^!group_name")	; Checks, if the current user is member of group

#T=Instr
Instr ("^!string_to_search_in", "string_to_search_for") 
				; Returns 0=if not present, >0 position

#T=KeyExist
KeyExist ("^!subkey")		; Returns 0=if not found, 1=found

#T=LCase
LCase ("^!string")		; Returns string in lowercase

#T=Len
Len ("^!string")		; Returns lenght of string, 0=empty string

#T=Loadhive
Loadhive ("^!key", "file_name")	; Creates subkey and store it to registry

#T=LoadKey
LoadKey ("^!subkey", "file_name") ; Loads key (incl. subkey) from a file

#T=LogEvent
LogEvent (^!type, id, message, target, source)
; Logs a event to the Windows NT event log
; Type:	 0=Success		ID	= Number ofoccured event
;	 1=Error		Message	= Message text of event
;	 2=Warning		Target	= (UNC) Target system, def. local system
;	 4=Information		Source	= Source of event, def. Kix32.exe
;	 8=Audit_Success
;	16=Audit_Failure

#T=LogOff
LogOff (^!force)			; Logs current user off and ends Windows session
				; 0=does not force application to close, 1=force

#T=LTrim
LTrim ("^!string")		; Strips leading spaces and returns result

#T=MessageBox
MessageBox ("^!message", "title", style, time_out)
;Style	  0=OK
;	  1=OK+Cancel
;	  2=Abort+Retry+Ignore
;	  3=Yes+No+Cancel
;	  4=Yes+No
;	  5=Retry+Cancel
;Icon	 16=Stop symbol
;	 32=Question mark
;	 48=Exclamation mark
;	 64=Information symbol
;Buton	  0=First button is default
;	256=Second button is default
;	512=Third button is default

#T=Open
Open (^!file_number, "file_name", mode)
; mode	0=if file does not exists, open returns error code=2
;	1=if file does not exists, open creates new file
;	2=open file for read access (default)
;	4=open file for write access
;	(1+4=5 opens file for write access, if does not exists, open creates new file)

#T=ReadLine
ReadLine (^!file_number)	; Reads one line ending by CR+LF

#T=ReadProfileString
ReadProfileString ("^!file_name", "section", "key")
				; Retrives string from initialization file

#T=ReadType
ReadType ("^!subkey", "entry")	; Returns ASCII representation reg.entry data type

#T=ReadValue
ReadValue ("^!subkey", "entry")	; Reads the value from a registry entry

#T=RedirectOutput
RedirectOutput ("^!file_name", overwrite) 
				; Redirects all screen output to e file. Owerwrite:
				; 0=append data to existing contents of file
				; 1=owerwrite existing contents of file

#T=RND
RND (^!range)			; Returns pseudo random number, Range is the maximum value

#T=RTrim
RTrim ("^!string")		; Strips trailing spaces from string and gets result

#T=SaveKey
SaveKey ("^!subkey", "file_name") ; Saves reg. key incl. subkeys to a file

#T=SendKeys
SendKeys ("^!keys")		; Sends one or more keys to active windows
;	BACKSPACE	{BACKSPACE}	F1	{F1}         
;	BREAK		{BREAK}		F2	{F2}         
;	CAPS LOCK	{CAPSLOCK}	F3	{F3}         
;	DEL		{DEL}		F4	{F4}         
;	DOWN ARROW	{DOWN}		F5	{F5}         
;	END		{END}		F6	{F6}         
;	ENTER		{ENTER}		F7	{F7}         
;	ESC		{ESC}		F8	{F8}         
;	HELP		{HELP}		F9	{F9}         
;	HOME		{HOME}		F10	{F10}        
;	INS		{INS}		F11	{F11}        
;	LEFT ARROW	{LEFT}		F12	{F12}        
;	NUM LOCK	{NUMLOCK}	F13	{F13}        
;	PAGE DOWN	{PGDN}		F14	{F14}        
;	PAGE UP		{PGUP}		F15	{F15}        
;	PRINTSCREEN	{PRTSC}		F16	{F16}        
;	RIGHT ARROW	{RIGHT}
;	TAB		{TAB}
;	UP ARROW	{UP}
;-----------------------------------------------------
;	SHIFT	+	CTRL	^	ALT	~

#T=SendMessage
SendMessage ("^!recipient", "message") ; Sends message across network to another users or workstation

#T=SetASCII
SetASCII ("^!mode")			; Enables/Disables ASCII console output Mode=<ON|OFF>

#T=SetConsole
SetConsole ("^!mode")			; Show|Hide|Foreground|AlwaysOnTop|Minimize|Maximize

#T=SetDefaultPrinter
SetDefaultPrinter ("^!printer_name")	; Set default printer for aplication

#T=SetFileAttr
SetFileAttr ("^!file_name", attributes) ; Sets attributes of a file
;	1=Read only	  4=System	 128=Normal	     4096=Offline
;	2=Hidden	 32=Archive	 256=Temporary

#T=SetFocus
SetFocus ("^!title")			; Sets the input focus to specified application

#T=SetOption
SetOption ("^!option", "value")		; Configures KiXtart script engine
;Option	 ASCII		  Value	ON|OFF	
;	 CaseSensitivity	ON|OFF	
;	 Disable Debugging	ON	

#T=SetSystemState
SetSystemState (^!mode, force)	; Change power state of the computer
; Mode	0=Lock system (Only in Windows 2000)
;	1=StandBy
;	2=Hybernate
;	3=PowerOff

#T=SetTitle			
SetTitle ("^!title")		; Sets the title of current console

#T=SetWallpaper
SetWallpaper ("^!file_name.bmp") ; Sets the current wallpaper (file_name.BMP)

#T=ShowProgramGroup
ShowProgramGroup ("^!group_name", show_command, common_group_flag)
; Instruct Program manager, how to show window of existing program group

#T=Shutdown
Shutdown ("^!computer", "message", wait[sec], force<0|1>, options<1=reboot,2=PowerOff>)

#T=SIDToName
SIDToName ("^!SID")		; Translate Security Identifier SID to name

#T=Split
Split ("^!string", "delimiter", count) 
; Returns zaro-based one dimensional array, containing specified number of substrings
; $MYARRAY = Split ("Petr\Paul\Mary", "\", 0) ; Count = -1 all elements
; For Each $ELEMENT In $MYARRAY
;   ? $ELEMENT
; Next				; Repeats statements for all element in array or collection

#T=SRND
SRND (^!seed)			; Sets starting point for generating pseudorandom integers

#T=SubStr 
SubStr ("^!string", start, length) ; Returns part of the string

#T=UBound
UBound (^!array)		; Returns the largest available subscript for a array

#T=UCase	
UCase ("^!string")		; Returns string in uppercase

#T=UnLoadhive
UnLoadhive ("^!key")		; Unloads specified key or subkey from a registry

#T=Val
Val  ("^!string")		; Returns numeric value of a string

#T=VarType
VarType ($^!$VAR)		; Returns integer value representing subtype of variable
			;	0	Empty
			;	1	Null (no valid data)
			;	2	Integer
			;	3	Long integer
			;	4	Single-precision floating-point number
			;	5	Double-precision floating-point number
			;	6	Currency
			;	7	Date
			;	8	String
			;	9	Object handle
			;	10	Error
			;	11	Boolean
			;	12	Variant (used only with arrays of Variants)
			;	13	A data-access object
			;	17	Byte
			;	8192	Array (can only occur in combination with one of the other values)

#T=VarTypeName 
VarTypeName (^!$VAR)	; Returns string type information about variable
;return	Byte	Byte value
;	Integer	Integer value
;	Long	Long integer value
;	Single	Single-precision floating-point value
;	Double	Double-precision floating-point value
;	Currency Currency value
;	Decimal	Decimal value
;	Date	Date or time value
;	String	Character string value
;	Boolean	Boolean value; True or False
;	Empty	Unitialized
;	Null	No valid data
;	Object	Generic object
;	Unknown	Unknown object type
;	Nothing Object variable that doesn't yet refer to an object instance
;	Error	Error
;	[ ]	Array (can only occur in combination with one of the other values)

#T=WriteLine
WriteLine (^!file_number, "linetowrite") ; Writes line to the end of opened file
; Returns -4 File not open for writing
;	  -3 File number not open
;	  -2 Invalid file number specified
;	  -1 End of file
;	   0 Line written successfully

#T=WriteProfileString
WriteProfileString ("^!file_name", "section", "key", "string")
; Copies string to appropriate key in the section of initialisation file

#T=WriteValue
WriteValue ("^!subkey", "entry", "expression", "data Type")
				; Assigns value to registry entry
