%--------------------------------------------------------------
% essais d'un PID en utilisant les rsultats de la transforme en Z
% d' une cellule du 1er ordre passe bas et passe haut
%
% Equation de la transforme en Z d'1 filtre a reponse Impultionnelle
% Infinie :
%   y(n)/x(n) = b(1) + b(2)*Z(-1) + ... + b(nb+1)*Z(-nb) /
%                1   + a(2)*Z(-1) + ... + a(na+1)*Z(-na)
%
% les coef b et a sont calculs  partir des coefficient
%		Ki et Kd
%--------------------------------------------------------------

%------------ filtre integrateur du 1er Ordre ---------------- 
echo on
clear

ki = 0.15; % >> constante de temps tau
kd = 0.15; % >> constante de temps tau

clear A;
clear B;

A(1)=1.0;
A(2)=(1-ki)/(1+ki);

B(1)=1/(1+ki);
B(2)=1/(1+ki);

B
A

% affichage de la reponse de l'integrateur seul
figure(1);
freqz(B,A);
[Hi,F] = freqz(B,A);
figure(2);
Fe= 200;  %en Hz
F = F*Fe/(2*pi);
Hi = abs(Hi);
semilogx(F,Hi);
title 'reponse filtre integrateur seul';
xlabel 'frequence en Hz';
ylabel 'module';
grid;

figure(3);
impz(B,A);
%plot(T,R);
title 'rep impulsionnelle integrateur seul';
xlabel 'temps';
ylabel 'amplitude';

pause;
%------------ filtre diffrentiateur du 1er Ordre ---------------- 

clear C;
clear D;

C(1)=1.0;
C(2)=(1-kd)/(1+kd);

D(1)=kd/(1+kd);
D(2)=-kd/(1+kd);

D
C

% affichage de la reponse du differentiateur seul
figure(1);
freqz(D,C);
[Hd,F] = freqz(D,C);
figure(2);
F = F*Fe/(2*pi);
Hd = abs(Hd);
semilogx(F,Hd);
title 'reponse filtre differentiateur seul';
xlabel 'frequence en Hz';
ylabel 'module';
grid;

figure(3);
if (kd==0) 
else
	impz(D,C);
	%impz(D,C,100,Fe);
end
%plot(T,R);
title 'rep impulsionnelle differentiateur seul';
xlabel 'temps';
ylabel 'amplitude';
pause;

%------------ les deux filtres ensemble ---------------- 
% (les deux transformes en Z sont aditionnes)
% le calcul des coefficient du nouveau filtre donne alors:
% un filtre du 2eme Ordre
I(1)=1.0; 
I(2)=(A(1)*C(2)+A(2)*C(1))/(A(1)*C(1));
I(3)=(A(2)*C(2))/(A(1)*C(1));

J(1)=(B(1)*C(1)+A(1)*D(1))/(A(1)*C(1));
J(2)=(B(1)*C(2)+B(2)*C(1)+A(1)*D(2)+A(2)*D(1))/(A(1)*C(1));
J(3)=(B(2)*C(2)+A(2)*D(2))/(A(1)*C(1));

J % = coef B
I % = coef A

figure(1);
freqz(J,I);
[Hdi,F] = freqz(J,I);

% affichage de la reponse des deux
figure(2);
Hdi = abs(Hdi);
semilogx(F,Hdi);
title 'reponse des deux filtres';
xlabel 'frequence en Hz';
ylabel 'module';
grid;

figure(3);
impz(J,I,40,Fe);
%plot(T,R);
title 'rep impulsionnelle des deux';
xlabel 'temps';
ylabel 'amplitude';
 
%---------------------------------------------
% calcul de Yn en virgule fixe sur des "SHORT"
% tous les coeficients sont mult par 2^15=32768
% !!!! ne pas oublier le coefficient de Yn (=1.0)
% qui doit tre aussi multipli par 2^15
%---------------------------------------------
val	= hex2dec('7FF')
Xn 	= val;
Xn_1 	= val;
Xn_2 	= val;

Yn_1 	= val;
Yn_2 	= val;

co = 2^15;

NYn = (J(1)*co*Xn + J(2)*co*Xn_1 + J(3)*co*Xn_2)
dec2hex(round(NYn))
DYn = (1*co + I(2)*co*Yn_1 + I(3)*co*Yn_2) 
dec2hex(round(DYn))
Yn = NYn/DYn
dec2hex(round(NYn/DYn))


