#TITLE=SQL and PL/SQL
; This file is provided as a default syntax file for Oracle 8 SQL and PL/SQL.
; Syntax File for Oracle SQL written by Manfred Storr.
; (C) Trivadis GmbH; (http://www.trivadis.com)
; manfred.storr@trivadis.com

#INFO
New Cliptext library
#SORT=y

#T=%ISOPEN
IF ^!Cursor_name%ISOPEN THEN  -- Typical usage (Modify to suit current needs) 
	statements
END IF;
#T=%NOTFOUND
EXIT WHEN ^!Cursor_name%NOTFOUND ; -- Typical usage (Modify to suit current needs) 
#T=%ROWCOUNT
IF ^!Cursor_name%ROWCOUNT > 1000 THEN  -- Typical usage (Modify to suit current needs) 
	statements
END IF;
#T=%ROWTYPE
^!variable_name          table_or_view_or_cursor%ROWTYPE;
#T=%TYPE
^!variable_name          table_name.ColName%TYPE;
#T=ABS
ABS (^!num)
#T=ASCII
ASCII (^!str)
#T=BINARY_INTEGER
BINARY_INTEGER
#T=BINARY_INTEGER-Decl
^!variable_name   BINARY_INTEGER := NULL; 
#T=BOOLEAN
BOOLEAN
#T=BOOLEAN-Decl
^!variable_name   BOOLEAN := NULL;
#T=CHR
CHR (^!num)
#T=CLOSE
CLOSE ^!cursor_name;
#T=COUNT
COUNT (*)
#T=CURSOR(Paramterized)
CURSOR ^!cursor_name (param1 IN datatype, param2 IN datatype) IS 
SELECT insert_select_statement_here;
#T=CURSOR(Simple)
CURSOR ^!cursor_name IS 
SELECT insert_select_statement_here  ;
#T=DATE
DATE
#T=DATE-Decl
^!variable_name   DATE := NULL;
#T=dbms_output.put_line
dbms_output.put_line (^!);
#T=DECLARE
DECLARE
^!
BEGIN
END;

#T=DECODE
DECODE (^!expr,srch1,retrn1[,srch2,retrn2,]..[deflt])
#T=EXCEPTION-Decl
^!exception_name         EXCEPTION; 
#T=EXIT-WHEN
EXIT WHEN ^!condition_is_true;
#T=FETCH
FETCH ^!cursor_name INTO
put_list_of_program_variables_corresponding_to_cursor_select_list ;
#T=FOR-LOOP
FOR ^!k IN 1..12 LOOP
	Statements
END LOOP;
#T=FOR-LOOP(Cursor)
FOR ^!Cursor_Record IN Cursor_Name LOOP
	Statements
END LOOP;
#T=FUNCTION
FUNCTION ^!function_name (param1 IN datatype) RETURN datatype IS
BEGIN 
	statements ;
	RETURN return_value ;
EXCEPTION WHEN exception_name THEN
	statements ;
END;
#T=IF-THEN
IF ^!condition THEN
	statements
END IF;
#T=IF-THEN-ELSE
IF ^!condition THEN
	statements
ELSE
	statements
END IF;
#T=IF-THEN-ELSIF
IF ^!condition THEN
	statements
ELSIF condition THEN
	statements
ELSE
	statements
END IF;
#T=INTEGER
INTEGER
#T=INTEGER-Decl
^!variable_name   INTEGER := NULL;
#T=LENGTH
LENGTH (^!str)
#T=LOOP
LOOP
	^!
	EXIT WHEN condition_is_true;
END LOOP loop_label;
#T=LPAD
LPAD (^!str1,num[,str2])
#T=LTRIM
LTRIM (^!str[,set])
#T=MAX
MAX (^!expr)
#T=MIN
MIN (^!expr)
#T=MOD
MOD (^!num2,num1)
#T=NUMBER
NUMBER
#T=NUMBER-Decl
^!variable_name   NUMBER (precision,Scale) := NULL;
#T=NVL
NVL (^!expr1,expr2)
#T=OPEN(Parameterized)
OPEN ^!cursor_name (value_for_param1, value_for_param2);
#T=OPEN(Simple)
OPEN ^!cursor_name ;
#T=PACKAGE
CREATE OR REPLACE PACKAGE ^!package_name IS

-- Enter package declarations as shown below
PROCEDURE procedure_name (param1 IN datatype);
FUNCTION function_name (param1 IN datatype) RETURN datatype;

END package_name ;
#T=PACKAGE-BODY
CREATE OR REPLACE PACKAGE BODY ^!package_name IS

-- Enter procedure, function bodies as shown below
PROCEDURE procedure_name (param1 IN datatype) IS
BEGIN 
	statements ;
EXCEPTION WHEN exception_name THEN
	statements ;
END;

END package_name ;
#T=PL/SQL Block
DECLARE
	^!
BEGIN 
	statements ;
EXCEPTION WHEN exception_name THEN
	statements ;
END;
#T=PROCEDURE
PROCEDURE ^!procedure_name (param1 IN datatype) IS
BEGIN 
	statements ;
EXCEPTION WHEN exception_name THEN
	statements ;
END;
#T=RAISE
RAISE ^!exception_name ;
#T=RECORD
TYPE ^!record_type_name IS RECORD
( field_name1   datatype, 
  field_name2   datatype  
); 

record_variable  record_type_name
#T=ROUND
ROUND (^!num1[,num2])
#T=RPAD
RPAD (^!str1,num[,str2])
#T=SQL%FOUND
IF ^!SQL%FOUND THEN  -- Typical usage (Modify to suit current needs) 
	statements
END IF;
#T=SQL%NOTFOUND
IF ^!SQL%NOTFOUND THEN  -- Typical usage (Modify to suit current needs) 
	statements
END IF;
#T=SQL%ROWCOUNT
IF ^!SQL%ROWCOUNT > 1000 THEN  -- Typical usage (Modify to suit current needs) 
   statements
END IF;
#T=SQLCODE
dbms_output.put_line('SQL Code='||TO_CHAR(SQLCODE)); -- Typical usage
#T=SQLERRM
dbms_output.put_line('SQL Error Msg='||SQLERRM); -- Typical usage
#T=SUBSTR
SUBSTR (^!str,num2[,num1])
#T=SYSDATE
SYSDATE
#T=TABLE
TYPE ^!table_type_name IS TABLE OF record_type_name INDEX BY BINARY_INTEGER;

table_variable table_type_name

#T=TO_CHAR
TO_CHAR (^!expr[,frm])
#T=TO_DATE
TO_DATE(^!str[,frm])
#T=TO_NUMBER
TO_NUMBER (^!str[,frm])
#T=TRUNC
TRUNC (^!num1[,num2])
#T=UID
UID
#T=UPPER
UPPER (^!str)
#T=USER
USER
#T=USERENV
USERENV (^!'option')
#T=VARCHAR2
VARCHAR2
#T=VARCHAR2-Decl
^!variable_name   VARCHAR2 (max_length) := NULL;
#T=WHEN-DUP_VAL_ON_INDEX
WHEN DUP_VAL_ON_INDEX THEN
#T=WHEN-NO_DATA_FOUND
WHEN NO_DATA_FOUND
#T=WHEN-TOO_MANY_ROWS
WHEN TOO_MANY_ROWS THEN
#T=WHEN-VALUE_ERROR
WHEN VALUE_ERROR THEN -- conversion/arithmetic/constraint/trunc err !
#T=WHILE-LOOP
WHILE ^!condition_is_true LOOP
	Statements
END LOOP;
#