#TITLE=Xaraya Module Development
#INFO
EditPlus Cliptext Library v1.0 written by ES-Computing.
This file is provided as a sample Cliptext library of EditPlus.
#SORT=n

#T=Blank xarversion
<?php
/**
 * File: $Id$
 * 
 * ?modname version array
 * 
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 * 
 * @subpackage ?modname
 * @author ?author 
 */
$modversion['name']           = '?modname';
$modversion['id']             = '?';
$modversion['version']        = '1.0.0';
$modversion['description']    = '?';
$modversion['credits']        = 'xardocs/credits.txt';
$modversion['help']           = 'xardocs/help.txt';
$modversion['changelog']      = 'xardocs/changelog.txt';
$modversion['license']        = 'xardocs/license.txt';
$modversion['official']       = ?;
$modversion['author']         = '?author';
$modversion['contact']        = '?';
$modversion['admin']          = ?;
$modversion['user']           = ?;
$modversion['securityschema'] = array('?modname::Item' => '? item name::? item ID');
$modversion['class']          = '?';
$modversion['category']       = '?';
?>
#T= -------
#T=Blank xarinit
<?php
/**
 * File: $Id: s.xarinit.php 1.17 03/03/18 02:35:04-05:00 johnny@falling.local.lan $
 *
 * ?modname initialization functions
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?modname module development team 
 */

/**
 * initialise the ?modname module
 * This function is only ever called once during the lifetime of a particular
 * module instance
 */
function ?modname_init()
{
    return true;
}

/**
 * upgrade the ?modname module from an old version
 * This function can be called multiple times
 */
function ?modname_upgrade($oldversion)
{
    // Upgrade dependent on old version number
    switch ($oldversion) {
        case '1.0.0':
            // Code to upgrade from version 1.0 goes here
            break;
        case '2.0.0':
            // Code to upgrade from version 2.0 goes here
            break;
    }
    // Update successful
    return true;
}

/**
 * delete the ?modname module
 * This function is only ever called once during the lifetime of a particular
 * module instance
 */
function ?modname_delete()
{

    // Remove Masks and Instances
    // these functions remove all the registered masks and instances of a module
    // from the database. This is not strictly necessary, but it's good housekeeping.
    xarRemoveMasks('?modname');
    xarRemoveInstances('?modname');

    // Deletion successful
    return true;
}

?>
#T=-Database Setup
// Get datbase setup
xarDBLoadTableMaintenanceAPI();
list($dbconn) = xarDBGetConn();
$xartable = xarDBGetTables();

$?table = $xartable['?'];
#T=Table Definition
// Define the table structure 
$fields = array('xar_?fieldname'    => array('type' => 'integer',
                                             'null' => false, 
                                             'increment' => true, 
                                             'primary_key' => true),
                'xar_?fieldname'    => array('type' => 'varchar', 
                                             'size' => 32, 
                                             'null' => false),
                'xar_?fieldname'    => array('type' => 'integer',
                                             'size' => 'small', 
                                             'null' => false, 
                                             'default' => '0'));
#T=-Table Create
// Create Table
$query = xarDBCreateTable(?table, $fields);
if (empty($query)) return; // throw back
$result = &$dbconn->Execute($query);
if (!$result) return;
#T=-Create Module Var
xarModSetVar('?modname', '?varname', ?value);
#T=-Register Block Type
// Register Block types
if (!xarModAPIFunc('blocks',
                   'admin',
                   'register_block_type',
                    array('modName'     => '?modname',
                          'blockType'   => '?blocktype'))) return;
#T=-Register Hook
// Register Hooks 
if (!xarModRegisterHook('item', 
                        '?hooktype', 
                        'GUI',
                        '?modname', 
                        '?functype', 
                        '?func')) return;
#T=-Enable Hooks
// Enable hooks for ?modname
if (xarModIsAvailable('?targetmodname')) {
    xarModAPIFunc('modules',
                  'admin',
                  'enablehooks',
                   array('callerModName'    => '?modname',
                         'hookModName'      => '?targetmodname'));
}
#T=-Register BL Tags
// Register BL Tag
xarTplRegisterTag('?modname', 
                  '?tagname',
                  array(),
                  '?functionforprocessing');
#T=-Register Mask
// Register Mask 
xarRegisterMask('?MaskName', 'All', '?modname', '?type', 'All', '?accesslevel');
#T=- -Mask Overview
ACCESS_OVERVIEW
#T=- -Mask Read
ACCESS_READ
#T=- -Mask Edit
ACCESS_EDIT
#T=- -Mask Add
ACCESS_ADD
#T=- -Mask Moderate
ACCESS_MODERATE
#T=- -Mask Delete
ACCESS_DELETE
#T=- -Mask Admin
ACCESS_ADMIN
#T=-Drop Table
// Generate the SQL to drop the table using the API
$query = xarDBDropTable($xartable['?tablename']);
if (empty($query)) return; // throw back
// Drop the table and send exception if returns false.
$result = &$dbconn->Execute($query);
if (!$result) return;
#T=-Drop Modvars
// Drop all ModVars
xarModDelAllVars(?modname)
#T=-Remove Masks
// Drop all Masks
xarRemoveMasks('?modname');
#T=-Remove Instances
// Drop all Instances
 xarRemoveInstances('?modname');
#T=-UnRegister Block Type
// UnRegister Block types
if (!xarModAPIFunc('blocks',
                   'admin',
                   'unregister_block_type',
                    array('modName'     => '?modname',
                          'blockType'   => '?blocktype'))) return;
#T=-UnRegister Hook
// UnRegister Hooks 
if (!xarModRegisterHook('item', 
                        '?hooktype', 
                        'GUI',
                        '?modname', 
                        '?functype', 
                        '?func')) return;
#T=-UnRegister BL Tags
// UnRegister BL Tags
xarTplUnregisterTag('?tagname');
#T= -------
#T=Blank xartables
<?php
/**
 * File: $Id$
 *
 * ?modname table defintions
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html} 
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?author
 * @todo 
 */

/**
 * Passes table definitons back to Xaraya core
 *
 * @return string
 */
function ?modname_xartables()
{
    // Initialise table array
    $tables = array();
    $systemPrefix = xarDBGetSystemTablePrefix();

    // Assign to the array
    $tables['?tablename'] = $systemPrefix . '_?tablename';

    // Return the table information
    return $tables;
}

?>
#T= -------
#T=Interface Functions
#T= -------
#T=Blank Admin Main
<?php
/**
 * File: $Id$
 *
 * Main administration function
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @subpackage ?modname
 * @author ?author
 */
/**
 * the main administration function
 */
function ?modname_admin_main()
{
    // Security Check
    if (!xarSecurityCheck('EditRole')) return;

    if (xarModGetVar('adminpanels', 'overview') == 0) {
        return array();
    } else {
        xarResponseRedirect(xarModURL('?modname', 'admin', '?funcname'));
    }
    // success
    return true;
}
?>
#T=Blank Modify Config
<?php
/**
 * File: $Id$
 *
 * Modify configuration
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @subpackage ?modname
 * @author ?author
 */
/**
 * modify configuration
 */
function ?modname_admin_modifyconfig()
{
    // Security Check
    if (!xarSecurityCheck('?rolename')) return;

    if (!xarVarFetch('phase', 'str:1:100', $phase, 'modify', XARVAR_NOT_REQUIRED)) return;

    switch (strtolower($phase)) {
        case 'modify':
        default: 
            //Set Data Array
            $data                   = array();
            $data['authid']         = xarSecGenAuthKey();
            $data['submitlabel']    = xarML('Submit');

            // Call Modify Config Hooks
            $hooks = xarModCallHooks('module', 
                                     'modifyconfig', 
                                     '?modname',
                                     array('module'     => '?modname',
                                           'itemtype'   => ?itemtype));

            if (empty($hooks)) {
                $hooks = array();
            }
            $data['hooks'] = $hooks;
            break;

        case 'update':
            if (!xarVarFetch('?inputname', '?inputtype', ?inputvarname, ?default, ?argument, ?preps)) return;
            // Confirm authorisation code
            if (!xarSecConfirmAuthKey()) return; 
            // Update module variables
            xarModSetVar('?modname', '?varname', ?inputvarname);

            // Call Update Config Hooks
            xarModCallHooks('module', 
                            'updateconfig', 
                            '?modname',
                            array('module'      => '?modname', 
                                  'itemtype'    => ?itemtype));

            xarResponseRedirect(xarModURL('?modname', 'admin', 'modifyconfig')); 
            // Return
            return true;
            break;
    } 
    return $data;
} 
?>
#T=Blank Generic View
<?php
/**
 * File: $Id$
 *
 * View Items
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @subpackage ?modname
 * @author ?author
 */
/**
 * view items
 */
function ?modname_?modtype_view()
{
    // Get parameters from whatever input we need
    if (!xarVarFetch('startnum','str:1:',$startnum,'',XARVAR_NOT_REQUIRED)) return;
    $data['items']          = array();
    // Specify some labels for display
    $data['optionslabel']   = xarVarPrepForDisplay(xarML('Options'));
    $data['authid']         = xarSecGenAuthKey();
    $data['pager']          = xarTplGetPager($startnum,
                                             xarModAPIFunc('?modname', 'user', 'countitems'),
                                             xarModURL('?modname', 'admin', 'view', array('startnum' => '%%')),
                                             xarModGetVar('?modname', 'itemsperpage'));

    // Security Check
    if(!xarSecurityCheck('?maskname')) return;
    // The user API function is called
    $items = xarModAPIFunc('?modname',
                           'user',
                           'getall',
                            array('startnum' => $startnum,
                                  'numitems' => xarModGetVar('?modname',
                                                             'itemsperpage')));

    if (empty($items)) {
        $data['message']    = xarVarPrepForDisplay(xarML('No Items in Database'));
    }

    // Check individual permissions for Edit / Delete
    for ($i = 0; $i < count($items); $i++) {
        $item = $items[$i];
        if (xarSecurityCheck('?maskeditname',0)) {
            $items[$i]['editurl']   = xarModURL('?modname',
                                                'admin',
                                                'modify',
                                                array('?id' => $item['?id']));
        } else {
            $items[$i]['editurl']   = '';
        }
        $itemss[$i]['edittitle']    = xarML('Edit');
        if (xarSecurityCheck('?maskdeletename',0)) {
            $items[$i]['deleteurl'] = xarModURL('?modname',
                                                'admin',
                                                'delete',
                                                array('?id' => $link['?id'],
                                                      'authid' => $data['authid']));
            $items[$i]['javascript']= "return confirmLink(this, '" . xarML('Delete ?item') . " $item[url] ?')";
        } else {
            $items[$i]['deleteurl'] = '';
        }
        $items[$i]['deletetitle']   = xarML('Delete');
    }

    // Add the array of items to the template variables
    $data['items']          = $items;
    // Return the template variables defined in this function
    return $data;
}
?>
#T=Blank Generic Create
<?php
/**
 * File: $Id$
 *
 * Create an item
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @subpackage ?modname
 * @author ?author
 */
/**
 * Create an Item
 */
function ?modname_?modtype_new()
{
    // Security Check
    if (!xarSecurityCheck('?maskname')) return;

    if (!xarVarFetch('phase', 'str:1:100', $phase, 'new', XARVAR_NOT_REQUIRED)) return;

    switch (strtolower($phase)) {
        case 'new':
        default: 
            //Set Data Array
            $data                   = array();
            $data['authid']         = xarSecGenAuthKey();
            $data['submitlabel']    = xarML('Submit');

            $item = array();

            $item['module'] = '?modname';
            $item['itemtype'] = NULL; // itemtype
            $hooks = xarModCallHooks('item',
                                     'new',
                                     '',
                                     $item);

            if (empty($hooks)) {
                $data['hooks'] = '';
            } elseif (is_array($hooks)) {
                $data['hooks'] = join('',$hooks);
            } else {
                $data['hooks'] = $hooks;
            }
            break;

        case 'update':
            if (!xarVarFetch('?inputname', '?inputtype', ?inputvarname, ?default, ?argument, ?preps)) return;
            // Confirm authorisation code
            if (!xarSecConfirmAuthKey()) return; 
    
            // The API function is called
            $hid = xarModAPIFunc('?modname',
                                 'admin',
                                 'create',
                                 array('url' => $url));

            if ($hid == false) return;

            xarResponseRedirect(xarModURL('?modname', '?modtype', 'new')); 
            // Return
            return true;
            break;
    }
    return $data;
} 
?>
#T=Blank Generic Modify
<?php
/**
 * File: $Id$
 *
 * Modify an item
 *
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL <http://www.gnu.org/licenses/gpl.html>
 * @link http://www.xaraya.com
 * @subpackage ?modname
 * @author ?author
 */
/**
 * Create an Item
 */
function ?modname_?modtype_modify()
{
    // Security Check
    if (!xarSecurityCheck('?maskname')) return;

    if (!xarVarFetch('phase', 'str:1:100', $phase, 'modify', XARVAR_NOT_REQUIRED)) return;

    switch (strtolower($phase)) {
        case 'modify':
        default: 
            //Set Data Array
            $data                   = array();
            // Get parameters from whatever input we need
            if (!xarVarFetch('?id','int:1:',?idvarname)) return;
            if (!xarVarFetch('obid','str:1:',$obid,$hid,XARVAR_NOT_REQUIRED)) return;

            // Security Check
            if(!xarSecurityCheck('?maskname')) return;
            $data = xarModAPIFunc('?modname',
                                  'user',
                                  'get',
                                  array('?id' => ?idvarname));

            if ($data == false) return;
            $data['module']         = '?modname';
            $data['itemtype']       = NULL; // itemtype
            $data['itemid']         = ?idvarname;
            $hooks = xarModCallHooks('item',
                                     'modify',
                                     ?idvarname,
                                     $data);
            if (empty($hooks)) {
                $data['hooks']      = '';
            } elseif (is_array($hooks)) {
                $data['hooks']      = join('',$hooks);
            } else {
                $data['hooks']      = $hooks;
            }
            $data['authid']         = xarSecGenAuthKey();
            $data['submitlabel']    = xarML('Submit');
            break;

        case 'update':
            // Get parameters from whatever input we need
            if (!xarVarFetch('?id','int:1:',?idvarname)) return;
            if (!xarVarFetch('?inputname', '?inputtype', ?inputvarname, ?default, ?argument, ?preps)) return;

            // Confirm authorisation code
            if (!xarSecConfirmAuthKey()) return;

            if(!xarModAPIFunc('?modname',
                              '?modtype',
                              'update',
                              array('?id'   => ?idvarname,
                                    '?input'=> ?input))) return;

            xarResponseRedirect(xarModURL('?modname', '?modtype', 'view'));

            return true;
            break;
    }
    return $data;
} 
?>
#T=Blank Generic Display
<?php
 /**
 * File: $Id: 
 * 
 * Display an item
 * 
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?author
 */
/**
 * display an item
 * This is a standard function to provide detailed informtion on a single item
 * available from the module.
 * 
 * @param  $args an array of arguments (if called by other modules)
 * @param  $args ['objectid'] a generic object id (if called by other modules)
 * @param  $args ['exid'] the item id used for this example module
 */
function example_user_display($args)
{ 
    extract($args);
    // Input 
    if (!xarVarFetch('?id', 'int:1:', ?idvarname)) return;
    if (!xarVarFetch('objectid', 'str:1:', $objectid, '', XARVAR_NOT_REQUIRED)) return;

    if (!empty($objectid)) {
        ?idvarname = $objectid;
    } 
    $data = array();
    // Prepare the variable that will hold some status message if necessary
    $data['status'] = ''; 
    // The API function is called.  
    $item = xarModAPIFunc('?modname',
                          'user',
                          'get',
                          array('?id' => ?idvarname));
    if (!isset($item) && xarExceptionMajor() != XAR_NO_EXCEPTION) return; // throw back
     
    // Transformation Hooks 
    $item['transform'] = array('?varstotransform');
    $item = xarModCallHooks('item',
                            'transform',
                            ?idvarname,
                            $item); 

    $data['?id'] = ?idvarname;

    // Save the currently displayed item ID in a temporary variable cache
    // for any blocks that might be interested 
    xarVarSetCached('Blocks.?modname', '?id', ?idvarname); 
    // Call Hooks
    $item['returnurl'] = xarModURL('?modname',
                                   '?modtype',
                                   'display',
                                   array('?id' => ?idvarname));
    $hooks = xarModCallHooks('item',
                             'display',
                             ?idvarname,
                             $item);
    if (empty($hooks)) {
        $data['hookoutput'] = '';
    } else {
        $data['hookoutput'] = $hooks;
    } 
    // Change the title of the page
    xarTplSetPageTitle(xarVarPrepForDisplay(?titleofitem)); 
    return $data; 
} 
?>
#T=-xarModUrl
xarModURL('?modname', '?modtype', '?functiom', array('?parameter' => ?parametervar));
#T=-xarTplSetPageTitle
if (xarModAPIFunc('?modname',
                  '?modtype',
                  '?apifunction',
                  array('?parameter' => ?parametervar))) return;
#T=-xarModCallHooks
$hooks = xarModCallHooks('item',
                         '?hooktype',
                         ?idvarname,
                         ?extrainfo);
#T=-xarModGetVar
xarModGetVar('?modname', '?varname', ?prepoption);
#T=-xarConfigGetVar
xarModGetVar('?varname', ?prepoption);
#T=-xarModSetVar
xarModSetVar('?modname', '?varname', ?value);
#T=-xarModGetUserVar
xarModGetUserVar(?modname, ?varname, ?uid, ?prepoption);
#T=-xarModSetUserVar
xarModGetUserVar(?modname, ?varname, ?value, ?uid);
#T=-xarModIsAvailable
if (xarModIsAvailable(?modname)){
    ^!
}
#T=-xarML
xarML(?string);
#T=-xarMLByKey
xarMLByKey(?KEY);
#T=-xarLocaleFormatCurrency
xarLocaleFormatCurrency(?currency);
#T=-xarLocaleFormatNumber
xarLocaleFormatNumber(?number);
#T=-xarLocaleGetFormattedDate
xarLocaleGetFormattedDate(?length,?timestamp)
#T=-xarLocaleGetFormattedTime
xarLocaleGetFormattedTime(?length,?timestamp)
#T=-xarSecGenAuthKey
$data['authid'] = xarSecGenAuthKey();
#T=-xarSecConfirmAuthKey
if (!xarSecConfirmAuthKey()) return;
#T=-xarSecurityCheck
if (!xarSecurityCheck('?maskname')) return;
#T=-xarServerGetVar
$data['servervar'] = xarServerGetVar(?varname);
#T=-xarServerGetBaseURL
$data['baseurl'] = xarServerGetBaseURL();
#T=-xarServerGetCurrentURL
$data['currenturl'] = xarServerGetCurrentURL();
#T=-xarResponseRedirect
xarResponseRedirect(xarModUrl(?modname, ?modtype, ?modfunc, array(?parameter => ?parametervar)));
#T=-xarSessionGetVar
$data['sessionvar'] = xarSessionGetVar(?varname);
#T=-xarSessionSetVar
if (xarSessionSetVar(?varname, ?varvalue)) return;
#T=-xarTplSetPageTitle
if (xarTplSetPageTitle(xarVarPrepForDisplay(?titleofitem))) return;
#T=-xarTplAddStyleLink
if (xarTplAddStyleLink(?modname, ?stylename, ?fileext)) return;
#T=-xarTplGetPager
$data['pager'] = xarTplGetPager($startnum,
                                xarModAPIFunc('?modname', 'user', 'countitems'),
                                xarModURL('?modname', 'admin', 'view', array('startnum' => '%%')),
                                xarModGetVar('?modname', 'itemsperpage'));
#T=-xarTplGetImage
$data['image'] = xarTplGetImage(?image);
#T=-xarUserGetVar
$data['uservar'] = xarUserGetVar('?varname')
#T=- -Get UID
$data['uid'] = xarUserGetVar('uid')
#T=- -Get User Name
$data['uname'] = xarUserGetVar('uname')
#T=- -Get Display Name
$data['name'] = xarUserGetVar('name')
#T=- -Get Email Address
$data['email'] = xarUserGetVar('email')
#T=-xarUserIsLoggedIn
if (!xarUserIsLoggedIn()) {
    ^!
}
#T=-xarVarBatchFetch
$result = xarVarBatchFetch(array('?input','?inputtype', '?inputvarname', ?default, ?options, ?preps),
                           array('?input','?inputtype', '?inputvarname', ?default, ?options, ?preps));
#T=-xarVarFetch
if (!xarVarFetch('?inputname', '?inputtype', ?inputvarname, ?default, ?argument, ?preps)) return;
#T=- -xarVar Flag XARVAR_DONT_REUSE
XARVAR_DONT_REUSE
#T=- -xarVar Flag XARVAR_GET_OR_POST
XARVAR_GET_OR_POST
#T=- -xarVar Flag XARVAR_GET_ONLY
XARVAR_GET_ONLY
#T=- -xarVar Flag XARVAR_POST_ONLY
XARVAR_POST_ONLY
#T=- -xarVar Flag XARVAR_NOT_REQUIRED
XARVAR_NOT_REQUIRED
#T=- -xarVar Prep XARVAR_PREP_FOR_NOTHING
XARVAR_PREP_FOR_NOTHING
#T=- -xarVar Prep XARVAR_PREP_FOR_DISPLAY
XARVAR_PREP_FOR_DISPLAY
#T=- -xarVar Prep XARVAR_PREP_FOR_HTML
XARVAR_PREP_FOR_HTML
#T=- -xarVar Prep XARVAR_PREP_FOR_STORE
XARVAR_PREP_FOR_STORE
#T=- -xarVar Prep XARVAR_PREP_TRIM
XARVAR_PREP_TRIM
#T=-xarVarIsCached
if (xarVarIsCached(?cachename, ?varname)) {
    ^!
}
#T=-xarVarGetCached
xarVarGetCached(?cachename, ?varname);
#T=-xarVarSetCached
xarVarsetCached(?cachename, ?varname, ?value);
#T=-xarVarPrepForDisplay
xarVarPrepForDisplay(^!);
#T=-xarVarPrepHTMLDisplay
xarVarPrepHTMLDisplay(^!);
#T=-xarVarPrepForOS
xarVarPrepForOS(^!);
#T= -------
#T=API Functions
#T= -------
#T=Blank Admin Create
<?
/**
 * create a new item
 * @param $args['?parameter'] ?parameter of the item
 * @returns int
 * @return ID on success, false on failure
 */
function ?modname_adminapi_create($args)
{
    // Get arguments from argument array
    extract($args);
    // Argument check - make sure that all required arguments are present,
    // if not then set an appropriate error message and return
    if (!isset(?parameter)) {
        $msg = xarML('Invalid Parameter Count', join(', ',$invalid), 'admin', 'create', '?modname');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'BAD_PARAM', new SystemException($msg));
        return;
    }

    // Get datbase setup
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables();
    $table = $xartable['?tablename'];
    // Get next ID in table
    $nextId = $dbconn->GenId($table);
    // Add item
    $query = "INSERT INTO $table (
              xar_?id,
              xar_?parameter)
            VALUES (
              $nextId,
              '" . xarVarPrepForStore($?parameter) . "',
              $nextId)";
    $result =& $dbconn->Execute($query);
    if (!$result) return;
    // Get the ID of the item that we inserted
    $hid = $dbconn->PO_Insert_ID($table, 'xar_?id');
    // Let any hooks know that we have created a new link
    xarModCallHooks('item', 'create', $id, '?id');
    // Return the id of the newly created link to the calling process
    return $id;
}
?>
#T=Blank Admin Update
<?
/**
 * update an headline
 * @param $args['?id'] ID of the item
 * @param $args['?parameter'] ?parameter of the item
 */
function ?modname_adminapi_update($args)
{
    // Get arguments from argument array
    extract($args);
    // Argument check
    if ((!isset($id)) ||
        (!isset($?parameter))) {
        $msg = xarML('Invalid Parameter Count', join(', ',$invalid), 'admin', 'update', '?modname');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'BAD_PARAM', new SystemException($msg));
        return;
    }
    // The user API function is called
    $data = xarModAPIFunc('?modname',
                          'user',
                          'get',
                          array('id' => $id));

    if ($data == false) return;

    // Get datbase setup
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables();
    $table = $xartable['?tablename'];
    // Update the link
    $query = "UPDATE $table
              SET xar_?parameter = '" . xarVarPrepForStore($?parameter) . "',
                  xar_?parameter = '" . xarVarPrepForStore($?parameter) . "'
            WHERE xar_?id = " . xarVarPrepForStore($?id);
    $result =& $dbconn->Execute($query);
    if (!$result) return;
    // Let the calling process know that we have finished successfully
    xarModCallHooks('item', 'update', $id, '');
    return true;
}
?>
#T=Blank Admin Delete
<?
/**
 * delete an item
 * @param $args['id'] ID of the item
 * @returns bool
 * @return true on success, false on failure
 */
function ?modname_adminapi_delete($args)
{
    // Get arguments from argument array
    extract($args);
    // Argument check
    if (!isset($?id)) {
        $msg = xarML('Invalid Parameter Count', join(', ',$invalid), 'admin', 'delete', '?modname');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'BAD_PARAM', new SystemException($msg));
        return;
    }
    // The user API function is called
    $data = xarModAPIFunc('?modname',
                          'user',
                          'get',
                          array('?id' => $?id));
    if ($data == false) return;

    // Get datbase setup
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables();
    $table = $xartable['?tablename'];
    // Delete the item
    $query = "DELETE FROM $table
              WHERE xar_?id = " . xarVarPrepForStore($?id);
    $result =& $dbconn->Execute($query);
    if (!$result) return;
    // Let any hooks know that we have deleted a link
    xarModCallHooks('item', 'delete', $id, '');
    // Let the calling process know that we have finished successfully
    return true;
}
?>
#T=Blank Generic GetMenuLinks
<?
/**
 * utility function pass individual menu items to the main menu
 *
 * @author the ?author
 * @returns array
 * @return array containing the menulinks for the main menu items.
 */
function ?modname_adminapi_getmenulinks()
{

    // Security Check
    if(xarSecurityCheck('?maskname')) {
        $menulinks[] = Array('url'   => xarModURL('headlines',
                                                  'admin',
                                                  'new'),
                              'title' => xarML('Add a new Headline into the system'),
                              'label' => xarML('Add'));
    }
    if (empty($menulinks)){
        $menulinks = '';
    }
    return $menulinks;
}
?>
#T=Blank User GetItemTypes
<?php
/**
 * utility function to retrieve the list of item types of this module (if any)
 *
 * @returns array
 * @return array containing the item types and their description
 */
function ?modname_userapi_getitemtypes($args)
{
    $itemtypes = array();
/*
    // do not use this if you only handle one type of items in your module
    $itemtypes[1] = array('label' => xarVarPrepForDisplay(xarML('?modname')),
                          'title' => xarVarPrepForDisplay(xarML('View ?modname')),
                          'url'   => xarModURL('?modname','user','main'));
*/
    return $itemtypes;
}
?>
#T=Blank User GetItemLinks
<?php
/**
 * utility function to pass individual item links to whoever
 * 
 * @param  $args ['itemtype'] item type (optional)
 * @param  $args ['itemids'] array of item ids to get
 * @returns array
 * @return array containing the itemlink(s) for the item(s).
 */
function ?modname_userapi_getitemlinks($args)
{
    $itemlinks = array();
    if (!xarSecurityCheck('?maskname', 0)) {
        return $itemlinks;
    } 
    foreach ($args['itemids'] as $itemid) {
        $item = xarModAPIFunc('?modname', 'user', 'get', array('id' => $itemid));
        if (!isset($item)) return;
        $itemlinks[$itemid] = array('url' => xarModURL('?modname', 'user', 'view', array('id' => $itemid)),
                                    'title' => xarML('Display ?item),
                                    'label' => xarVarPrepForDisplay($item['title']));
    } 
    return $itemlinks;
} 
?>
#T=Blank User Count Items
<?php
/**
 * File: $Id:
 * 
 * Utility function counts number of items held by this module
 * 
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?author
 */
/**
 * utility function to count the number of items held by this module
 * 
 * @author ?author
 * @returns integer
 * @return number of items held by this module
 * @raise DATABASE_ERROR
 */
function ?modname_userapi_countitems()
{ 
    // Get database setup
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables(); 
    $table = $xartable['?tablename']; 
    // Get item
    $query = "SELECT COUNT(1)
            FROM $table";
    $result = &$dbconn->Execute($query); 
    if (!$result) return; 
    // Obtain the number of items
    list($numitems) = $result->fields; 
    $result->Close(); 
    // Return the number of items
    return $numitems;
} 
?>
#T=Blank User Get All
<?php
/**
 * File: $Id:
 * 
 * Get all module items
 * 
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?author
 */
/**
 * get all items
 * 
 * @author ?author 
 * @param numitems $ the number of items to retrieve (default -1 = all)
 * @param startnum $ start with this item number (default 1)
 * @returns array
 * @return array of items, or false on failure
 * @raise BAD_PARAM, DATABASE_ERROR, NO_PERMISSION
 */
function ?modname_userapi_getall($args)
{ 
    extract($args); 
    // Optional arguments.
    if (!isset($startnum)) {
        $startnum = 1;
    } 
    if (!isset($numitems)) {
        $numitems = -1;
    } 
    // Argument check
    $invalid = array();
    if (!isset($startnum) || !is_numeric($startnum)) {
        $invalid[] = 'startnum';
    } 
    if (!isset($numitems) || !is_numeric($numitems)) {
        $invalid[] = 'numitems';
    } 
    if (count($invalid) > 0) {
        $msg = xarML('Invalid #(1) for #(2) function #(3)() in module #(4)', join(', ', $invalid), 'user', 'getall', '?modname');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'BAD_PARAM', new SystemException($msg));
        return;
    } 

    $items = array(); 
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables(); 
    $table = $xartable['?tablename']; 
    // Query from Example Module.  Replace as needed.
    $query = "SELECT xar_exid,
                   xar_name,
                   xar_number
            FROM $exampletable
            ORDER BY xar_name";
    $result = $dbconn->SelectLimit($query, $numitems, $startnum-1); 
    if (!$result) return; 
    for (; !$result->EOF; $result->MoveNext()) {
        list($exid, $name, $number) = $result->fields;
        if (xarSecurityCheck('?maskname', 0, 'Item', "$name:All:$exid")) {
            $items[] = array('exid' => $exid,
                'name' => $name,
                'number' => $number);
        } 
    } 
    $result->Close(); 
    // Return the items
    return $items;
} 
?>
#T=Blank User Get
<?php
/**
 * File: $Id:
 * 
 * Get a specific item
 * 
 * @package Xaraya eXtensible Management System
 * @copyright (C) 2003 by the Xaraya Development Team.
 * @license GPL {@link http://www.gnu.org/licenses/gpl.html}
 * @link http://www.xaraya.com
 *
 * @subpackage ?modname
 * @author ?author 
 */
/**
 * get a specific item
 * 
 * @author ?author 
 * @param  $args ['id'] id of example item to get
 * @returns array
 * @return item array, or false on failure
 * @raise BAD_PARAM, DATABASE_ERROR, NO_PERMISSION
 */
function ?modname_userapi_get($args)
{ 
    extract($args); 
    // Argument check
    if (!isset($id) || !is_numeric($id)) {
        $msg = xarML('Invalid #(1) for #(2) function #(3)() in module #(4)', 'item ID', 'user', 'get', '?modname');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'BAD_PARAM', new SystemException($msg));
        return;
    } 
    // Get database setup - note that both xarDBGetConn() and xarDBGetTables()
    // return arrays but we handle them differently.  For xarDBGetConn() we
    // currently just want the first item, which is the official database
    // handle.  For xarDBGetTables() we want to keep the entire tables array
    // together for easy reference later on
    list($dbconn) = xarDBGetConn();
    $xartable = xarDBGetTables(); 
    $table = $xartable['?tablename']; 
    // Get item
    // Query from Example Module
    $query = "SELECT xar_name,
                   xar_number
            FROM $exampletable
            WHERE xar_exid = " . xarVarPrepForStore($exid);
    $result = &$dbconn->Execute($query); 
    if (!$result) return; 
    // Check for no rows found, and if so, close the result set and return an exception
    if ($result->EOF) {
        $result->Close();
        $msg = xarML('This item does not exists');
        xarExceptionSet(XAR_SYSTEM_EXCEPTION, 'ID_NOT_EXIST',
            new SystemException(__FILE__ . '(' . __LINE__ . '): ' . $msg));
        return;
    } 
    // Obtain the item information from the result set
    list($name, $number) = $result->fields; 
    $result->Close(); 
    // Security check
    if (!xarSecurityCheck('?maskname', 1, 'Item', "$name:All:$id")) {
        return;
    } 
    // Create the item array
    $item = array('exid' => $exid,
        'name' => $name,
        'number' => $number); 
    // Return the item array
    return $item;
} 
?>
#T=-xarVarPrepForStore
xarVarPrepForStore(^!);