/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-1999 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://www.funduc.com                    *
* or E-MAIL: sales@funduc.com                                                *
*                                                                            *
*****************************************************************************/

#ifndef DECENC_H
#define DECENC_H

#ifdef __cplusplus
extern "C"
{
#endif
                       
/* Possible values for the nType parameter passed to EncodeFile() 
   and return code from DecodeFile */
#define NONE_TYPE        0
#define UUE_TYPE         1   /* UUENCODED file */
#define B64_TYPE         2   /* Base64 encoded (MIME) */
#define BINHEX_TYPE      3   /* BinHex (Macintosh) encoding */
#define XXE_TYPE         4   /* XXENCODED file */
#define TEXT_TYPE	 5   /* 7-bit or quoted-printable - encoding quoted-printable */

/* Possible values for the nPrompt parameter to Decode File() */
#define PROMPT_ALL       0   /* DLL prompts for everything */
#define PROMPT_NONE      1   /* No prompts, file names passed in are used */
#define PROMPT_OVERWRITE 2   /* DLL only prompts for overwrites */

/* How many files are encoded */
int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
/* 0 relative index into the array of names (see call above) */
int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
   the strOutFile parameter.  That can be accomplished by calling GetNumFilesToDecode() 
   and GetEncodedFile in a loop to get the list of files first. The list of files passed
   (after modification if needed) must then be delimited by the ';' character */
/* Return code is one of the Encoding types above */
int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
   for example */
/* Boundary should be passed in.  It needs to be listed in the message header as:
    boundary="<your boundary>" */
int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, LPCTSTR szBoundary, int nType, BOOL bAppend); 

/* Call after all files are encoded to append the final boundary */
/* You can also append -- and 2 linefeeds to the end of the encoded file or */
/* send that out with your message */
void WINAPI FinishAttachments(LPCSTR strFileOut);

/* call with the name of registered application to write that to the encoded file */
void WINAPI SetEncodingApplication(LPCSTR szInFile);

/* Utility functions */
/* This function will return TRUE if the name of the file had to be changed to avoid an overwrite */
BOOL WINAPI GetUniqueFileName(LPSTR szFileName);
/* This function will concatenate related files into the first one.  All files must
   be found in the same directory.
   For example: file1.dat, file2.dat, file3.dat will be concatenated into file1.dat
   If bDeleteOthers is TRUE, file2.dat and file3.dat are deleted
   This function returns TRUE when successful, FALSE otherwise 
*/
BOOL WINAPI ConcatenateRelated(BOOL bDeleteOthers, LPSTR szFileName);

/* This function will split a file into as many smaller files as necessary
   For example: file.dat of size 100000 will be split into
   file1.dat (size 35000), file2.dat(35000), file3.dat(size 30000)
   if 35000 is used for the lFileSize parameter 
   This function returns TRUE when successful, FALSE otherwise
*/
BOOL WINAPI SplitFile(LPSTR szFileName, long lFileSize);


#ifdef __cplusplus
}
#endif

#endif
