/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import java.awt.Image;
import java.awt.Rectangle;
import treeview.ImageSet;
import treeview.ImageSetSource;
import treeview.SiblingChildTree;

public class TreeViewNode
extends SiblingChildTree {
    protected ImageSet m_isImages;
    protected ImageSetSource m_issrcSource;
    protected String m_strLabel;
    protected Rectangle m_rectBounds;
    protected boolean m_bCollapsed = false;
    protected boolean m_bSelected = false;
    protected boolean m_bUseSpecificImgIndex = false;
    protected int m_nImageIndex = -1;

    public void doDblClick() {
    }

    public void moveBounds(int n, int n2) {
        this.m_rectBounds.x = n;
        this.m_rectBounds.y = n2;
    }

    public boolean getCollapsedState() {
        return this.m_bCollapsed;
    }

    public void setCollapsedState(boolean bl) {
        this.m_bCollapsed = bl;
    }

    public TreeViewNode nextNode(boolean bl) {
        if (!(bl && this.m_bCollapsed || this.child == null)) {
            return (TreeViewNode)this.child;
        }
        if (this.sibling_right != null) {
            return (TreeViewNode)this.sibling_right;
        }
        SiblingChildTree siblingChildTree = this.parent;
        while (siblingChildTree != null) {
            if (siblingChildTree.sibling_right != null) {
                return (TreeViewNode)siblingChildTree.sibling_right;
            }
            siblingChildTree = siblingChildTree.parent;
        }
        return null;
    }

    public void select(boolean bl) {
        this.m_bSelected = bl;
    }

    public void collapseTree() {
        TreeViewNode treeViewNode = this;
        while (treeViewNode != null) {
            treeViewNode.m_bCollapsed = true;
            try {
                ((TreeViewNode)treeViewNode.child).collapseTree();
            }
            catch (NullPointerException nullPointerException) {}
            treeViewNode = (TreeViewNode)treeViewNode.sibling_right;
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.m_rectBounds.x, this.m_rectBounds.y, this.m_rectBounds.width, this.m_rectBounds.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_rectBounds.reshape(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.m_rectBounds.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getWidth() {
        return this.m_rectBounds.width;
    }

    public int getImageIndex() {
        return this.m_nImageIndex;
    }

    public void setImageIndex(int n) {
        this.m_nImageIndex = n;
    }

    public void setImageSetSource(ImageSetSource imageSetSource) {
        this.m_issrcSource = imageSetSource;
    }

    public ImageSetSource getImageSetSource() {
        return this.m_issrcSource;
    }

    public void expandTree() {
        TreeViewNode treeViewNode = this;
        while (treeViewNode != null) {
            treeViewNode.m_bCollapsed = false;
            try {
                ((TreeViewNode)treeViewNode.child).expandTree();
            }
            catch (NullPointerException nullPointerException) {}
            treeViewNode = (TreeViewNode)treeViewNode.sibling_right;
        }
    }

    public TreeViewNode() {
        this.m_isImages = null;
        this.m_issrcSource = null;
        this.m_strLabel = null;
        this.m_rectBounds = new Rectangle();
    }

    public TreeViewNode(String string) {
        this.m_isImages = null;
        this.m_issrcSource = null;
        this.m_strLabel = string;
        this.m_rectBounds = new Rectangle();
    }

    public TreeViewNode(ImageSet imageSet) {
        this.m_isImages = imageSet;
        this.m_issrcSource = null;
        this.m_strLabel = null;
        this.m_rectBounds = new Rectangle();
    }

    public TreeViewNode(ImageSetSource imageSetSource) {
        this.m_isImages = null;
        this.m_issrcSource = imageSetSource;
        this.m_strLabel = null;
        this.m_rectBounds = new Rectangle();
    }

    public TreeViewNode(String string, ImageSetSource imageSetSource) {
        this.m_isImages = null;
        this.m_issrcSource = imageSetSource;
        this.m_strLabel = string;
        this.m_rectBounds = new Rectangle();
    }

    public TreeViewNode(String string, ImageSet imageSet) {
        this.m_isImages = imageSet;
        this.m_issrcSource = null;
        this.m_strLabel = string;
        this.m_rectBounds = new Rectangle();
    }

    public boolean isSelected() {
        return this.m_bSelected;
    }

    /*
     * Unable to fully structure code
     */
    public TreeViewNode prevNode(boolean var1_1) {
        block2: {
            block3: {
                if (this.sibling_left == null) break block2;
                if (var1_1 && ((TreeViewNode)this.sibling_left).m_bCollapsed) break block3;
                var2_2 = this.sibling_left.child;
                if (var2_2 != null) ** GOTO lbl7
                return (TreeViewNode)this.lastBeforeMatch((TreeViewNode)this.sibling_left, var1_1);
lbl-1000:
                // 1 sources

                {
                    var2_2 = var2_2.sibling_right;
lbl7:
                    // 2 sources

                    ** while (var2_2.sibling_right != null)
                }
lbl8:
                // 1 sources

                return (TreeViewNode)this.lastBeforeMatch((TreeViewNode)var2_2, var1_1);
            }
            return (TreeViewNode)this.lastBeforeMatch((TreeViewNode)this.sibling_left, var1_1);
        }
        if (this.parent != null) {
            return (TreeViewNode)this.lastBeforeMatch((TreeViewNode)this.parent, var1_1);
        }
        return null;
    }

    private SiblingChildTree lastBeforeMatch(TreeViewNode treeViewNode, boolean bl) {
        TreeViewNode treeViewNode2 = null;
        do {
            if (treeViewNode2 == null) continue;
            treeViewNode = treeViewNode2;
        } while ((treeViewNode2 = treeViewNode.nextNode(bl)) != this);
        return treeViewNode;
    }

    public Image getCurrentImage() {
        ImageSet imageSet = this.m_isImages;
        if (imageSet == null) {
            if (this.m_issrcSource != null) {
                imageSet = this.m_issrcSource.getImages();
            }
            if (imageSet == null) {
                return null;
            }
        }
        try {
            if (this.m_bUseSpecificImgIndex) {
                try {
                    return imageSet.getImage(this.m_nImageIndex);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    return null;
                }
            }
            if (this.child == null) {
                if (this.m_bSelected) {
                    try {
                        return imageSet.getImage(3);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return imageSet.getImage(0);
                    }
                }
                return imageSet.getImage(0);
            }
            if (this.m_bSelected) {
                try {
                    if (this.m_bCollapsed) {
                        return imageSet.getImage(4);
                    }
                    return imageSet.getImage(5);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (this.m_bCollapsed) {
                        return imageSet.getImage(1);
                    }
                    return imageSet.getImage(2);
                }
            }
            if (this.m_bCollapsed) {
                return imageSet.getImage(1);
            }
            return imageSet.getImage(2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public boolean getUseSpecifiedImageIndex() {
        return this.m_bUseSpecificImgIndex;
    }

    public void setUseSpecifiedImageIndex(boolean bl) {
        this.m_bUseSpecificImgIndex = bl;
    }

    public int getHeight() {
        return this.m_rectBounds.height;
    }

    public ImageSet getImages() {
        return this.m_isImages;
    }

    public void setImages(ImageSet imageSet) {
        this.m_isImages = imageSet;
    }

    public boolean isInside(int n, int n2) {
        return this.m_rectBounds.inside(n, n2);
    }

    public String getLabel() {
        return this.m_strLabel;
    }

    public void setLabel(String string) {
        this.m_strLabel = string;
    }

    public void doAction() {
    }
}

